/*
 *   MediaMVP Plugin
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: mvplive.h,v 1.1 2004/04/25 16:35:46 dom Exp $
 *   $Date: 2004/04/25 16:35:46 $
 *
 *
 *   Handle the mvplive:// URL type
 */


#ifndef MVPLIVE_H
#define MVPLIVE_H

#include <vdr/thread.h>
#include <vdr/ringbuffer.h>
#include "libmvp.h"



class cMvpLiveURL : public cThread {
private:
    bool                  running;
    int                   transfer_pipe[2];


    struct event         *event;

    
    cRingBufferLinear    *ringbuffer;      /* Passed in on construction */

    /* Callbacks into the library */
    readready_cb          cb;
    void                 *cb_ptr;

    virtual void          Action(void);    /* Thread event */

public:
 
    cMvpLiveURL(cRingBufferLinear *ringy);
    ~cMvpLiveURL();

    bool Poll(cPoller &Poller, int TimeoutMs = 0);
    

    /* Callbacks from the library */
    static void Init();
    static void *Open(char *name, int *type, fops_t **fops, readready_cb cb, void *cb_ptr);
    static off_t Seek(void *ptr, off_t offset, int whence);
    static void Close(void *ptr);
    static int Read(void *ptr, unsigned char *buf, size_t buflen);
    static int Info(void *ptr, int cmd, void *args);
    static void ReadEvent(int fd, short event, void *arg);

};


#endif
