/*
 * mvp.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: mvp.c,v 1.2 2004/06/08 08:58:09 dom Exp $
 */

#include <vdr/plugin.h>

#include "i18n.h"
#include "mvpwrap.h"
#include "setup.h"

static const char *VERSION        = "0.0.1";
static const char *DESCRIPTION    = "Enter description for 'mvp' plugin";
static const char *MAINMENUENTRY  = "Mvp";

class cPluginMvp : public cPlugin {
private:
  // Add any member variables or functions you may need here.
public:
  cPluginMvp(void);
  virtual ~cPluginMvp();
  virtual const char *Version(void) { return VERSION; }
  virtual const char *Description(void) { return DESCRIPTION; }
  virtual const char *CommandLineHelp(void);
  virtual bool ProcessArgs(int argc, char *argv[]);
  virtual bool Initialize(void);
  virtual bool Start(void);
  virtual void Housekeeping(void);
  virtual const char *MainMenuEntry(void) { return MAINMENUENTRY; }
  virtual cOsdObject *MainMenuAction(void);
  virtual cMenuSetupPage *SetupMenu(void);
  virtual bool SetupParse(const char *Name, const char *Value);
  };

cPluginMvp::cPluginMvp(void)
{
  // Initialize any member variables here.
  // DON'T DO ANYTHING ELSE THAT MAY HAVE SIDE EFFECTS, REQUIRE GLOBAL
  // VDR OBJECTS TO EXIST OR PRODUCE ANY OUTPUT!
}

cPluginMvp::~cPluginMvp()
{
  // Clean up after yourself!
}

const char *cPluginMvp::CommandLineHelp(void)
{
  // Return a string that describes all known command line options.
  return NULL;
}

bool cPluginMvp::ProcessArgs(int argc, char *argv[])
{
  // Implement command line argument processing here if applicable.
  return true;
}

bool cPluginMvp::Initialize(void)
{
  // Initialize any background activities the plugin shall perform.
    new cMvpWrap();
    return true;
}

bool cPluginMvp::Start(void)
{

    
    // Start any background activities the plugin shall perform.
    RegisterI18n(Phrases);

    return true;
}

void cPluginMvp::Housekeeping(void)
{
  // Perform any cleanup or other regular tasks.
}

cOsdObject *cPluginMvp::MainMenuAction(void)
{
  // Perform the action when selected from the main VDR menu.
  return NULL;
}

cMenuSetupPage *cPluginMvp::SetupMenu(void)
{
  // Return a setup menu in case the plugin supports one.
  return NULL;
}

bool cPluginMvp::SetupParse(const char *Name, const char *Value)
{
    return ConfigParse(Name,Value);
}

VDRPLUGINCREATOR(cPluginMvp); // Don't touch this!
