/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: program.h,v 1.2 2004/04/25 15:52:53 dom Exp $
 *   $Date: 2004/04/25 15:52:53 $
 *
 *
 *   Implements the skeleton application
 * 
 *   This abstracts part of the old interface from gui.c into a separate file for libraryification
 */

#ifndef PROGRAM_H
#define PROGRAM_H


typedef struct _program program_t;

#include "libmvp.h"
#include "mvprender.h"

#include "menuapp.h"

#ifndef VDR_PLUGIN
#include "libini.h"
#else
#include <vdr/plugin.h>
#include "mediamvp.h"
#include "setup.h"
#endif


#define  REGISTER_MENU  1
#define  REGISTER_MEDIA 2


#ifndef VDR_PLUGIN
extern void       program_config();
#endif
extern void       program_init(mvpinit_t *);
extern void       program_register_keys(program_t *program,int type, 
                                    int (*key_func)(void *param,int keycode), void *param);
extern void       program_register_ack(program_t *program, int type,
                                   int    (*ack_func)(int acktype, void *param, unsigned char *buf, int len), 
                                   void  *param);


extern char      *filename_expand(char *filename);

#endif /* PROGRAM_H */
