/*
 *   MediaMVP Server Render Library
 *
 *   (C) 2004 Dave Kelly
 *
 *   $Id: mvpwindow.h,v 1.9 2004/05/06 09:31:58 ravelox Exp $
 *   $Date: 2004/05/06 09:31:58 $
 *
 *   Window handling
 *
 */


#ifndef MVPWINDOW_H
#define MVPWINDOW_H

#ifdef __cplusplus
extern "C" {
#endif

#include "libmvp.h"
#include "mvpfont.h"

#include <stdio.h>     /* We need NULL */

typedef struct _pos pos_t;
typedef struct _dimension dimension_t;
typedef struct _window window_t;

#define FLAG_DIRTY	0x00000001
#define FLAG_FOCUS	0x00000002
#define FLAG_MODAL	0x00000004

#define WINDOW_NULL	0
#define WINDOW_BOX	1
#define WINDOW_LABEL 2

/* Basic window */
extern window_t *new_window(window_t *parent, int x, int y, int width, int height);
extern window_t *new_root(int width, int height, int bpp);
extern void window_set_name(window_t *window, char *name);
extern char *window_get_name(window_t *window);
#ifdef TESTING
extern void window_dump_window(window_t *window);
#endif
extern void window_set_data(window_t *window, void *data);
extern void *window_get_data(window_t *window);
extern void window_set_draw_func(window_t *window, void (*draw_func)(window_t *this));
extern void window_set_focus_func(window_t *window, void (*draw_func)(window_t *this));
extern void window_set_delete_func(window_t *window, void (*delete_func)(window_t *this));
extern surface_t *window_get_draw_surface(window_t *window);
extern void window_set_draw_surface(window_t *window, surface_t *surface);
extern void window_set_type(window_t *window, int type);
extern int window_get_type(window_t *window);
extern int window_get_xpos(window_t *window);
extern void window_set_xpos(window_t *window, int x);
extern int window_get_ypos(window_t *window);
extern void window_set_ypos(window_t *window, int y);
extern void window_set_pos(window_t *window, int x, int y);
extern int window_get_height(window_t *window);
extern void window_set_height(window_t *window, int height);
extern int window_get_width(window_t *window);
extern void window_set_width(window_t *window, int width);
extern void window_set_dimension(window_t *window, int width, int height);
extern int window_get_xoffset(window_t *window);
extern void window_set_xoffset(window_t *window, int xoffset);
extern int window_get_yoffset(window_t *window);
extern void window_set_yoffset(window_t *window, int yoffset);
extern void window_set_offset(window_t *window, int xoffset, int yoffset);
extern int window_get_zorder(window_t *window);
extern void window_set_zorder(window_t *window, int z);
extern void window_add_child(window_t *parent, window_t *child);
extern void delete_window(window_t *window);
extern int window_draw(window_t *window);
extern void window_blit(window_t *window);
extern surface_t *window_get_contents(window_t *window);
extern void window_set_pixel(window_t *window, int x, int y, uint32_t col);
extern void window_mark_dirty(window_t *window);
extern void window_mark_clean(window_t *window);
extern int window_is_dirty(window_t *window);

extern void window_toggle_modal(window_t *window);
extern int window_is_modal(window_t *window);

/* Box */
typedef struct _box box_t;

extern void box_set_border_size(window_t *window, int border_size);
extern void box_set_border_col(window_t *window, uint32_t border_col);
extern void box_set_fill_col(window_t *window, uint32_t fill_col);
extern window_t *new_box(window_t *parent, int x, int y, int width, int height);

/* Label */

typedef struct _label label_t;

#define LABEL_ALIGN_LEFT	0x00000001
#define LABEL_ALIGN_CENTER	0x00000002
#define LABEL_ALIGN_RIGHT	0x00000004

#define LABEL_VALIGN_TOP	0x00000001
#define LABEL_VALIGN_MIDDLE	0x00000002
#define LABEL_VALIGN_BOTTOM 0x00000004

extern window_t *new_label(window_t *parent, int x, int y, int width, int height, char *text);
extern void label_set_font(window_t *label, font_t *font);
extern font_t *label_get_font(window_t *label);
extern void label_set_fgcol(window_t *label, uint32_t rgb);
extern void label_set_bgcol(window_t *label, uint32_t rgb);
extern uint32_t label_get_fgcol(window_t *label);

extern void label_set_align(window_t *label, int align);
extern void label_set_valign(window_t *label, int valign);

#ifdef __cplusplus
}
#endif


#endif /* MVPWINDOW_H */
