#include "mvpwindow.h"

#if 0
#define DEBUG(xxx...) fprintf(stderr,xxx)
#else
#define DEBUG(xxx,...)
#endif

struct _label {
	char *text;
	uint32_t fgcol;
	uint32_t bgcol;
	font_t *font;
	char align;
	char valign;
};

static void     label_print(window_t *label, int x, int y, int maxx,  char *text);
static void     label_printchar(window_t *label, int x, int y, glyph_t *glyph);
static void		delete_label_data(window_t *label);

extern glyph_t nbsp;

static void draw_label(window_t *label)
{
	label_t *data;
	int width, height;
	int label_width;
	int x,y;

	if(window_get_type(label) != WINDOW_LABEL) {
		return;
	}

	if(! (data = (label_t *)window_get_data(label)) ) {
		return;
	}

	surface_clear(window_get_contents(label), data->bgcol);
	
	width = window_get_width(label);
	height = window_get_height(label);

	label_width = font_get_textwidth(data->font, data->text);

	switch(data->align) {
		case LABEL_ALIGN_CENTER:
			x = (width / 2) - (label_width / 2);
			break;
		case LABEL_ALIGN_RIGHT:
			x = width - label_width;
			break;
		case LABEL_ALIGN_LEFT:
		default:
			x = 0;
			break;
	}

	if(x < 0) {
		x = 0;
	}

	switch(data->valign) {
		case LABEL_VALIGN_BOTTOM:
			y = height - font_get_height(data->font);
			break;
		case LABEL_VALIGN_MIDDLE:
			y = (height / 2) - (font_get_height(data->font) / 2) ;
			break;
		case LABEL_VALIGN_TOP:
		default:
			y = 0;
			break;
	}

	if(y < 0) {
		y = 0;
	}

	label_print(label, x, y, window_get_width(label), data->text);
}

window_t *new_label(window_t *parent, int x, int y, int width, int height, char *text)
{
	window_t *label;
	label_t *data;

	Dprintf(DEBUG, "new_label\n");
	label = new_window(parent, x, y, width, height);
	data = (label_t *)malloc(sizeof(label_t));

	data->text = (char *)strdup(text);
	data->fgcol = 0xFFFFFF;
	data->bgcol = 0x000000;
	data->font = font_read(default_font);
	data->align = 0;
	data->valign = 0;

	window_set_type(label, WINDOW_LABEL);
	window_set_data(label, data);
	window_set_draw_func(label, draw_label);
	window_set_delete_func(label, delete_label_data);

	window_mark_dirty(label);

	return label;
}

void label_set_font(window_t *label, font_t *font)
{
	label_t *data;

	if(window_get_type(label) != WINDOW_LABEL) {
		return;
	}

	if(! (data = (label_t *)window_get_data(label)) ) {
		return;
	}

    data->font = font;
	window_mark_dirty(label);
}

font_t *label_get_font(window_t *label)
{
	label_t *data;

	if(window_get_type(label) != WINDOW_LABEL) {
		return NULL;
	}

	if(! (data = (label_t *)window_get_data(label)) ) {
		return NULL;
	}

    return data->font;
}

void label_set_fgcol(window_t *label, uint32_t rgb)
{
	label_t *data;

	if(window_get_type(label) != WINDOW_LABEL) {
		return;
	}

	if(! (data = (label_t *)window_get_data(label)) ) {
		return;
	}

    data->fgcol = rgb;
	window_mark_dirty(label);
}

void label_set_bgcol(window_t *label, uint32_t rgb)
{
	label_t *data;

	if(window_get_type(label) != WINDOW_LABEL) {
		return;
	}

	if(! (data = (label_t *)window_get_data(label)) ) {
		return;
	}

    data->bgcol = rgb;
	window_mark_dirty(label);
}

uint32_t label_get_fgcol(window_t *label)
{
	label_t *data;

	if(window_get_type(label) != WINDOW_LABEL) {
		return 0;
	}

	if(! (data = (label_t *)window_get_data(label)) ) {
		return 0;
	}

	return data->fgcol;
}

static void label_print(window_t *label, int x, int y, int maxwidth, char *text)
{
	label_t *data;
    glyph_t  *glyph;
    int   tabwidth = ( (maxwidth - x )  ) / 6;
    int width  = 0;

	if(! label) {
		return;
	}

	if(! (data = (label_t *)window_get_data(label)) ) {
		return;
	}

	Dprintf(DEBUG, "label_print(%s)\n", text);
    /* Check to see if a font is defined */
    if(! data->font) {
        Dprintf(ERROR, "No font defined for label\n");
        return;
    }

    while ( *text ) {
        switch ( *text ) {
        case '\t':        /* Do some nasty stuff to calculate tab stops,
                             only really works for a full display */
            Dprintf(DEBUG, "label_print(tabstop)\n");
            glyph_set_height(&nbsp, font_get_height(data->font));
            while ( x + 1 < ( ( x / tabwidth ) + 1 ) * tabwidth && x < maxwidth ) {
                label_printchar(label,x,y, &nbsp);
                x++;
            }
            break;
        case '\n':
            Dprintf(DEBUG, "label_print(cr)\n");
            glyph_set_height(&nbsp, font_get_height(data->font));
            width = glyph_get_width(&nbsp);
            while ( x + width < maxwidth ) {
                label_printchar(label,x,y,&nbsp);
                x += width;
            }
            y += font_get_height(data->font);
            if ( y >= window_get_height(label) - window_get_yoffset(label)) {
                return;
            }
            break;
        default:
            Dprintf(DEBUG,  "label_print(%c)\n", *(unsigned char *)text);
            if(font_is_defined(data->font, *(unsigned char *)text)) {
                glyph = font_get_glyph(data->font, *(unsigned char *)text);
                width = glyph_get_width(glyph);
                if ( x + width < maxwidth &&
                     ( y < window_get_height(label) - window_get_yoffset(label)) ) {
                    label_printchar(label,x,y,glyph);
                    x += width;
                }
            }
            break;
        }
        text++;
    }
}

static void label_printchar(window_t *label,int x, int y, glyph_t *glyph)
{
	label_t *data;
    int *bitmap;
    int i,j, mask;
    int width, height;

	if(! label) {
		return;
	}

	if(! (data = (label_t *)window_get_data(label)) ) {
		return;
	}

	Dprintf(DEBUG, "label_printchar\n");

    bitmap = glyph_get_bitmap(glyph);

    width = glyph_get_width(glyph);
    height = glyph_get_height(glyph);

    for(j = 0 ; j < height; j++) {
        for ( i = 0; i < width; i++ ) {
            mask = 1 << i;
            if ( bitmap && (bitmap[j] & mask ) ) {
                surface_set_pixel(window_get_contents(label),x + (width - i),y,data->fgcol);
            } else {
                surface_set_pixel(window_get_contents(label),x + (width - i),y,data->bgcol);
            }
        }
        y++;
    }
}

void label_set_align(window_t *label, int align)
{
	label_t *data;

	if(window_get_type(label) != WINDOW_LABEL) {
		return;
	}

	if(! (data = (label_t *)window_get_data(label)) ) {
		return;
	}

	data->align = align;

	window_mark_dirty(label);
}

void label_set_valign(window_t *label, int valign)
{
	label_t *data;

	if(window_get_type(label) != WINDOW_LABEL) {
		return;
	}

	if(! (data = (label_t *)window_get_data(label)) ) {
		return;
	}

	data->valign = valign;

	return;
}


char label_get_align(window_t *label)
{
	label_t *data;

	if(window_get_type(label) != WINDOW_LABEL) {
		return 0;
	}

	if(! (data = (label_t *)window_get_data(label)) ) {
		return 0;
	}

	return data->align;
}

char label_get_valign(window_t *label)
{
	label_t *data;

	if(window_get_type(label) != WINDOW_LABEL) {
		return 0;
	}

	if(! (data = (label_t *)window_get_data(label)) ) {
		return 0;
	}

	return data->valign;
}

static void delete_label_data(window_t *label)
{
	label_t *data;

	if(window_get_type(label) != WINDOW_LABEL) {
		return;
	}

	if(! (data = (label_t *)window_get_data(label)) ) {
		return;
	}

	free(data->text);
	free(data);

	window_set_data(label, NULL);
}

/*
 * Local Variables:
 *  indent-tabs-mode:nil
 *  require-final-newline:t
 *  c-basic-offset: 4
 * End:
 */
