/*
 *   MediaMVP Plugin
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: vdrrecurl.c,v 1.4 2004/05/07 19:27:55 dom Exp $
 *   $Date: 2004/05/07 19:27:55 $
 *
 *
 *   Handle the vdr:// URL type
 */

#include "libmvp.h"

#include "vdrrecurl.h"
#include <vdr/recording.h>

static fops_t vdrrecurl_fops = {
    NULL,
    cMediamvpVdrRecURL::Open,
    cMediamvpVdrRecURL::Close,
    cMediamvpVdrRecURL::Seek,
    cMediamvpVdrRecURL::Read,
    cMediamvpVdrRecURL::Info
};


cMediamvpVdrRecURL::cMediamvpVdrRecURL()
{
    fd = -1;
    tmplen = 0;
    offset = 0;
    name = NULL;
}

cMediamvpVdrRecURL::~cMediamvpVdrRecURL()
{
    if ( fd != -1 ) {
        close(fd);
        fd = -1;
    }

    if ( name != NULL ) {
        free(name);
        name = NULL;
    }
}

void cMediamvpVdrRecURL::Init()
{
    urlhandler_add("vdrrec://",&vdrrecurl_fops);
}



void *cMediamvpVdrRecURL::Open(char *name, int *type, fops_t **fops, readready_cb cb, void *cb_ptr)
{

    cMediamvpVdrRecURL *vdrrecurl = new cMediamvpVdrRecURL;
    char               *realname;
    cRecordings         Recordings;  

 

    if ( strncmp(name,"vdrrec://",strlen("vdrrec://") ) ) {
        return NULL;
    }

    if ( !Recordings.Load() ) {
        return NULL;
    }

    realname = name + strlen("vdrrec://");


    cRecording *rec = Recordings.First();
    while ( rec != NULL && strcmp(rec->Title(' ',true), realname ) ) {
        rec = Recordings.Next(rec);
    }


    if ( rec == NULL ) {
        Dprintf(INFO,"Cannot find recording - %s\n",realname);
        return NULL;
    }

    /* So rec is our recording.. */
    snprintf(vdrrecurl->filename,sizeof(vdrrecurl->filename),"%s/",rec->FileName());
    vdrrecurl->curfile = 0;
    vdrrecurl->name = strdup(realname);

    vdrrecurl->OpenFile();

    *type = MEDIA_MPEG;

    if ( vdrrecurl->fd == -1 ) {
        Dprintf(INFO,"Couldn't open recording - %s\n",vdrrecurl->filename);
        delete vdrrecurl;
        return NULL;
    }

    return vdrrecurl;
}

void cMediamvpVdrRecURL::OpenFile()
{
    char      buf[FILENAME_MAX+1];

    if ( fd != -1 ) {
        close(fd);
    }

    snprintf(buf,sizeof(buf),"%s%03d.vdr",filename,++curfile);

    fd = open(buf,O_RDONLY);
}

/* We need to go through the files looking for the appropriate position
   within the files
*/
off_t cMediamvpVdrRecURL::Seek(void *ptr, off_t offset, int whence)
{
    cMediamvpVdrRecURL *vdrrecurl = ( cMediamvpVdrRecURL *) ptr;
 
    struct stat sb;
    char        buf[FILENAME_MAX+1];
    off_t      oldlength;
    off_t      length;
    int         number;
    
    for ( oldlength = 0, length = 0, number = 1; length < offset; number++ ) {
        snprintf(buf,sizeof(buf),"%s%03d.vdr",vdrrecurl->filename,number);
        if ( stat(buf,&sb) == -1 ) {
            return (off_t)-1;
        }
        oldlength = length;
        length += sb.st_size;
    }

    vdrrecurl->curfile = number - 2;  /* We incremented at top of loop
                                         and ::Open() increments */

    vdrrecurl->OpenFile();

    lseek(vdrrecurl->fd,offset - oldlength,SEEK_SET);


    return offset;;
}

void cMediamvpVdrRecURL::Close(void *ptr)
{
    cMediamvpVdrRecURL *vdrrecurl = ( cMediamvpVdrRecURL *) ptr;

    if ( vdrrecurl != NULL ) {       
        delete vdrrecurl;
    }
    return;
}

int cMediamvpVdrRecURL::Read(void *ptr, unsigned char *buf, size_t buflen)
{
    cMediamvpVdrRecURL *vdrrecurl = ( cMediamvpVdrRecURL *)ptr;
    size_t  ret = 0;
    size_t  i = 0;
    int     red;


    red = read(vdrrecurl->fd,buf + ret,buflen - ret);

    if ( red >= 0 ) {
        ret += red;
    }

    if ( ret != buflen ) {
        vdrrecurl->OpenFile();
        if ( vdrrecurl->fd != -1 ) {
            red = read(vdrrecurl->fd,buf + ret, buflen - ret);
            if ( red > 0 ) {
                ret += red;
            }
        }
    }

    /* We saved the last few bytes of the last read since there wasn't
       enough there for an mpeg header, so do a bit of copying around the
       place to try and find the header info
    */
    if ( vdrrecurl->tmplen > 0 && ret > 6 ) {
        memcpy(vdrrecurl->tmp + vdrrecurl->tmplen,buf,6);
        unsigned char *lbuf = vdrrecurl->tmp;
        unsigned char *modify = buf - vdrrecurl->tmplen;

        if ( lbuf[0] == 0x00 && lbuf[1] == 0x00 && lbuf[2] == 0x01 && lbuf[3] == 0xC1 ) {
            modify[3] = 0;
        }
    }
    vdrrecurl->tmplen = 0;


    /* Lets try and strip out any additional audio tracks here */
    if ( ret > vdrrecurl->offset + 6) {
        for ( i = vdrrecurl->offset; i < ret - 6; i++ ) {
            if ( buf[i] == 0x00 && buf[i+1] == 0x00 && buf[i + 2] == 0x01 ) {
                uchar c = buf[i+3];
                int l = buf[i + 4] * 256 + buf[i + 5] + 6;           
                if ( c == 0xC1  ) {
                    buf[i+3] = 0xB0;
                }
                
                if ( ( c >= 0xE0 && c <= 0xEF ) || ( c >= 0xC0 || c <= 0xCF ) ) {
                    if ( l ) 
                        i += l -1;
                }
            }
        }
        vdrrecurl->offset = 0;
    }
   
    if ( i > 0 &&  i <= ret ) {
        --i;  /* We incremented at top of loop */
        memcpy(vdrrecurl->tmp + vdrrecurl->tmplen,&buf[i],(ret - i) );
        vdrrecurl->tmplen += (ret -  i) ;
    } else {
        vdrrecurl->offset = i - ret;
    }
      

    return ret;
}

int cMediamvpVdrRecURL::Info(void *ptr, int cmd, void *args)
{
    cMediamvpVdrRecURL *vdrrecurl = ( cMediamvpVdrRecURL *) ptr;

    if ( cmd == URLFILE_SIZE ) {
        struct stat sb;
        char        buf[FILENAME_MAX+1];
        off_t	    length;
        int         number;
    
        for ( length = 0, number = 1; ; number++ ) {
            snprintf(buf,sizeof(buf),"%s%03d.vdr",vdrrecurl->filename,number);
            if ( stat(buf,&sb) == -1 ) {
                break;
            }
            length += sb.st_size;
        }
       
        *((off_t *)args) = length;

        return 0;
    } else if ( cmd == URLFILE_NAME ) {
        *(char **)args = vdrrecurl->name;
    }
    return -1;
}
