/*
 *  MediaMVP Output Device for VDR
 *
 *  $Id: mvpwrap.h,v 1.1 2004/04/25 16:35:46 dom Exp $ 
 *  $Date: 2004/04/25 16:35:46 $
 *
 *  This wraps up the real device in a redirecting layer
 *
 *  The main action takes place in a thread.
 *
 */

#ifndef MVPWRAP_H
#define MVPWRAP_H

#include <vdr/device.h>

#include "mvpprog.h"

class cMvpWrap: public cDevice {
private:
    cMvpProgram    Program;
    
public:
    cMvpWrap(void);
    ~cMvpWrap();

    void MakePrimaryDevice(bool On);
    int ProvidesCa(int Ca);
    virtual bool HasDecoder(void) const;

    virtual bool CanReplay(void) const;
    virtual bool SetPlayMode(ePlayMode PlayMode);

    virtual void TrickSpeed(int Speed);
    virtual void Clear(void);
    virtual void Play(void);
    virtual void Freeze(void);
    virtual void Mute(void);
    virtual void StillPicture(const uchar *Data, int Length);
    virtual int PlayVideo(const uchar *Data, int Length);
    virtual void SetVideoFormat(bool VideoFormat16_9);
    virtual void SetVolumeDevice(int Volume);

    virtual bool Poll(cPoller &Poller, int TimeoutMs = 0);
    virtual cOsdBase *NewOsd(int x, int y);
};

#endif // MVPWRAP_H
