/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: menuapp.h,v 1.2 2003/12/04 12:12:39 dom Exp $
 *   $Date: 2003/12/04 12:12:39 $
 *
 *
 *   Details of the menuapp
 */



#ifndef MENUAPP_H
#define MENUAPP_H

/* Get in some basic definitions from the library */
#include "libmvp.h"

#include "libini.h"

typedef struct _menuapp menuapp_t;
typedef struct _menu    menu_t;


#define   MENU_NUMBERS   1
#define   MENU_NONE      0
#define   MENU_INT       1


extern void            menuapp_config();
extern void            menuapp_init();
extern menuapp_t      *new_menuapp(dongle_t *dongle, render_t *render, app_t *app);
extern void            delete_menuapp(menuapp_t *app);

extern menu_t         *new_menu(dongle_t *dongle, render_t *render, app_t *app,menu_t *parent,void *param, int flags);
extern void            delete_menu_tree(menu_t *menu);
extern void            delete_menu(menu_t *menu);
extern void            menu_set_title(menu_t *menu, char *text);
extern void            menu_add_option(menu_t *menu, char *name, 
                                       int (callback_func)(menu_t *menu,void *param, int sel),
                                       int type, int num_options, char **options,void *value_ptr);

extern void            menu_add(menu_t *menu, char *name, int (*callback_func)(menu_t *menu,void *param, int sel));
extern void            menu_display(menu_t *menu);
extern void            menu_set_param_clearup(menu_t *menu, void (*clearup)(void *ptr));
extern void            menu_set_colour_actions(menu_t *menu,
                                               char   *red,
                                               char   *green,
                                               char   *yellow,
                                               char   *blue,
                                               int   (*func)(menu_t *menu,void *param, int key, int sel));




#endif
