/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: main.c,v 1.1.1.1 2003/12/04 00:10:13 dom Exp $
 *   $Date: 2003/12/04 00:10:13 $
 *
 *
 *   Startup..
 */

#include "mediamvp.h"

#include "menuapp.h"
#include "libini.h"



static char       *c_interface;
uint32_t           main_interfaceip;

static int         c_width          = 720;
static int         c_depth          = 576;
static int         c_totwidth       = 720;
static int         c_totdepth       = 576;
static int         c_gui_port       = 5906;
static int         c_stream_port    = 6337;
static int         c_dongleversion  = 21323;

int main(int argc, char *argv[])
{
    char hostbuf[2048];


    iniparse_init();

    iniparse_add("main:interface",OPT_STR,&c_interface);
    iniparse_add("main:dongleversion",OPT_INT,&c_dongleversion);
    iniparse_add("main:streamport",OPT_INT,&c_stream_port);
    iniparse_add("main:guiport",OPT_INT,&c_gui_port);
    iniparse_add("main:width",OPT_INT,&c_width);
    iniparse_add("main:depth",OPT_INT,&c_depth);
    iniparse_add("main:screenwidth",OPT_INT,&c_totwidth);
    iniparse_add("main:screendepth",OPT_INT,&c_totdepth);

    
    app_config();

    iniparse_file("mediamvp.conf");
    iniparse_cleanup();


    if ( c_interface == NULL ) {
        if ( gethostname(hostbuf,sizeof(hostbuf)-1) == -1 ) {
            perror("gethostbyname");
            exit(1);
        }
        c_interface = hostbuf;
    }

    if ( ( main_interfaceip = host_resolve(c_interface) ) == - 1 ) {
        fprintf(stderr,"Cannot resolve host <%s>\n",c_interface);
        exit(1);
    }

    event_init();

    app_init();

    mediamvp_server_init(c_stream_port,c_gui_port,c_dongleversion,
                         c_totwidth,c_totdepth,c_width,c_depth);

   
    event_dispatch();

    return 0;
}

    


/*
 * Local Variables:
 *  indent-tabs-mode:nil
 *  require-final-newline:t
 *  c-basic-offset: 4
 * End:
 */
