/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: dongle.c,v 1.3 2003/11/19 23:48:13 dom Exp $
 *   $Date: 2003/11/19 23:48:13 $
 *
 *
 *   Dongle registration - maintains a list of dongles with their subcomponents 
 */


#include "mediamvp.h"


static int        dongles_num   = 0;
static dongle_t  *dongles       = NULL;



dongle_t *dongle_return(char *address)
{
    dongle_t  *dongle;
    int        i;
    int        first = -1;

    for ( i = 0; i < dongles_num; i++ ) {
        if ( strcmp(dongles[i].address,address) == 0 && dongles[i].inuse ) {
            return &dongles[i];
        }
        if ( dongles[i].inuse == FALSE ) {
            first = i;
        }
    }

    if ( first != -1 ) {
        dongle=&dongles[first];
    } else {
        i = dongles_num++;
        dongles = realloc(dongles,dongles_num * sizeof(dongle_t));
        dongle = &dongles[i];
    }


    strcpy(dongle->address,address);
    dongle->inuse = TRUE;
    dongle->gui = NULL;
    dongle->stream = NULL;

    /* Reset to defaults - we ask client for details of these settings */
    dongle->tvmode = 0;
    dongle->videooutput = 0;
    dongle->flickermode = 0;
    dongle->aspectratio = 0;

    return dongle;
}


void dongle_close(dongle_t *dongle)
{
    delete_gui(dongle->gui);
    delete_stream(dongle->stream);
    dongle->stream = NULL;
    dongle->gui    = NULL;
    /* Close gui/stream here */
    dongle->inuse = FALSE;
}




/*
 * Local Variables:
 *  indent-tabs-mode:nil
 *  require-final-newline:t
 *  c-basic-offset: 4
 * End:
 */
