/*
 *   MediaMVP Plugin
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: vdrurl.c,v 1.4 2003/12/13 14:06:53 dom Exp $
 *   $Date: 2003/12/13 14:06:53 $
 *
 *
 *   Handle the vdr:// URL type
 */

#include "libmvp.h"

#include "vdrurl.h"
#include "misc.h"

cMediamvpVdrURL::cMediamvpVdrURL()
{
    m_Transceiver = NULL;
}

cMediamvpVdrURL::~cMediamvpVdrURL()
{

}



cDevice *cMediamvpVdrURL::GetDevice(const cChannel *Channel, int Priority)
{
    cDevice    *device = NULL;
    int         i;

    for (i = 0; i < cDevice::NumDevices(); ++i) {
        device = cDevice::GetDevice(i);
        if (device == cDevice::PrimaryDevice())
            // Prefer secondary devices over Primary
            continue;
        
        if (!device->ProvidesChannel(Channel, Priority))
            continue;

        if (device != cDevice::ActualDevice())
            // Should be ok if the current channel doesn't run there
            break;

        cChannel *current   = Channels.GetByNumber(cDevice::PrimaryDevice()->CurrentChannel());
        if (current->Frequency() == Channel->Frequency() )
            // Should be ok if the tuned Frequency is equal to the requested one
            break;
    }

    if (i == cDevice::NumDevices()) {
        device = cDevice::PrimaryDevice();
        if (device == cDevice::ActualDevice()) {
            cChannel *current = Channels.GetByNumber(cDevice::PrimaryDevice()->CurrentChannel());
            if (current->Frequency() != Channel->Frequency() )
                device = NULL;
        }
    }
        
    return device;
}

int cMediamvpVdrURL::Open(char *name, void **ptr, int *type)
{
    cMediamvpVdrURL *vdrurl = new cMediamvpVdrURL;
    char            *realname;
    const cChannel  *Channel;
    cDevice         *device;

    if ( strncmp(name,"vdr://",strlen("vdr://") ) ) {
        return -1;
    }
    
    realname = name + strlen("vdr://");

    if ( ( Channel = ChannelFromString(realname) ) == NULL ) {
        return -1;
    }

    
    if ( (device = vdrurl->GetDevice(Channel,0) ) == NULL ) {
        return -1;
    }

    if ( Channel->Vpid() == 0 || Channel->Vpid() == 1 || Channel->Vpid() == 0x1fff ) {
        *type = MEDIA_MP3 | MEDIA_SOCKET | MEDIA_LIVE;
    } else {
        *type = MEDIA_MPEG | MEDIA_SOCKET | MEDIA_LIVE;
    }

    if ( pipe(&vdrurl->transfer_pipe[0]) == -1 ) {
        return -1;
    }


    /* Create a new transceiver */
    vdrurl->m_Transceiver = new cMediamvpTransceiver(Channel,0,vdrurl->transfer_pipe[1],device);

    /* Dump into the storage space a pointer to our class */
    *ptr = vdrurl;

    vdrurl->m_Transceiver->Activate(TRUE);


    return vdrurl->transfer_pipe[0];      
}

off_t cMediamvpVdrURL::Seek(char *name, void *ptr, int fd, off_t offset, int whence)
{
    cMediamvpVdrURL *vdrurl = ( cMediamvpVdrURL *) ptr;


    return (off_t) -1;
}

int cMediamvpVdrURL::Close(char *name, void *ptr, int fd)
{
    cMediamvpVdrURL *vdrurl = ( cMediamvpVdrURL *) ptr;


    if ( vdrurl->m_Transceiver != NULL ) {
        DELETENULL(vdrurl->m_Transceiver);
    }


    close(vdrurl->transfer_pipe[0]);
    close(vdrurl->transfer_pipe[1]);

    delete vdrurl;

    return 0;
}
