/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic morris
 *
 *   $Id: gui.h,v 1.1.1.1 2003/12/04 00:10:13 dom Exp $
 *   $Date: 2003/12/04 00:10:13 $
 *
 *
 *   RFB definitions
 */

#ifndef __GUI_H__
#define __GUI_H__

#include "keys.h"
#include <zlib.h>

#define RFB_MAJOR   3
#define RFB_MINOR   3

enum {
  VNC_DEALLOCATED,
  VNC_VERSION,
  VNC_VERSION2,
  VNC_AUTH,
  VNC_AUTH2,
  VNC_INIT,
  VNC_INIT2,
  VNC_RUNNING
};


/* send message types */
#define SEND_NONE          0
#define SEND_SCREEN        1
#define SEND_PING          2

#define RFB_WIDTH          720
#define RFB_DEPTH          576

/* RFB authentication constants. */

#define RFB_AUTH_FAILED      0
#define RFB_AUTH_NONE        1
#define RFB_AUTH_VNC         2

#define RFB_VNC_AUTH_OK      0
#define RFB_VNC_AUTH_FAILED  1
#define RFB_VNC_AUTH_TOOMANY 2

/* RFB message types. */

/* From server to client: */
#define RFB_FB_UPDATE            0
#define RFB_SET_COLORMAP_ENTRIES 1
#define RFB_BELL                 2
#define RFB_SERVER_CUT_TEXT      3

/* HP extensions here */
#define RFB_RDC                  4

/* From client to server. */
#define RFB_SET_PIXEL_FORMAT     0
#define RFB_FIX_COLORMAP_ENTRIES 1
#define RFB_SET_ENCODINGS        2
#define RFB_FB_UPDATE_REQ        3
#define RFB_KEY_EVENT            4
#define RFB_POINTER_EVENT        5
#define RFB_CLIENT_CUT_TEXT      6
#define RFB_RDC_ACK            7

/* HP extensions here */
#define RFB_PING                 8

/* Encoding types. */
#define RFB_ENC_RAW      0
#define RFB_ENC_COPYRECT 1
#define RFB_ENC_RRE      2
#define RFB_ENC_CORRE    3
#define RFB_ENC_HEXTILE  4



#endif
