/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic morris
 *
 *   $Id: udp.c,v 1.8 2003/11/18 22:44:53 dom Exp $
 *   $Date: 2003/11/18 22:44:53 $
 *
 *
 *   Handles the initial UDP phase
 *
 *   Incoming protocol to 16881 - packet length is 52

4   32:  0001
2   16:  babe
2   16:  fafe
6   48:  mac address
2   16:  0000
4   32:  client address
2   16:  port to call back on
30   30:  00
==52


   Reply:

4   32:  0001
2   16:  fafe
2   16:  babe
8   64:  0000 0000 0000 0000 
4   32:  client ip
2   16:  port to make tcp connection from
2   16:  0000
4   32:  server ip
2   16:  gui port (-100!)
2   16:  0000
4   32:  server ip
2   16:  control port
6   48:  0000 0000 0000
4   32:  server ip
2   16:  unknown port - 16886
===52
   Client the connects to 6337
*/


#include "mediamvp.h"

/* This is the breakdown of the UDP message */

typedef struct {
    uint32_t  sequence;
    uint32_t  id1;
    uint32_t  id2;
    uint8_t   mac[6];
    uint8_t   pad[2];
    uint32_t  client_addr;
    uint16_t  client_port;
    uint8_t   pad2[2];
    uint32_t  guiserv_addr;
    uint16_t  guiserv_port;
    uint8_t   pad3[2];
    uint32_t  conserv_addr;
    uint16_t  conserv_port;
    uint8_t   pad4[6];
    uint32_t  serv_addr;
    uint16_t  serv_port;
} udpprot_t;


static struct event listen_event;


static void          udp_read(int fd, short event, void *arg);
static void          parse_udp(udpprot_t *prot,unsigned char *buf, int len);
static void          serialise_udp(udpprot_t *prot, unsigned char *buf, int len);

static int           c_udpport      = 16881;

void udp_config()
{
    iniparse_add("udp:port",OPT_INT,&c_udpport);
}


void udp_init()
{
    int   sock;

    if ( (sock = udp_listen(NULL,c_udpport) ) == -1 ) {
        perror("udp");
        exit(1);
    }


    event_set(&listen_event,sock,EV_READ,udp_read,&listen_event);

    /* Add the event with no timeout */
    event_add(&listen_event,NULL);
}



static void udp_read(int fd, short event, void *arg)
{
    struct event  *ev = arg;
    char           msg[60];
    char           buf[500];
    int            len;
    char          *desthost;
    int            destport;
    uint32_t       desthostip;
    udpprot_t      prot;
    struct in_addr in;

    /* Reschedule event */
    event_add(ev,NULL);

    len = read(fd,buf,sizeof(buf)-1);

    // dump_hex(buf,len);

    if ( len == 52 ) {
        parse_udp(&prot,buf,len);

        if ( prot.id1 != 0xbabe || prot.id2 != 0xfafe ) {
            printf("id1 = %04x id2=%04x\n",prot.id1,prot.id2);
            return;
        }

        printf("Client addr is %04x %02x\n",prot.client_addr,prot.client_port);

        prot.id1 = 0xfafe;
        prot.id2 = 0xbabe;
        memset(&prot.mac,0,8);
        destport = prot.client_port;
        prot.client_port = 2048;

        /* FIXME Here to support multiple clients */
        prot.guiserv_addr = ntohl(c_gui_hostip);
        prot.guiserv_port = c_gui_port;
        prot.conserv_addr = ntohl(c_stream_hostip);
        prot.conserv_port = c_stream_port;
        prot.serv_addr = ntohl(main_interfaceip);  /* No idea what this is.. */
        prot.serv_port = 16886;
	    
        serialise_udp(&prot,msg,52);
        desthostip = ntohl(prot.client_addr);
        memcpy(&in,&desthostip,4);
        desthost = inet_ntoa(in);
        printf("Sending to %s:%d\n",desthost,destport);

        //	dump_hex(msg,52);
        udp_send(msg,52,desthost,destport);
    }
}


static void parse_udp(udpprot_t *prot,unsigned char *buf, int len)
{
    unsigned char  *ptr = buf;

    BUF_TO_INT32(prot->sequence,ptr);
    BUF_TO_INT16(prot->id1,ptr);
    BUF_TO_INT16(prot->id2,ptr);
    memcpy(&prot->mac,ptr,6);
    ptr += 6;
    ptr += 2;  /* Skip pad */
    BUF_TO_INT32(prot->client_addr,ptr);
    BUF_TO_INT16(prot->client_port,ptr);
    ptr += 2;  /* Skip pad */
    BUF_TO_INT32(prot->guiserv_addr,ptr);
    BUF_TO_INT16(prot->guiserv_port,ptr);
    ptr += 2;  /* Skip pad */
    BUF_TO_INT32(prot->conserv_addr,ptr);
    BUF_TO_INT16(prot->conserv_port,ptr);
    ptr += 6;  /* Skip pad */
    BUF_TO_INT32(prot->serv_addr,ptr);
    BUF_TO_INT16(prot->serv_port,ptr);
}

static void serialise_udp(udpprot_t *prot, unsigned char *buf, int len)
{
    unsigned char *ptr = buf;
    memset(buf,0,len);

    INT32_TO_BUF(prot->sequence,ptr);
    INT16_TO_BUF(prot->id1,ptr);
    INT16_TO_BUF(prot->id2,ptr);
    memcpy(&prot->mac,ptr,6);
    ptr += 6;
    ptr += 2;  /* Skip pad */
    INT32_TO_BUF(prot->client_addr,ptr);
    INT16_TO_BUF(prot->client_port,ptr);
    ptr += 2;  /* Skip pad */
    INT32_TO_BUF(prot->guiserv_addr,ptr);
    INT16_TO_BUF(prot->guiserv_port,ptr);
    ptr += 2;  /* Skip pad */
    INT32_TO_BUF(prot->conserv_addr,ptr);
    INT16_TO_BUF(prot->conserv_port,ptr);
    ptr += 6;  /* Skip pad */
    INT32_TO_BUF(prot->serv_addr,ptr);
    INT16_TO_BUF(prot->serv_port,ptr);
}



