/* 
 *  This table was derived from on-air transmissions.  It certainly has omissions and 
 *  almost certainly contains errors.  Use entirely at your own risk. 
 */ 
 
static struct hufftab fsat_huffman1[] = 
{ 
        { START,  0x00000000,  2, 'T'}, 
        { START,  0x40000000,  3, 'B'}, 
        { START,  0x60000000,  5, 'L'}, 
        { START,  0x68000000,  7, 'K'}, 
        { START,  0x6a000000,  8, '6'}, 
        { START,  0x6c000000,  6, 'Q'}, 
        { START,  0x70000000,  5, 'D'}, 
        { START,  0x78000000,  5, 'H'}, 
        { START,  0x80000000,  4, 'C'}, 
        { START,  0x90000000,  4, 'I'}, 
        { START,  0xa0000000,  5, 'R'}, 
        { START,  0xa8000000,  5, 'N'}, 
        { START,  0xb0000000,  5, 'E'}, 
        { START,  0xb8000000,  8, 'V'}, 
        { START,  0xb9000000, 10, 'Z'}, 
        { START,  0xb9400000, 11, '1'}, 
        { START,  0xb9600000, 11, '3'}, 
        { START,  0xb9800000,  9, '2'}, 
        { START,  0xba000000,  7, 'U'}, 
        { START,  0xbc000000,  6, 'G'}, 
        { START,  0xc0000000,  5, 'F'}, 
        { START,  0xc8000000,  5, 'A'}, 
        { START,  0xd0000000,  4, 'S'}, 
        { START,  0xe0000000,  5, 'M'}, 
        { START,  0xe8000000,  5, 'P'}, 
        { START,  0xf0000000,  5, 'W'}, 
        { START,  0xf8000000,  6, 'J'}, 
        { START,  0xfc000000,  7, 'O'}, 
        { START,  0xfe000000,  8, 'Y'}, 
    { START,  0xff400000, 11, '4'}, 
        { START,  0xff600000, 14, '5'}, 
        { START,  0xff698000, 18, 't'}, 
        { START,  0xff800000,  9, 'X'}, 
        { ' ',    0x00000000,  4, 'W'}, 
        { ' ',    0x10000000,  7, 'f'}, 
        { ' ',    0x12000000,  7, 'Q'}, 
        { ' ',    0x14000000,  8, '-'}, 
    { ' ',    0x15240000, 14, '.'}, 
        { ' ',    0x152c0000, 14, 'l'}, 
        { ' ',    0x15300000, 13, 'g'}, 
        { ' ',    0x15400000, 10, 'r'}, 
        { ' ',    0x15800000, 11, 'b'}, 
        { ' ',    0x15a00000, 12, 'v'}, 
        { ' ',    0x15b00000, 12, 'd'}, 
        { ' ',    0x15f00000, 13, 'u'}, 
        { ' ',    0x16000000,  7, 'V'}, 
        { ' ',    0x18000000,  5, 'I'}, 
        { ' ',    0x20000000,  5, 'G'}, 
        { ' ',    0x28000000,  7, STOP}, 
        { ' ',    0x2a000000,  7, 'w'}, 
        { ' ',    0x2c000000,  6, 'U'}, 
        { ' ',    0x30000000,  4, 'M'}, 
        { ' ',    0x40000000,  4, 'C'}, 
        { ' ',    0x50000000,  4, 'B'}, 
        { ' ',    0x60000000,  5, 'H'}, 
        { ' ',    0x68000000,  5, 'D'}, 
        { ' ',    0x70000000,  4, 'P'}, 
        { ' ',    0x80000000,  5, 'o'}, 
        { ' ',    0x88000000,  5, 'A'}, 
        { ' ',    0x90000000,  4, 'T'}, 
        { ' ',    0xa0000000,  5, 't'}, 
        { ' ',    0xa8000000,  9, '&'}, 
        { ' ',    0xa8800000, 10, '5'}, 
        { ' ',    0xa8c00000, 10, 'Z'}, 
        { ' ',    0xa9000000,  8, '1'}, 
        { ' ',    0xaa000000, 11, '\''}, 
        { ' ',    0xaa200000, 11, '0'}, 
        { ' ',    0xaa400000, 10, '9'}, 
        { ' ',    0xab000000, 11, '6'}, 
        { ' ',    0xab200000, 12, 'n'}, 
        { ' ',    0xab300000, 12, '8'}, 
        { ' ',    0xab400000, 10, 's'}, 
        { ' ',    0xab800000, 10, '4'}, 
        { ' ',    0xabc00000, 10, '3'}, 
        { ' ',    0xac000000,  6, 'O'}, 
        { ' ',    0xb0000000,  5, 'a'}, 
        { ' ',    0xb8000000,  5, 'F'}, 
        { ' ',    0xc0000000,  4, 'N'}, 
        { ' ',    0xd0000000,  5, 'L'}, 
        { ' ',    0xd8000000,  5, 'R'}, 
        { ' ',    0xe0000000,  7, '2'}, 
        { ' ',    0xe2000000,  7, 'K'}, 
        { ' ',    0xe4000000,  6, 'J'}, 
        { ' ',    0xe8000000,  6, 'E'}, 
        { ' ',    0xec000000,  7, 'Y'}, 
        { ' ',    0xee000000,  7, 'i'}, 
        { ' ',    0xf0000000,  4, 'S'}, 
        { '!',    0x40000000,  2, ' '}, 
        { '!',    0x80000000,  8, STOP}, 
        { '&',    0x40000000,  2, 'B'}, 
        { '&',    0x80000000,  1, ' '}, 
    { '%',    0x80000000,  1, ' '}, 
    { ',',    0x80000000,  1, ' '}, 
    { '-',    0x0c000000,  7, 'L'}, 
        { '-',    0x1c000000,  6, 'I'}, 
        { '-',    0x20000000,  8, 'P'}, 
        { '-',    0x38000000, 10, 'E'}, 
        { '-',    0x40000000,  4, 'U'}, 
        { '-',    0x5d000000,  8, 'i'}, 
        { '-',    0x84000000,  7, 'D'}, 
    { '-',    0x96af8000, 17, 'H'}, 
        { '-',    0xb0000000,  4, 'S'}, 
        { '-',    0xc0000000,  2, ' '}, 
        { '.',    0x08000000,  5, 'T'}, 
        { '.',    0x19600000, 13, ESCAPE}, 
        { '.',    0x1a000000,  8, 'W'}, 
        { '.',    0x20000000,  4, ' '}, 
        { '.',    0x40000000,  2, STOP}, 
        { '.',    0x80000000,  1, '.'}, 
    { '/',    0x40000000,  3, '7'}, 
    { '0',    0x40000000,  2, ' '}, 
        { '0',    0x80000000,  3, '6'}, 
        { '0',    0xa0000000,  4, STOP}, 
        { '0',    0xb0000000,  6, '8'}, 
        { '0',    0xb4000000,  7, 's'}, 
    { '0',    0xb7000000,  9, '/'}, 
    { '0',    0xb7800000,  9, '%'}, 
    { '0',    0xb8000000,  5, '7'}, 
        { '0',    0xc0000000,  2, '0'}, 
        { '1',    0x30000000,  4, ' '}, 
        { '1',    0x40000000,  2, STOP}, 
        { '1',    0x8c000000,  6, ':'}, 
        { '1',    0x98000000,  6, '\''}, 
        { '1',    0xa0000000,  3, '0'}, 
    { '1',    0xc0000000,  5, '3'}, 
        { '1',    0xc8000000,  6, 'X'}, 
        { '1',    0xcc000000,  6, '9'}, 
        { '1',    0xe0000000,  3, '1'}, 
        { '2',    0x00000000,  1, '0'}, 
        { '2',    0x80000000,  5, ':'}, 
        { '2',    0x90000000,  4, ' '}, 
        { '2',    0xa0000000,  3, STOP}, 
        { '2',    0xc0000000,  2, '4'}, 
        { '3',    0x00000000,  1, ' '}, 
        { '3',    0x80000000,  8, STOP}, 
        { '3',    0xe0000000,  5, '0'}, 
        { '3',    0xe8000000,  7, ':'}, 
        { '4',    0x00000000,  8, STOP}, 
    { '4',    0x52000000,  8, 'M'}, 
        { '4',    0x90000000,  4, ':'}, 
        { '4',    0xa0000000,  3, '-'}, 
        { '4',    0xc0000000,  2, ' '}, 
        { '5',    0xa0000000,  3, '0'}, 
        { '5',    0xc0000000,  2, ' '}, 
        { '6',    0x40000000,  2, ' '}, 
        { '6',    0x80000000,  2, '0'}, 
        { '6',    0xc6000000,  7, '4'}, 
        { '6',    0xd8000000,  6, '8'}, 
        { '6',    0xe0000000,  3, ':'}, 
        { '7',    0x80000000,  8, STOP}, 
        { '8',    0x00000000,  2, '0'}, 
        { '8',    0x84000000,  7, ':'}, 
        { '8',    0x86800000,  9, STOP}, 
    { '8',    0x87800000, 10, '.'}, 
    { '8',    0x88000000,  5, ' '}, 
        { '9',    0x00000000,  1, '1'}, 
        { '9',    0x80000000,  4, '9'}, 
        { '9',    0x98000000,  5, '0'}, 
        { '9',    0xa0000000,  3, '6'}, 
        { '9',    0xc0000000,  3, STOP}, 
        { ':',    0x00000000,  2, '0'}, 
        { ':',    0x58000000,  8, ESCAPE}, 
    { ':',    0x59000000,  8, 'T'}, 
    { ':',    0x60000000,  3, '.'}, 
    { ':',    0x80000000,  1, ' '}, 
        { '?',    0x20000000,  3, ':'}, 
        { '?',    0x40000000,  2, ' '}, 
        { '?',    0x80000000,  2, STOP}, 
        { 'A',    0x00000000,  4, 'm'}, 
        { 'A',    0x10000000,  5, 'w'}, 
        { 'A',    0x18000000,  6, 'u'}, 
        { 'A',    0x1c000000,  6, STOP}, 
        { 'A',    0x20000000,  3, 'r'}, 
        { 'A',    0x40000000,  3, ' '}, 
        { 'A',    0x68000000,  5, 'c'}, 
        { 'A',    0x70000000,  4, 'g'}, 
        { 'A',    0x80000000,  3, 'l'}, 
        { 'A',    0xa2000000,  7, 'v'}, 
        { 'A',    0xa8000000,  5, 't'}, 
        { 'A',    0xb0000000,  5, 'f'}, 
        { 'A',    0xb8000000,  5, 'i'}, 
        { 'A',    0xc0000000,  3, 'n'}, 
        { 'A',    0xe0000000,  5, 's'}, 
        { 'A',    0xe8000000,  6, 'b'}, 
        { 'A',    0xec000000,  7, 'p'}, 
        { 'A',    0xef180000, 13, '\''}, 
        { 'A',    0xef400000, 12, 'y'}, 
        { 'A',    0xf0000000,  4, 'd'}, 
        { 'B',    0x00000000,  2, 'C'}, 
        { 'B',    0x40000000,  2, 'B'}, 
        { 'B',    0x80000000,  6, STOP}, 
        { 'B',    0x84000000,  7, 'y'}, 
        { 'B',    0x87a00000, 11, 'h'}, 
        { 'B',    0x87e00000, 11, ' '}, 
        { 'B',    0x88000000,  5, 'l'}, 
        { 'B',    0x90000000,  4, 'i'}, 
        { 'B',    0xa0000000,  3, 'r'}, 
        { 'B',    0xc0000000,  4, 'o'}, 
        { 'B',    0xd0000000,  4, 'u'}, 
        { 'B',    0xe0000000,  4, 'a'}, 
        { 'B',    0xf0000000,  4, 'e'}, 
        { 'C',    0x00000000,  2, 'o'}, 
        { 'C',    0x40000000,  2, ' '}, 
        { 'C',    0x80000000,  3, 'l'}, 
        { 'C',    0xa0000000,  4, 'r'}, 
        { 'C',    0xb0000000,  5, 'i'}, 
        { 'C',    0xb8000000,  5, 'e'}, 
        { 'C',    0xc0000000,  3, 'h'}, 
        { 'C',    0xe0000000,  4, 'a'}, 
        { 'C',    0xf0000000,  6, 'u'}, 
        { 'C',    0xf4000000,  6, 'B'}, 
        { 'C',    0xf8000000,  7, 'y'}, 
    { 'C',    0xfa800000, 11, '4'}, 
        { 'C',    0xfc000000,  7, '!'}, 
    { 'C',    0xfe000000,  9, STOP}, 
    { 'C',    0xfea00000, 11, 'D'}, 
        { 'C',    0xfec00000, 10, 'I'}, 
        { 'C',    0xff000000,  9, 'S'}, 
        { 'D',    0x00000000,  3, 'r'}, 
        { 'D',    0x28400000, 10, 'h'}, 
        { 'D',    0x29800000,  9, '&'}, 
        { 'D',    0x2a000000,  7, 'J'}, 
        { 'D',    0x2c000000,  6, ' '}, 
        { 'D',    0x30000000,  7, 'y'}, 
        { 'D',    0x32000000,  9, '\''}, 
        { 'D',    0x32a00000, 11, 'N'}, 
        { 'D',    0x38000000,  5, 'u'}, 
        { 'D',    0x40000000,  2, 'o'}, 
        { 'D',    0x80000000,  2, 'a'}, 
        { 'D',    0xc0000000,  3, 'e'}, 
        { 'D',    0xe0000000,  3, 'i'}, 
        { 'E',    0x00000000,  2, 'm'}, 
        { 'E',    0x40000000,  4, 'E'}, 
        { 'E',    0x50000000,  5, 'F'}, 
        { 'E',    0x58000000,  6, 'u'}, 
        { 'E',    0x5d000000,  9, 'g'}, 
        { 'E',    0x5e000000,  7, 's'}, 
        { 'E',    0x60000000,  3, 'v'}, 
        { 'E',    0x80000000,  4, STOP}, 
        { 'E',    0x90000000,  6, 'r'}, 
        { 'E',    0x96000000,  8, 'R'}, 
        { 'E',    0x98000000,  5, 'd'}, 
        { 'E',    0xa0000000,  3, 'n'}, 
        { 'E',    0xc6000000,  8, '\''}, 
        { 'E',    0xc7000000,  8, ' '}, 
        { 'E',    0xc8000000,  5, 'l'}, 
        { 'E',    0xd0000000,  4, 'x'}, 
        { 'E',    0xe0000000,  3, 'a'}, 
        { 'F',    0x00000000,  2, 'i'}, 
        { 'F',    0x40000000,  4, 'e'}, 
        { 'F',    0x50000000,  7, 'A'}, 
    { 'F',    0x52000000,  8, ' '}, 
        { 'F',    0x53000000,  9, 'h'}, 
        { 'F',    0x54000000,  7, 'O'}, 
        { 'F',    0x57200000, 11, 'I'}, 
        { 'F',    0x57600000, 11, '1'}, 
        { 'F',    0x58000000,  5, 'l'}, 
        { 'F',    0x60000000,  3, 'r'}, 
        { 'F',    0x80000000,  2, 'a'}, 
        { 'F',    0xc0000000,  3, 'u'}, 
        { 'F',    0xe0000000,  3, 'o'}, 
        { 'G',    0x00000000,  8, ':'}, 
        { 'G',    0x01300000, 13, ESCAPE}, 
    { 'G',    0x01400000, 11, 'A'}, 
    { 'G',    0x01600000, 12, 'T'}, 
        { 'G',    0x02000000,  7, 'y'}, 
    { 'G',    0x04000000,  6, 'h'}, 
        { 'G',    0x08000000,  5, 'u'}, 
        { 'G',    0x1a800000, 10, 'P'}, 
        { 'G',    0x1ac00000, 10, ' '}, 
        { 'G',    0x1b000000,  8, 'C'}, 
        { 'G',    0x1c000000,  6, 'l'}, 
        { 'G',    0x20000000,  3, 'M'}, 
        { 'G',    0x40000000,  3, 'a'}, 
        { 'G',    0x60000000,  3, 'o'}, 
        { 'G',    0x80000000,  2, 'r'}, 
        { 'G',    0xc0000000,  3, 'i'}, 
        { 'G',    0xe0000000,  3, 'e'}, 
        { 'H',    0x00000000,  1, 'o'}, 
        { 'H',    0x80000000,  3, 'a'}, 
        { 'H',    0xa0000000,  3, 'i'}, 
        { 'H',    0xc0000000,  3, 'e'}, 
        { 'H',    0xe0000000,  4, 'u'}, 
        { 'H',    0xf0000000,  5, 'R'}, 
        { 'H',    0xfe200000, 14, ESCAPE}, 
        { 'H',    0xfe280000, 13, 'D'}, 
    { 'H',    0xff000000,  9, 'S'}, 
        { 'I',    0x00000000,  1, 'T'}, 
        { 'I',    0x80000000,  3, 's'}, 
        { 'I',    0xa0000000,  3, 'n'}, 
        { 'I',    0xc0000000,  6, 'I'}, 
        { 'I',    0xc4000000,  6, STOP}, 
        { 'I',    0xc8000000,  5, ' '}, 
        { 'I',    0xd0000000,  4, 't'}, 
        { 'I',    0xe4000000,  6, 'm'}, 
        { 'I',    0xe8000000,  5, '\''}, 
        { 'I',    0xf0000000,  8, 'a'}, 
        { 'I',    0xf6900000, 13, ','}, 
        { 'I',    0xf6980000, 13, 'A'}, 
        { 'I',    0xf6c00000, 11, 'f'}, 
        { 'I',    0xf6e00000, 12, 'o'}, 
        { 'I',    0xf7000000,  9, 'c'}, 
        { 'I',    0xf7800000, 11, 'l'}, 
        { 'I',    0xf7a80000, 13, 'g'}, 
    { 'I',    0xf7d40000, 14, 'b'}, 
        { 'I',    0xf8000000,  5, 'r'}, 
        { 'J',    0x00000000,  2, 'a'}, 
        { 'J',    0x40000000,  2, 'u'}, 
        { 'J',    0x80000000,  5, ' '}, 
        { 'J',    0x8c800000,  9, 's'}, 
    { 'J',    0x8d900000, 12, 'D'}, 
        { 'J',    0x90000000,  4, 'i'}, 
        { 'J',    0xa0000000,  3, 'o'}, 
        { 'J',    0xc0000000,  2, 'e'}, 
        { 'K',    0x00000000,  4, 'a'}, 
        { 'K',    0x10000000,  8, STOP}, 
        { 'K',    0x18000000,  5, 'r'}, 
        { 'K',    0x20000000,  3, 'e'}, 
        { 'K',    0x40000000,  2, 'i'}, 
        { 'K',    0x80000000,  4, 'o'}, 
        { 'K',    0x92800000,  9, 'w'}, 
        { 'K',    0x93000000,  8, 'G'}, 
        { 'K',    0x98000000,  6, 'n'}, 
        { 'K',    0xa0000000,  3, ' '}, 
        { 'K',    0xc0000000,  2, 'y'}, 
        { 'L',    0x00000000,  2, 'a'}, 
        { 'L',    0x40000000,  3, 'e'}, 
        { 'L',    0x60000000,  7, 'l'}, 
        { 'L',    0x63000000,  8, 'y'}, 
        { 'L',    0x68000000,  5, 'K'}, 
        { 'L',    0x70000000,  4, 'u'}, 
        { 'L',    0x80000000,  2, 'o'}, 
        { 'L',    0xc0000000,  2, 'i'}, 
        { 'M',    0x00000000,  3, 'e'}, 
        { 'M',    0x20000000,  4, 'T'}, 
        { 'M',    0x30000000,  5, STOP}, 
        { 'M',    0x38200000, 11, 'h'}, 
        { 'M',    0x38c00000, 10, ' '}, 
        { 'M',    0x39000000,  8, 'r'}, 
        { 'M',    0x3a000000,  8, 'E'}, 
        { 'M',    0x3b000000, 10, '1'}, 
        { 'M',    0x3c000000,  6, 'c'}, 
        { 'M',    0x40000000,  2, 'a'}, 
        { 'M',    0x80000000,  2, 'o'}, 
        { 'M',    0xc0000000,  4, 'y'}, 
        { 'M',    0xd0000000,  4, 'u'}, 
        { 'M',    0xe0000000,  3, 'i'}, 
        { 'N',    0x00000000,  2, 'o'}, 
    { 'N',    0x45400000, 12, 'M'}, 
        { 'N',    0x45c00000, 11, 'A'}, 
        { 'N',    0x48000000,  5, 'u'}, 
        { 'N',    0x50000000,  4, 'a'}, 
        { 'N',    0x60000000,  3, 'i'}, 
        { 'N',    0x80000000,  1, 'e'}, 
        { 'O',    0x00000000,  3, '\''}, 
        { 'O',    0x30000000,  4, 'l'}, 
        { 'O',    0x40000000,  3, 'f'}, 
        { 'O',    0x60800000,  9, 'g'}, 
        { 'O',    0x62000000,  8, 'x'}, 
        { 'O',    0x64000000,  6, 'S'}, 
        { 'O',    0x68000000,  5, 'r'}, 
        { 'O',    0x70000000,  5, 'd'}, 
        { 'O',    0x7c000000,  6, 'b'}, 
        { 'O',    0x80000000,  5, 'p'}, 
        { 'O',    0x8a800000,  9, 'a'}, 
        { 'O',    0x8c000000,  6, 'v'}, 
        { 'O',    0x90000000,  4, 'm'}, 
        { 'O',    0xa8000000,  6, 'w'}, 
        { 'O',    0xac000000,  6, 'U'}, 
        { 'O',    0xb0000000,  5, STOP}, 
        { 'O',    0xbe000000,  8, 's'}, 
        { 'O',    0xc0000000,  3, 'u'}, 
        { 'O',    0xe0000000,  3, 'n'}, 
        { 'P',    0x00000000,  3, 'e'}, 
        { 'P',    0x20000000,  3, 'a'}, 
        { 'P',    0x40000000,  2, 'r'}, 
        { 'P',    0x80000000,  2, 'l'}, 
        { 'P',    0xc0000000,  6, 'D'}, 
        { 'P',    0xc4000000,  6, 'u'}, 
        { 'P',    0xc8000000,  8, ' '}, 
        { 'P',    0xc9800000,  9, 'M'}, 
        { 'P',    0xcb800000, 11, ':'}, 
        { 'P',    0xcbc60000, 15, ESCAPE}, 
    { 'P',    0xcbe80000, 13, 'G'}, 
    { 'P',    0xcc000000,  6, 'h'}, 
        { 'P',    0xd0000000,  4, 'i'}, 
        { 'P',    0xe0000000,  3, 'o'}, 
        { 'Q',    0x68000000,  5, 'C'}, 
        { 'Q',    0x80000000,  1, 'u'}, 
        { 'R',    0x00000000,  2, 'a'}, 
        { 'R',    0x40000000,  2, 'o'}, 
        { 'R',    0x80000000,  3, 'i'}, 
    { 'R',    0xa4540000, 15, ESCAPE}, 
        { 'R',    0xa4600000, 12, ' '}, 
        { 'R',    0xa4c00000, 10, 'n'}, 
        { 'R',    0xa6000000,  7, STOP}, 
        { 'R',    0xa8000000,  5, 'E'}, 
        { 'R',    0xb0000000,  4, 'u'}, 
        { 'R',    0xc0000000,  2, 'e'}, 
        { 'S',    0x00000000,  5, 'n'}, 
        { 'S',    0x0a000000,  7, 'A'}, 
        { 'S',    0x0c000000,  6, 'w'}, 
        { 'S',    0x10000000,  4, 'a'}, 
        { 'S',    0x20000000,  3, 'o'}, 
        { 'S',    0x40000000,  3, 'p'}, 
        { 'S',    0x60000000,  3, 'u'}, 
        { 'S',    0x80000000,  8, 'O'}, 
    { 'S',    0x81000000,  9, 'y'}, 
        { 'S',    0x83000000,  8, ' '}, 
        { 'S',    0x84000000,  7, 'l'}, 
        { 'S',    0x86000000,  9, 'E'}, 
        { 'S',    0x86800000, 11, 'g'}, 
        { 'S',    0x88000000,  5, 'i'}, 
        { 'S',    0x90000000,  4, 'e'}, 
        { 'S',    0xa0000000,  6, 'm'}, 
        { 'S',    0xa4000000,  7, 'q'}, 
        { 'S',    0xa8000000,  5, 'k'}, 
        { 'S',    0xb0000000,  4, 'c'}, 
        { 'S',    0xc0000000,  3, 'h'}, 
        { 'S',    0xe0000000,  3, 't'}, 
        { 'T',    0x00000000,  1, 'h'}, 
        { 'T',    0x80000000,  4, 'e'}, 
        { 'T',    0x90000000,  4, 'r'}, 
        { 'T',    0xa0000000,  3, 'o'}, 
        { 'T',    0xc0000000,  5, 'a'}, 
        { 'T',    0xc83e1600, 24, '-'}, 
    { 'T',    0xc9000000,  8, 'y'}, 
    { 'T',    0xcb800000,  9, '4'}, 
        { 'T',    0xcc000000,  6, 'i'}, 
        { 'T',    0xd0000000,  5, 'w'}, 
        { 'T',    0xd9000000, 10, ' '}, 
        { 'T',    0xdc000000,  8, 'u'}, 
        { 'T',    0xdd000000,  8, 'W'}, 
        { 'T',    0xde000000,  7, 'H'}, 
        { 'T',    0xe0000000,  3, 'V'}, 
        { 'U',    0x00000000,  1, 'n'}, 
        { 'U',    0x80000000,  2, 'p'}, 
        { 'U',    0xc0000000,  5, 'R'}, 
        { 'U',    0xc8800000,  9, 'r'}, 
        { 'U',    0xce000000,  8, 'E'}, 
        { 'U',    0xd0000000,  4, 'K'}, 
        { 'U',    0xe0000000,  5, 'S'}, 
        { 'U',    0xec000000,  6, 's'}, 
        { 'U',    0xf0000000,  4, 'l'}, 
        { 'V',    0x20000000,  4, 'e'}, 
        { 'V',    0x30000000,  4, 'a'}, 
        { 'V',    0x50000000,  7, '\''}, 
        { 'V',    0x52000000,  7, '4'}, 
    { 'V',    0x58000000, 10, 's'}, 
        { 'V',    0x58e00000, 14, ESCAPE}, 
        { 'V',    0x5a000000,  7, 'o'}, 
        { 'V',    0x5c000000,  8, STOP}, 
        { 'V',    0x60000000,  3, 'i'}, 
        { 'V',    0x80000000,  1, ' '}, 
        { 'W',    0x10000000,  5, 'O'}, 
        { 'W',    0x18000000,  5, 'r'}, 
        { 'W',    0x20000000,  3, 'h'}, 
        { 'W',    0x40000000,  2, 'o'}, 
        { 'W',    0x80000000,  3, 'a'}, 
        { 'W',    0xa0000000,  3, 'i'}, 
        { 'W',    0xc0000000,  2, 'e'}, 
        { 'X',    0x80000000,  2, ' '}, 
        { 'X',    0xc0000000,  2, 't'}, 
        { 'Y',    0x40000000,  2, 'e'}, 
        { 'Y',    0x80000000,  1, 'o'}, 
        { 'Z',    0x00000000,  2, 'a'}, 
        { 'Z',    0x70000000,  5, 'e'}, 
        { 'Z',    0x7e000000,  8, STOP}, 
        { 'Z',    0x80000000,  1, 'o'}, 
        { '\'',   0x00000000,  3, 'm'}, 
        { '\'',   0x20000000,  4, 't'}, 
        { '\'',   0x30000000,  4, ' '}, 
        { '\'',   0x40000000,  3, 'C'}, 
        { '\'',   0x60000000,  5, 'd'}, 
    { '\'',   0x68000000,  8, 'G'}, 
        { '\'',   0x69700000, 13, 'K'}, 
        { '\'',   0x6c000000,  6, 'r'}, 
        { '\'',   0x70000000,  5, 'v'}, 
        { '\'',   0x79000000,  8, 'l'}, 
        { '\'',   0x7a400000, 10, STOP}, 
    { '\'',   0x7b800000, 13, '0'}, 
        { '\'',   0x7b880000, 14, ESCAPE}, 
        { '\'',   0x80000000,  1, 's'}, 
        { 'a',    0x00000000,  7, 'e'}, 
        { 'a',    0x02000000,  7, '\''}, 
        { 'a',    0x04000000, 10, '!'}, 
        { 'a',    0x04600000, 11, 'a'}, 
        { 'a',    0x04800000,  9, ':'}, 
        { 'a',    0x05000000,  8, 'f'}, 
        { 'a',    0x06000000,  7, 'w'}, 
        { 'a',    0x08000000,  6, 'b'}, 
        { 'a',    0x0c000000,  8, STOP}, 
        { 'a',    0x10000000,  4, 'm'}, 
        { 'a',    0x20000000,  3, 'r'}, 
        { 'a',    0x40000000,  4, 'c'}, 
        { 'a',    0x50000000, 10, 'o'}, 
        { 'a',    0x50400000, 10, 'x'}, 
        { 'a',    0x50900000, 13, 'j'}, 
        { 'a',    0x50e00000, 11, ','}, 
        { 'a',    0x51000000,  8, 'h'}, 
        { 'a',    0x52000000,  7, 'u'}, 
        { 'a',    0x54000000,  7, 'z'}, 
        { 'a',    0x56000000,  7, 'v'}, 
        { 'a',    0x58000000,  6, 'p'}, 
        { 'a',    0x5c000000,  6, 'g'}, 
        { 'a',    0x60000000,  3, 't'}, 
        { 'a',    0x80000000,  3, 'l'}, 
        { 'a',    0xa0000000,  4, 's'}, 
        { 'a',    0xb0000000,  5, ' '}, 
        { 'a',    0xb8000000,  5, 'd'}, 
        { 'a',    0xb8000000,  5, 'd'}, 
        { 'a',    0xc0000000,  3, 'n'}, 
        { 'a',    0xe0000000,  4, 'y'}, 
        { 'a',    0xf0000000,  5, 'i'}, 
        { 'a',    0xf8000000,  5, 'k'}, 
        { 'b',    0x00000000,  3, 'r'}, 
        { 'b',    0x20000000,  3, 'o'}, 
        { 'b',    0x40000000,  3, 'e'}, 
        { 'b',    0x60000000,  3, 'a'}, 
        { 'b',    0x80000000,  3, 'i'}, 
        { 'b',    0xa0000000,  6, 'h'}, 
        { 'b',    0xa4000000,  7, ':'}, 
        { 'b',    0xa6400000, 10, 't'}, 
        { 'b',    0xa8000000,  5, 's'}, 
        { 'b',    0xb0000000,  4, 'u'}, 
        { 'b',    0xc0000000,  4, 'y'}, 
        { 'b',    0xd0000000,  4, 'l'}, 
        { 'b',    0xe0000000,  5, 'b'}, 
        { 'b',    0xe8000000,  5, STOP}, 
        { 'b',    0xf0000000,  4, ' '}, 
        { 'c',    0x00000000,  2, 'k'}, 
        { 'c',    0x40000000,  3, 'o'}, 
        { 'c',    0x60000000,  6, 'l'}, 
        { 'c',    0x64000000,  6, 'y'}, 
        { 'c',    0x68000000,  6, 's'}, 
        { 'c',    0x6c000000,  6, STOP}, 
        { 'c',    0x70000000,  4, 'r'}, 
        { 'c',    0x80000000,  3, 'h'}, 
        { 'c',    0xa0000000,  5, ' '}, 
        { 'c',    0xa8000000,  7, 'c'}, 
    { 'c',    0xaa000000,  8, ':'}, 
        { 'c',    0xac500000, 12, '\''}, 
        { 'c',    0xac600000, 11, 'A'}, 
        { 'c',    0xac800000,  9, 'D'}, 
        { 'c',    0xad400000, 11, 'q'}, 
        { 'c',    0xad680000, 13, 'I'}, 
        { 'c',    0xae000000,  7, 'u'}, 
        { 'c',    0xb0000000,  5, 'i'}, 
        { 'c',    0xb8000000,  5, 'a'}, 
        { 'c',    0xc0000000,  3, 't'}, 
        { 'c',    0xe0000000,  3, 'e'}, 
        { 'd',    0x00000000,  5, 'o'}, 
        { 'd',    0x08000000,  7, '\''}, 
        { 'd',    0x0a000000,  8, ':'}, 
        { 'd',    0x0b000000,  8, 'h'}, 
        { 'd',    0x0c000000,  6, 'u'}, 
        { 'd',    0x10000000,  4, 'y'}, 
        { 'd',    0x20000000,  3, 'e'}, 
        { 'd',    0x40000000,  4, 'i'}, 
        { 'd',    0x50000000,  5, 'd'}, 
        { 'd',    0x58000000,  6, 'r'}, 
        { 'd',    0x5c000000,  6, 'l'}, 
        { 'd',    0x60000000,  4, 's'}, 
        { 'd',    0x70000000,  8, 'c'}, 
        { 'd',    0x71c00000, 10, 'm'}, 
        { 'd',    0x72000000,  8, 'n'}, 
        { 'd',    0x73000000,  8, 'w'}, 
        { 'd',    0x74000000,  6, 'v'}, 
        { 'd',    0x78000000,  6, 'g'}, 
        { 'd',    0x7c000000,  9, '!'}, 
        { 'd',    0x7c800000,  9, '-'}, 
        { 'd',    0x7d000000,  9, 'f'}, 
        { 'd',    0x7d800000, 10, ','}, 
        { 'd',    0x7dc00000, 11, 't'}, 
        { 'd',    0x7de00000, 11, 'b'}, 
        { 'd',    0x7e000000,  7, '.'}, 
        { 'd',    0x80000000,  3, STOP}, 
        { 'd',    0xa0000000,  3, 'a'}, 
        { 'd',    0xc0000000,  2, ' '}, 
        { 'e',    0x00000000,  3, 's'}, 
        { 'e',    0x20000000,  4, 't'}, 
        { 'e',    0x30000000,  8, 'g'}, 
        { 'e',    0x31000000,  8, 'f'}, 
        { 'e',    0x32000000,  8, 'x'}, 
        { 'e',    0x33000000, 10, 'P'}, 
        { 'e',    0x33400000, 10, 'B'}, 
        { 'e',    0x33800000,  9, 'h'}, 
        { 'e',    0x34000000,  7, 'i'}, 
        { 'e',    0x36000000,  7, 'p'}, 
        { 'e',    0x38000000,  6, 'm'}, 
        { 'e',    0x3c000000,  7, 'b'}, 
        { 'e',    0x3e000000,  8, 'k'}, 
        { 'e',    0x3f000000,  8, ':'}, 
        { 'e',    0x40000000,  2, ' '}, 
        { 'e',    0x80000000,  5, 'l'}, 
        { 'e',    0x88000000,  6, 'c'}, 
        { 'e',    0x8c000000,  6, 'd'}, 
        { 'e',    0x90000000,  4, 'n'}, 
        { 'e',    0xa0000000,  3, 'r'}, 
        { 'e',    0xc0000000,  8, STOP}, 
        { 'e',    0xd0000000,  7, 'v'}, 
        { 'e',    0xd2000000, 10, ','}, 
        { 'e',    0xd2400000, 11, '4'}, 
        { 'e',    0xd2600000, 11, '?'}, 
        { 'e',    0xd2800000,  9, '.'}, 
        { 'e',    0xd3000000,  8, 'o'}, 
        { 'e',    0xd4000000,  8, '\''}, 
        { 'e',    0xd5000000, 10, 'V'}, 
    { 'e',    0xd5400000, 10, 'z'}, 
        { 'e',    0xd5820000, 15, 'G'}, 
        { 'e',    0xd5840000, 14, 'q'}, 
        { 'e',    0xd5880000, 13, '!'}, 
        { 'e',    0xd5900000, 12, '-'}, 
        { 'e',    0xd5a00000, 11, 'u'}, 
        { 'e',    0xd5c00000, 10, 'j'}, 
        { 'e',    0xd6000000,  7, 'y'}, 
        { 'e',    0xd8000000,  5, 'e'}, 
        { 'e',    0xe0000000,  4, 'a'}, 
        { 'e',    0xf0000000,  4, 'w'}, 
        { 'f',    0x00000000,  1, ' '}, 
    { 'f',    0x80000000,  5, '.'}, 
        { 'f',    0x88000000,  6, STOP}, 
    { 'f',    0x8cb00000, 12, 's'}, 
        { 'f',    0x8d000000,  8, 'y'}, 
    { 'f',    0x8e700000, 12, ':'}, 
    { 'f',    0x8f000000,  8, 'u'}, 
        { 'f',    0x90000000,  4, 't'}, 
        { 'f',    0xa0000000,  3, 'o'}, 
        { 'f',    0xc0000000,  4, 'a'}, 
        { 'f',    0xd0000000,  4, 'i'}, 
        { 'f',    0xe0000000,  5, 'r'}, 
        { 'f',    0xe8000000,  5, 'f'}, 
        { 'f',    0xf0000000,  4, 'e'}, 
        { 'g',    0x00000000,  2, 'h'}, 
        { 'g',    0x40000000,  8, STOP}, 
        { 'g',    0x60000000,  3, 'e'}, 
        { 'g',    0x80000000,  2, ' '}, 
        { 'g',    0xc0000000,  4, 'i'}, 
        { 'g',    0xd0000000,  6, 's'}, 
        { 'g',    0xd5000000, 10, '.'}, 
        { 'g',    0xd5800000, 10, '\''}, 
        { 'g',    0xd5c00000, 10, 't'}, 
        { 'g',    0xd6000000,  7, 'b'}, 
        { 'g',    0xd8000000,  7, 'g'}, 
        { 'g',    0xda000000,  7, 'o'}, 
        { 'g',    0xdc000000,  6, 'l'}, 
        { 'g',    0xe0000000,  5, ':'}, 
        { 'g',    0xe8000000,  5, 'r'}, 
        { 'g',    0xf1000000, 11, 'w'}, 
    { 'g',    0xf1300000, 12, 'm'}, 
        { 'g',    0xf1400000, 10, 'y'}, 
        { 'g',    0xf1800000,  9, 'd'}, 
        { 'g',    0xf2000000,  7, 'n'}, 
        { 'g',    0xf4000000,  6, 'u'}, 
        { 'g',    0xf8000000,  5, 'a'}, 
        { 'h',    0x00000000,  1, 'e'}, 
        { 'h',    0x80000000,  6, 'b'}, 
        { 'h',    0x84000000,  6, 'u'}, 
        { 'h',    0x88000000,  8, 'w'}, 
        { 'h',    0x89000000,  8, 'd'}, 
        { 'h',    0x8a000000,  8, 'n'}, 
        { 'h',    0x8b000000,  8, 'y'}, 
        { 'h',    0x8d000000,  8, 'l'}, 
        { 'h',    0x8e000000,  9, '\''}, 
        { 'h',    0x8e800000, 10, 's'}, 
        { 'h',    0x8ec00000, 11, 'm'}, 
        { 'h',    0x8ee80000, 14, 'c'}, 
        { 'h',    0x8eee0000, 16, 'g'}, 
    { 'h',    0x8eef0000, 17, '-'}, 
        { 'h',    0x8f000000,  8, '.'}, 
        { 'h',    0x90000000,  4, 'i'}, 
        { 'h',    0xa0000000,  3, 'o'}, 
        { 'h',    0xc0000000,  4, 'a'}, 
        { 'h',    0xd0000000,  5, 'r'}, 
        { 'h',    0xd8000000,  8, STOP}, 
        { 'h',    0xe0000000,  4, ' '}, 
        { 'h',    0xf0000000,  4, 't'}, 
        { 'i',    0x00000000,  3, 'c'}, 
        { 'i',    0x20000000,  6, 'p'}, 
        { 'i',    0x24060000, 15, 'j'}, 
        { 'i',    0x24200000, 11, 'h'}, 
        { 'i',    0x24400000, 11, ':'}, 
        { 'i',    0x24600000, 11, 'w'}, 
        { 'i',    0x26000000,  8, 'x'}, 
        { 'i',    0x27000000, 10, 'u'}, 
        { 'i',    0x28000000,  5, 'a'}, 
        { 'i',    0x30000000,  5, 'v'}, 
        { 'i',    0x38000000,  6, ' '}, 
        { 'i',    0x3c000000,  7, 'z'}, 
        { 'i',    0x3e000000,  8, STOP}, 
        { 'i',    0x40000000,  2, 'n'}, 
        { 'i',    0x80000000,  5, 'r'}, 
        { 'i',    0x88000000,  5, 'd'}, 
        { 'i',    0x90000000,  4, 'o'}, 
        { 'i',    0xa0000000,  4, 'l'}, 
        { 'i',    0xb0000000,  5, 'm'}, 
        { 'i',    0xb8000000,  7, 'b'}, 
        { 'i',    0xba000000,  7, 'k'}, 
        { 'i',    0xbc000000,  6, 'f'}, 
        { 'i',    0xc0000000,  4, 'g'}, 
        { 'i',    0xd0000000,  4, 's'}, 
        { 'i',    0xe0000000,  4, 't'}, 
        { 'i',    0xf0000000,  4, 'e'}, 
        { 'j',    0x00000000,  1, 'y'}, 
        { 'j',    0x84000000,  6, 'i'}, 
        { 'j',    0x88000000,  5, 'u'}, 
        { 'j',    0x90000000,  4, 'a'}, 
        { 'j',    0xa0000000,  3, 'e'}, 
        { 'k',    0x00000000,  2, ' '}, 
        { 'k',    0x40000000,  3, 'i'}, 
        { 'k',    0x60000000,  4, 'y'}, 
        { 'k',    0x70000000,  4, 's'}, 
        { 'k',    0x80000000,  2, 'e'}, 
        { 'k',    0xc0000000,  8, STOP}, 
        { 'k',    0xe0000000,  8, '\''}, 
        { 'k',    0xe1000000, 11, 'b'}, 
        { 'k',    0xe1800000,  9, 'w'}, 
        { 'k',    0xe2000000,  7, ':'}, 
        { 'k',    0xe4000000,  6, 'a'}, 
        { 'k',    0xe8000000,  6, 'l'}, 
        { 'k',    0xec000000,  7, 'k'}, 
        { 'k',    0xee000000,  9, 'o'}, 
    { 'k',    0xeea00000, 12, '?'}, 
        { 'k',    0xeeb80000, 13, 't'}, 
        { 'k',    0xeee00000, 11, 'n'}, 
        { 'k',    0xf0000000,  4, 'f'}, 
        { 'l',    0x00000000,  3, 'l'}, 
        { 'l',    0x20000000,  5, 'u'}, 
        { 'l',    0x28000000,  6, 't'}, 
        { 'l',    0x2c000000,  6, 'm'}, 
        { 'l',    0x30000000,  4, 'y'}, 
        { 'l',    0x40000000,  2, 'e'}, 
        { 'l',    0x80000000,  8, STOP}, 
        { 'l',    0x90000000,  4, 'd'}, 
        { 'l',    0xa0000000,  3, 'a'}, 
        { 'l',    0xc0000000,  4, 'o'}, 
        { 'l',    0xd0000000,  5, 's'}, 
        { 'l',    0xd8000000,  8, 'f'}, 
        { 'l',    0xd9000000, 11, 'z'}, 
        { 'l',    0xd9400000, 10, '.'}, 
        { 'l',    0xd9800000,  9, 'v'}, 
        { 'l',    0xda000000,  7, 'k'}, 
        { 'l',    0xdc000000,  8, 'b'}, 
        { 'l',    0xdd000000,  9, ':'}, 
        { 'l',    0xdd800000, 10, 'w'}, 
        { 'l',    0xddc00000, 13, 'g'}, 
        { 'l',    0xdddb0000, 16, '?'}, 
        { 'l',    0xde000000,  8, '\''}, 
        { 'l',    0xdf000000,  8, 'c'}, 
        { 'l',    0xe0000000,  4, 'i'}, 
        { 'l',    0xf0000000,  4, ' '}, 
        { 'm',    0x00000000,  4, 'i'}, 
        { 'm',    0x10000000,  8, STOP}, 
        { 'm',    0x20000000,  3, 'm'}, 
        { 'm',    0x40000000,  4, 'y'}, 
        { 'm',    0x50000000,  5, 'b'}, 
        { 'm',    0x5a000000,  8, ':'}, 
        { 'm',    0x5b000000,  9, 'h'}, 
        { 'm',    0x5b800000, 13, ESCAPE}, 
    { 'm',    0x5ba00000, 11, '.'}, 
    { 'm',    0x5bc00000, 10, '\''}, 
        { 'm',    0x5c000000,  7, 'f'}, 
        { 'm',    0x5f000000,  9, 'w'}, 
        { 'm',    0x5f800000, 10, 'r'}, 
        { 'm',    0x5fc00000, 10, 'u'}, 
        { 'm',    0x60000000,  3, ' '}, 
        { 'm',    0x80000000,  2, 'e'}, 
        { 'm',    0xc0000000,  5, 'o'}, 
        { 'm',    0xc8000000,  6, 'n'}, 
        { 'm',    0xcc000000,  6, 's'}, 
        { 'm',    0xd0000000,  4, 'p'}, 
        { 'm',    0xe0000000,  3, 'a'}, 
        { 'n',    0x00000000,  3, 'i'}, 
        { 'n',    0x20000000,  7, 'r'}, 
        { 'n',    0x22000000,  8, 'v'}, 
        { 'n',    0x23000000, 10, '!'}, 
        { 'n',    0x23600000, 12, 'B'}, 
        { 'n',    0x23800000,  9, ','}, 
    { 'n',    0x24000000,  8, '-'}, 
        { 'n',    0x25000000,  8, '.'}, 
        { 'n',    0x26000000,  7, 'f'}, 
        { 'n',    0x28000000,  6, 'y'}, 
        { 'n',    0x2c000000,  7, 'u'}, 
        { 'n',    0x2e000000,  7, 'j'}, 
        { 'n',    0x30000000,  4, 'a'}, 
        { 'n',    0x40000000,  4, 's'}, 
        { 'n',    0x50000000,  6, '\''}, 
        { 'n',    0x54000000,  6, 'k'}, 
        { 'n',    0x58000000,  8, 'l'}, 
        { 'n',    0x59000000, 12, 'w'}, 
        { 'n',    0x59140000, 14, 'p'}, 
        { 'n',    0x59180000, 13, 'q'}, 
        { 'n',    0x59400000, 11, 'h'}, 
        { 'n',    0x59600000, 11, 'b'}, 
        { 'n',    0x59800000,  9, 'm'}, 
        { 'n',    0x5a000000,  8, 'x'}, 
        { 'n',    0x5b000000,  8, ':'}, 
        { 'n',    0x5c000000,  6, 'o'}, 
        { 'n',    0x60000000,  4, 'e'}, 
        { 'n',    0x70000000,  5, 'c'}, 
        { 'n',    0x78000000,  5, 'n'}, 
        { 'n',    0x80000000,  3, 'g'}, 
        { 'n',    0xa0000000,  3, ' '}, 
        { 'n',    0xc0000000,  3, 'd'}, 
        { 'n',    0xe0000000,  8, STOP}, 
        { 'n',    0xf0000000,  4, 't'}, 
        { 'o',    0x00000000,  2, 'r'}, 
        { 'o',    0x40000000,  4, 'f'}, 
        { 'o',    0x50000000,  4, ' '}, 
        { 'o',    0x60000000,  4, 'w'}, 
        { 'o',    0x70000000,  6, 'a'}, 
        { 'o',    0x74000000,  6, 'b'}, 
        { 'o',    0x78000000,  5, 't'}, 
        { 'o',    0x80000000,  4, 'o'}, 
        { 'o',    0x90000000,  5, 'c'}, 
        { 'o',    0x98000000,  6, 'y'}, 
        { 'o',    0x9c000000,  8, STOP}, 
        { 'o',    0xa0000000,  5, 'p'}, 
        { 'o',    0xa8000000,  5, 'd'}, 
        { 'o',    0xb0000000,  4, 'u'}, 
        { 'o',    0xc0000000,  3, 'n'}, 
        { 'o',    0xe0000000,  5, 'm'}, 
        { 'o',    0xe8000000,  6, 's'}, 
        { 'o',    0xec000000,  6, 'k'}, 
        { 'o',    0xf0000000,  5, 'l'}, 
    { 'o',    0xf8180000, 14, ','}, 
        { 'o',    0xf8200000, 11, '?'}, 
        { 'o',    0xf8400000, 11, ':'}, 
        { 'o',    0xf8600000, 12, '.'}, 
        { 'o',    0xf8800000,  9, 'h'}, 
        { 'o',    0xf9000000,  9, '!'}, 
        { 'o',    0xf9800000, 10, '\''}, 
        { 'o',    0xf9c00000, 11, 'z'}, 
        { 'o',    0xf9e00000, 11, 'x'}, 
        { 'o',    0xfa000000,  7, 'v'}, 
        { 'o',    0xfc000000,  7, 'g'}, 
        { 'o',    0xfe000000,  9, 'e'}, 
        { 'o',    0xfe800000,  9, 'j'}, 
        { 'o',    0xff000000,  8, 'i'}, 
        { 'p',    0x00000000,  2, 'e'}, 
        { 'p',    0x40000000,  8, STOP}, 
        { 'p',    0x60000000,  4, 's'}, 
        { 'p',    0x70000000,  5, 'l'}, 
        { 'p',    0x78000000,  5, 'r'}, 
        { 'p',    0x80000000,  3, 'i'}, 
        { 'p',    0xa0000000,  4, ' '}, 
        { 'p',    0xb0000000,  5, 'h'}, 
        { 'p',    0xb8000000,  6, 't'}, 
    { 'p',    0xbc000000,  6, '\''}, 
        { 'p',    0xc0000000,  3, 'o'}, 
        { 'p',    0xe0000000,  4, 'p'}, 
        { 'p',    0xf0000000,  5, 'a'}, 
        { 'p',    0xf8000000,  7, 'd'}, 
        { 'p',    0xfa000000,  7, 'm'}, 
        { 'p',    0xfc000000,  7, 'y'}, 
        { 'p',    0xfe000000, 10, '?'}, 
    { 'p',    0xfe600000, 11, '.'}, 
    { 'p',    0xff000000, 10, 'w'}, 
        { 'p',    0xff400000, 10, 'u'}, 
        { 'p',    0xff800000,  9, '!'}, 
        { 'q',    0x10000000,  4, '\''}, 
        { 'q',    0x40000000,  8, STOP}, 
        { 'q',    0x80000000,  1, 'u'}, 
        { 'r',    0x00000000,  3, ' '}, 
        { 'r',    0x20000000,  7, '\''}, 
        { 'r',    0x22000000,  8, 'f'}, 
        { 'r',    0x23000000,  8, '.'}, 
        { 'r',    0x24000000,  6, 'k'}, 
        { 'r',    0x28000000,  6, 'r'}, 
        { 'r',    0x2c000000,  6, 'm'}, 
        { 'r',    0x30000000,  4, 'y'}, 
        { 'r',    0x40000000,  4, 'd'}, 
        { 'r',    0x50000000,  9, ','}, 
        { 'r',    0x50800000,  9, 'p'}, 
        { 'r',    0x51000000,  8, 'b'}, 
        { 'r',    0x52000000,  7, 'c'}, 
        { 'r',    0x54000000,  6, 'u'}, 
        { 'r',    0x58000000,  5, 'n'}, 
        { 'r',    0x60000000,  3, 'i'}, 
        { 'r',    0x80000000,  4, 's'}, 
        { 'r',    0x90000000,  4, 't'}, 
        { 'r',    0xa0000000,  3, 'e'}, 
        { 'r',    0xc0000000,  4, 'a'}, 
        { 'r',    0xd0000000,  4, STOP}, 
        { 'r',    0xe0000000,  8, 'v'}, 
        { 'r',    0xe1000000,  9, 'w'}, 
        { 'r',    0xe1800000, 11, '-'}, 
        { 'r',    0xe1a00000, 12, 'h'}, 
        { 'r',    0xe1c00000, 10, 'j'}, 
        { 'r',    0xe2000000,  7, ':'}, 
        { 'r',    0xe4000000,  6, 'g'}, 
        { 'r',    0xe8000000,  5, 'l'}, 
        { 'r',    0xf0000000,  4, 'o'}, 
        { 's',    0x00000000,  4, 's'}, 
        { 's',    0x10000000,  7, '.'}, 
        { 's',    0x12000000,  7, '!'}, 
        { 's',    0x14000000,  8, ','}, 
        { 's',    0x15000000,  8, 'f'}, 
        { 's',    0x16000000,  7, 'y'}, 
        { 's',    0x20000000,  4, 'i'}, 
        { 's',    0x30000000,  4, 'h'}, 
        { 's',    0x40000000,  7, 'p'}, 
        { 's',    0x42000000, 11, '?'}, 
        { 's',    0x42200000, 11, 'w'}, 
        { 's',    0x42400000, 10, 'm'}, 
        { 's',    0x42800000,  9, 'k'}, 
        { 's',    0x43000000,  8, '\''}, 
        { 's',    0x44000000,  6, 'o'}, 
        { 's',    0x48000000,  7, 'a'}, 
        { 's',    0x4a000000,  9, 'd'}, 
        { 's',    0x4a800000, 11, 'g'}, 
        { 's',    0x4aa00000, 12, 'q'}, 
        { 's',    0x4ac00000, 10, 'b'}, 
        { 's',    0x4b000000,  8, 'n'}, 
        { 's',    0x4c000000,  6, 'c'}, 
        { 's',    0x50000000,  5, 'e'}, 
        { 's',    0x58000000,  6, ':'}, 
        { 's',    0x5c000000,  8, 'l'}, 
        { 's',    0x5d000000,  8, 'r'}, 
        { 's',    0x5e000000,  7, 'u'}, 
        { 's',    0x60000000,  3, 't'}, 
        { 's',    0x80000000,  2, ' '}, 
        { 's',    0xc0000000,  2, STOP}, 
        { 't',    0x00000000,  3, 'i'}, 
        { 't',    0x20000000,  4, 'a'}, 
        { 't',    0x30000000,  7, '\''}, 
        { 't',    0x32000000,  8, 'w'}, 
        { 't',    0x33000000,  9, '?'}, 
        { 't',    0x33c00000, 11, '-'}, 
        { 't',    0x33e00000, 11, ','}, 
        { 't',    0x34000000,  7, ':'}, 
        { 't',    0x36000000,  8, '!'}, 
        { 't',    0x37000000,  9, 'n'}, 
        { 't',    0x37800000, 10, 'd'}, 
        { 't',    0x38000000,  5, 't'}, 
        { 't',    0x40000000,  4, 'r'}, 
        { 't',    0x50000000,  5, 'y'}, 
        { 't',    0x58000000,  6, 'm'}, 
        { 't',    0x5c000000,  8, '.'}, 
        { 't',    0x5d000000,  8, 'b'}, 
        { 't',    0x5e000000,  8, 'E'}, 
        { 't',    0x60000000,  8, STOP}, 
        { 't',    0x80000000,  3, ' '}, 
        { 't',    0xa0000000,  4, 's'}, 
        { 't',    0xb0000000,  4, 'o'}, 
        { 't',    0xc0000000,  5, 'u'}, 
        { 't',    0xc8000000,  6, 'c'}, 
        { 't',    0xcc000000,  6, 'l'}, 
        { 't',    0xd0000000,  4, 'e'}, 
        { 't',    0xe0000000,  3, 'h'}, 
        { 'u',    0x00000000,  2, 'r'}, 
        { 'u',    0x40000000,  4, 'e'}, 
        { 'u',    0x50000000,  4, 'm'}, 
        { 'u',    0x60000000,  5, 'c'}, 
        { 'u',    0x68000000,  5, 'g'}, 
        { 'u',    0x70000000,  5, 'b'}, 
        { 'u',    0x78000000,  6, STOP}, 
        { 'u',    0x7e800000, 10, 'f'}, 
        { 'u',    0x7f000000,  8, '\''}, 
        { 'u',    0x80000000,  3, 's'}, 
        { 'u',    0xa0000000,  5, 'p'}, 
        { 'u',    0xa8000000,  5, 'i'}, 
        { 'u',    0xb0000000,  5, 'l'}, 
        { 'u',    0xb8000000,  6, 'y'}, 
        { 'u',    0xbc000000,  7, ' '}, 
        { 'u',    0xbf000000, 10, 'w'}, 
        { 'u',    0xbf400000, 12, 'v'}, 
        { 'u',    0xbf500000, 12, 'x'}, 
        { 'u',    0xbf600000, 13, 'j'}, 
        { 'u',    0xc0000000,  4, 't'}, 
        { 'u',    0xd0000000,  5, 'd'}, 
        { 'u',    0xd8000000,  5, 'a'}, 
        { 'u',    0xe0000000,  3, 'n'}, 
        { 'v',    0x00000000,  5, '.'}, 
        { 'v',    0x08000000,  7, 'y'}, 
        { 'v',    0x0a000000, 10, ESCAPE}, 
        { 'v',    0x0b000000,  8, 's'}, 
        { 'v',    0x10000000,  4, 'o'}, 
        { 'v',    0x20000000,  3, 'a'}, 
        { 'v',    0x40000000,  2, 'i'}, 
        { 'v',    0x80000000,  1, 'e'}, 
        { 'w',    0x00000000,  1, 's'}, 
        { 'w',    0x80000000,  3, ' '}, 
        { 'w',    0xa0000000,  5, 'a'}, 
        { 'w',    0xa8000000,  8, 'm'}, 
        { 'w',    0xa9800000,  9, 'b'}, 
        { 'w',    0xaa000000,  9, 'k'}, 
        { 'w',    0xaa800000,  9, 'r'}, 
        { 'w',    0xab000000,  8, 'd'}, 
    { 'w',    0xac000000, 11, 'c'}, 
        { 'w',    0xac200000, 11, 'f'}, 
    { 'w',    0xacc00000, 10, 'h'}, 
        { 'w',    0xad000000,  8, 'l'}, 
    { 'w',    0xae000000,  7, 'y'}, 
        { 'w',    0xb0000000,  4, 'i'}, 
        { 'w',    0xc0000000,  3, STOP}, 
        { 'w',    0xe0000000,  4, 'o'}, 
        { 'w',    0xf0000000,  5, 'n'}, 
        { 'w',    0xf8000000,  5, 'e'}, 
        { 'x',    0x00000000,  2, 'p'}, 
        { 'x',    0x40000000,  5, 'o'}, 
        { 'x',    0x48000000,  6, 'e'}, 
        { 'x',    0x4e000000,  7, 'f'}, 
        { 'x',    0x50000000,  5, 'c'}, 
        { 'x',    0x58000000,  6, 'y'}, 
        { 'x',    0x5c800000,  9, 'a'}, 
        { 'x',    0x5d000000, 12, ESCAPE}, 
        { 'x',    0x5d400000, 10, '\''}, 
        { 'x',    0x60000000,  4, STOP}, 
        { 'x',    0x70000000,  5, 'i'}, 
        { 'x',    0x80000000,  2, ' '}, 
        { 'x',    0xc0000000,  2, 't'}, 
        { 'y',    0x00000000,  1, ' '}, 
        { 'y',    0x80000000,  8, 'i'}, 
        { 'y',    0x81800000,  9, 'f'}, 
        { 'y',    0x82000000,  7, 'n'}, 
        { 'y',    0x84000000,  7, 't'}, 
        { 'y',    0x86000000,  8, ','}, 
        { 'y',    0x87000000,  8, 'p'}, 
        { 'y',    0x88000000,  5, 'o'}, 
        { 'y',    0x90000000,  5, 's'}, 
        { 'y',    0x98000000,  6, 'd'}, 
        { 'y',    0x9c000000,  8, 'm'}, 
        { 'y',    0x9d000000,  9, 'r'}, 
    { 'y',    0x9d800000,  9, 'g'}, 
        { 'y',    0x9e000000,  8, 'c'}, 
        { 'y',    0x9f500000, 13, 'v'}, 
    { 'y',    0x9f5c0000, 15, 'h'}, 
        { 'y',    0xa0000000,  5, 'a'}, 
        { 'y',    0xa8000000,  7, '\''}, 
        { 'y',    0xaa000000,  7, 'b'}, 
        { 'y',    0xac000000,  8, 'w'}, 
        { 'y',    0xad000000,  8, 'e'}, 
    { 'y',    0xae000000,  7, '.'}, 
        { 'y',    0xb0000000,  5, 'l'}, 
        { 'y',    0xb8000000,  5, ':'}, 
        { 'y',    0xc0000000,  8, STOP}, 
        { 'z',    0x00000000,  2, 'z'}, 
        { 'z',    0x40000000,  2, STOP}, 
    { 'z',    0x80000000,  4, 'y'}, 
        { 'z',    0x90000000,  4, 'e'}, 
        { 'z',    0xa0000000,  3, 'i'}, 
        { 'z',    0xd0000000,  4, ' '}, 
        { 'z',    0xe0000000,  4, 'l'}, 
        { 'z',    0xf0000000,  5, 'a'}, 
        { 'z',    0xf8000000,  6, 'o'}, 
        { 'z',    0xfc000000,  8, 'm'} 
}; 

