#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/errno.h>

#define BLOCKSIZE 512

main(int ac, char *av[])
{
  struct stat sb;
  int i;
  for (i = 1; i < ac; i++) {
    if (lstat(av[i], &sb) < 0) {
      if (errno != ENOENT)
        perror(av[i]);
    } else {
      if (S_ISREG(sb.st_mode) || S_ISDIR(sb.st_mode)) {
        printf("%s %d%d%d %d %d ", 
	       S_ISDIR(sb.st_mode) ? "dir" : "file",
	       (sb.st_mode & S_IRWXU) >> 6,
	       (sb.st_mode & S_IRWXG) >> 3,
	       (sb.st_mode & S_IRWXO) >> 0,
	       sb.st_uid, sb.st_gid);
	if (S_ISREG(sb.st_mode))
	  printf("%d ", ((sb.st_size + BLOCKSIZE - 1)/BLOCKSIZE) * BLOCKSIZE);
	printf("%s\n", av[i]);
      } else
      if (S_ISLNK(sb.st_mode)) {
        printf("link %s\n", av[i]);
      } else {
        fprintf(stderr, "unknown %s\n", av[i]);
      }
    }
  }
  return (0);
}
