; RAMFONT.ASM 
;
; Loads the specified font file into the RamFont storage area of the
; GB112, and initializes the board for 4k RamFont operation with a 9x14
; character matrix.

; RamFont equates

dmc_port	equ	03b8h		; HGC+ Display mode control port
status_port	equ	03bah		; HGC+ Display status port
index_reg	equ	03b4h		; 6845 index register
data_reg	equ	03b5h		; 6845 data register

scrn_on_b	equ	28h		; Masks for dmc_port
scrn_on_nb	equ	08h
scrn_off_text  	equ	20h

rom_generator	equ	0		; xModeReg bit 0
ram_font	equ	1
nine_wide	equ	0		; xModeReg bit 1
eight_wide	equ	2	
fnt_4k		equ	0		; xModeReg bit 2
fnt_48k		equ	4

xModeReg	equ	14h		; HGC+ font option port
scorereg	equ	15h		; register to set undersocre
strikereg	equ	16h		; register to set overstrike

id_mask		equ	00110000b
id_code		equ	00010000b
blank_cnt	equ	2000h

text_buf_seg	equ	0b000h
font_seg	equ	0b400h
open_num	equ	03dh

disp_num	equ	9		; DOS function numbers
close_num	equ	03eh
read_num	equ	03fh

char_len	equ	010h

col_seg		equ	40h		;DOS's record of number of columns
col_off		equ	4ah

cr		equ	0dh
lf		equ	0ah

cseg	segment	para	public	'CODE'
	assume	cs:cseg,ds:cseg
	org 	80h
arg_count	db	0
arg_string	db	?
	org	100h
start:
	jmp	start1

handle		dw	?
filename	db	30 dup (?)
open_err	db	cr,lf,'Unable to open font file.',cr,lf,24h
board_error_flag db	0

start1:
	push	cs
	pop	ds

	call 	test_board		;see if we have a HGC model GB112
	cmp	board_error_flag,0
	je	RamFont_ok
	
	ret

RamFont_ok:

;set the HGC to HALF - change to FULL if memory above B8000h is needed.

	mov	dx,03bfh
	mov	al,1
	out	dx,al

;copy arg_string into filename
	push	cs
	pop	es

	xor	cx,cx
	cld

	mov	cl,[arg_count]
	lea	si,arg_string
	lea	di,filename
	rep	movsb
	mov	byte ptr cs:[di],0 		;for ASCIIZ string

;open font file
	mov	dx,offset filename+1
	mov	al,0
	mov	ah,open_num
	int	21h

	jnc	open_ok

	jmp	error_return

;load the font into RamFont area

open_ok:
	mov	handle,ax

	mov	ax,font_seg
	mov	es,ax
	xor	bp,bp

rd_char:
	mov	bx,handle
	mov	dx,bp
	mov	cx,char_len
	mov	ah,read_num
	push	es
	pop	ds
	int	21h

	push	cs
	pop	ds

	cmp	ax,0				;eof?
	jz	close

;still loading font

	add	bp,char_len
	jmp	rd_char

close:
	mov	bx,handle
	mov	ah,close_num
	int	21h

;program the 6845 for a 9x14 dot character

	mov	bx,0720h			;blanking value
	call	prog_6845

;screen is still off, select the 4k ramfont

	mov	dx,index_reg
	mov	al,xModeReg
	out	dx,al

	mov	dx,data_reg
	xor	ax,ax
	mov	al,ram_font+nine_wide+fnt_4k
	out	dx,al

;set the underline and overstrike positions - don't need these for 4K mode
	mov	dx,index_reg
	mov	al,scorereg
	out	dx,al

	mov	dx,data_reg
	mov	ax,7
	out	dx,al			;underscore at h - 1

	mov	dx,index_reg
	mov	al,strikereg
	out	dx,al

	mov	dx,data_reg
	mov	ax,7
	out	dx,al			;overstrike at h/2

;store correct column width for DOS
	mov	ax,col_seg
	mov	es,ax
	mov	di,col_off
	mov	al,80				;we want 80 columns
	mov	es:[di],ax
	push	cs
	pop	es

;turn the screen on, with blink activated
	mov	dx,dmc_port
	mov	al,scrn_on_b
	out	dx,al

;normal return

	ret

;unable to open font file
error_return:

	mov	bx,720h
	call	prog_6845

	mov	dx,index_reg
	mov	al,xModeReg
	out	dx,al

	mov	dx,data_reg
	mov	al,rom_generator+nine_wide	;text mode
	out	dx,al

;store correct column width for DOS
	mov	ax,col_seg
	mov	es,ax
	mov	di,col_off
	mov	al,80				;we want 80 columns
	mov	es:[di],ax
	push	cs
	pop	es

	mov	dx,dmc_port			;turn on screen
	mov	al,scrn_on_b
	out	dx,al

	mov	dx,offset open_err		;print error message

	mov	ah,disp_num
	int	21h

	ret

;***************************************************************************
;				PROG_6845
;
;	This procedure programs the 6845 for 9 x 14 matrix
;
;	bx = the blanking value used to clear the text buffer
;		blanking value = 0720h for text mode and 4k ramfont mode
;		blanking value = 020h for 48k ramfont mode.
;
;****************************************************************************

;the data below is used to program the 6845 for 9 dot text
r0_9dot		db	61h,50h,52h,0fh,19h,6,19h,19h,2,0dh,0bh,0ch,0,0

prog_6845	proc	near
;save blanking value
	push	bx

;select the appropriate data table

	mov	si,offset r0_9dot

;turn the screen off
screen_off:
	mov	al,scrn_off_text
	mov	dx,dmc_port
	out	dx,al

;program the 6845
	mov	dx,index_reg
	mov	cx,14

	xor	ah,ah			;start from register 0

loadtable:
	mov	al,ah
	out	dx,al			;output the register number

	inc	dx			;point to the data register
	lodsb				;load al with next table value

	out	dx,al			;output data value

	inc	ah			;point to next register
	dec	dx			;point to index register

	loop	loadtable		;continue loading until done

;clear the text buffer, but leave the screen off

setup_ptr:
	mov	ax,text_buf_seg
	mov	es,ax
	xor	di,di
	mov	cx,blank_cnt
	pop	ax			;get blanking value

;clear the buffer

rep	stosw

	ret

prog_6845	endp

;* * * * * * * * * * * * * * * * *
; TEST_BOARD - Performs two tests - first, makes sure that a Hercules
;	       Graphics Card is present and active, then checks for a GB112.
;
; RETURNS -  board_error_flag = 1 if GB112 is not detected
;* * * * * * * * * * * * * * * * *

fail_message1	db	0dh,0ah,'ERROR - Hercules Graphics Card not present '
		db	'or not presently activated.',0dh,0ah,'$'
fail_message2	db	0dh,0ah,'ERROR - Model GB112 Hercules Graphics Card '
		db	'not detected in system.',0dh,0ah,'$'

test_board	proc	near

	mov	ah,15			; check current video state
	int	10h

	cmp	al,7			; is it 80 x 25 "B&W" Card
	je	mono_ok			; yes - continue

	mov	dx,offset fail_message1 ; no - quit
	jmp	test_failed

mono_ok:		       	
	mov	dx,status_port		; record state 
	in	al,dx			
	and	al,80h			; save bit 7 for test
	mov	ah,al

	mov	cx,8000h

examine:
	in	al,dx			; take another reading
	and	al,80h			; again save bit seven
	cmp	al,ah
	jne	hgc  			; if bit 7 changes, then it
	loop	examine			; is a Hercules Graphics Card
    
	mov	dx,offset fail_message1
	jmp	test_failed		; after this long it must be
					; something else - quit.
        
hgc:	in	al,dx			; test for GB112
	and	al,id_mask		; clear all but bits 4 and 5

	cmp	al,id_code		; test ID bits
	jne	t_f_1			; exit if failed - not a GB112

	ret				; normal return

t_f_1:
	mov	dx,offset fail_message2

test_failed:
	mov	ah,9
	int	21h

	mov	board_error_flag,1

	ret				; error return

test_board	endp			

cseg	ends
	end	start
