// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_2_0_autogen.cpp:
//   Defines the GLES 2.0 entry points.

#include "libGLESv2/entry_points_gles_2_0_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/validationES2.h"
#include "libGLESv2/entry_points_utils.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY ActiveTexture(GLenum texture)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum texture = 0x%X)", texture);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateActiveTexture(context, texture))
        {
            context->activeTexture(texture);
        }
    }
}

void GL_APIENTRY AttachShader(GLuint program, GLuint shader)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint program = %u, GLuint shader = %u)", program, shader);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateAttachShader(context, program, shader))
        {
            context->attachShader(program, shader);
        }
    }
}

void GL_APIENTRY BindAttribLocation(GLuint program, GLuint index, const GLchar *name)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint program = %u, GLuint index = %u, const GLchar *name = 0x%016" PRIxPTR ")",
          program, index, (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateBindAttribLocation(context, program, index, name))
        {
            context->bindAttribLocation(program, index, name);
        }
    }
}

void GL_APIENTRY BindBuffer(GLenum target, GLuint buffer)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLuint buffer = %u)", target, buffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        if (context->skipValidation() || ValidateBindBuffer(context, targetPacked, buffer))
        {
            context->bindBuffer(targetPacked, buffer);
        }
    }
}

void GL_APIENTRY BindFramebuffer(GLenum target, GLuint framebuffer)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLuint framebuffer = %u)", target, framebuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateBindFramebuffer(context, target, framebuffer))
        {
            context->bindFramebuffer(target, framebuffer);
        }
    }
}

void GL_APIENTRY BindRenderbuffer(GLenum target, GLuint renderbuffer)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLuint renderbuffer = %u)", target, renderbuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateBindRenderbuffer(context, target, renderbuffer))
        {
            context->bindRenderbuffer(target, renderbuffer);
        }
    }
}

void GL_APIENTRY BindTexture(GLenum target, GLuint texture)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLuint texture = %u)", target, texture);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        if (context->skipValidation() || ValidateBindTexture(context, targetPacked, texture))
        {
            context->bindTexture(targetPacked, texture);
        }
    }
}

void GL_APIENTRY BlendColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfloat red = %f, GLfloat green = %f, GLfloat blue = %f, GLfloat alpha = %f)", red,
          green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateBlendColor(context, red, green, blue, alpha))
        {
            context->blendColor(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY BlendEquation(GLenum mode)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateBlendEquation(context, mode))
        {
            context->blendEquation(mode);
        }
    }
}

void GL_APIENTRY BlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum modeRGB = 0x%X, GLenum modeAlpha = 0x%X)", modeRGB, modeAlpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateBlendEquationSeparate(context, modeRGB, modeAlpha))
        {
            context->blendEquationSeparate(modeRGB, modeAlpha);
        }
    }
}

void GL_APIENTRY BlendFunc(GLenum sfactor, GLenum dfactor)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum sfactor = 0x%X, GLenum dfactor = 0x%X)", sfactor, dfactor);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateBlendFunc(context, sfactor, dfactor))
        {
            context->blendFunc(sfactor, dfactor);
        }
    }
}

void GL_APIENTRY BlendFuncSeparate(GLenum sfactorRGB,
                                   GLenum dfactorRGB,
                                   GLenum sfactorAlpha,
                                   GLenum dfactorAlpha)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLenum sfactorRGB = 0x%X, GLenum dfactorRGB = 0x%X, GLenum sfactorAlpha = 0x%X, GLenum "
        "dfactorAlpha = 0x%X)",
        sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateBlendFuncSeparate(context, sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha))
        {
            context->blendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
        }
    }
}

void GL_APIENTRY BufferData(GLenum target, GLsizeiptr size, const void *data, GLenum usage)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLsizeiptr size = %llu, const void *data = 0x%016" PRIxPTR
          ", GLenum usage = 0x%X)",
          target, static_cast<unsigned long long>(size), (uintptr_t)data, usage);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        BufferUsage usagePacked    = FromGLenum<BufferUsage>(usage);
        if (context->skipValidation() ||
            ValidateBufferData(context, targetPacked, size, data, usagePacked))
        {
            context->bufferData(targetPacked, size, data, usagePacked);
        }
    }
}

void GL_APIENTRY BufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const void *data)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLenum target = 0x%X, GLintptr offset = %llu, GLsizeiptr size = %llu, const void *data = "
        "0x%016" PRIxPTR ")",
        target, static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size),
        (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        if (context->skipValidation() ||
            ValidateBufferSubData(context, targetPacked, offset, size, data))
        {
            context->bufferSubData(targetPacked, offset, size, data);
        }
    }
}

GLenum GL_APIENTRY CheckFramebufferStatus(GLenum target)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateCheckFramebufferStatus(context, target))
        {
            return context->checkFramebufferStatus(target);
        }
    }

    return GetDefaultReturnValue<EntryPoint::CheckFramebufferStatus, GLenum>();
}

void GL_APIENTRY Clear(GLbitfield mask)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLbitfield mask = 0x%X)", mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateClear(context, mask))
        {
            context->clear(mask);
        }
    }
}

void GL_APIENTRY ClearColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfloat red = %f, GLfloat green = %f, GLfloat blue = %f, GLfloat alpha = %f)", red,
          green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateClearColor(context, red, green, blue, alpha))
        {
            context->clearColor(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY ClearDepthf(GLfloat d)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfloat d = %f)", d);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateClearDepthf(context, d))
        {
            context->clearDepthf(d);
        }
    }
}

void GL_APIENTRY ClearStencil(GLint s)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint s = %d)", s);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateClearStencil(context, s))
        {
            context->clearStencil(s);
        }
    }
}

void GL_APIENTRY ColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLboolean red = %u, GLboolean green = %u, GLboolean blue = %u, GLboolean alpha = %u)",
          red, green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateColorMask(context, red, green, blue, alpha))
        {
            context->colorMask(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY CompileShader(GLuint shader)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint shader = %u)", shader);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateCompileShader(context, shader))
        {
            context->compileShader(shader);
        }
    }
}

void GL_APIENTRY CompressedTexImage2D(GLenum target,
                                      GLint level,
                                      GLenum internalformat,
                                      GLsizei width,
                                      GLsizei height,
                                      GLint border,
                                      GLsizei imageSize,
                                      const void *data)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLint border = %d, GLsizei imageSize = %d, const void *data = "
        "0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, border, imageSize, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        if (context->skipValidation() ||
            ValidateCompressedTexImage2D(context, targetPacked, level, internalformat, width,
                                         height, border, imageSize, data))
        {
            context->compressedTexImage2D(targetPacked, level, internalformat, width, height,
                                          border, imageSize, data);
        }
    }
}

void GL_APIENTRY CompressedTexSubImage2D(GLenum target,
                                         GLint level,
                                         GLint xoffset,
                                         GLint yoffset,
                                         GLsizei width,
                                         GLsizei height,
                                         GLenum format,
                                         GLsizei imageSize,
                                         const void *data)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLsizei "
        "width = %d, GLsizei height = %d, GLenum format = 0x%X, GLsizei imageSize = %d, const void "
        "*data = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, width, height, format, imageSize, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        if (context->skipValidation() ||
            ValidateCompressedTexSubImage2D(context, targetPacked, level, xoffset, yoffset, width,
                                            height, format, imageSize, data))
        {
            context->compressedTexSubImage2D(targetPacked, level, xoffset, yoffset, width, height,
                                             format, imageSize, data);
        }
    }
}

void GL_APIENTRY CopyTexImage2D(GLenum target,
                                GLint level,
                                GLenum internalformat,
                                GLint x,
                                GLint y,
                                GLsizei width,
                                GLsizei height,
                                GLint border)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum internalformat = 0x%X, GLint x = %d, "
        "GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLint border = %d)",
        target, level, internalformat, x, y, width, height, border);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        if (context->skipValidation() ||
            ValidateCopyTexImage2D(context, targetPacked, level, internalformat, x, y, width,
                                   height, border))
        {
            context->copyTexImage2D(targetPacked, level, internalformat, x, y, width, height,
                                    border);
        }
    }
}

void GL_APIENTRY CopyTexSubImage2D(GLenum target,
                                   GLint level,
                                   GLint xoffset,
                                   GLint yoffset,
                                   GLint x,
                                   GLint y,
                                   GLsizei width,
                                   GLsizei height)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint x "
        "= %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)",
        target, level, xoffset, yoffset, x, y, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        if (context->skipValidation() ||
            ValidateCopyTexSubImage2D(context, targetPacked, level, xoffset, yoffset, x, y, width,
                                      height))
        {
            context->copyTexSubImage2D(targetPacked, level, xoffset, yoffset, x, y, width, height);
        }
    }
}

GLuint GL_APIENTRY CreateProgram()
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateCreateProgram(context))
        {
            return context->createProgram();
        }
    }

    return GetDefaultReturnValue<EntryPoint::CreateProgram, GLuint>();
}

GLuint GL_APIENTRY CreateShader(GLenum type)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum type = 0x%X)", type);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ShaderType typePacked = FromGLenum<ShaderType>(type);
        if (context->skipValidation() || ValidateCreateShader(context, typePacked))
        {
            return context->createShader(typePacked);
        }
    }

    return GetDefaultReturnValue<EntryPoint::CreateShader, GLuint>();
}

void GL_APIENTRY CullFace(GLenum mode)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        CullFaceMode modePacked = FromGLenum<CullFaceMode>(mode);
        if (context->skipValidation() || ValidateCullFace(context, modePacked))
        {
            context->cullFace(modePacked);
        }
    }
}

void GL_APIENTRY DeleteBuffers(GLsizei n, const GLuint *buffers)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLsizei n = %d, const GLuint *buffers = 0x%016" PRIxPTR ")", n, (uintptr_t)buffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateDeleteBuffers(context, n, buffers))
        {
            context->deleteBuffers(n, buffers);
        }
    }
}

void GL_APIENTRY DeleteFramebuffers(GLsizei n, const GLuint *framebuffers)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLsizei n = %d, const GLuint *framebuffers = 0x%016" PRIxPTR ")", n,
          (uintptr_t)framebuffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateDeleteFramebuffers(context, n, framebuffers))
        {
            context->deleteFramebuffers(n, framebuffers);
        }
    }
}

void GL_APIENTRY DeleteProgram(GLuint program)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint program = %u)", program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateDeleteProgram(context, program))
        {
            context->deleteProgram(program);
        }
    }
}

void GL_APIENTRY DeleteRenderbuffers(GLsizei n, const GLuint *renderbuffers)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLsizei n = %d, const GLuint *renderbuffers = 0x%016" PRIxPTR ")", n,
          (uintptr_t)renderbuffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateDeleteRenderbuffers(context, n, renderbuffers))
        {
            context->deleteRenderbuffers(n, renderbuffers);
        }
    }
}

void GL_APIENTRY DeleteShader(GLuint shader)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint shader = %u)", shader);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateDeleteShader(context, shader))
        {
            context->deleteShader(shader);
        }
    }
}

void GL_APIENTRY DeleteTextures(GLsizei n, const GLuint *textures)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLsizei n = %d, const GLuint *textures = 0x%016" PRIxPTR ")", n, (uintptr_t)textures);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateDeleteTextures(context, n, textures))
        {
            context->deleteTextures(n, textures);
        }
    }
}

void GL_APIENTRY DepthFunc(GLenum func)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum func = 0x%X)", func);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateDepthFunc(context, func))
        {
            context->depthFunc(func);
        }
    }
}

void GL_APIENTRY DepthMask(GLboolean flag)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLboolean flag = %u)", flag);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateDepthMask(context, flag))
        {
            context->depthMask(flag);
        }
    }
}

void GL_APIENTRY DepthRangef(GLfloat n, GLfloat f)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfloat n = %f, GLfloat f = %f)", n, f);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateDepthRangef(context, n, f))
        {
            context->depthRangef(n, f);
        }
    }
}

void GL_APIENTRY DetachShader(GLuint program, GLuint shader)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint program = %u, GLuint shader = %u)", program, shader);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateDetachShader(context, program, shader))
        {
            context->detachShader(program, shader);
        }
    }
}

void GL_APIENTRY Disable(GLenum cap)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum cap = 0x%X)", cap);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateDisable(context, cap))
        {
            context->disable(cap);
        }
    }
}

void GL_APIENTRY DisableVertexAttribArray(GLuint index)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint index = %u)", index);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateDisableVertexAttribArray(context, index))
        {
            context->disableVertexAttribArray(index);
        }
    }
}

void GL_APIENTRY DrawArrays(GLenum mode, GLint first, GLsizei count)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum mode = 0x%X, GLint first = %d, GLsizei count = %d)", mode, first, count);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PrimitiveMode modePacked = FromGLenum<PrimitiveMode>(mode);
        if (context->skipValidation() || ValidateDrawArrays(context, modePacked, first, count))
        {
            context->drawArrays(modePacked, first, count);
        }
    }
}

void GL_APIENTRY DrawElements(GLenum mode, GLsizei count, GLenum type, const void *indices)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLenum mode = 0x%X, GLsizei count = %d, GLenum type = 0x%X, const void *indices = "
        "0x%016" PRIxPTR ")",
        mode, count, type, (uintptr_t)indices);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PrimitiveMode modePacked    = FromGLenum<PrimitiveMode>(mode);
        DrawElementsType typePacked = FromGLenum<DrawElementsType>(type);
        if (context->skipValidation() ||
            ValidateDrawElements(context, modePacked, count, typePacked, indices))
        {
            context->drawElements(modePacked, count, typePacked, indices);
        }
    }
}

void GL_APIENTRY Enable(GLenum cap)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum cap = 0x%X)", cap);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateEnable(context, cap))
        {
            context->enable(cap);
        }
    }
}

void GL_APIENTRY EnableVertexAttribArray(GLuint index)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint index = %u)", index);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateEnableVertexAttribArray(context, index))
        {
            context->enableVertexAttribArray(index);
        }
    }
}

void GL_APIENTRY Finish()
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateFinish(context))
        {
            context->finish();
        }
    }
}

void GL_APIENTRY Flush()
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateFlush(context))
        {
            context->flush();
        }
    }
}

void GL_APIENTRY FramebufferRenderbuffer(GLenum target,
                                         GLenum attachment,
                                         GLenum renderbuffertarget,
                                         GLuint renderbuffer)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum renderbuffertarget = 0x%X, GLuint "
        "renderbuffer = %u)",
        target, attachment, renderbuffertarget, renderbuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateFramebufferRenderbuffer(context, target, attachment, renderbuffertarget,
                                            renderbuffer))
        {
            context->framebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
        }
    }
}

void GL_APIENTRY FramebufferTexture2D(GLenum target,
                                      GLenum attachment,
                                      GLenum textarget,
                                      GLuint texture,
                                      GLint level)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum textarget = 0x%X, GLuint texture "
        "= %u, GLint level = %d)",
        target, attachment, textarget, texture, level);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget textargetPacked = FromGLenum<TextureTarget>(textarget);
        if (context->skipValidation() ||
            ValidateFramebufferTexture2D(context, target, attachment, textargetPacked, texture,
                                         level))
        {
            context->framebufferTexture2D(target, attachment, textargetPacked, texture, level);
        }
    }
}

void GL_APIENTRY FrontFace(GLenum mode)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateFrontFace(context, mode))
        {
            context->frontFace(mode);
        }
    }
}

void GL_APIENTRY GenBuffers(GLsizei n, GLuint *buffers)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLsizei n = %d, GLuint *buffers = 0x%016" PRIxPTR ")", n, (uintptr_t)buffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGenBuffers(context, n, buffers))
        {
            context->genBuffers(n, buffers);
        }
    }
}

void GL_APIENTRY GenFramebuffers(GLsizei n, GLuint *framebuffers)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLsizei n = %d, GLuint *framebuffers = 0x%016" PRIxPTR ")", n, (uintptr_t)framebuffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGenFramebuffers(context, n, framebuffers))
        {
            context->genFramebuffers(n, framebuffers);
        }
    }
}

void GL_APIENTRY GenRenderbuffers(GLsizei n, GLuint *renderbuffers)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLsizei n = %d, GLuint *renderbuffers = 0x%016" PRIxPTR ")", n,
          (uintptr_t)renderbuffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGenRenderbuffers(context, n, renderbuffers))
        {
            context->genRenderbuffers(n, renderbuffers);
        }
    }
}

void GL_APIENTRY GenTextures(GLsizei n, GLuint *textures)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLsizei n = %d, GLuint *textures = 0x%016" PRIxPTR ")", n, (uintptr_t)textures);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGenTextures(context, n, textures))
        {
            context->genTextures(n, textures);
        }
    }
}

void GL_APIENTRY GenerateMipmap(GLenum target)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        if (context->skipValidation() || ValidateGenerateMipmap(context, targetPacked))
        {
            context->generateMipmap(targetPacked);
        }
    }
}

void GL_APIENTRY GetActiveAttrib(GLuint program,
                                 GLuint index,
                                 GLsizei bufSize,
                                 GLsizei *length,
                                 GLint *size,
                                 GLenum *type,
                                 GLchar *name)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLuint program = %u, GLuint index = %u, GLsizei bufSize = %d, GLsizei *length = "
        "0x%016" PRIxPTR ", GLint *size = 0x%016" PRIxPTR ", GLenum *type = 0x%016" PRIxPTR
        ", GLchar *name = 0x%016" PRIxPTR ")",
        program, index, bufSize, (uintptr_t)length, (uintptr_t)size, (uintptr_t)type,
        (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateGetActiveAttrib(context, program, index, bufSize, length, size, type, name))
        {
            context->getActiveAttrib(program, index, bufSize, length, size, type, name);
        }
    }
}

void GL_APIENTRY GetActiveUniform(GLuint program,
                                  GLuint index,
                                  GLsizei bufSize,
                                  GLsizei *length,
                                  GLint *size,
                                  GLenum *type,
                                  GLchar *name)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLuint program = %u, GLuint index = %u, GLsizei bufSize = %d, GLsizei *length = "
        "0x%016" PRIxPTR ", GLint *size = 0x%016" PRIxPTR ", GLenum *type = 0x%016" PRIxPTR
        ", GLchar *name = 0x%016" PRIxPTR ")",
        program, index, bufSize, (uintptr_t)length, (uintptr_t)size, (uintptr_t)type,
        (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateGetActiveUniform(context, program, index, bufSize, length, size, type, name))
        {
            context->getActiveUniform(program, index, bufSize, length, size, type, name);
        }
    }
}

void GL_APIENTRY GetAttachedShaders(GLuint program,
                                    GLsizei maxCount,
                                    GLsizei *count,
                                    GLuint *shaders)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint program = %u, GLsizei maxCount = %d, GLsizei *count = 0x%016" PRIxPTR
          ", GLuint *shaders = 0x%016" PRIxPTR ")",
          program, maxCount, (uintptr_t)count, (uintptr_t)shaders);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateGetAttachedShaders(context, program, maxCount, count, shaders))
        {
            context->getAttachedShaders(program, maxCount, count, shaders);
        }
    }
}

GLint GL_APIENTRY GetAttribLocation(GLuint program, const GLchar *name)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR ")", program,
          (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetAttribLocation(context, program, name))
        {
            return context->getAttribLocation(program, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetAttribLocation, GLint>();
}

void GL_APIENTRY GetBooleanv(GLenum pname, GLboolean *data)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, GLboolean *data = 0x%016" PRIxPTR ")", pname, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetBooleanv(context, pname, data))
        {
            context->getBooleanv(pname, data);
        }
    }
}

void GL_APIENTRY GetBufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        if (context->skipValidation() ||
            ValidateGetBufferParameteriv(context, targetPacked, pname, params))
        {
            context->getBufferParameteriv(targetPacked, pname, params);
        }
    }
}

GLenum GL_APIENTRY GetError()
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("()");

    Context *context = GetGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetError(context))
        {
            return context->getError();
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetError, GLenum>();
}

void GL_APIENTRY GetFloatv(GLenum pname, GLfloat *data)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, GLfloat *data = 0x%016" PRIxPTR ")", pname, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetFloatv(context, pname, data))
        {
            context->getFloatv(pname, data);
        }
    }
}

void GL_APIENTRY GetFramebufferAttachmentParameteriv(GLenum target,
                                                     GLenum attachment,
                                                     GLenum pname,
                                                     GLint *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum pname = 0x%X, GLint *params = "
        "0x%016" PRIxPTR ")",
        target, attachment, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateGetFramebufferAttachmentParameteriv(context, target, attachment, pname, params))
        {
            context->getFramebufferAttachmentParameteriv(target, attachment, pname, params);
        }
    }
}

void GL_APIENTRY GetIntegerv(GLenum pname, GLint *data)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, GLint *data = 0x%016" PRIxPTR ")", pname, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetIntegerv(context, pname, data))
        {
            context->getIntegerv(pname, data);
        }
    }
}

void GL_APIENTRY GetProgramInfoLog(GLuint program,
                                   GLsizei bufSize,
                                   GLsizei *length,
                                   GLchar *infoLog)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint program = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *infoLog = 0x%016" PRIxPTR ")",
          program, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateGetProgramInfoLog(context, program, bufSize, length, infoLog))
        {
            context->getProgramInfoLog(program, bufSize, length, infoLog);
        }
    }
}

void GL_APIENTRY GetProgramiv(GLuint program, GLenum pname, GLint *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint program = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", program,
          pname, (uintptr_t)params);

    Context *context = GetGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetProgramiv(context, program, pname, params))
        {
            context->getProgramiv(program, pname, params);
        }
    }
}

void GL_APIENTRY GetRenderbufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateGetRenderbufferParameteriv(context, target, pname, params))
        {
            context->getRenderbufferParameteriv(target, pname, params);
        }
    }
}

void GL_APIENTRY GetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint shader = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *infoLog = 0x%016" PRIxPTR ")",
          shader, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateGetShaderInfoLog(context, shader, bufSize, length, infoLog))
        {
            context->getShaderInfoLog(shader, bufSize, length, infoLog);
        }
    }
}

void GL_APIENTRY GetShaderPrecisionFormat(GLenum shadertype,
                                          GLenum precisiontype,
                                          GLint *range,
                                          GLint *precision)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum shadertype = 0x%X, GLenum precisiontype = 0x%X, GLint *range = 0x%016" PRIxPTR
          ", GLint *precision = 0x%016" PRIxPTR ")",
          shadertype, precisiontype, (uintptr_t)range, (uintptr_t)precision);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateGetShaderPrecisionFormat(context, shadertype, precisiontype, range, precision))
        {
            context->getShaderPrecisionFormat(shadertype, precisiontype, range, precision);
        }
    }
}

void GL_APIENTRY GetShaderSource(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint shader = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *source = 0x%016" PRIxPTR ")",
          shader, bufSize, (uintptr_t)length, (uintptr_t)source);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateGetShaderSource(context, shader, bufSize, length, source))
        {
            context->getShaderSource(shader, bufSize, length, source);
        }
    }
}

void GL_APIENTRY GetShaderiv(GLuint shader, GLenum pname, GLint *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint shader = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", shader,
          pname, (uintptr_t)params);

    Context *context = GetGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetShaderiv(context, shader, pname, params))
        {
            context->getShaderiv(shader, pname, params);
        }
    }
}

const GLubyte *GL_APIENTRY GetString(GLenum name)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum name = 0x%X)", name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetString(context, name))
        {
            return context->getString(name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetString, const GLubyte *>();
}

void GL_APIENTRY GetTexParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        if (context->skipValidation() ||
            ValidateGetTexParameterfv(context, targetPacked, pname, params))
        {
            context->getTexParameterfv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetTexParameteriv(GLenum target, GLenum pname, GLint *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        if (context->skipValidation() ||
            ValidateGetTexParameteriv(context, targetPacked, pname, params))
        {
            context->getTexParameteriv(targetPacked, pname, params);
        }
    }
}

GLint GL_APIENTRY GetUniformLocation(GLuint program, const GLchar *name)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR ")", program,
          (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetUniformLocation(context, program, name))
        {
            return context->getUniformLocation(program, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetUniformLocation, GLint>();
}

void GL_APIENTRY GetUniformfv(GLuint program, GLint location, GLfloat *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint program = %u, GLint location = %d, GLfloat *params = 0x%016" PRIxPTR ")",
          program, location, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetUniformfv(context, program, location, params))
        {
            context->getUniformfv(program, location, params);
        }
    }
}

void GL_APIENTRY GetUniformiv(GLuint program, GLint location, GLint *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint program = %u, GLint location = %d, GLint *params = 0x%016" PRIxPTR ")", program,
          location, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetUniformiv(context, program, location, params))
        {
            context->getUniformiv(program, location, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribPointerv(GLuint index, GLenum pname, void **pointer)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, void **pointer = 0x%016" PRIxPTR ")", index,
          pname, (uintptr_t)pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateGetVertexAttribPointerv(context, index, pname, pointer))
        {
            context->getVertexAttribPointerv(index, pname, pointer);
        }
    }
}

void GL_APIENTRY GetVertexAttribfv(GLuint index, GLenum pname, GLfloat *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")", index,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetVertexAttribfv(context, index, pname, params))
        {
            context->getVertexAttribfv(index, pname, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribiv(GLuint index, GLenum pname, GLint *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", index,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetVertexAttribiv(context, index, pname, params))
        {
            context->getVertexAttribiv(index, pname, params);
        }
    }
}

void GL_APIENTRY Hint(GLenum target, GLenum mode)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum mode = 0x%X)", target, mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateHint(context, target, mode))
        {
            context->hint(target, mode);
        }
    }
}

GLboolean GL_APIENTRY IsBuffer(GLuint buffer)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint buffer = %u)", buffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateIsBuffer(context, buffer))
        {
            return context->isBuffer(buffer);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsBuffer, GLboolean>();
}

GLboolean GL_APIENTRY IsEnabled(GLenum cap)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum cap = 0x%X)", cap);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateIsEnabled(context, cap))
        {
            return context->isEnabled(cap);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsEnabled, GLboolean>();
}

GLboolean GL_APIENTRY IsFramebuffer(GLuint framebuffer)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint framebuffer = %u)", framebuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateIsFramebuffer(context, framebuffer))
        {
            return context->isFramebuffer(framebuffer);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsFramebuffer, GLboolean>();
}

GLboolean GL_APIENTRY IsProgram(GLuint program)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint program = %u)", program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateIsProgram(context, program))
        {
            return context->isProgram(program);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsProgram, GLboolean>();
}

GLboolean GL_APIENTRY IsRenderbuffer(GLuint renderbuffer)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint renderbuffer = %u)", renderbuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateIsRenderbuffer(context, renderbuffer))
        {
            return context->isRenderbuffer(renderbuffer);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsRenderbuffer, GLboolean>();
}

GLboolean GL_APIENTRY IsShader(GLuint shader)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint shader = %u)", shader);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateIsShader(context, shader))
        {
            return context->isShader(shader);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsShader, GLboolean>();
}

GLboolean GL_APIENTRY IsTexture(GLuint texture)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint texture = %u)", texture);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateIsTexture(context, texture))
        {
            return context->isTexture(texture);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsTexture, GLboolean>();
}

void GL_APIENTRY LineWidth(GLfloat width)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfloat width = %f)", width);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateLineWidth(context, width))
        {
            context->lineWidth(width);
        }
    }
}

void GL_APIENTRY LinkProgram(GLuint program)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint program = %u)", program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateLinkProgram(context, program))
        {
            context->linkProgram(program);
        }
    }
}

void GL_APIENTRY PixelStorei(GLenum pname, GLint param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, GLint param = %d)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidatePixelStorei(context, pname, param))
        {
            context->pixelStorei(pname, param);
        }
    }
}

void GL_APIENTRY PolygonOffset(GLfloat factor, GLfloat units)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfloat factor = %f, GLfloat units = %f)", factor, units);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidatePolygonOffset(context, factor, units))
        {
            context->polygonOffset(factor, units);
        }
    }
}

void GL_APIENTRY ReadPixels(GLint x,
                            GLint y,
                            GLsizei width,
                            GLsizei height,
                            GLenum format,
                            GLenum type,
                            void *pixels)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLenum format = "
        "0x%X, GLenum type = 0x%X, void *pixels = 0x%016" PRIxPTR ")",
        x, y, width, height, format, type, (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateReadPixels(context, x, y, width, height, format, type, pixels))
        {
            context->readPixels(x, y, width, height, format, type, pixels);
        }
    }
}

void GL_APIENTRY ReleaseShaderCompiler()
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateReleaseShaderCompiler(context))
        {
            context->releaseShaderCompiler();
        }
    }
}

void GL_APIENTRY RenderbufferStorage(GLenum target,
                                     GLenum internalformat,
                                     GLsizei width,
                                     GLsizei height)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLenum target = 0x%X, GLenum internalformat = 0x%X, GLsizei width = %d, GLsizei height = "
        "%d)",
        target, internalformat, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateRenderbufferStorage(context, target, internalformat, width, height))
        {
            context->renderbufferStorage(target, internalformat, width, height);
        }
    }
}

void GL_APIENTRY SampleCoverage(GLfloat value, GLboolean invert)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfloat value = %f, GLboolean invert = %u)", value, invert);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateSampleCoverage(context, value, invert))
        {
            context->sampleCoverage(value, invert);
        }
    }
}

void GL_APIENTRY Scissor(GLint x, GLint y, GLsizei width, GLsizei height)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)", x, y, width,
          height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateScissor(context, x, y, width, height))
        {
            context->scissor(x, y, width, height);
        }
    }
}

void GL_APIENTRY ShaderBinary(GLsizei count,
                              const GLuint *shaders,
                              GLenum binaryformat,
                              const void *binary,
                              GLsizei length)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLsizei count = %d, const GLuint *shaders = 0x%016" PRIxPTR
          ", GLenum binaryformat = 0x%X, const void *binary = 0x%016" PRIxPTR
          ", GLsizei length = %d)",
          count, (uintptr_t)shaders, binaryformat, (uintptr_t)binary, length);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateShaderBinary(context, count, shaders, binaryformat, binary, length))
        {
            context->shaderBinary(count, shaders, binaryformat, binary, length);
        }
    }
}

void GL_APIENTRY ShaderSource(GLuint shader,
                              GLsizei count,
                              const GLchar *const *string,
                              const GLint *length)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint shader = %u, GLsizei count = %d, const GLchar *const*string = 0x%016" PRIxPTR
          ", const GLint *length = 0x%016" PRIxPTR ")",
          shader, count, (uintptr_t)string, (uintptr_t)length);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateShaderSource(context, shader, count, string, length))
        {
            context->shaderSource(shader, count, string, length);
        }
    }
}

void GL_APIENTRY StencilFunc(GLenum func, GLint ref, GLuint mask)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum func = 0x%X, GLint ref = %d, GLuint mask = %u)", func, ref, mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateStencilFunc(context, func, ref, mask))
        {
            context->stencilFunc(func, ref, mask);
        }
    }
}

void GL_APIENTRY StencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum face = 0x%X, GLenum func = 0x%X, GLint ref = %d, GLuint mask = %u)", face, func,
          ref, mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateStencilFuncSeparate(context, face, func, ref, mask))
        {
            context->stencilFuncSeparate(face, func, ref, mask);
        }
    }
}

void GL_APIENTRY StencilMask(GLuint mask)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint mask = %u)", mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateStencilMask(context, mask))
        {
            context->stencilMask(mask);
        }
    }
}

void GL_APIENTRY StencilMaskSeparate(GLenum face, GLuint mask)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum face = 0x%X, GLuint mask = %u)", face, mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateStencilMaskSeparate(context, face, mask))
        {
            context->stencilMaskSeparate(face, mask);
        }
    }
}

void GL_APIENTRY StencilOp(GLenum fail, GLenum zfail, GLenum zpass)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum fail = 0x%X, GLenum zfail = 0x%X, GLenum zpass = 0x%X)", fail, zfail, zpass);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateStencilOp(context, fail, zfail, zpass))
        {
            context->stencilOp(fail, zfail, zpass);
        }
    }
}

void GL_APIENTRY StencilOpSeparate(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum face = 0x%X, GLenum sfail = 0x%X, GLenum dpfail = 0x%X, GLenum dppass = 0x%X)",
          face, sfail, dpfail, dppass);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateStencilOpSeparate(context, face, sfail, dpfail, dppass))
        {
            context->stencilOpSeparate(face, sfail, dpfail, dppass);
        }
    }
}

void GL_APIENTRY TexImage2D(GLenum target,
                            GLint level,
                            GLint internalformat,
                            GLsizei width,
                            GLsizei height,
                            GLint border,
                            GLenum format,
                            GLenum type,
                            const void *pixels)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint internalformat = %d, GLsizei width = %d, "
        "GLsizei height = %d, GLint border = %d, GLenum format = 0x%X, GLenum type = 0x%X, const "
        "void *pixels = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, border, format, type, (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        if (context->skipValidation() ||
            ValidateTexImage2D(context, targetPacked, level, internalformat, width, height, border,
                               format, type, pixels))
        {
            context->texImage2D(targetPacked, level, internalformat, width, height, border, format,
                                type, pixels);
        }
    }
}

void GL_APIENTRY TexParameterf(GLenum target, GLenum pname, GLfloat param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", target, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        if (context->skipValidation() || ValidateTexParameterf(context, targetPacked, pname, param))
        {
            context->texParameterf(targetPacked, pname, param);
        }
    }
}

void GL_APIENTRY TexParameterfv(GLenum target, GLenum pname, const GLfloat *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        if (context->skipValidation() ||
            ValidateTexParameterfv(context, targetPacked, pname, params))
        {
            context->texParameterfv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY TexParameteri(GLenum target, GLenum pname, GLint param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint param = %d)", target, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        if (context->skipValidation() || ValidateTexParameteri(context, targetPacked, pname, param))
        {
            context->texParameteri(targetPacked, pname, param);
        }
    }
}

void GL_APIENTRY TexParameteriv(GLenum target, GLenum pname, const GLint *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        if (context->skipValidation() ||
            ValidateTexParameteriv(context, targetPacked, pname, params))
        {
            context->texParameteriv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY TexSubImage2D(GLenum target,
                               GLint level,
                               GLint xoffset,
                               GLint yoffset,
                               GLsizei width,
                               GLsizei height,
                               GLenum format,
                               GLenum type,
                               const void *pixels)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLsizei "
        "width = %d, GLsizei height = %d, GLenum format = 0x%X, GLenum type = 0x%X, const void "
        "*pixels = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, width, height, format, type, (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        if (context->skipValidation() ||
            ValidateTexSubImage2D(context, targetPacked, level, xoffset, yoffset, width, height,
                                  format, type, pixels))
        {
            context->texSubImage2D(targetPacked, level, xoffset, yoffset, width, height, format,
                                   type, pixels);
        }
    }
}

void GL_APIENTRY Uniform1f(GLint location, GLfloat v0)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint location = %d, GLfloat v0 = %f)", location, v0);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUniform1f(context, location, v0))
        {
            context->uniform1f(location, v0);
        }
    }
}

void GL_APIENTRY Uniform1fv(GLint location, GLsizei count, const GLfloat *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint location = %d, GLsizei count = %d, const GLfloat *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUniform1fv(context, location, count, value))
        {
            context->uniform1fv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform1i(GLint location, GLint v0)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint location = %d, GLint v0 = %d)", location, v0);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUniform1i(context, location, v0))
        {
            context->uniform1i(location, v0);
        }
    }
}

void GL_APIENTRY Uniform1iv(GLint location, GLsizei count, const GLint *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUniform1iv(context, location, count, value))
        {
            context->uniform1iv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform2f(GLint location, GLfloat v0, GLfloat v1)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f)", location, v0, v1);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUniform2f(context, location, v0, v1))
        {
            context->uniform2f(location, v0, v1);
        }
    }
}

void GL_APIENTRY Uniform2fv(GLint location, GLsizei count, const GLfloat *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint location = %d, GLsizei count = %d, const GLfloat *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUniform2fv(context, location, count, value))
        {
            context->uniform2fv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform2i(GLint location, GLint v0, GLint v1)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint location = %d, GLint v0 = %d, GLint v1 = %d)", location, v0, v1);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUniform2i(context, location, v0, v1))
        {
            context->uniform2i(location, v0, v1);
        }
    }
}

void GL_APIENTRY Uniform2iv(GLint location, GLsizei count, const GLint *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUniform2iv(context, location, count, value))
        {
            context->uniform2iv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f, GLfloat v2 = %f)", location, v0,
          v1, v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUniform3f(context, location, v0, v1, v2))
        {
            context->uniform3f(location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY Uniform3fv(GLint location, GLsizei count, const GLfloat *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint location = %d, GLsizei count = %d, const GLfloat *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUniform3fv(context, location, count, value))
        {
            context->uniform3fv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform3i(GLint location, GLint v0, GLint v1, GLint v2)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint location = %d, GLint v0 = %d, GLint v1 = %d, GLint v2 = %d)", location, v0, v1,
          v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUniform3i(context, location, v0, v1, v2))
        {
            context->uniform3i(location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY Uniform3iv(GLint location, GLsizei count, const GLint *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUniform3iv(context, location, count, value))
        {
            context->uniform3iv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f, GLfloat v2 = %f, GLfloat v3 = %f)",
        location, v0, v1, v2, v3);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUniform4f(context, location, v0, v1, v2, v3))
        {
            context->uniform4f(location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY Uniform4fv(GLint location, GLsizei count, const GLfloat *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint location = %d, GLsizei count = %d, const GLfloat *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUniform4fv(context, location, count, value))
        {
            context->uniform4fv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint location = %d, GLint v0 = %d, GLint v1 = %d, GLint v2 = %d, GLint v3 = %d)",
          location, v0, v1, v2, v3);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUniform4i(context, location, v0, v1, v2, v3))
        {
            context->uniform4i(location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY Uniform4iv(GLint location, GLsizei count, const GLint *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUniform4iv(context, location, count, value))
        {
            context->uniform4iv(location, count, value);
        }
    }
}

void GL_APIENTRY UniformMatrix2fv(GLint location,
                                  GLsizei count,
                                  GLboolean transpose,
                                  const GLfloat *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateUniformMatrix2fv(context, location, count, transpose, value))
        {
            context->uniformMatrix2fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix3fv(GLint location,
                                  GLsizei count,
                                  GLboolean transpose,
                                  const GLfloat *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateUniformMatrix3fv(context, location, count, transpose, value))
        {
            context->uniformMatrix3fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix4fv(GLint location,
                                  GLsizei count,
                                  GLboolean transpose,
                                  const GLfloat *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() ||
            ValidateUniformMatrix4fv(context, location, count, transpose, value))
        {
            context->uniformMatrix4fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UseProgram(GLuint program)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint program = %u)", program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateUseProgram(context, program))
        {
            context->useProgram(program);
        }
    }
}

void GL_APIENTRY ValidateProgram(GLuint program)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint program = %u)", program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateValidateProgram(context, program))
        {
            context->validateProgram(program);
        }
    }
}

void GL_APIENTRY VertexAttrib1f(GLuint index, GLfloat x)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint index = %u, GLfloat x = %f)", index, x);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateVertexAttrib1f(context, index, x))
        {
            context->vertexAttrib1f(index, x);
        }
    }
}

void GL_APIENTRY VertexAttrib1fv(GLuint index, const GLfloat *v)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint index = %u, const GLfloat *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateVertexAttrib1fv(context, index, v))
        {
            context->vertexAttrib1fv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib2f(GLuint index, GLfloat x, GLfloat y)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint index = %u, GLfloat x = %f, GLfloat y = %f)", index, x, y);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateVertexAttrib2f(context, index, x, y))
        {
            context->vertexAttrib2f(index, x, y);
        }
    }
}

void GL_APIENTRY VertexAttrib2fv(GLuint index, const GLfloat *v)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint index = %u, const GLfloat *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateVertexAttrib2fv(context, index, v))
        {
            context->vertexAttrib2fv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint index = %u, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", index, x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateVertexAttrib3f(context, index, x, y, z))
        {
            context->vertexAttrib3f(index, x, y, z);
        }
    }
}

void GL_APIENTRY VertexAttrib3fv(GLuint index, const GLfloat *v)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint index = %u, const GLfloat *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateVertexAttrib3fv(context, index, v))
        {
            context->vertexAttrib3fv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint index = %u, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f, GLfloat w = %f)",
          index, x, y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateVertexAttrib4f(context, index, x, y, z, w))
        {
            context->vertexAttrib4f(index, x, y, z, w);
        }
    }
}

void GL_APIENTRY VertexAttrib4fv(GLuint index, const GLfloat *v)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLuint index = %u, const GLfloat *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateVertexAttrib4fv(context, index, v))
        {
            context->vertexAttrib4fv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribPointer(GLuint index,
                                     GLint size,
                                     GLenum type,
                                     GLboolean normalized,
                                     GLsizei stride,
                                     const void *pointer)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLuint index = %u, GLint size = %d, GLenum type = 0x%X, GLboolean normalized = %u, "
        "GLsizei stride = %d, const void *pointer = 0x%016" PRIxPTR ")",
        index, size, type, normalized, stride, (uintptr_t)pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        if (context->skipValidation() ||
            ValidateVertexAttribPointer(context, index, size, typePacked, normalized, stride,
                                        pointer))
        {
            context->vertexAttribPointer(index, size, typePacked, normalized, stride, pointer);
        }
    }
}

void GL_APIENTRY Viewport(GLint x, GLint y, GLsizei width, GLsizei height)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)", x, y, width,
          height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateViewport(context, x, y, width, height))
        {
            context->viewport(x, y, width, height);
        }
    }
}
}  // namespace gl
