/***********************************************************************/
/*	equipmnt.c                                                    */
/***********************************************************************/

equipmnt(printers,games,comms,drives,videotyp,memsize) /* equipment check */
int *printers; /* number of parallel ports available */
int *games; /* game ports available */
int *comms; /* number of RS232 ports */
int *drives; /* the number of disk drives present */
int *videotyp; /* type of adapter being used: 0 for mono, 1 for color */
int *memsize; /* amount of memory in k bytes */
{
  struct intregs regs;  /* registers for gdosint    */
  int ret_code,int_no;  /* return code and interrupt for gdosint */
  unsigned equip;       /* data word returned from BIOS call */

  regs.es=regs.ds=0;   /* default value - no changes to register */
  int_no=18;
  ret_code = gdosint(int_no,&regs,&regs);
  *memsize=(regs.ah << 8) + regs.al;
  int_no=17;
  ret_code = gdosint(int_no,&regs,&regs);
  equip = (regs.ah << 8) + regs.al;

  *printers = (equip & 0xC000) >> 14;
  *games = (equip & 0x1000) >> 12;
  *comms = (equip & 0x0E00) >> 9;
  if ( (equip & 0x0001) != 0 ){
     *drives = ((equip & 0x00C0) >> 6) + 1;
  }else {
     *drives = 0;
  }
  if ( ((equip & 0x0030) >> 4) == 3 ){
     *videotyp = 0;  /* monochrome adapter */
  }else {
     *videotyp = 1;  /* color adapter */
  }
}
