/***********************************************************************/
/*	strmid.c                                                      */
/***********************************************************************/

/* function to replace characters in one string with the leftmost */
/* characters of another                                          */
strmid(ins,outs,pos,cnt,maxsize)
char *ins; /* source string */
char *outs; /* output (target) string */
int pos; /* starting character of output string */
int cnt; /* # of charcters to be replaced */
int maxsize; /* size of output (target) string */
{
int i; /* return value ( actual characters replaced or added ) */
char nullflag; /* flag if output string needs null terminator */
/* check for negative starting position */
if(pos < 0) return(-1);
/* check for non positive maximun size */
if(maxsize < 1) return(-2);
/* check for starting position passed null terminator */
for(i = 0; i < pos; ++i)
  {
  if(outs[i] == '\0') return(-3);
  }
/* check for non positive count */
if(cnt < 0) return(-4);
/* all error checks are okay, replace characters starting at pos. */
/* If we hit end of output string before we are done replacing,   */
/* the remaining characters are appended to the output string     */
/* up to the maximun size                                         */
nullflag = 'n';
for(i = pos; i < (cnt + pos); ++i)
  {
  if(ins[i - pos] == '\0')
    {
    if(nullflag == 'y') outs[i] = '\0';
    return( i - pos);
    }
  if(outs[i] == '\0') nullflag = 'y';
  outs[i] = ins[i - pos];
  if((maxsize - 1) == i)
    {
    if(nullflag == 'y') outs[i] = '\0';
    return(i - pos);
    }
  }
if(nullflag == 'y') outs[i] = '\0';
return(i - pos);
}
