/***********************************************************************/
/*	setdate.c                                                     */
/***********************************************************************/
setdate(yr,mon,day)      /* set system date                */
int yr,mon,day;          /* year, month, day               */
{
struct intregs regs;     /* register structure for gdosint */
int ret_code;            /* return code from gdosint       */
int year;

if (yr < 100)
	year = yr + 1900;
else
	year = yr;
regs.ch = year >> 8;
regs.cl = year - (regs.ch << 8);
regs.dh = mon;
regs.dl = day;
regs.ah = 0x2B;          /* DOS set date function          */
ret_code = gdosint(0x21,&regs,&regs);
if (regs.al == 0xFF )
	return(-1);      /* invalid date parameter         */
else
	return(0);       /* date reset                     */
}
