/***********************************************************************/
/*	qtrsfrom.c                                                    */
/***********************************************************************/

/* function to return a new date from a date & # of quarters to be added */
quartersfrom(out,year,month,day,nq,j)
char *out; /* output (target) string */
int year; /* year passed */
int month; /* month passed */
int day; /* day passed */
int nq; /* # of quarters to be added */
int j; /* conversion code */
       /*  98 - #qyy      */
       /*  99 - #qyyyy    */
       /* 100 - Q# yy     */
       /* 101 - Q# yyyy   */
       /* 102 - Q#-yy     */
       /* 103 - Q#-yyyy   */
       /* 104 - Q#/yy     */
       /* 105 - Q#/yyyy   */
       /* 106 - #Q yy     */
       /* 107 - #Q yyyy   */
       /* 108 - #Q-yy     */
       /* 109 - #Q-yyyy   */
       /* 110 - #Q/yy     */
       /* 111 - #Q/yyyy   */
       /* 112 - yy Q#     */
       /* 113 - YYYY Q#   */
       /* 114 - yy-Q#     */
       /* 115 - YYYY-Q#   */
       /* 116 - YY/Q#     */
       /* 117 - YYYY/Q#   */
       /* 118 - YY #Q     */
       /* 119 - YYYY #Q   */
       /* 120 - YY-#Q     */
       /* 121 - YYYY-#Q   */
       /* 122 - YY/#Q     */
       /* 123 - YYYY/#Q   */
       /* 124 - YYQ#      */
       /* 125 - YYYYQ#    */
       /* 126 - #Q        */
       /* 127 - Q#        */
       /* 128 - #         */
{
int y1; /* century part of year */
int y2; /* remaining part of year */
int y3; /* return year */
int m1; /* return month, if necessary */
int k; /* increment variable */
int d; /* temp counter */
int q; /* output quarter */
char ys[6]; /* year part of string */
char qs[6]; /* quarter part of string */
/* month range check */
if((month < 1)||(month > 12)) return(-3);
m1 = month;
/* break up year */
if(year > 100)
  {
  y1 = year / 100;
  y2 = year % 100;
  }
  else
  {
  y1 = 19;
  y2 = year;
  }
/* set current quarter */
if(month < 4) q = 1;
  else if(month < 7) q = 2;
    else if(month < 10) q = 3;
      else q = 4;
if(nq == 0) goto end;
if(nq > 0) k = 1;
  else k = -1;
/* start advancing thru */
for(d = k; d !=(nq+k); d = d + k)
  {
  q = q + k;
  m1 = m1 + (k * 3);
  if((q == 5)||(q == 0))
    {
    q = q - (4 * k);
    m1 = m1 - (12 * k);
    y2 = y2 + k;
    if((y2 == 100)||(y2 == -1))
      {
      y2 = y2 - (100 * k);
      y1 = y1 + k;
      }
    }
  continue;
  }
end:
if(j < 98)
  {
  k = cdate(out,y1,y2,m1,day,j);
  return(k);
  }
/* setup year string */
y3 = (y1 * 100) + y2;
if((j < 98)||(j > 128)) return(-1);
if((j < 125)&&((j % 2) == 0))
  {
  /* only 2 digit year */
  k = stci_d(&ys[0],y2,6);
  if(k == 1)
    {
    ys[2] = '\0';
    ys[1] = ys[0];
    ys[0] = '0';
    }
  }
  /* four digit year */
  else k = stci_d(&ys[0],y3,6);
/* setup quarter string */
if(((j > 99)&&(j < 106))||((j > 111)&&(j < 118))||(j == 124)
  ||(j == 125)||(j == 127))
  {
  /* Q# format */
  qs[0] = 'Q';
  stci_d(&qs[1],q,5);
  qs[2] = '\0';
  }
  else
  {
  if(j != 128)
    {
    /* #Q format */
    stci_d(&qs[0],q,6);
    qs[1] = 'Q';
    qs[2] = '\0';
    }
    else stci_d(&qs[0],q,6);
  }
out[0] = '\0';
/* merge together */
if(j < 112)
  {
  strcat(out,&qs[0]);
  if((j == 102)||(j == 103)||(j == 108)||(j == 109)) strcat(out,"-");
  if((j == 104)||(j == 105)||(j == 110)||(j == 111)) strcat(out,"/");
  if((j == 100)||(j == 101)||(j == 106)||(j == 107)) strcat(out," ");
  strcat(out,&ys[0]);
  return(0);
  }
if(j < 126)
  {
  strcat(out,&ys[0]);
  if((j == 114)||(j == 115)||(j == 120)||(j == 121)) strcat(out,"-");
  if((j == 116)||(j == 117)||(j == 122)||(j == 123)) strcat(out,"/");
  if((j == 112)||(j == 113)||(j == 118)||(j == 119)) strcat(out," ");
  strcat(out,&qs[0]);
  return(0);
  }
strcat(out,&qs[0]);
return(0);
}
