/***********************************************************************/
/*	getscmod.c                                                    */
/***********************************************************************/

getscmod(mode,num_cols,act_page) /* get the current video mode, page, cols */
int *mode; /* pointer to mode variable in caller */
int *num_cols; /* pointer to number of columns */
int *act_page; /* pointer to active page variable */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  regs.es=regs.ds=0;   /* default value - no changes to register */
  regs.ah=15;    /*  get active video mode returned in al and active page in bh */
  int_no=0x10; /* video I/O BIOS call */
  ret_code = gdosint(int_no,&regs,&regs);
  *mode=regs.al;
  *num_cols=regs.ah;
  *act_page=regs.bh;
  return(0);
}
