/***********************************************************************/
/*	curtype.c                                                     */
/***********************************************************************/

curtype(onoff,startlin,stoplin) /* set cursor on/off and attributes */
int onoff; /* turn cursor on (0) or off (anything else) */
int startlin; /* the starting line of the new cursor definition */
int stoplin; /* the ending line of the cursor */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  if ( startlin < 0 || startlin > 13 || stoplin < 0 || stoplin > 13 )
     return(-1);
  regs.cl=stoplin;
  if ( onoff != 0 ) /* set appropriate bit pattern to turn cursor on/off */
     regs.ch= startlin | 16;
  else
     regs.ch= startlin & 15;
  regs.es=regs.ds=0;   /* default value - no changes to register */
  regs.ah=1;
  int_no=0x10; /* video I/O BIOS call */
  ret_code = gdosint(int_no,&regs,&regs);
}
