/***********************************************************************/
/*	clscolor.c
/***********************************************************************/

clscolor(forgnd,bakrnd) /* clear screen with color function */
int forgnd; /* the forground color to fill with */
int bakrnd; /* the background color to fill with */
{
  int act_page; /* current active video page */
  int mode; /* current video mode */
  int num_cols; /* number of columns in active video mode */
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  getscmod(&mode,&num_cols,&act_page); /* get current settings */
  if ( mode > 3 ) /* if it is a graphics mode, reset it to clrscrn */
     {
       setscmod(mode);
       curlocat(0,0);
       return(0);
     }
  regs.al=0; /* set the registers to scroll the entire screen */
  if (forgnd < 16 ) /* set the attribute byte */
     regs.bh= ( bakrnd << 4 ) + forgnd; /* forgnd not blinking */
  else
     regs.bh= (( bakrnd << 4 ) + forgnd - 16) | 0x0080; /* forgnd blinking */
  regs.bl=0;
  regs.ch=0;
  regs.cl=0;
  regs.dh=24;
  regs.dl=num_cols;
  regs.es=regs.ds=0;   /* default value - no changes to register */
  regs.ah=0x6; /* video scroll up function */
  int_no=0x10; /* video I/O BIOS call */
  ret_code = gdosint(int_no,&regs,&regs);
  curlocat(0,0); /* place cursor at top of page */
  return(0);
}
