;***********************************************************************/
;*	segmov.asm                                                    */
;***********************************************************************/
;
INCLUDE MACROS.INC
INCLUDE BIOSDATA.INC

IFDEF MSDOS        ; DEFINED IN LATTICE 2.X M8086.MAC
PSEG
ENDIF
;
;**************************************************************************
;
;  SEGMOVE
;
;  This subroutine moves a number of BYTES from one memory
;  location (SEGMENT AND OFFSET) to another memory location 
;  (SEGMENT AND OFFSET). The syntax for the function is as follows:
;
;        segmov(bytes,from_offset,from_segment,to_offset,to_segment);
;        where:
;              unsigned bytes; /* number of bytes to move */
;              *from_segment,from_offset; /* two 16 bit pointers which */
;                                         /* define the source of the  */
;                                         /* data to be moved. One 32  */
;                                         /* pointer from the large    */
;                                         /* data models can replace   */
;                                         /* the two 16 bit pointers.  */
;              *to_segment,*to_offset;    /* destination of move. same */
;                                         /* characteristics as *from_ */
;                                         /* pointers.                 */
;
;
;
;
	PUBLIC SEGMOV

IF @BIGMODEL+LPROG     ; LARGE CODE MODELS
SEGMOV	PROC FAR
	BYTES EQU BP+6
ELSE
SEGMOV	PROC NEAR
	BYTES EQU BP+4
ENDIF
	PUSH BP
	MOV BP,SP
	PUSH DS		; SAVE SEGMENT REGISTERS WHICH MAY BE MODIFIED
	PUSH ES
	MOV CX,[BYTES]	; PUT BYTE COUNT IN CX REGISTER
	LES DI,DWORD PTR [BYTES+6]	; SET UP DESTINATION REGS
	LDS SI,DWORD PTR [BYTES+2]	; SET UP SOURCE REGS
REP	MOVSB		; DO MOVE
	POP ES		; RESTORE ES AND DS REGISTERS
	POP DS
	POP BP
	RET
SEGMOV	ENDP

;******************************************************************************
;
IFDEF CI_C86
@CODE	ENDS
ELSE
ENDPS
ENDIF
	END
