	PAGE	,132
;	Copyright(C) 1984, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;

.XLIST
	INCLUDE ASCII.DEF
	INCLUDE DRIVERS.DEF
	INCLUDE FIXED.DEF
	INCLUDE IOCONFIG.DEF
	INCLUDE LOADER.DEF
	INCLUDE MSDOS.DEF
	INCLUDE MACRO.ASM
	INCLUDE Z150BIOS.DEF
	INCLUDE Z150ROM.DEF
	INCLUDE DEFCHR.ASM
	INCLUDE DEFCONFG.ASM
.LIST


BIOS	SEGMENT	BYTE PUBLIC 'BIOS'
	ASSUME	CS:BIOS, DS:BIOS, SS:BIOS

;	PARDEV - Low level routines for parallel device I/O
;
;	Routines are called from CHRFUNC
;

	PUBLIC	CHRFOD_PAR, CHRFOS_PAR, CHRFID_PAR, CHRFIS_PAR
	PUBLIC	CHRCTS_PAR, CHRCTI_PAR, CHRCTO_PAR

	EXTRN	TCID:BYTE
	EXTRN	CHRCTS_GEX:NEAR


;	CHRFOD_PAR - Raw data output

CHRFOD_PAR:
	PUSH	DX			; Save DX
	PUSH	AX			; Save AX
	MOV	DX,0			; Use first printer
	MOV	AH,PIO_WRITE		; Write the character
	INT	PRINTER_IO_INTR
	POP	AX			; Restore registers
	POP	DX
	RET


;	CHRFOS_PAR - Raw output status

CHRFOS_PAR:
	PUSH	DX			; Save registers
	PUSH	AX
	MOV	DX,0			; First printer
	MOV	AH,PIO_STATUS		; Get status
	INT	PRINTER_IO_INTR
	XOR	DL,DL			; Make sure DL = 0
	TEST	AH,80H			; Is printer busy?
	JNZ	CHRFOS_PAR1		; Skip if not
	OR	DL,1			;  else set busy bit.
CHRFOS_PAR1:
	TEST	AH,08H			; Is there an I/O error?
	JNZ	CHRFOS_PAR2		; Skip if so
	OR	DL,02H			;  else set 'no error' bit
CHRFOS_PAR2:
	POP	AX			; Get AH back
	MOV	AL,DL			; Get status in AL
	POP	DX			; Recover DX
	RET


;	CHRFID_PAR - Raw input data

CHRFID_PAR:
	XOR	AL,AL			; Can't read from parallel printer
	RET


;	CHRFIS_PAR - Raw input status

CHRFIS_PAR:
	XOR	AX,AX			; Meaningless
	XOR	DX,DX			; Clear queue status
	RET


;	CHRCTS_PAR - Set up new parms

CHRCTS_PAR:
	MOV	BYTE PTR TCID+CID_CHRD+CHRD_HSHK,CHRDH_NO	; No handshaking
	MOV	BYTE PTR TCID+CID_ORM,00000001B	; Store ouput ready mask
	MOV	BYTE PTR TCID+CID_OPM,00000001B	; Store output polarity mask
	JMP	CHRCTS_GEX		; Join common code


;	CHRCTI_PAR - Clear input function

CHRCTI_PAR:
	CLC				; Show success
	RET


;	CHRCTO_PAR - Clear output function

CHRCTO_PAR:
	CLC				; Show success
	RET


BIOS	ENDS
	END
