;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
;  Define Functions performed by Disk driver routines
;

DSK_RESET	EQU 0			; Reset function
DSK_STATUS	EQU DSK_RESET+1 	; Status function
DSK_READ	EQU DSK_STATUS+1	; Read function
DSK_WRITE	EQU DSK_READ+1		; Write function
DSK_VERIFY	EQU DSK_WRITE+1		; Verify function
DSK_FORMAT	EQU DSK_VERIFY+1	; Format(write track) function
DSK_STEPIN	EQU DSK_FORMAT+1	; Step in function
DSK_READTRK	EQU DSK_STEPIN+1	; Read track function
DSK_GBIOSVEC	EQU DSK_READTRK+1	; Get BIOS disk vector addr
DSK_MAPDSK	EQU DSK_GBIOSVEC+1	; Get Logical to physical mapping
DSK_SETFDC	EQU DSK_MAPDSK+1	; Set FDC bit in drive table
DSK_PREAD	EQU DSK_SETFDC+1	; Physical read
DSK_ASSIGN	EQU DSK_PREAD+1		; Assign partition
DSK_PWRITE	EQU DSK_ASSIGN+1	; Physical write
DSK_DRVNUM	EQU DSK_PWRITE+1	; Return number of drives
DSK_SKIP	EQU DSK_DRVNUM+1	; Set WRITE skip value
DSK_FMAX	EQU DSK_SKIP		; Max function value



;	
;  Define the disk info block (one is needed for each drive)
;

MAXDSK		EQU 15		; Maximum number of disks
MAXDSK5		EQU 2		; Maximum 5 inch drives (0-1)
MAXDSK8		EQU 4		; Maximum 8 inch drives (2-3)
MAXDSKW		EQU 8		; Maximum winchester drive (4-7)


DSK_STA		EQU 0		; Status of last operation
  DSKST_FNERR	  EQU	0100H	  ; Invalid function 
  DSKST_ORERR	  EQU	0200H	  ; Improper order of function
  DSKST_DNERR	  EQU   0300H	  ; Invalid disk number
  DSKST_DTERR	  EQU	0400H	  ; Invalid disk type
  DSKST_NIERR	  EQU	0500H	  ; Function not implemented  
  DSKST_NDERR	  EQU	0600H	  ; No disk in drive
DSK_TYPE	EQU DSK_STA+2	; Disk type
  DSK_TZ2075	  EQU 0	  	   ; Z-207 type disk 5"
  DSK_TZ2078	  EQU DSK_TZ2075+1 ; Z-207 type disk 8" 
  DSK_TZ217	  EQU DSK_TZ2078+1 ; Z-217 type disk
DSK_LTRK	EQU DSK_TYPE+1	; Last track
DSK_LOPT	EQU DSK_LTRK+1	; Last operation
  DSK_OWR	  EQU	01H	  ; Write was last op
  DSK_ORD	  EQU	02H	  ; Read was last op
  DSK_ORS	  EQU	04H	  ; Reset was last op
  DSK_OSI	  EQU	08H	  ; Step in was last op
  DSK_OFT	  EQU	10H	  ; Format was last op
  DSK_ORT	  EQU	20H	  ; Read track was last op
  DSK_OUK	  EQU	80H	  ; Track is unknown
DSK_FLAG	EQU DSK_LOPT+1	; Flags
  DSK_FDS	  EQU	01H	  ; Disk is double sided
  DSK_FFS	  EQU	02H	  ; Drive can be fast stepped
  DSK_FDP	  EQU	04H	  ; Disk is 48 tpi and should be double stepped
  DSK_FWP	  EQU	08H	  ; Disk is software write protected
  DSK_FDC	  EQU	10H	  ; Force DISK HAS CHANGED one time
  DSK_FSL	  EQU	20H	  ; Long head settle
  DSK_FRS	  EQU	40H	  ; Restore fast then slow
  DSK_ASN	  EQU	80H	  ; No partition assigned
DSK_SEL		EQU DSK_FLAG+1	; Command to select drive
				;  Flag from superblock for winchester
DSK_RS		EQU DSK_SEL+1	; Command to reset drive
DSK_SPHI	EQU DSK_RS+1	; Command to step in
DSK_FMT		EQU DSK_SPHI+1	; Command to format(write) a track
DSK_RD		EQU DSK_FMT+1	; Command to read a sector
DSK_WR		EQU DSK_RD+1	; Command to write a sector
DSK_SK		EQU DSK_WR+1	; Command to seek to a track
DSK_SERR	EQU DSK_SK+1	; Number of "soft" errors
DSK_MAXT	EQU DSK_SERR+2	; Maximum track number of drive
DSK_NRETRY	EQU DSK_MAXT+1	; Maximum retry count
DSK_SPT		EQU DSK_NRETRY+1; Sectors per track
				; Sectors per cylinder for winchester
DSK_BPS		EQU DSK_SPT+1	; Number of bytes per sector
DSK_BPWT	EQU DSK_BPS+2	; Number of bytes per write track operation
DSK_BPRT	EQU DSK_BPWT+2	; Number of bytes per read track operation
DSK_DELAY	EQU DSK_BPRT+2	; Counter value for short delay
DSK_LDELAY	EQU DSK_DELAY+2	; Counter value for a long delay
DSK_PORT	EQU DSK_LDELAY+2; Base Port number
DSK_RDT		EQU DSK_PORT+2	; Read track command
DSK_IMGFLG	EQU DSK_RDT+1	; Imaginary drive flag
  DSKIF_ID	  EQU 80H	  ; (0 - real drive; 1 - imaginary drive)
  DSKIF_DV	  EQU 40H	  ; (0 - disk is not in drive; 1 - disk is in drive)
  DSKIF_NM	  EQU 20H	  ; (0 - can map imag to drive; 1 - can't)	
  DSKIF_DN	  EQU 0FH	  ; (Mask for disk in drive)
DSK_TDSEL	EQU DSK_IMGFLG+1 ; Time to wait before deselecting drive(in 100ths of secs)
DSK_NAME	EQU DSK_TDSEL+2	; Name for drive
DSK_TIMOUT	EQU DSK_NAME+1	; Disk time out value
DSK_SIZE	EQU DSK_TIMOUT+2	; Size of DSK
DSK_BSEC	EQU DSK_TIMOUT+2	; Base sector
DSKW_NPS	EQU DSK_BSEC+2	; Number of physical sectors
DSKW_FAT	EQU DSKW_NPS+2	; Size of FAT in sectors
DSKW_SPAU	EQU DSKW_FAT+1	; Sectors/allocation unit
DSKW_WUN	EQU DSKW_SPAU+1	; Unit number
DSKW_BSECH	EQU DSKW_WUN+1	; Hish sector number of base
DSKW_SIZE	EQU DSKW_BSECH+1 ; Size of DSK for winchester


; 
;  Define the parameter table passed to the disk drive routines
;

DSKPR_DRIVE	EQU 0		; Logical drive number
DSKPR_SECTOR	EQU DSKPR_DRIVE+1 ; Logical sector number
DSKPR_COUNT	EQU DSKPR_SECTOR+2 ; Sector transfer count
DSKPR_BUFF	EQU DSKPR_COUNT+2 ; Buffer addr (offset,paragraph)
DSKPR_SIZE	EQU DSKPR_BUFF+4 ; Size of this thig

