;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
	PAGE	,132
	TITLE	BIOS for MS-DOS 2.00

	.LFCOND
	.TFCOND		; /X switch cause FALSE conds not to be listed

;  BIOS for MS-DOS 2.00
;
;      This is the so called Basic I/O
;      System for MS-DOS.
;
;      It is loaded into memory at a known
;      location by the MS-DOS Loader.
;
;  (C)COPYRIGHT 1982, 1983 BY ZENITH DATA SYSTEMS
;

	INCLUDE	PARMS.ASM		; Get program parms
	INCLUDE	VER.ASM		; Version

    IF1
	%OUT	*Pass 1 started*
    ELSE
	%OUT	*Pass 2 started*
    ENDIF


    IF1
      IF LISTI
	%OUT	*Full listing being generated*
      ELSE
	%OUT	*Include files are not part of listing*
	.XLIST
      ENDIF
    ENDIF

	INCLUDE	DEFASCII.ASM	; ASCII characters
	INCLUDE	DEFCONFG.ASM	; System configuration 
	INCLUDE	DEFMTR.ASM	; ROM based monitor 
	INCLUDE	DEF8259A.ASM	; 8259A interrupt controller 
	.LIST

	PAGE
;
;  The Beginning of the BIOS must have a jump
;  to the init code.
;

BIOS_SEG SEGMENT PUBLIC 'BIOSCODE'
	ASSUME	CS:BIOS_SEG,DS:BIOS_SEG,ES:NOTHING,SS:BIOS_SEG

	EXTRN	BIOS_INIT:NEAR		; BIOS init code
	EXTRN	DSK_TPTR:BYTE		; Addr of disk table vector
	EXTRN	CHRD_PRN:BYTE		; Addr of PRN: configuration table
	EXTRN	CHRD_AUX:BYTE		; Addr of AUX: configuration table
	EXTRN	CHRD_CON:BYTE		; Addr of CON: configuration table
	EXTRN	FNT_INFO:BYTE		; Addr of FONT information
	EXTRN	BIOS_DEVS:BYTE		; Addr of DOS device table
	EXTRN	BIOS_INTFUNC:NEAR	; Interrupt functions
	EXTRN	BIOS_DSKFUNC:NEAR	; Disk functions
	EXTRN	BIOS_CONFUNC:NEAR	; CON functions
	EXTRN	BIOS_AUXFUNC:NEAR	; AUX functions
	EXTRN	BIOS_PRNFUNC:NEAR	; PRN functions
	EXTRN	CQ_ZCON:BYTE		; Input que for CON
	EXTRN	CQ_ZSERA:BYTE		; Input que for Serial A
	EXTRN	CQ_ZSERB:BYTE		; Input que for Serial B
	EXTRN	ASNFL2:BYTE		; Disk assignment values

	PUBLIC	EVN_FLG
	PUBLIC	ISR_EVN
	PUBLIC	RECURLV
	PUBLIC	SAVESS
	PUBLIC	SAVESP
	EXTRN	BIOS_STACK:NEAR
	EXTRN	ROM_WA:NEAR
	PUBLIC	BIOS_START
	PUBLIC	ISR_SLV
	PUBLIC	ISR_PP
	PUBLIC	ISR_SLV0
	PUBLIC	ISR_SLV1
	PUBLIC	ISR_SLV2
	PUBLIC	ISR_SLV3
	PUBLIC	ISR_SLV4
	PUBLIC	ISR_SLV5
	PUBLIC	ISR_SLV6
	PUBLIC	ISR_SLV7
	PUBLIC	ISR_WILD
	PUBLIC	ISR_EI
	PUBLIC	BIOS_MCL
	PUBLIC	BIOS_DATE
	PUBLIC	BIOS_HRS
	PUBLIC	BIOS_MIN
	PUBLIC	BIOS_SEC
	PUBLIC	BIOS_HSEC
	PUBLIC	PMESG
	PUBLIC	BIOS_ASP
	PUBLIC	ASP_LPEFV
	PUBLIC	ASP_LPHFV
	PUBLIC	ASP_LPHCAV
	PUBLIC	ASP_LPHPAV
	PUBLIC	ASP_LPHCNT
	PUBLIC	PRSC_IN_PROGRESS
	PUBLIC	TICVAL
	ORG	0

BIOS_START:
	JMP	BIOS_INIT

;*	PBE_xxxx - Phony Bios Entry
;
;	These entry points are phony entries used simply to maintain
;	compatability with Z-DOS 1.25 programs, and to give extended
;	capabilities to Z-DOS programs like FORMAT and DSKCOPY
;

	EXTRN	PBE_STATUS:NEAR,PBE_CONIN:NEAR,PBE_CONOUT:NEAR
	EXTRN	PBE_PRINT:NEAR,PBE_AUXIN:NEAR,PBE_AUXOUT:NEAR
	EXTRN	PBE_READ:NEAR,PBE_WRITE:NEAR,PBE_DSKCHG:NEAR
	EXTRN	PBE_SETDATE:NEAR,PBE_SETTIME:NEAR,PBE_GETDATE:NEAR
	EXTRN	PBE_FLUSH:NEAR,PBE_MAPDEV:NEAR

	JMP	PBE_STATUS		; Console status
	JMP	PBE_CONIN		; Console input
	JMP	PBE_CONOUT		; Console output
	JMP	PBE_PRINT		; Printer output
	JMP	PBE_AUXIN		; AUX device input
	JMP	PBE_AUXOUT		; AUX device output
	JMP	PBE_READ		; Disk Read Routine
	JMP	PBE_WRITE		; Disk Write Routine
	JMP	PBE_DSKCHG		; Disk change
	JMP	PBE_SETDATE		; Date Set
	JMP	PBE_SETTIME		; Set time
	JMP	PBE_GETDATE		; Get date
	JMP	PBE_FLUSH		; Console flush
	JMP	PBE_MAPDEV		; Map device

	ORG	045H			; Reserved for other unused entries

	JMP	BIOS_INTFUNC		; INT functions
	JMP	BIOS_DSKFUNC		; Disk functions
	JMP	BIOS_PRNFUNC		; PRN functions
	JMP	BIOS_AUXFUNC		; AUX functions
	JMP	BIOS_CONFUNC		; CON functions

	ORG	060H

	DB	BIOS_CREL		; Release of the BIOS(010H for 1.0x)
	DW	OFFSET CONFG_INFO	; Addr of configuation info
	DB	BIOS_CVER		; Version of BIOS

	PAGE
;
; Fake up some interrupt service routines for now
;    (let them fall through to WILD INTERRUPT)
;

ISR_SLV:				; Slave
ISR_PP:					; Parallel

ISR_SLV0:				; Source 0 on Slave 
ISR_SLV1:				; Source 1 on Slave 
ISR_SLV2:				; Source 2 on Slave 
ISR_SLV3:				; Source 3 on Slave 
ISR_SLV4:				; Source 4 on Slave 
ISR_SLV5:				; Source 5 on Slave 
ISR_SLV6:				; Source 6 on Slave 
ISR_SLV7:				; Source 7 on Slave 


;
; Wild Interrupt trap
;    (You get here if you do an interrupt which hasn't been
;      changed from init time)

ISR_WILD:
	INC	WORD PTR CS:RECURLV ; Bump level, first time through ?
	JNZ	INT_TR1		;   No, skip
	MOV	CS:SAVESS,SS	;   Yes, save old stack
	MOV	CS:SAVESP,SP
	PUSH	CS		; Set up local stack
	POP	SS
	MOV	SP,OFFSET BIOS_STACK
INT_TR1:
	STI			; Turn interrupts back on
	PUSH	DS		; Save some regs
	PUSH	AX
	PUSH	CX
	PUSH	BX
	PUSH	CS		; Set up DS
	POP	DS
	MOV	BX,OFFSET IMESG	; Get addr of message
	MOV	CH,OFFSET IMESGL ; Get length of message
	CALL	PMESG		; Print message
	POP	BX		; Restore the regs
	POP	CX
	POP	AX
	POP	DS
	CLI			; Turn interrupts off (for a bit)
	DEC	WORD PTR CS:RECURLV ; Decr recursion level, at bottom yet ?
	JNS	INT_TR2		;   No, skip
	MOV	SS,CS:SAVESS	;   Yes, restore stack
	MOV	SP,CS:SAVESP
INT_TR2:
	IRET			; Return

IMESG	DB	CC_CR,CC_LF,CC_LF
	DB	'WILD INTERRUPT'
	DB	CC_CR,CC_LF,CC_LF
IMESGL	=	(OFFSET $)-(OFFSET IMESG)

	PAGE
;
; Fatal Error - Memory Parity or S-100 buss error
;

ISR_EI:
	MOV	CS:SAVESP1,SP	; Save SP(in special place)
	INC	WORD PTR CS:RECURLV ; Bump level, first time through ?
	JNZ	INT_EI1		;   No, skip
	MOV	CS:SAVESS,SS	;   Yes, save old stack
	MOV	CS:SAVESP,SP
	MOV	SP,CS		; Set up local stack
	MOV	SS,SP
	MOV	SP,OFFSET BIOS_STACK
INT_EI1:
	MOV	CS:SAVEAX,AX	; Save Regs
	MOV	CS:SAVEDS,DS
	PUSH	CS		; Set up DS
	POP	DS

	MOV	AL,BYTE PTR BIOS_MCL ; Get memory control latch value
	AND	AL,NOT ZMCLPK	; Turn off parity checking
	OUT	ZMCL,AL

; Save registers on stack

	PUSH	BP
	PUSH	SI
	PUSH	DI
	PUSH	DX
	PUSH	CX
	PUSH	BX
	PUSH	SAVEAX
	PUSH	SAVESP1
	PUSH	SAVESS	
	PUSH	ES
	PUSH	SAVEDS
	MOV	BX,SAVESP1
	MOV	DS,SAVESS
	PUSH	2[BX]		; CS
	PUSH	0[BX]		; IP
	PUSH	4[BX]		; Flags

	MOV	AX,CS		; Set up DS and ES
	MOV	DS,AX
	MOV	ES,AX

; For each register on stack, store it's hex value in print buffer

	MOV	BP,SP		; Get base of values
	MOV	DI,OFFSET EIMESG1+3 ; Get address to store value
	MOV	CX,14		; Get number of registers
EILOOP:
	MOV	AL,BYTE PTR 1[BP] ; Get high byte of register
	CALL	EIDBYTE		; Store that byte
	MOV	AL,BYTE PTR 0[BP] ; Get low byte of register
	CALL	EIDBYTE		; Store that byte
	ADD	BP,2		; Point to next register
	ADD	DI,6		; Point to next place to store string
	LOOP	EILOOP		; Do it again

; Print message

	CALL	FAR PTR MTR_TTY_INTR ; Force scroll
	MOV	BX,OFFSET EIMESG ; Get addr of message
	MOV	CH,OFFSET EIMESGL ; Get length of message
	CALL	PMESG		; Print message
	CALL	FAR PTR MTR_TTY_INTR ; Force scroll

; Restore registers

	POP	BP		; Flags
	POP	BP		; IP
	POP	BP		; CS
	POP	BP		; DS
	POP	ES
	POP	BP		; SS
	POP	BP		; SP
	POP	AX
	POP	BX
	POP	CX
	POP	DX
	POP	DI
	POP	SI
	POP	BP

; Restore stack

	CLI			; Turn interrupts off (for a bit)
	DEC	WORD PTR RECURLV ; Decr recursion level, at bottom yet ?
	JNS	INT_EI2		;   No, skip
	MOV	SS,SAVESS	;   Yes, restore stack
	MOV	SP,SAVESP

;	NOTE: Users can patch out following JMP and allow
;	 parity errors to return to O/S

INT_EI2:
	JMP	INT_EI2		; Loop forever

	MOV	AH,BYTE PTR BIOS_EDCNT ; Get down counter
	OR	AH,AH		; Is it down to zero ?
	JZ	INT_EI3		;   Yes, skip
	DEC	AH		; Bump it down
	MOV	BYTE PTR BIOS_EDCNT,AH ; Store new value
	JMP	INT_EI4		; Skip
INT_EI3:
	MOV	AL,BYTE PTR BIOS_MCL ; Get memory control latch value
	AND	AL,NOT ZMCLPK	; Turn off memory parity checking
	MOV	BYTE PTR BIOS_MCL,AL ; Store new value
INT_EI4:
	MOV	AL,OCW2OP+OCW2EOI ; Tell 8259A that interrupt serviced
	OUT	ZM8259A+OCW2,AL

	MOV	AL,BYTE PTR BIOS_MCL ; Get memory control latch value
	OUT	ZMCL,AL		; Set value

	MOV	AX,CS:SAVEAX	; Restore regs
	MOV	DS,CS:SAVEDS
	IRET			;  and return

;
; EIDBYTE - Hex display routines
;
;     Call with:
;         AL = value
;         ES:DI -> place to store string
;
;     Returns:
;         DI - updated
;
;     Uses: AL, AH
;

EIDBYTE	PROC NEAR
	DB	0D4H,010H	; Separate hex digits in AH, AL
	XCHG	AL,AH		; Change order for STOSB
	ADD	AL,090H		; "Trick" procedure to convert to ASCII
	DAA	
	ADC	AL,040H
	DAA
	STOSB
	MOV	AL,AH
	ADD	AL,090H
	DAA
	ADC	AL,040H
	DAA
	STOSB
	RET
EIDBYTE	ENDP

SAVESP1	DW	?
SAVEDS	DW	?
SAVEAX	DW	?


EIMESG	DB	CC_CR,CC_LF
	DB	'ERROR - MEMORY PARITY OR BUSS'
	DB	CC_CR,CC_LF,CC_LF
EIMESG1	DB	"F =0000   IP=0000   CS=0000   DS=0000   "
	DB	"ES=0000   SS=0000   SP=0000"
	DB	CC_CR,CC_CR,CC_LF
	DB	"AX=0000   BX=0000   CX=0000   DX=0000   "
	DB	"DI=0000   SI=0000   BP=0000"
	DB	CC_CR,CC_LF,CC_LF
	DB	"SYSTEM HALT"
	DB	CC_CR,CC_LF
EIMESGL	=	(OFFSET $)-(OFFSET EIMESG)


	PAGE
;
;  PMESG - Print a message on the console
;
;  Call with:
;      BX -> message to print
;      CH =  length of message
;
;  Uses: AX, BX, CX
;
;  Assumes: 
;      1) Stack is large enough
;      2) String doesn't cause ROM to change video control latch
;

PMESG	PROC	NEAR
	PUSH	DX		; Save regs
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	ES

PMESGLP:
	MOV	AL,[BX]		; Get next character

	PUSH	AX		; Save regs
	PUSH	BX
	PUSH	CX
	PUSH	DS
	CALL	MTR_SCRT	; Have ROM monitor display char
	POP	DS		; Restore regs
	POP	CX
	POP	BX
	POP	AX

	INC	BX		; Bump char pointer
	DEC	CH		; Decr remaining characters, Finished ?
	JNZ	PMESGLP		;   No, keep going

	POP	ES		; Restore regs
	POP	BP
	POP	DI
	POP	SI
	POP	DX

	RET 			;   and return
PMESG	ENDP

	PAGE

; Recursion variables and stack(so BIOS can call itself)

RECURLV		DW	-1	; Recursion level
SAVESS		DW	?	; Save area for SS
SAVESP		DW	?	; Save area for SP

; Memory information(Must be together)

BIOS_MCL 	DB	ZSM0+ZRM2+ZMCLPZ+ZMCLPK	; Map 0 with ROM at top
				; parity gen and checking enabled

BIOS_EDCNT	DB	0	; Error down counter


; Date and time information (must be together)

BIOS_DATE	DW BIOS_IDATE	; Days since 1980
BIOS_HRS	DB 8		; Hours since midnite
BIOS_MIN	DB 0		; Minutes
BIOS_SEC	DB 0		; Seconds
BIOS_HSEC	DW 0		; Hundredths of secs(must be word)

; Configuration vector
;
; The DW 0 following commented out entries are place holders
;  for the entries not yet defined
;

CONFG_INFO:
	DW	OFFSET DSK_TPTR	; Addr of disk table vector
	DW	OFFSET CHRD_PRN	; Addr of PRN: configuration table
	DW	OFFSET CHRD_AUX ; Addr of AUX: configuration table
	DW	OFFSET CHRD_CON	; Addr of CON: configuration table
	DW	OFFSET FNT_INFO	; Addr of FONT information
	DW	OFFSET BIOS_DATE ; Addr of date and time fields
	DW	OFFSET BIOS_DEVS ; Addr of DOS disk table
	DW	OFFSET BIOS_MCL ; Addr of Memory control info
	DW	OFFSET BIOS_ASP	; Aspect ratio information
	DW	OFFSET CQ_ZCON	; Console que pointer
	DW	OFFSET CQ_ZSERA	; Serial A que pointer
	DW	OFFSET CQ_ZSERB	; Serial B que pointer
	DW	OFFSET EVN_FLG	; Event flag
	DW	OFFSET TICVAL	; 16BIT tic counter
	DW	OFFSET ASNFL2	; Drive assignment table
	DW	-1

;	BIOS aspect and light pen information

BIOS_ASP	LABEL	NEAR
		DB	ASP_X			; X aspect value
		DB	ASP_Y			; Y aspect value
ASP_LPEFV	DW	5			; Light pen error factor
ASP_LPHFV	DB	0			; Light pen hit flag
ASP_LPHCAV	DW	0			; Character of hit
ASP_LPHPAV	DB	0			; Pixel of hit
ASP_LPHCNT	DB	0			; =0 if pen is up
PRSC_IN_PROGRESS DB	0			; !=0 if prsc in progress
EVN_FLG		DW	0			; Event flag
TICVAL		DW	0			; 16bit tic counter
GWBASIC		DB	0			; != 0 if GWBASIC in ram

;*	ISR_EVN - Event intertupt
;
;	ISR_EVN is a service routine for the INT_EVNA interrupt.
;
;	It returns AX as the event flag, and resets the event flag
;	to zero.
;

ISR_EVN:
	MOV	AX,CS:WORD PTR EVN_FLG		; Event flag
	MOV	CS:WORD PTR EVN_FLG,0		; Reset it
	IRET

BIOS_SEG ENDS


	END

