;	Keymap -- map function keys to user defined characters
;
;	This program maps the various function keys to user
;	defined character sequences.  The sequence for any
;	one key can be up to 20 characters.
;
;	This version is for CP/M + on the H/Z computers
;
;	BY W.M. Adney 08-31-85
;	COPYRiGHT (C) 1985 BY W. M. Adney

;	Modified by W.M. Adney to include additional keys: 6-1-85
;	Modification Notes
;	1. This program must be assembled before KEYCON & KEYUNmap
;	   because addresses must be obtained from this PRN list
;	   for the KEYCON/UNmap programs.
;	2. All addresses required for the KEYCON program are indicated
;	   by the literal KEYCON in the comments. Addresses required
;	   for KEYUNmap are indicated by UNmap in the comments.
;	3. New and modified code is indicated by my initials - WMA
;	4. Major enhancements to Pat's code include:
;		a. Expansion of code from 41 keys to 56 keys for
;		keypad.
;		b. Keypad default is to alternate mode to allow
;		addition of 13 keys (0-9, ".", "-", and ENTER.
;		Indexing scheme required addition of dummy ESC ?o
;		to maintain. Reset to normal mode by KEYUNmap.
;		c. Added BREAK key to program for mapping.
;		d. Main keyboard can be mapped for following keys:
;			F0-F12, ICHR/DCHR, ILINE/DLINE, HELP, BREAK
;		   17 keys can be mapped in 4 modes:
;		   	Unshifted, shifted, alternate unshifted, alt shifted
;			for a total of 68 commands.
;		e. Keypad (all 18 keys) can be mapped in 2 modes:
;			unshifted, alternate unshifted.
;			One key reserved (normally HOME) for alt key
;			for a total of 35 commands [17 x 2 + 1 (Home)]
;	5. Hard code the SF1 key for ^Q DEL for Wordstar.
;	6. Add special processing for BACKSPACE, LINEFEED, DELETE keys.


;*******************************
;	Definitions
;*******************************


bios	equ	0		;bios jump vector
cr	equ	0dh
lf	equ	0ah
esc	equ	1bh		; escape sequence
constat	equ	11		; get console status function
dconio	equ	06h	; direct console i/o function
;***************************************************************
;
;		RSX Prefix Structure
;
;***************************************************************

	db	0,0,0,0,0,0		; room for serial number
	jmp	ftest			; beginning of program
next	db	0c3h			; jump
        dw	0			; next module in line
prev:	dw	0			; previous module
;	The remove flag indicates that the CCP can remove any RSX's
;	from memory after a system warm start. Since this RSX will
;	perform key mapping with WordStar, we don't want the RSX
;	removed since a new disk may be logged and WS will
;	perform a warm start for the new disk. Flag is normally
;	set to 0FFh to indicate removal...we will set to 0h so
;	that CCP will not remove key may from memory.
remov:	db	0h			; remove flag not set
nonbnk:	db	0			; 0 indicates banked system
					; change to 0ffh for non-banked
pname:	db	'KEYMAP  '		; name of this program
loader:	db	0			; reserve space for loader flag
	db	0,0			; reserved space for RSX

;********************************************************
;							*
;	Check function for intercept     		*
;							*
;********************************************************

ftest:					; is this function 1? (CONIN)
	mov 	a,c 
	cpi 	1 
	jz 	begin			; yes - intercept
        jmp 	next			; some other function 

begin:					; Start the intercept code
	lxi 	h,0	
	dad 	sp 			;save stack
	shld 	ret$stack
	lxi 	sp,loc$stack

;************************************************
;	Special console input routine for mapping
;************************************************

;MYCONIN:lda	mapflg
;	ora	a		;are we mapping?
;	jnz	MAP		;yes, return mapped character
NMAP:	call	cconin		;get character
	cpi	esc		; is it escape character?
ESCCHR	equ	$-1
	jz	gotesc		; Yes, check it - otherwise exit

endit: 	lhld 	ret$stack 		; restore user stack
	sphl
	lxi 	h,0031h			; return SCB ??
	ret

;************************************************
;	Special console status routine for mapping
;************************************************

MYCONST:lda	mapflg
	ora	a		;are we mapping
	jnz	MAPST		;yes
cconst:
	mvi	c,constat	; check console status	
	call 	next
	cpi	01h		; is console ready?
	jnz	cconst		; no, check again
MAPST:	lhld	mapptr		;get map character pointer
	mov	a,m		;get next character
	ora	a		;done mapping?
	jz	CKRST		;yes, check regular status
	mvi	a,0FFh		;else, return char ready
	jmp	endit		; and exit this rsx
CKRST:	sta	mapflg		;clear map flag
	jmp	cconst		;check status

;************************************************
;	Escape char found -- Is it part of a mapped sequence?
;************************************************

GOTESC:	mvi	c,50		;Try for esc-ch 50 times
ESCLP:	call	cconst		;check console status
	ora	a
	jnz	GOTCHR		;got a character
	dcr	c		;else, decrement counter
	jnz	ESCLP		;try again
	xra	a
	sta	asflg		;clear alternate sel. flag
	mvi	a,esc
	ret			;return with esc

;************************************************
;	Looks ok - verify that it's a function key
;************************************************

GOTCHR:	call	cconin		;get next character
	lxi	h,HELPKEY	;assume help
	cpi	'~'		;is it help?
	jz	MHELP
;
;	Break key added here
;
	lxi	h,BRKKEY 	;assume break - WMA
	cpi	'|'		;is it break? - WMA
	jz	MBRK		; WMA
;
	lxi	h,MAPTBL1	;assume F9-F12
	cpi	'0'		;is it?
	jz	MAPT1		;yes
	lxi	h,MAPTBL2	;assume shift-F keys
	cpi	'1'		;is it?
	jz	MAPT2		;yes
;
;	Special code for alternate keypad mode added here
;
	lxi	h,KEYPAD	;assume alt keypad keys - WMA
	cpi	'?'		;is it? - WMA
	jz	KEYP		;yes - WMA
;
	lxi	h,MAPTBL	;else, use regular table
	cpi	'@'		;"@" or more?
	jc	SPMAP		;no
	cpi	'W'+1		;"W" or less?
	jnc	SPMAP		;no
	jmp	GDCHR		;else, good character
MHELP:	
	sui	'~'-'@'		;fix reg a (Help key) for index into table
	jmp	NOAS

;	Add index for BREAK key

MBRK:
 	sui	'|'-'@'		;fix reg a (BreAk key) for table - WMA
	jmp	NOAS		; WMA

MAPT1:	push	h
	call	cconin		;get next character
	pop	h
	sui	'I'-'@'		;fix a
	jmp	NOAS
MAPT2:	push	h
	call	cconin		;get next character
	pop	h
	sui	1		;fix al to del 1??? Adney
MAPT3:	jmp	NOAS		;and process key
;
;	Special code to handle keypad and ENTER key

KEYP:
	push	h		;WMA
	call	cconin		;get next character - WMA
	pop	h
	cpi	'M'		;is it enter key?
	jnz	KEYE		;no, it's another keypad key
	lxi 	h,ENTKEY	; WMA
	sui	'M'-'@'		; WMA
	jmp	NOAS
KEYE:
	sui	'm'-'@'		;fix reg a to del ? - WMAA
	jmp	NOAS		; WMA
;
GDCHR:	push	h
	lxi	h,asflg
	inr	m
	dcr	m		;Working on alternate key?
	pop	h
	jnz	NOAS		;if so, skip shift check
	cpi	0		;is this the alternate sel. key?
ASKEY	equ	$-1		; -KEYCON
	jnz	NOAS		;no
	push	h
	lxi	h,asflg
	inr	m		;else, set alternate sel. flag
	pop	h
	call	cconin		;get second key
	cpi	esc		;escape?
	jz	gotesc		;it's escape, get next character
	push	h
	lxi	h,asflg
	dcr	m		;else, clear alternate sel. flag
	pop	h
	ret	

;************************************************
;	It's a valid function key -- turn mapping on
;************************************************

NOAS:	push	h
	lxi	h,mapflg
	inr	m		;set map flag
	pop	h
	sui	'@'		;remove ascii from character
	add	a		;double it
	add	l		;add result to hl
	mov	l,a
	mov	a,h
	aci	0
	mov	h,a		;hl points to table entry
	mov	a,m		;get it
	inx	h
	mov	h,m
	mov	l,a		;hl points to map string
	lda	asflg
	ora	a		;alternate function?
	jz	NOAS1		;no
	mvi	d,LTBL shr 8
	mvi	e,LTBL and 0FFh	;else, use second shift table entry
	dad	d
	xra	a
	sta	asflg		;clear alternate flag
NOAS1:	shld	mapptr		;Set up map pointer

;*******************************************************************
;	mapping routine -- Sends a character from the user supplied
;	string as long as the system requests keyboard input, until
;	the end of the string is reached.  Then normal input is
;	resumed
;*******************************************************************

MAP:	lhld	mapptr		;get map pointer
	mov	a,m		;get mapped character
	sta	SAVCHR		;Save character
	inx	h
	mov	a,m		;Preview next character
	ora	a		;end of string?
	jnz	NOTEND		;no
	sta	mapflg		;else, clear map flag
NOTEND:	mvi	a,0		;get character
SAVCHR	equ	$-1
	shld	mapptr		;Update map pointer
	ret			;return with mapped character


;************************************************************************
;	map non-definded escape sequences
;	to preserve them intact
;************************************************************************

SPMAP:	sta	spchar		;insert character in buffer
	lxi	h,mapflg
	inr	m		;turn on mapping
	lxi	h,spchar
	shld	mapptr		;Set up map pointer
	mvi	a,esc		;return with esc. character
	ret	

;************************************************************************
;	Console read subroutine for mapping
;************************************************************************
cconin:
	mvi	c,dconio	; direct i/o
	lxi	e,0fdh		; load input function
	call	next		; call bdos
	ret

;************************************************************************
;	Console write subroutine for mapping
;************************************************************************

ccnout:
	mvi	c,dconio	; direct i/o
	lxi	e,m		; load character for console output
	call	next		; call bdos
	ret

;********************************************************
;	Basic table of mapped sequences
;	Mod note - this table must contain the exact
;	number of keys for counter in this program.
;	Current number is 56...
;********************************************************

MAPTBL	dw	IC		; -KEYCON
	dw	UP
	dw	DN
	dw	FWD
	dw	BK
	dw	SF0
	dw	ESCF	; This maintains continuity in the index
	dw	ESCG	; scheme and is required according to Pat
	dw	HOME
	dw	ESCI	; Another dummy
	dw	F0
	dw	ESCK	; Dummy
	dw	IL
	dw	DLX
	dw	DC
	dw	ESCO	; Dummy
	dw	F6
	dw	F7
	dw	F8
	dw	F1
	dw	F2
	dw	F3
	dw	F4
	dw	F5
MAPTBL1	dw	F9
	dw	F10
	dw	F11
	dw	F12
MAPTBL2	dw	SF1
	dw	SF2
	dw	SF3
	dw	SF4
	dw	SF5
	dw	SF6
	dw	SF7
	dw	SF8
	dw	SF9
	dw	SF10
	dw	SF11
	dw	SF12
HELPKEY	dw	HELP
BRKKEY	dw	BREAK		; WMA - note dummy ESCOH required to
KEYPAD	dw	KEYDAS		; WMA -   maintain index
	dw	KEYDOT		; WMA
	dw	ESCOH		; fOR ESC ? o - not used
	dw	KEY0		; WMA
	dw	KEY1		; WMA
	dw	KEY2		; WMA
	dw	KEY3		; WMA
	dw	KEY4		; WMA
	dw	KEY5		; WMA
	dw	KEY6		; WMA
	dw	KEY7		; WMA
	dw	KEY8		; WMA
	dw	KEY9		; WMA
ENTKEY	dw	KEYENT		; WMA

;****************************************
;	mapped character sequences
;****************************************

F0	db	esc,'J',0	; -KEYCON
	ds	18
F1	db	esc,'S',0
	ds	18
F2	db	esc,'T',0
	ds	18
F3	db	esc,'U',0
	ds	18
F4	db	esc,'V',0
	ds	18
F5	db	esc,'W',0
	ds	18
F6	db	esc,'P',0
	ds	18
F7	db	esc,'Q',0
	ds	18
F8	db	esc,'R',0
	ds	18
F9	db	esc,'0I',0
	ds	17
F10	db	esc,'0J',0
	ds	17
F11	db	esc,'0K',0
	ds	17
F12	db	esc,'0L',0
	ds	17
SF0	db	esc,'E',0
	ds	18
SF1	db	11h,7Fh,0	;^Q DEL FOR ShIFT F1
	ds	18
SF2	db	esc,'1B',0
	ds	17
SF3	db	esc,'1C',0
	ds	17
SF4	db	esc,'1D',0
	ds	17
SF5	db	esc,'1E',0
	ds	17
SF6	db	esc,'1F',0
	ds	17
SF7	db	esc,'1G',0
	ds	17
SF8	db	esc,'1H',0
	ds	17
SF9	db	esc,'1I',0
	ds	17
SF10	db	esc,'1J',0
	ds	17
SF11	db	esc,'1K',0
	ds	17
SF12	db	esc,'1L',0
	ds	17
IC	db	esc,'@',0
	ds	18
DC	db	esc,'N',0
	ds	18
IL	db	esc,'L',0
	ds	18
DLX	db	esc,'M',0
	ds	18
HOME	db	esc,'H',0
	ds	18
BK	db	esc,'D',0
	ds	18
FWD	db	esc,'C',0
	ds	18
UP	db	esc,'A',0
	ds	18
DN	db	esc,'B',0
	ds	18
HELP	db	esc,'~',0 
	ds	18 
BREAK	db	esc,'|',0	; WMA
	ds	18		; WMA
KEYDAS	db	esc,'?m',0	; WMA
	ds	17		; WMA
KEYDOT	db	esc,'?n',0	; WMA
	ds	17		; WMA
KEY0	db	esc,'?p',0	; WMA
	ds	17		; WMA
KEY1	db	esc,'?q',0	; WMA
	ds	17		; WMA
KEY2	db	esc,'?r',0	; WMA
	ds	17		; WMA
KEY3	db	esc,'?s',0	; WMA
	ds	17		; WMA
KEY4	db	esc,'?t',0	; WMA
	ds	17		; WMA
KEY5	db	esc,'?u',0	; WMA
	ds	17		; WMA
KEY6	db	esc,'?v',0	; WMA
	ds	17		; WMA
KEY7	db	esc,'?w',0	; WMA
	ds	17		; WMA
KEY8	db	esc,'?x',0	; WMA
	ds	17		; WMA
KEY9	db	esc,'?y',0	; WMA
	ds	17		; WMA
KEYENT	db	esc,'?M',0	; WMA
	ds	17		; WMA
;BACKSP	db	7Fh,0		; WMA - Backspace key - Normal is 08H
;	ds	19		; WMA - Remap to DEL (7Fh) function
;LINEF	db	14h,0		; WMA - Linefeed key - Normal is 0AH
;	ds	19		; WMA - Remap to WS word delete (^T - 14h)
;DELETE	db	07h,0		; WMA - Delete key - Normal is 7Fh
;	ds	19		; WMA - Remap to WS char delete (^G - 07h)
ESCF	db	esc,'F',0
ESCG	db	esc,'G',0
ESCI	db	esc,'I',0
ESCK	db	esc,'K',0
ESCO	db	esc,'O',0
ESCOH	db	esc,'?o',0	; Dummy sequence

;****************************************
;	alternate mapped character sequences
;****************************************

F0S	db	esc,'J',0	; -KEYCON
LTBL	equ	F0S-F0
	ds	18
F1S	db	esc,'S',0
	ds	18
F2S	db	esc,'T',0
	ds	18
F3S	db	esc,'U',0
	ds	18
F4S	db	esc,'V',0
	ds	18
F5S	db	esc,'W',0
	ds	18
F6S	db	esc,'P',0
	ds	18
F7S	db	esc,'Q',0
	ds	18
F8S	db	esc,'R',0
	ds	18
F9S	db	esc,'0I',0
	ds	17
F10S	db	esc,'0J',0
	ds	17
F11S	db	esc,'0K',0
	ds	17
F12S	db	esc,'0L',0
	ds	17
SF0S	db	esc,'E',0
	ds	18
SF1S	db	esc,'1A',0
	ds	17
SF2S	db	esc,'1B',0
	ds	17
SF3S	db	esc,'1C',0
	ds	17
SF4S	db	esc,'1D',0
	ds	17
SF5S	db	esc,'1E',0
	ds	17
SF6S	db	esc,'1F',0
	ds	17
SF7S	db	esc,'1G',0
	ds	17
SF8S	db	esc,'1H',0
	ds	17
SF9S	db	esc,'1I',0
	ds	17
SF10S	db	esc,'1J',0
	ds	17
SF11S	db	esc,'1K',0
	ds	17
SF12S	db	esc,'1L',0
	ds	17
ICS	db	esc,'@',0
	ds	18
DCS	db	esc,'N',0
	ds	18
ILS	db	esc,'L',0
	ds	18
DLS	db	esc,'M',0
	ds	18
HOMES	db	esc,'H',0
	ds	18
BKS	db	esc,'D',0
	ds	18
FWDS	db	esc,'C',0
	ds	18
UPS	db	esc,'A',0
	ds	18
DNS	db	esc,'B',0
	ds	18
HELPS	db	esc,'~',0
	ds	18
BREAKS	db	esc,'|',0	; WMA
	ds	18		; WMA
KEYDASS	db	esc,'?m',0	; WMA
	ds	17		; WMA
KEYDOTS	db	esc,'?n',0	; WMA
	ds	17		; WMA
KEY0S	db	esc,'?p',0	; WMA
	ds	17		; WMA
KEY1S	db	esc,'?q',0	; WMA
	ds	17		; WMA
KEY2S	db	esc,'?r',0	; WMA
	ds	17		; WMA
KEY3S	db	esc,'?s',0	; WMA
	ds	17		; WMA
KEY4S	db	esc,'?t',0	; WMA
	ds	17		; WMA
KEY5S	db	esc,'?u',0	; WMA
	ds	17		; WMA
KEY6S	db	esc,'?v',0	; WMA
	ds	17		; WMA
KEY7S	db	esc,'?w',0	; WMA
	ds	17		; WMA
KEY8S	db	esc,'?x',0	; WMA
	ds	17		; WMA
KEY9S	db	esc,'?y',0	; WMA
	ds	17		; WMA
KEYENTS	db	esc,'?M',0	; WMA
	ds	17		; WMA
;BACKSPS	db	7Fh,0		; WMA - Backspace key - Normal is 08h
;	ds	19		; WMA - Remap to DEL (7Fh) function
;LINEFS	db	14h,0		; WMA - Linefeed key - Normal is 0Ah
;	ds	19		; WMA - Remap to WS word delete (^T - 14h)
;DELETES	db	07h,0		; WMA - Delete key - Normal is 7Fh
;	ds	19		; WMA - Remap to WS char delete (^G - 07h)
ESCFS	db	esc,'F',0
ESCGS	db	esc,'G',0
ESCIS	db	esc,'I',0
ESCKS	db	esc,'K',0
ESCOS	db	esc,'O',0
ESCOHS	db	esc,'?o',0	; Dummy sequence
;

;****************************************
;	Other data
;****************************************

spchar	db	0,0		;special char for undef. seq.

mapflg	db	0		;mapping in progress flag
mapptr	dw	0		;mapped character pointer
asflg	db	0		;alternate select flag
ret$stack:	
	dw	0
	ds	32			; 16 level stack
loc$stack:
	end
