;	KEYCON - CONFIGURATION PROGRAM FOR KEYMAP (CP/M-85)
;
;	THIS PROGRAM CONFIGURES THE KEYMAP PROGRAM, ALLOWING THE
;	USER TO INSERT HIS/HER DESIRED OUTPUTS FOR EACH MAPPED KEY.
;
;	BY P. SWAYNE, HUG  26-FEB-85
;	COPYRIGHT (C) 1985 BY HEATH USERS' GROUP

;	DEFINITIONS

BDOS	EQU	5		;BDOS VECTOR
CONOUT	EQU	2		;CONSOLE OUTPUT
LSTOUT	EQU	5		;LST OUTPUT
DCIO	EQU	6		;DIRECT CONSOLE I/O
TYPEF	EQU	9		;TYPE STRING
LINPUT	EQU	10		;LINE INPUT
OPENF	EQU	15		;OPEN FILE
CLOSEF	EQU	16		;CLOSE FILE
DELETF	EQU	19		;DELETE FILE
READF	EQU	20		;READ FILE (SEQUENTIAL)
WRITEF	EQU	21		;WRITE FILE (SEQ)
MAKEF	EQU	22		;MAKE FILE
SETDMA	EQU	26		;SET DMA ADDRESS

	ORG	100H
;	START BY GETTING NAME OF KEYMAP FILE TO WORK ON

CONFIG:	LXI	H,0
	DAD	SP		;LOCATE STACK
	SHLD	OLDSP		;SAVE IT
	LXI	SP,STACK	;SET STACK
	LXI	D,CONMSG	;PRINT CONFIG MESSAGE
	CALL	PMSG
	MVI	A,14		;ALLOW 14 CHARACTERS
	CALL	RDCON		;READ FILE NAME
	JZ	EXIT		;GUESS HE DON'T WANT TO DO IT

;	READ IN THE KEYMAP FILE

GOTNAM:	LXI	H,CFCB		;POINT TO INPUT FILE FCB
	MVI	M,0		;CLEAR DRIVE CODE
	PUSH	H		;SAVE FCB ADDRESS
	INX	H		;MOVE TO NAME AREA
	MVI	B,8
CLFCB:	MVI	M,' '		;CLEAR FCB
	INX	H
	DCR	B
	JNZ	CLFCB
	MVI	M,'C'		;DEFAULT EXTENSION IS "COM"
	INX	H
	MVI	M,'O'
	INX	H
	MVI	M,'M'
	MVI	B,33-12		;SET A COUNTER
CLFCB1:	INX	H		;ZERO REST OF FCB
	MVI	M,0
	DCR	B
	JNZ	CLFCB1
	XCHG			;HL = NAME ADDRESS
	POP	D		;GET FCB
	PUSH	D		;SAVE AGAIN
	INX	H		;SKIP TO POSSIBLE ":"
	MOV	A,M
	CPI	':'		;ONE THERE?
	JNZ	NOCOL		;NO
	DCX	H		;ELSE BACK UP TO DRIVE
	MOV	A,M		;GET IT
	CALL	MCU		;CAPITALIZE
	SUI	'@'		;REMOVE ASCII
	STAX	D		;PUT IT IN FCB
	INX	H		;SKIP TO NAME
	INX	H
	INX	H		;CANCEL NEXT DCX
NOCOL:	DCX	H		;BACK UP TO NAME START
	INX	D		;POINT TO FCB NAME AREA
INFIL1:	MOV	A,M		;MOVE NAME TO FCB
	ORA	A		;END?
	JNZ	INFIL1A
	POP	D
	JMP	GOTNAM1		;GOT ALL THERE IS
INFIL1A:CPI	'.'		;EXTENSION?
	JZ	INFIL2
	CALL	MCU		;MAP TO UPPER CASE
	STAX	D		;STORE CHARACTER
	INX	D
	INX	H
	JMP	INFIL1
INFIL2:	INX	H		;SKIP PERIOD
	POP	D		;GET FCB ADDRESS AGAIN
	XCHG
	LXI	B,9
	DAD	B
	XCHG			;MOVE TO EXTENSION AREA
	MVI	B,3		;SET A COUNTER
INFIL3:	MOV	A,M
	CALL	MCU
	ORA	A
	JZ	INFIL4
	STAX	D
	INX	D
	INX	H
	DCR	B
	JNZ	INFIL3
	JMP	GOTNAM1		;ALL CHARACTERS USED
INFIL4:	MVI	A,' '		;SPACES TO END OF EXT.
	STAX	D
	INX	D
	DCR	B
	JNZ	INFIL4+2

GOTNAM1:LXI	D,CFCB		;POINT TO KEYMAP FILE NAME
	MVI	C,OPENF
	CALL	BDOS		;TRY TO OPEN KEYMAP.COM
	INR	A
	ORA	A
	JNZ	OPENED		;OPENED OK
	LXI	D,OPMSG
	CALL	PMSG		;PRINT "CAN'T FIND KEYMAP"
	JMP	EXIT		;EXIT TO CP/M
OPENED:	LXI	D,CFCB
	LXI	H,CBUF		;PUT FILE HERE
	MVI	B,0		;SET RECORD COUNTER
RDFIL:	PUSH	B		;SAVE COUNT
	XCHG			;DE = ADDRESS
	MVI	C,SETDMA
	CALL	CBDOS		;SET DMA ADDRESS
	XCHG			;DE = FCB
	MVI	C,READF
	CALL	CBDOS		;READ A RECORD
	POP	B		;GET RECORD COUNT
	ORA	A		;OPERATION OK?
	JNZ	RFIL2		;NO, MUST BE END
	PUSH	B
	LXI	B,80H
	DAD	B		;UPDATE ADDRESS
	POP	B
	INR	B		;COUNT THIS RECORD
	JMP	RDFIL		;READ ANOTHER RECORD
RFIL2:	MOV	A,B
	STA	RECSIZ		;SAVE RECORD COUNT

;	ASK FOR STATUS LINE MESSAGE

	LXI	D,BLINEM
	CALL	PMSG		;ASK FOR BOTTOM LINE
	MVI	A,4
	CALL	RDCON		;GET REPLY
	JZ	NOSTLN		;NO STATUS LINE
	LDAX	D
	ANI	5FH		;CAPITALIZE
	CPI	'Y'		;YES?
	JZ	STATLN
NOSTLN:	LXI	H,CBUF+BLMSG
	MVI	M,1AH		;CLEAR STATUS LINE MESSAGE
	JMP	NBLINE		;NO BOTTOM LINE

;	GET STATUS LINE MESSAGE

STATLN:	LXI	D,PRMSG
	CALL	PMSG		;PROMPT FOR ENTRIES
	LXI	H,CBUF+BLMSG
	SHLD	OUTPTR		;SET UP OUTPUT POINTER
	LXI	D,INTRO		;GET INTRO STRING
	MVI	B,9
	CALL	MOVE		;MOVE IT INTO OUTPUT BUFFER
	SHLD	OUTPTR		;UPDATE POINTER
	MVI	C,0		;CLEAR A COUNTER
GELP:	LXI	D,ENMSG
	CALL	PMSG		;PRINT "ENTER"
	MOV	A,C
	CPI	10		;COUNT LESS THAN 10?
	JC	LT10		;YES
	MVI	E,'1'
	CALL	SCOUT		;ELSE PRINT "1"
	MOV	A,C
	SUI	10
LT10:	ADI	'0'		;ADD ASCII TO COUNT
	MOV	E,A
	CALL	SCOUT		;PRINT COUNT
	LXI	D,ENMSG1
	CALL	PMSG		;PRINT COLON PROMPT
	MVI	A,6
	CALL	RDCON		;GET REPLY
	PUSH	PSW		;SAVE FLAGS FROM ENTRY
	LHLD	OUTPTR
	PUSH	D		;SAVE ENTRY ADDRESS
	LXI	D,ISTR
	MVI	B,2
	CALL	MOVE		;INSERT REVERSE VIDEO
	MOV	A,C		;GET THE COUNT
	CPI	10		;UNDER 10?
	JC	LT10A		;YES
	MVI	M,'1'		;ELSE, INSERT A "1"
	INX	H
	SUI	10
LT10A:	ADI	'0'		;ADD ASCII TO COUNT
	MOV	M,A		;PUT IT IN
	INX	H
	LXI	D,ISTR1
	MVI	B,2
	CALL	MOVE		;MOVE IN NORMAL VIDEO
	POP	D		;GET ENTRY ADDRESS
	POP	PSW		;GET FLAGS FROM ENTRY
	JNZ	NOTNUL		;NOT NUL ENTRY
	PUSH	B
	LXI	B,6
	DAD	B		;ELSE, SKIP ENTRY
	POP	B
	JMP	SKIP
NOTNUL:	MVI	B,6
	CALL	MOVE		;MOVE ENTRY INTO BUFFER
SKIP:	SHLD	OUTPTR
	INR	C
	MOV	A,C
	CPI	13		;DONE?
	JNZ	GELP		;IF NOT, LOOP
	LXI	D,OUTRO
	MVI	B,3
	CALL	MOVE		;MOVE IN CLOSING STUFF
	LXI	H,CBUF+BLMSG
PMSGS:	MOV	E,M		;GET CHARACTER
	INX	H		;INCREMENT POINTER
	MOV	A,E
	CPI	1AH		;END OF MESSAGE?
	JZ	MSGEND
	CALL	SCOUT		;ELSE, PRINT CHARACTER
	JMP	PMSGS
MSGEND:	LXI	D,OKM
	CALL	PMSG		;ASK FOR OK
	MVI	A,4
	CALL	RDCON		;GET REPLY
	JZ	OK		;IT'S OK
;	PUSH	D
;	LXI	D,ERAM
;	CALL	PMSG		;ERASE BOTTOM LINE
;	POP	D
	LDAX	D
	ANI	5FH
	CPI	'N'		;NO?
	JZ	STATLN		;NOT OK
OK:	LXI	D,ERAM
	CALL	PMSG		;ERASE BOTTOM LINE MESSAGE

;	ASK FOR ALTERNATE SELECT KEY

NBLINE:	CALL	CRLF
GETFSK:	LXI	D,ASKEYM
	CALL	PMSG		;PRINT "ENTER A.S. KEY"
	MVI	A,10
	CALL	RDCON		;GET REPLY
	MVI	A,0		;ASSUME NO KEY WANTED
	JZ	NGOTFSK		;DIDN'T WANT ONE
	INX	D
	LDAX	D		;GET CHARACTER AFTER ESCAPE
	CPI	'~'		;HELP KEY?
	JZ	GETFSK
	CPI	'0'		;ILLEGAL KEY?
	JZ	GETFSK
	CPI	'1'
	JZ	GETFSK
NGOTFSK:STA	CBUF+ASKEY	;SAVE KEY ENTERED
	ORA	A		;TEST KEY
	JZ	NGOTFS1		;SKIP MARKING OF KEY
	LXI	H,MAPTBL+CBUF	;POINT TO MAP TABLE
	SUI	'@'		;REMOVE ASCII FROM FUNC. KEY
	ADD	A		;DOUBLE IT
	ADD	L		;ADD TO HL
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A		;HL POINTS TO TABLE ENTRY
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A		;HL = MAPPED STRING
	LXI	D,CBUF-256
	DAD	D		;CORRECT FOR LOADED PROGRAM
	MOV	A,M
	ORI	80H		;SET 8TH BIT (MARK A.S. KEY)
	MOV	M,A

;	NOW, ENTER THE KEY RESPONSES THEMSELVES

NGOTFS1:LXI	D,KEYM
	CALL	PMSG		;PRINT "ENTER KEYS"
	LXI	H,KEYS
	SHLD	KEYMPTR		;SET KEY MESSAGE POINTER
	LXI	H,F0+CBUF
	SHLD	RESPTR		;SET RESPONSE POINTER
	MVI	A,36
	STA	COUNT		;SET COUNTER TO 36 KEYS
GETKLP:	CALL	CRLF		;PRINT CRLF
	LHLD	KEYMPTR		;GET KEY MESSAGE POINTER
	CALL	PMSG1		;PRINT PROMPT
	SHLD	KEYMPTR		;UPDATE POINTER
	CALL	OPPAR		;PRINT OPEN PARENTHESES
	LHLD	RESPTR		;GET RESPONSE POINTER
	MOV	A,M		;GET FIRST CHARACTER
	ADD	A		;SHIFT LEFT
	JNC	GETKLPA		;NOT ALTERNATE RESP. KEY
	RRC			;FIX CHARACTER
	MOV	M,A		;REPLACE IT
	LXI	D,ALRESM
	CALL	PMSG		;SAY "ALTERNATE KEY"
	JMP	GETKLPB
GETKLPA:CALL	PMSG1		;PRINT CURRENT KEY RESPONSE
GETKLPB:CALL	CLPAR		;PRINT CLOSING PARENTHESES
	MVI	A,20		;ALLOW 20 CHARACTERS
	CALL	RDCON		;INPUT RESPONSE
	JZ	NOCHG		;NO CHANGE
	LHLD	RESPTR		;PUT RESPONSE HERE
	MVI	B,21		;MOVE 21 CHARACTERS
	CALL	MOVE
	SHLD	RESPTR		;UPDATE POINTER
	JMP	INRCNT		;INCREMENT COUNT
NOCHG:	LHLD	RESPTR
	LXI	B,21
	DAD	B		;MOVE POINTER
	SHLD	RESPTR
INRCNT:	LDA	COUNT
	DCR	A		;DECREMENT COUNT
	STA	COUNT
	JNZ	GETKLP		;NOT DONE, CONTINUE
	LDA	ASKEY+CBUF	;GET ALTERNATE RESP. KEY
	ORA	A		;WANT ALTERNATE KEYS?
	JZ	ASKPAD		;NO, ASK ABOUT KEYPAD
	LXI	D,ALKEYM
	CALL	PMSG		;PRINT "ENTER FUNCTION KEYS"
	LXI	H,KEYS
	SHLD	KEYMPTR		;SET KEY MESSAGE POINTER
	LXI	H,F0S+CBUF
	SHLD	RESPTR		;SET RESPONSE POINTER
	MVI	A,36
	STA	COUNT		;SET COUNTER
GETKLP1:CALL	CRLF		;PRINT CRLF
	LHLD	KEYMPTR		;GET KEY MESSAGE POINTER
	CALL	PMSG1		;PRINT PROMPT
	SHLD	KEYMPTR		;UPDATE POINTER
	CALL	OPPAR		;PRINT OPEN PARENTHESES
	LHLD	RESPTR		;GET RESPONSE POINTER
	CALL	PMSG1		;PRINT CURRENT KEY RESPONSE
	CALL	CLPAR		;PRINT CLOSING PARENTHESES
	MVI	A,20		;ALLOW 20 CHARACTERS
	CALL	RDCON		;INPUT RESPONSE
	JZ	NOCHG1		;NO CHANGE
	LHLD	RESPTR		;PUT RESPONSE HERE
	MVI	B,21		;MOVE 21 CHARACTERS
	CALL	MOVE
	SHLD	RESPTR		;UPDATE POINTER
	JMP	INRCNT1		;INCREMENT COUNT
NOCHG1:	LHLD	RESPTR
	LXI	B,21
	DAD	B
	SHLD	RESPTR
INRCNT1:LDA	COUNT
	DCR	A		;DECREMENT COUNT
	STA	COUNT
	JNZ	GETKLP1		;NOT DONE, CONTINUE

;	ASK IF SHIFTED KEYPAD WANTED

ASKPAD:	LXI	D,KPADM
	CALL	PMSG		;ASK FOR KEYPAD SHIFT
	MVI	A,4
	CALL	RDCON		;GET ANSWER
	LXI	H,SPADM+CBUF	;POINT TO WORK AREA
	JZ	ZRPAD		;DO NOT SHIFT PAD
	LDAX	D		;GET ANSWER
	ANI	5FH		;CAPITALIZE
	CPI	'Y'		;NO?
	JZ	SHPAD		;NO, SHIFT IT
ZRPAD:	XRA	A
	MOV	M,A		;ZERO SHIFT PAD STRING
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A
	JMP	NSHPAD
SHPAD:	MVI	M,27		;INSERT SHIFT MESSAGE
	INX	H
	MVI	M,'x'
	INX	H
	MVI	M,'6'

;	GET ON/OFF TOGGLE CODE

NSHPAD:	LXI	D,TGLKM
	CALL	PMSG		;ASK FOR TOGGLE CODE
	MVI	A,4
	CALL	RDCON		;GET ANSWER
	MVI	A,'^'-'@'	;ASSUME DEFAULT
	JZ	STGLK		;DEFAULT TOGGLE KEY WANTED
	LDAX	D		;GET ANSWER
	ANI	1FH		;MAKE IT A CONTROL CODE
STGLK:	STA	CBUF+TGLK	;STORE TOGGLE CODE

;	ASK IF BOTTOM LINE TO BE LEFT ON

	LXI	D,LBMSG
	CALL	PMSG		;ASK "WANT BOTTOM LINE LEFT ON?"
	MVI	A,4
	CALL	RDCON		;GET ANSWER
	LXI	H,CBUF+ERABL+3
	JZ	KILLBL		;KILL IT
	LDAX	D
	ANI	5FH
	CPI	'Y'		;YES?
	JNZ	KILLBL		;ELSE KILL BOTTOM LINE
LEAVON:	MVI	M,27		;INSERT MSG TO ENABLE BOTTOM LINE
	INX	H
	MVI	M,'x'
	INX	H
	MVI	M,'1'
	JMP	GOFFLK
KILLBL:	XRA	A
	MOV	M,A		;CLEAR BOTTOM ENABLE MSG
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A

;	GET OFF LINE TOGGLE CODE

GOFFLK:	LXI	D,OFLNKM
	CALL	PMSG		;ASK FOR OFF LINE CODE
	MVI	A,4
	CALL	RDCON		;GET ANSWER
	MVI	A,'\'-'@'	;ASSUME DEFAULT
	JZ	SOFLNK		;DEFAULT OFF LINE KEY WANTED
	LDAX	D		;GET ANSWER
	ANI	1FH		;MAKE IT A CONTROL CODE
SOFLNK:	STA	CBUF+OFFLNK	;STORE OFF LINE CODE

;	NOW, WRITE THE PATCHED KEYMAP TO DISK

WRITE:	CALL	CRLF
	LXI	H,FCBX		;POINT TO FCB AFTER FILE TYPE
	XRA	A		;CLEAR AL
	MVI	B,33-12		;CLEAR THIS MUCH OF FCB
WRTCL:	MOV	M,A
	INX	H
	DCR	B
	JNZ	WRTCL
	LXI	D,CFCB
	MVI	C,DELETF
	CALL	BDOS		;DELETE OLD KEYMAP
	LXI	D,CFCB
	MVI	C,MAKEF
	CALL	BDOS		;MAKE NEW ENTRY
;	LXI	D,CFCB
;	MVI	C,OPENF
;	CALL	BDOS		;OPEN KEYMAP FILE
	LXI	D,CFCB
	LDA	RECSIZ		;GET RECORD COUNT
	MOV	B,A		;IN B
	LXI	H,CBUF		;FILE IS HERE
WRFIL:	PUSH	B		;SAVE COUNT
	XCHG			;DX = ADDRESS
	MVI	C,SETDMA
	CALL	CBDOS		;SET DMA ADDRESS
	XCHG			;DE = FCB
	MVI	C,WRITEF
	CALL	CBDOS		;WRITE A RECORD
	POP	B		;RESTORE COUNT
	ORA	A		;OPERATION OK?
	JNZ	WRABT		;NO, CAN'T WRITE
	PUSH	B
	LXI	B,80H
	DAD	B		;UPDATE ADDRESS
	POP	B
	DCR	B
	JNZ	WRFIL		;WRITE UNTIL DONE
WRABT:	MVI	C,CLOSEF
	LXI	D,CFCB
	CALL	BDOS		;CLOSE FILE
	LXI	D,DONEMSG
	CALL	PMSG		;PRINT "DONE"
EXIT:	LXI	D,80H
	MVI	C,SETDMA
	CALL	BDOS		;SET NORMAL DMA
	LHLD	OLDSP
	SPHL			;SET ORIGINAL STACK
	RET			;RETURN TO CCP

;	SUBROUTINES

;	MESSAGE PRINTERS

CRLF:	LXI	D,CRLFM
	JMP	PMSG
OPPAR:	LXI	D,OPPARM
	JMP	PMSG
CLPAR:	LXI	D,CLPARM
PMSG:	PUSH	B
	MVI	C,TYPEF
	CALL	CBDOS		;PRINT MESSAGE
	POP	B
	RET

;	PRINT MESSAGE AT (HL) UNTIL 0 FOUND.  EXPAND CONTROL
;	CHARACTERS TO "^"+CHAR.

PMSG1:	MOV	A,M		;GET CHARACTER
	INX	H		;INCREMENT POINTER
	ORA	A		;END OF MESSAGE?
	JNZ	PMSG2
	RET			;YES
PMSG2:	CPI	' '		;LESS THAN SPACE?
	JNC	PABLE		;NO, PRINTABLE
	CPI	27		;ESCAPE?
	JNZ	NOTESCP		;NO
	LXI	D,ESCMSG	;ELSE, PRINT "ESC"
	CALL	PMSG
	JMP	PMSG1		;PRINT NEXT CHARACTER
NOTESCP:PUSH	PSW		;ELSE, SAVE CHARACTER
	MVI	E,'^'
	CALL	SCOUT		;PRINT "^"
	POP	PSW		;RESTORE CHARACTER
	ADI	'@'		;ADD ASCII
PABLE:	MOV	E,A
	CALL	SCOUT		;PRINT CHARACTER
	JMP	PMSG1		;PRINT NEXT CHARACTER

;	READ A LINE FROM THE CONSOLE

RDCON:	STA	INBUF		;SET IN COUNT
	LXI	D,INBUF		;POINT TO CONSOLE BUFFER
	PUSH	B
	MVI	C,LINPUT
	CALL	CBDOS		;READ CONSOLE BUFFER
	POP	B
	INX	D
	LDAX	D		;GET COUNT
	ORA	A		;ANY INPUT
	JNZ	RDCON0	
	RET			;RETURN IF NOT
RDCON0:	INX	D		;MOVE TO ACTUAL COUNT
	PUSH	D		;SAVE START OF ENTRY
	ADD	E
	MOV	E,A		;ADD COUNT TO DE
	MOV	A,D
	ACI	0
	MOV	D,A
	PUSH	B
	MVI	B,6
	XRA	A
RDCCL:	STAX	D		;TERMINATE ENTRY WITH 6 ZEROS
	INX	D
	DCR	B
	JNZ	RDCCL
	POP	B
	POP	D		;RESTORE ENTRY ADDRESS
	INR	A		;CLEAR ZERO
	RET

;	MAP LOWER CASE TO UPPER CASE

MCU:	CPI	'a'
	RC
	CPI	'z'+1
	RNC
	ANI	5FH		;BETWEEN a AND z, CAPITALIZE
	RET

;	SINGLE CHARACTER INPUT, NO ECHO

SCIN:	PUSH	B
	MVI	C,DCIO
	MVI	E,0FFH
	CALL	CBDOS		;LOOK FOR A CHARACTER
	POP	B
	ORA	A
	JZ	SCIN		;WAIT UNTIL ONE TYPED
	RET

;	OUTPUT CHARACTER IN E

SCOUT:	PUSH	B
	MVI	C,CONOUT
	CALL	CBDOS
	POP	B
	RET

;	MOVE B BYTES FROM DE TO HL

MOVE:	LDAX	D			;GET A CHARACTER
	CPI	'^'			;CONTROL CHARACTER?
	JNZ	MOVE1			;NO
	INX	D			;ELSE, SKIP "^"
	LDAX	D			;GET NEXT CHARACTER
	ANI	5FH			;CAPITALIZE
	SUI	'@'			;MAKE IT A CONTROL CHARACTER
MOVE1:	MOV	M,A			;MOVE IT IN
	INX	D
	INX	H			;INCREMENT POINTERS
	DCR	B			;DECREMENT COUNTER
	JNZ	MOVE			;LOOP UNTIL DONE
	RET

;	CALL BDOS, REGISTERS SAVED

CBDOS:	PUSH	H
	PUSH	B
	PUSH	D
	CALL	BDOS
	POP	D
	POP	B
	POP	H
	RET

;	DATA AREA

CONMSG	DB	13,10,'CP/M-85 KEYMAP Function Key Mapper, '
	DB	'Version 1.0 Configuration Utility',13,10,10
	DB	'Enter the name of the KEYMAP program you want '
	DB	'to configure: $'
BLINEM	DB	13,10,10,'Do you want a status line message?'
	DB	' (Y or N -- RETURN = N) $'
ASKEYM	DB	13,10
	DB	'Press the key you want to use for alternate '
	DB	'response select, then RETURN.',13,10
	DB	'(Or, RETURN only to disable alternate response): $'
KEYM	DB	13,10,10
	DB	'Enter the response for each key when prompted.'
	DB	13,10
	DB	'The current response will be shown in parentheses.'
	DB	13,10,'$'
ALKEYM	DB	13,10,10
	DB	'Enter the alternate response for each key when '
	DB	'prompted.',13,10,'$'
ALRESM	DB	27,'p ALTERNATE RESPONSE KEY ',27,'q$'
KEYS	DB	'F0',0,'F1',0,'F2',0,'F3',0,'F4',0,'F5',0,'F6',0
	DB	'F7',0,'F8',0,'F9',0,'F10',0,'F11',0,'F12',0
	DB	'SHIFT-F0',0,'SHIFT-F1',0,'SHIFT-F2',0,'SHIFT-F3',0
	DB	'SHIFT-F4',0,'SHIFT-F5',0,'SHIFT-F6',0,'SHIFT-F7',0
	DB	'SHIFT-F8',0,'SHIFT-F9',0,'SHIFT-F10',0
	DB	'SHIFT-F11',0,'SHIFT-F12',0
	DB	'I CHR',0,'D CHR',0,'INS LINE',0,'DEL LINE',0
	DB	'HOME',0,'BACK ARROW',0,'FORWARD ARROW',0
	DB	'UP ARROW',0,'DOWN ARROW',0,'HELP KEY',0
KPADM	DB	13,10,10
	DB	'Want keypad shifted? (Y or N -- RETURN = N) $'
TGLKM	DB	13,10,10
	DB	'Enter on/off toggle code. (RETURN = Control-^) $'
LBMSG	DB	13,10,10
	DB	'Do you want to leave the 25th line enabled '
	DB	'when KEYMAP is toggled off?',13,10
	DB	'(Y or N -- RETURN = N) $'
OFLNKM	DB	13,10,10
	DB	'Enter off line toggle code. (RETURN = Control-\) $'
CRLFM	DB	13,10,'$'
OPPARM	DB	' ($'
CLPARM	DB	'): $'
ESCMSG	DB	'ESC-$'
ERAM	DB	27,'y1$'
PRMSG	DB	13,10,10,'Enter messages for each key from left to '
	DB	'right.',13,10,'$'
ENMSG	DB	13,10,'Enter message for F$'
ENMSG1	DB	': $'
OKM	DB	13,10,10
	DB	'Does this look OK? (Y or N -- RETURN = Y) $'
INTRO	DB	27,'j',27,'x1',27,'Y8 '
ISTR	DB	27,'p'
ISTR1	DB	27,'q'
OUTRO	DB	27,'k',1AH
DONEMSG	DB	13,10,'KEYMAP configuration completed.',13,10,'$'
OPMSG	DB	13,10,'ERROR - Can',27H,'t find your KEYMAP program.',13,10,'$'
BADRD	DB	13,10,'ERROR - Can',27H,'t read your KEYMAP program.',13,10,'$'

OUTPTR	DW	0		;STATUS MSG OUTPUT POINTER
RECSIZ	DB	0		;KEYMAP FILE RECORD SIZE
KEYMPTR	DW	0		;KEY MESSAGE POINTER
RESPTR	DW	0		;RESPONSE POINTER
COUNT	DB	0		;COUNTER
OLDSP	DW	0		;OLD STACK
CFCB	DB	0,'KEYMAP  COM'
FCBX	DB	0,0,0,0
	DS	16
	DB	0,0,0,0
INBUF	DS	28		;INPUT BUFFER
	DS	256		;STACK SPACE
STACK	EQU	$
CBUF	DS	1		;CONFIG BUFFER

;	CONSTANTS IN THE KEYMAP PROGRAM

MAPTBL	EQU	461H-100H
F0	EQU	4B3H-100H
F0S	EQU	7B6H-100H
SPADM	EQU	0ABBH-100H
BLMSG	EQU	0AC1H-100H
ASKEY	EQU	396H-100H
TGLK	EQU	321H-100H
OFFLNK	EQU	326H-100H
ERABL	EQU	0BBFH-100H
	END
U	0ABBH-