	TITLE	RAM.COM - Display System RAM Utilization

;	Version 2.0 (C) 06-Jul-86 by John Stetson

;	This program displays the total amount of system RAM
;	(as reported by DOS), the amount of system RAM currently
;	in use, and the amount of system RAM currently available.

;	MASM, LINK, and EXE2BIN to make RAM.COM

EXIT	EQU	20H
MSDOS	EQU	21H

OUTSTR	EQU	09H

LF	EQU	0AH
CR	EQU	0DH
EOS	EQU	'$'

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	100H		;Origin past PSP

;	Start of program

RAM:	MOV	SI,2		;Offset in PSP of Total RAM
	MOV	AX,[SI] 	;Total RAM in paragraphs

	PUSH	AX
	MOV	SI,OFFSET TOTAL
	CALL	CONVERT 	;Convert & store value
	POP	AX

	MOV	BX,CS
	SUB	AX,BX		;Free = Total RAM - Code Segment
	MOV	SI,OFFSET FREE
	CALL	CONVERT 	;Convert & store value

	MOV	AX,CS		;Used = Code Segment
	MOV	SI,OFFSET USED
	CALL	CONVERT 	;Convert & store value

	MOV	DX,OFFSET MSG
	MOV	AH,OUTSTR
	INT	MSDOS		;Display message

	INT	EXIT

;	Convert (AX) from binary paragraphs to ASCII
;	kbytes and store at address pointed to by SI

;	kbytes = bytes / 1024, paragraphs = bytes / 16,
;	therefore kbytes = paragraphs / (1024/16)=64.

CONVERT PROC	NEAR
	ADD	AX,31		;compute (paragraphs+31) to round
	MOV	CL,6		;64 = 2**6
	SHR	AX,CL		;compute (paragraphs/64)
	MOV	CX,AX		;CX = kbytes = (paragraphs+31)/64

	MOV	AX,3		;Count of output chars
	ADD	SI,AX		;Point past output area

CNVT2:	MOV	DX,10
	CALL	DIVIDE		;(CX)=(CX)/10, (DX)=REM
	ADD	DL,'0'		;Make printable
	DEC	SI		;Point to next digit
	MOV	[SI],DL 	;Store digit
	JCXZ	CNVT3		;Jump if no more

	DEC	AL		;Decrement output count
	JNZ	CNVT2		;Jump if more to go
	JMP	CNVT4		;Jump if done

CNVT3:	DEC	AL		;Decrement output count
	JZ	CNVT4		;Jump if done

	DEC	SI		;Point to next digit
	MOV	[SI],BYTE PTR 0 ;Store 0 - no display
	JMP	CNVT3		;Loop for more

CNVT4:	RET			;Return to caller

CONVERT	ENDP

;	Compute (CX) = (CX) / (DX), (DX) = REM

DIVIDE	PROC	NEAR
	PUSH	AX
	MOV	AX,CX
	MOV	CX,DX
	XOR	DX,DX
	DIV	CX		;(DX,AX)/(CX) -> AX(QUO), DX(REM)
	MOV	CX,AX
	POP	AX
	RET
DIVIDE	ENDP

;	Data Areas

MSG	DB	CR,LF
	DB	'System RAM: '
TOTAL	DB	'xxxk Total, '
USED	DB	'xxxk Used, '
FREE	DB	'xxxk Free',CR,LF,EOS

CODE	ENDS

	END	RAM
