	PAGE	60,132

	TITLE	PASSWORD.DVD - MS-DOS Password Device Driver

;	Version 1.1 (C) 06-Jul-86 by John Stetson

;	This "quick-and-dirty" MS-DOS device driver is designed
;	to provide a simple security mechanism for MS-DOS computer
;	systems with hard disk drives.	Most systems are easily
;	accessible to the casual passer-by by simply being powered
;	on, without even the necessity that the interloper have a
;	bootable floppy disk in his possession.  Once in control,
;	this driver asks the operator for a password, and denies
;	access to the system if the correct word is not entered.

;	This mechanism can be easily bypassed by simply booting
;	from a floppy disk which then allows relatively easy access
;	to the files on the hard disk, in most cases.  The advantage
;	of this approach is that it discourages casual snooping and
;	software theft, and does not use any system memory, since the
;	driver does not remain in memory after it has done its job.

;	For added security, you can replace the printable prompt
;	message with either a null string ($) or just a BELL character
;	and a null string (7,$) as a signal that it's time to enter
;	the password.  This way, the unsuspecting operator may conclude
;	that the machine has a hardware malfunction, and may well
;	abandon further attempts to access the system.

;	To install the driver, copy the PASSWORD.DVD file to the
;	root directory of the hard disk and insert the following line
;	as the FIRST statement in the CONFIG.SYS file:

;	DEVICE=PASSWORD.DVD

;	Use of the Control-C or Control-Break functions will not
;	abort this driver.  The keyboard is intentionally left active
;	so that the user can perform CTRL-RESET or ALT-CTRL-DEL
;	sequences without cycling the power on the computer.

;	The default password can be changed by editing this file
;	and changing the LPSWD and PSWD data values, below.  The
;	.ASM file is then reassembled and linked as described below.
;	Alternatively, you can just use DEBUG to patch these areas.

;	MASM, LINK, and EXE2BIN to make PASSWORD.COM,
;	then RENAME PASSWORD.COM to PASSWORD.DVD.

;	Definitions

MSDOS	EQU	21H			; System Interrupt

DCIN	EQU	07H			; Direct Console Input
OUTSTR	EQU	09H			; Output String

LF	EQU	0AH			; Line Feed
CR	EQU	0DH			; Carriage Return

;	Start of Device Driver

CODE	SEGMENT BYTE
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

PWORD	LABEL	NEAR

;	Device Header

	DW	-1			; Next Device Header Offset
	DW	-1			; Next Device Header Segment
	DW	0			; Device Attributes
	DW	OFFSET STR_RTN		; Address of Strategy Routine
	DW	OFFSET INT_RTN		; Address of Interrupt Routine
	DB	8 DUP (0)		; Number of Units and Driver Name

;	Strategy Routine

STR_RTN PROC	FAR

	MOV	WORD PTR CS:STR_PTR,BX	 ; Save Request Packet Ptr
	MOV	WORD PTR CS:STR_PTR+2,ES
	RET

STR_RTN ENDP

;	Interrupt Routine

INT_RTN PROC	FAR

	PUSHF				; Save everything
	PUSH	AX

	MOV	CS:SAVE_SS,SS
	MOV	CS:SAVE_SP,SP
	MOV	AX,CS
	CLI				; Interrupts off
	MOV	SS,AX			; Establish local stack
	MOV	SP,OFFSET STACK
	STI				; Interrupts on

	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	ES
	PUSH	DS

	MOV	DS,AX			; Set segment registers
	MOV	ES,AX

	CALL	CHKPWD			; Check password

;	Prevent DOS from keeping the driver in memory

	LES	SI,STR_PTR		; ES:SI -> Request Packet
	MOV	BYTE PTR ES:[SI]+3,81H	; Status = Error + Done
	MOV	BYTE PTR ES:[SI]+4,02H	; Error  = Device Not Ready

	XOR	AX,AX
	MOV	BYTE PTR ES:[SI]+13,AL	; Zero units
	MOV	WORD PTR ES:[SI]+14,AX	; End address = Start address
	MOV	WORD PTR ES:[SI]+16,CS
	MOV	WORD PTR ES:[SI]+18,AX	; BPB Array Ptr = 0
	MOV	WORD PTR ES:[SI]+20,AX

	POP	DS			; Restore everything
	POP	ES
	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX

	CLI				; Interrupts off
	MOV	SS,WORD PTR CS:SAVE_SS	; Restore stack
	MOV	SP,WORD PTR CS:SAVE_SP
	STI				; Interrupts on

	POP	AX
	POPF
	RET

INT_RTN	ENDP

;	Check for correct password

CHKPWD	PROC	NEAR

	MOV	DX,OFFSET PROMPT
	MOV	AH,OUTSTR		; Display prompt message
	INT	MSDOS

	XOR	CX,CX
	MOV	DI,OFFSET BUFF

LOOP:	MOV	AH,DCIN 		; Get next character
	INT	MSDOS

	CMP	AL,CR			; Carriage return?
	JZ	COMP			; Done, if so

	MOV	[DI],AL 		; Store character
	INC	DI
	INC	CX
	CMP	CX,8			; 8 characters typed?
	JL	LOOP			; Continue, if not

COMP:	MOV	DX,OFFSET CRLF
	MOV	AH,OUTSTR		; Output CR/LF
	INT	MSDOS

	CMP	CX,0			; Any characters typed?
	JZ	SLEEP			; Sleep, if not

	CMP	CX,LPSWD		; Correct length?
	JNZ	SLEEP			; Sleep, if not

	CLD
	MOV	SI,OFFSET BUFF
	MOV	DI,OFFSET PSWD
	REPZ	CMPSB			; Does password match?
	JNZ	SLEEP			; Sleep, if not

	RET				; Return Ok

SLEEP:	JMP	SLEEP			; Go to sleep

CHKPWD	ENDP

;	Data Areas

PROMPT	DB	'Enter password: $'
CRLF	DB	CR,LF,'$'
BUFF	DB	8 DUP (?)

;	Change the following 2 values to set the password

LPSWD	DW	5			; Length of password (1-8)
PSWD	DB	'xyzzy   '		; User password (8 chars max)

SAVE_SP DW	?			; Saved SP register
SAVE_SS DW	?			; Saved SS register
STR_PTR DD	?			; Request Packet pointer
STACK	EQU	$+256			; Local stack

CODE	ENDS

	END	PWORD
