	PAGE	60,132

	TITLE	MODEM.COM - Dumb Terminal Modem Utility

;	Version 2.0 (C) 06-Jul-86 by John Stetson

;	This program can be used as a "dumb terminal emulator"
;	for either a standard modem device, or for another
;	computer which is connected to one of the serial ports.

;	The CONFIGUR program must be run on the Z-100 to select
;	the appropriate serial port (J1 or J2), parity, baud rate,
;	and other communications parameters.  The remote computer
;	must have appropriate software driving its serial port.

;	The COM and AUX_PARMS values must be set appropriately to
;	the desired communications parameters for PC compatibles.
;	The loop which receives characters from the PC modem is
;	very timing sensitive at 1200 baud; I had to use the ROM
;	BIOS Video I/O interrupt since the DOS direct console I/O
;	function caused characters to be lost.	However, this has
;	the side effect that any received tab characters are not
;	expanded to spaces, which may be undesirable.  In addition,
;	I bypassed the ROM BIOS RS232 I/O interrupt for this loop,
;	and read the COM ports directly to increase throughput.

;	Running the program causes the system console to appear
;	to be connected to the remote system; pressing ESCAPE
;	restores the console to normal.  This is intentionally
;	structured as a minimal program; this allows each user
;	to customize the program for their individual needs.

;	MASM, LINK, and EXE2BIN to make MODEM.COM

;	System	Equates

FALSE	EQU	0
TRUE	EQU	NOT FALSE

Z100	EQU	TRUE		;Set TRUE for Z-100 or
IBMPC	EQU	NOT Z100	;FALSE for PC compatibles

;	Operating System Equates

EXIT	EQU	20H		;MS-DOS Program Termination
MSDOS	EQU	21H		;MS-DOS System Functions

DCIO	EQU	06H		;Direct Console I/O
OUTSTR	EQU	09H		;Output String to Console

	IF	Z100
;	Z-100 BIOS Entry Point Definitions

BIOS_SEG    SEGMENT AT 40H	;Z-100 BIOS Segment

	    ORG     1*3
BIOS_STATUS LABEL   FAR 	;Console Input Status
	    ORG     2*3
BIOS_CONIN  LABEL   FAR 	;Console Input
	    ORG     3*3
BIOS_CONOUT LABEL   FAR 	;Console Output

	    ORG     26*3
BIOS_AUXFUN LABEL   FAR 	;Aux Function
AUX_WRITE   EQU     00H 	;Write Function
AUX_READ    EQU     01H 	;Read Function
AUX_STATUS  EQU     02H 	;Status Function
AUX_GSTAT   EQU     00H 	;Get Status Sub-function
AUX_TXR     EQU     80H 	;Transmitter ready to send
AUX_RXR     EQU     40H 	;Receiver has data
BIOS_SEG    ENDS

	ELSE
;	IBM-PC ROM BIOS Definitions

VIDEO	    EQU     10H 	;Video I/O Interrupt
KEYBD	    EQU     16H 	;Keyboard I/O Interrupt
RS232	    EQU     14H 	;RS232 I/O Interrupt
AUX_INIT    EQU     00H 	;Initialize COM port
AUX_WRITE   EQU     01H 	;Write Function
AUX_READ    EQU     02H 	;Read Function
AUX_STATUS  EQU     03H 	;Status Function
AUX_TXR     EQU     20H 	;Transmitter ready to send
AUX_RXR     EQU     01H 	;Receiver has data
AUX_PARMS   EQU     83H 	;1200 baud, No parity, 1 s.b., 8 b.w.

COM	    EQU     00H 	;Serial port # (COM1=0, COM2=1)

	    IF	    COM
BASE	    EQU     02F8H	;COM2 8250 base port
	    ELSE
BASE	    EQU     03F8H	;COM1 8250 base port
	    ENDIF

	ENDIF

;	ASCII Character Equates

LF	EQU	0AH		;Line Feed
CR	EQU	0DH		;Carriage Return
ESC	EQU	1BH		;Escape

;	Program Initialization

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	100H		;Origin past PSP

;	Start of program

MODEM:	MOV	DX,OFFSET INITMSG
	MOV	AH,OUTSTR
	INT	MSDOS		;Display initial message

	IF	Z100
LOOP:	MOV	AH,AUX_STATUS
	MOV	AL,AUX_GSTAT
	CALL	BIOS_AUXFUN	;Get AUX status
	JC	ERROR

	TEST	AH,AUX_RXR	;Character ready from AUX?
	JZ	SKIP		;Jump if not

	MOV	AH,AUX_READ
	CALL	BIOS_AUXFUN	;Read char from AUX
	JC	ERROR

	CALL	BIOS_CONOUT	;Send char to console
	JMP	LOOP

SKIP:	CALL	BIOS_STATUS	;Char ready from keyboard?
	JZ	LOOP		;Jump if not

	CALL	BIOS_CONIN	;Read character
	CMP	AL,ESC		;Escape?
	JZ	BYE		;Jump if so

	MOV	CHAR,AL 	;Save character

WAIT:	MOV	AH,AUX_STATUS
	MOV	AL,AUX_GSTAT
	CALL	BIOS_AUXFUN	;Get AUX status
	JC	ERROR

	TEST	AH,AUX_TXR	;AUX transmitter ready?
	JZ	WAIT		;Jump if not

	MOV	AH,AUX_WRITE
	MOV	AL,CHAR 	;Restore character
	CALL	BIOS_AUXFUN	;Write char to AUX
	JNC	LOOP

	ELSE
	MOV	AH,AUX_INIT
	MOV	AL,AUX_PARMS
	MOV	DX,COM
	INT	RS232		;Initialize COM device

LOOP:
;	MOV	AH,AUX_STATUS
;	MOV	DX,COM
;	INT	RS232		;Get COM status

	MOV	DX,BASE+5	;Line status register
	IN	AL,DX		;Get status

	TEST	AL,AUX_RXR	;Character ready from COM?
	JZ	SKIP		;Jump if not

;	MOV	AH,AUX_READ
;	MOV	DX,COM
;	INT	RS232		;Read char from COM

	MOV	DX,BASE 	;Receiver buffer register
	IN	AL,DX		;Read character
	MOV	BL,AL		;Save character

	MOV	DX,BASE+5	;Line status register
	IN	AL,DX		;Get status

	TEST	AL,8EH		;Error?
	JNZ	ERROR		;Jump if so

	MOV	AL,BL		;Restore character
	AND	AL,07FH 	;Strip parity bit
	MOV	AH,14		;Write TTY function
	XOR	BX,BX
	INT	VIDEO		;Send char to console

	JMP	LOOP

SKIP:	MOV	AH,1
	INT	KEYBD		;Char ready from keyboard?
	JZ	LOOP		;Jump if not

	MOV	AH,0
	INT	KEYBD		;Get character

	CMP	AL,ESC		;Escape?
	JZ	BYE		;Jump if so

	MOV	CHAR,AL 	;Save character

WAIT:	MOV	AH,AUX_STATUS
	MOV	DX,COM
	INT	RS232		;Get COM status

	TEST	AH,AUX_TXR	;COM transmitter ready?
	JZ	WAIT		;Jump if not

	MOV	AH,AUX_WRITE
	MOV	AL,CHAR 	;Restore character
	MOV	DX,COM
	INT	RS232		;Write char to COM

	TEST	AH,8EH		;Error?
	JNZ	ERROR		;Jump if so

	JMP	LOOP		;Jump if not
	ENDIF

ERROR:	MOV	DX,OFFSET ERRMSG
	MOV	AH,OUTSTR
	INT	MSDOS		;Display error message

BYE:	MOV	DX,OFFSET ENDMSG
	MOV	AH,OUTSTR
	INT	MSDOS		;Display final message

	INT	EXIT

;	Data Areas

CHAR	DB	0
INITMSG DB	CR,LF,'REMOTE',CR,LF,'$'
ENDMSG	DB	CR,LF,'LOCAL',CR,LF,'$'
	IF	Z100
ERRMSG	DB	CR,LF,'Error from AUX device!',CR,LF,'$'
	ELSE
ERRMSG	DB	CR,LF,'Error from COM device!',CR,LF,'$'
	ENDIF

CODE	ENDS

	END	MODEM
