	PAGE	60,132

	TITLE	DATETIME.COM - MS-DOS Date/Time Utility

;	Version 1.1 (C) 06-Oct-86 by John Stetson

;	This program gets the current DOS date and time
;	and displays them on the console using the format:

;	Monday December 31, 1984 12:34:56

;	It is primarily intended to be used in .BAT file
;	with the command output redirected to a data file,
;	as part of an automatic time tracking system.

;	For example: datetime >logon.dat

;	MASM, LINK, and EXE2BIN to make DATETIME.COM

;	Operating System Equates

MSDOS	EQU	21H		;Interrupt for system functions
EXIT	EQU	20H		;Interrupt for program termination
OUTSTR	EQU	09H		;Console string output
GDATE	EQU	2AH		;Get system date
GTIME	EQU	2CH		;Get system time

;	ASCII Character Equates

CR	EQU	0DH		;Carriage return
LF	EQU	0AH		;Line feed
EOS	EQU	'$'		;End of string indicator

;	Program initialization

CODE	SEGMENT BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	100H		;Origin after PSP

;	Get the Day of the Week and Date

DT:	MOV	AH,GDATE
	INT	MSDOS

;	AL = Week Day from 0 to 6
;	CX = Year from 1980 to 2099
;	DH = Month from 1 to 12
;	DL = Month Day from 1 to 31

	INC	AL
	MOV	BYTE PTR WDAY,AL
	MOV	WORD PTR YEAR,CX
	MOV	BYTE PTR MONTH,DH
	MOV	BYTE PTR MDAY,DL

;	Get the Time

	MOV	AH,GTIME
	INT	MSDOS

;	CH = Hour from 0 to 23
;	CL = Minute from 0 to 59
;	DH = Second from 0 to 59
;	DL = Secs/100 from 0 to 99

	MOV	BYTE PTR HOUR,CH
	MOV	BYTE PTR MINUTE,CL
	MOV	BYTE PTR SECOND,DH

;	Print the Day of the Week

	MOV	AX,WDAY 	;Day of Week (1-7)
	DEC	AX		;Less one
	SHL	AX,1		;Times two

	MOV	SI,OFFSET DAYS
	ADD	SI,AX		;SI = A(A(day name))
	MOV	DX,[SI] 	;DX = A(day name)

	MOV	AH,OUTSTR
	INT	MSDOS		;Print day name

;	Print a space

	MOV	DX,OFFSET SPACE
	MOV	AH,OUTSTR
	INT	MSDOS

;	Print the Month

	MOV	AX,MONTH	;Month (1-12)
	DEC	AX		;Less one
	SHL	AX,1		;Times two

	MOV	SI,OFFSET MONTHS
	ADD	SI,AX		;SI = A(A(month name))
	MOV	DX,[SI] 	;DX = A(month name)

	MOV	AH,OUTSTR
	INT	MSDOS		;Print month name

;	Format the Day of the Month

	MOV	LFLAG,BYTE PTR 0;No leading zeros
	MOV	AX,MDAY 	;Day of Month
	MOV	DI,OFFSET DAY+1
	CALL	FORMAT
	MOV	[DI],BYTE PTR EOS

;	Print the Day of the Month

	MOV	DX,OFFSET DAY
	MOV	AH,OUTSTR
	INT	MSDOS

;	Print the Year

	MOV	AX,YEAR 	;AX = binary year
	SUB	AX,1900 	;Adjust to 2 digits
	CMP	AX,100		;Year GE 2000?
	JL	DT1		;Jump if not
	SUB	AX,100		;Normalize to 0
	MOV	WORD PTR YCENT,'02' ;Store year century

DT1:	AAM
	XCHG	AL,AH
	OR	WORD PTR YEARS,AX   ;Store year

	MOV	DX,OFFSET YRMSG
	MOV	AH,OUTSTR
	INT	MSDOS

;	Format the Hour

	MOV	LFLAG,BYTE PTR 1;Leading zeros
	MOV	AX,HOUR 	;Hour
	MOV	DI,OFFSET TIME
	CALL	FORMAT

;	Format the Minute

	MOV	AX,MINUTE	;Minute
	INC	DI
	CALL	FORMAT

;	Format the Second

	MOV	AX,SECOND	;Second
	INC	DI
	CALL	FORMAT

;	Print the Time

	MOV	DX,OFFSET TIME
	MOV	AH,OUTSTR
	INT	MSDOS

;	Exit to MS-DOS

	INT	EXIT

;	HEXDEC - routine to convert a hexadecimal value from
;	(0-FF) in register (AL) to decimal and return in (AX).

;	(AX) = 10 * INT(AL/16) + MOD(AL,16)

HEXDEC	PROC	NEAR

	XOR	DX,DX
	XOR	AH,AH
	MOV	BX,16
	DIV	BX		;(DX,AX)/BX -> AX(QUO), DX(REM)
	MOV	CX,DX		;CX = remainder = MOD(AL,16)

	MOV	BX,10
	MUL	BX		;(AX)*(BX) -> (DX,AX) = 10 * INT(AL/16)

	ADD	AX,CX		;(AX) = 10 * INT(AL/16) + MOD(AL,16)
	RET			;Return to caller
HEXDEC	ENDP

;	FORMAT - routine to convert (AX) from decimal to ASCII (0-99).
;	LFLAG = 1 indicates that a leading zero is to be stored.
;	(DI) = address of output area to receive character string.

FORMAT	PROC	NEAR

	XOR	DX,DX
	MOV	BX,10
	DIV	BX		;(DX,AX)/BX -> AX(QUO), DX(REM)
	PUSH	DX		;Save unit's digit

	CMP	AX,0		;Ten's digit = zero?
	JNZ	DEC1		;Jump if not

	CMP	LFLAG,BYTE PTR 1 ;Print leading zero?
	JNZ	DEC2		;Jump if not

	MOV	DL,'0'
	MOV	[DI],DL 	;Store leading zero
	INC	DI
	JMP	DEC2

DEC1:	MOV	DL,AL		;Ten's digit
	ADD	DL,'0'		;Make printable
	MOV	[DI],DL 	;Store digit
	INC	DI

DEC2:	POP	DX		;Restore unit's digit
	ADD	DL,'0'		;Make printable
	MOV	[DI],DL 	;Store digit
	INC	DI
	RET			;Return to caller
FORMAT	ENDP

;	Data areas

DAYS	DW	OFFSET SUN
	DW	OFFSET MON
	DW	OFFSET TUE
	DW	OFFSET WED
	DW	OFFSET THU
	DW	OFFSET FRI
	DW	OFFSET SAT

SUN	DB	'Sunday',EOS
MON	DB	'Monday',EOS
TUE	DB	'Tuesday',EOS
WED	DB	'Wednesday',EOS
THU	DB	'Thursday',EOS
FRI	DB	'Friday',EOS
SAT	DB	'Saturday',EOS

SPACE	DB	' ',EOS

MONTHS	DW	OFFSET JAN
	DW	OFFSET FEB
	DW	OFFSET MAR
	DW	OFFSET APR
	DW	OFFSET MAY
	DW	OFFSET JUN
	DW	OFFSET JUL
	DW	OFFSET AUG
	DW	OFFSET SEP
	DW	OFFSET OCT
	DW	OFFSET NOV
	DW	OFFSET DEC

JAN	DB	'January',EOS
FEB	DB	'February',EOS
MAR	DB	'March',EOS
APR	DB	'April',EOS
MAY	DB	'May',EOS
JUN	DB	'June',EOS
JUL	DB	'July',EOS
AUG 	DB	'August',EOS
SEP	DB	'September',EOS
OCT	DB	'October',EOS
NOV	DB	'November',EOS
DEC	DB	'December',EOS

DAY	DB	' DD',EOS

YRMSG	DB	', '
YCENT	DB	'19'
YEARS	DB	'00 ',EOS

TIME	DB	'HH:'
	DB	'MM:'
	DB	'SS'
	DB	CR,LF,EOS

LFLAG	DB	0		;Leading zeros flag

WDAY	DW	0		;Day of the week (1=Sun,...,7=Sat)
YEAR	DW	0		;Year (1980-2099)
MONTH	DW	0		;Month (1=Jan,...,12=Dec)
MDAY	DW	0		;Day of the month (1-31)

HOUR	DW	0		;Hour (0-23)
MINUTE	DW	0		;Minute (0-59)
SECOND	DW	0		;Second (0-59)

CODE	ENDS

	END	DT
