1000 ' Zenith MS-DOS HELP Utility Program
1010 ' Convert Sequential HELP File to Random File
1020 ' Version 1.2 (C) 28-Dec-85 by John F. Stetson
1030 '
1040 ' Structure of the random file is 16 directory records
1050 ' each containing entries for 8 commands in the format:
1060 '
1070 ' 8 bytes - command name padded with trailing spaces
1080 ' 4 bytes - starting record number for command text
1090 ' 4 bytes - offset of command text in starting record
1100 '
1110 ' followed by the text of the HELP data base itself.
1120 ' Text lines are separated by the NULL character.
1130 '
1140 DEFINT A-Z : DIM CMD$(128),REC$(128),OFF$(128)
1150 RL=128 : NDR=16 : DLM$=CHR$(0) : NSR=0
1160 '
1170 ' Open data base files
1180 '
1190 PRINT "Zenith MS-DOS HELP Utility V1.2 (C) 1985 by J.F.Stetson"
1200 PRINT
1210 PRINT "Converting Sequential HELP Data Base File to Random File"
1220 PRINT
1230 OPEN "I",#1,"HELPS.DAT"
1240 OPEN "R",#2,"HELP.DAT",RL
1250 FIELD #2, RL AS RS$
1260 NR=1 : NC=0 : S$=""
1270 '
1280 ' Read next sequential record
1290 '
1300 IF EOF(1) GOTO 1560
1310 LINE INPUT #1,L$ : NSR=NSR+1
1320 '
1330 ' Process command record
1340 '
1350 IF LEFT$(L$,2)<>".c" GOTO 1470
1360 NC=NC+1
1370 CMD$(NC)=MID$(L$,4)
1380 I=INSTR(CMD$(NC),"(") : IF I=0 GOTO 1400
1390 CMD$(NC)=LEFT$(CMD$(NC),I-2)
1400 CMD$(NC)=LEFT$(CMD$(NC),8)
1410 CMD$(NC)=LEFT$(CMD$(NC)+STRING$(8," "),8)
1420 REC$(NC)=RIGHT$("000"+MID$(STR$(NDR+NR),2),4)
1430 OFF$(NC)=RIGHT$("000"+MID$(STR$(LEN(S$)),2),4)
1440 '
1450 ' Store the text of the record & write, if necessary
1460 '
1470 S$=S$+L$+DLM$ : T$=""
1480 IF LEN(S$)<RL GOTO 1300
1490 IF LEN(S$)=RL GOTO 1510
1500 T$=MID$(S$,RL+1) : S$=LEFT$(S$,RL)
1510 LSET RS$=S$ : PUT #2,NDR+NR : NR=NR+1
1520 S$=T$ : T$="" : GOTO 1300
1530 '
1540 ' Pad last random record with spaces
1550 '
1560 IF LEN(S$)=0 GOTO 1590
1570 S$=S$+LEFT$(STRING$(RL," "),RL-LEN(S$))
1580 LSET RS$=S$ : PUT #2,NDR+NR : NR=NR+1
1590 NRR=NDR+NR-1
1600 '
1610 ' Build and write directory records
1620 '
1630 S$="" : NR=1
1640 FOR I=1 TO NC : S$=S$+CMD$(I)+REC$(I)+OFF$(I)
1650 IF LEN(S$)<RL GOTO 1670
1660 LSET RS$=S$ : PUT #2,NR : NR=NR+1 : S$=""
1670 NEXT I
1680 IF LEN(S$)=0 GOTO 1740
1690 S$=S$+LEFT$(STRING$(RL," "),RL-LEN(S$))
1700 LSET RS$=S$ : PUT #2,NR : NR=NR+1
1710 '
1720 ' Pad trailing directory records with spaces
1730 '
1740 IF NR>NDR GOTO 1820
1750 FOR I=NR TO NDR
1760 S$=STRING$(LR," ")
1770 LSET RS$=S$ : PUT #2,I
1780 NEXT I
1790 '
1800 ' Close files and give messages
1810 '
1820 CLOSE
1830 PRINT "Number of input records =";NSR
1840 PRINT "Number of output records =";NRR
1850 END
