	PAGE	,132
;	THIS PROGRAM IS A SHELL THAT RUNS WORDSTAR AND PROVIDES
;	A CHARACTER UNDELETE FUNCTION
;	BY PATRICK SWAYNE, HUG SOFTWARE ENGINEER  24-NOV-87

;	DEFINE BIOS STORAGE CELLS

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	2CH
ENVSEG	LABEL	WORD			;ENVIRONMENT SEGMENT
	ORG	50H
CURPOS	LABEL	WORD			;DEFINE CURSOR POSITION (IN BIOS RAM)
	ORG	5DH
ARG	LABEL	BYTE			;ARGUMENT ADDRESS
	ORG	100H

;	SET UP VECTOR FOR INT 16H, AND EXECUTE WORDSTAR

START:	MOV	AH,30H
	INT	21H			;GET DOS VERSION NUMBER
	CMP	AL,2			;CHECK IT
	JAE	DOSOK			;VERSION OK
	MOV	DX,OFFSET BADVER
	MOV	AH,9
	INT	21H			;ELSE, SAY "BAD VERSION"
	INT	20H			;AND EXIT
DOSOK:	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;PRINT SIGN-ON
	MOV	SI,OFFSET ARG		;POINT TO USER ARGUMENT
	MOV	DI,OFFSET CONNAM	;POINT TO "CONFIG"
	MOV	CX,11			;COMPARE THIS MUCH
	CLD
	REPZ	CMPSB			;TEST ARGUMENT
	JZ	CONFIG			;CONFIG WANTED
	JMP	NOTCON			;NOT CONFIG MODE
CONFIG:	MOV	DX,OFFSET CONMSG
	MOV	AH,9
	INT	21H			;ELSE, SAY "CONFIG MODE"
	MOV	DX,OFFSET WSNAM		;POINT TO WS PATH NAME
	MOV	CX,80			;READ 80 BYTES
	MOV	BX,0			;USE STD IN
	MOV	AH,3FH
	INT	21H			;READ PATH NAME
	ADD	DX,AX			;POINT TO END
	MOV	BX,DX			;IN BX
	CMP	BYTE PTR -1[BX],0AH	;LAST CHARACTER LF?
	JZ	BACK2			;IF SO, BACK UP 2
NOTLF:	CMP	BYTE PTR -1[BX],0DH	;LAST CHARACTER CR?
	JZ	BACK1			;IF SO, BACK UP 1
	JMP	SHORT ADDZ		;ELSE, ADD ZERO HERE
BACK2:	DEC	BX
BACK1:	DEC	BX
ADDZ:	MOV	BYTE PTR [BX],0		;MAKE STRING ASCIIZ
ASKWS:	MOV	DX,OFFSET WSMSG
	MOV	AH,9
	INT	21H			;ASK WORDSTAR VERSION
	MOV	AH,1
	INT	21H			;GET REPLY
	MOV	BX,1			;ASSUME 4
	CMP	AL,'4'			;IS IT?
	JZ	SETWSV			;YES, SET BACK SPACE MODE
	MOV	BX,300H			;ASSUME 3
	CMP	AL,'3'			;IS IT?
	JNZ	ASKWS			;BAD REPLY
SETWSV:	MOV	SCANCD,BH		;SET SCAN CODE
	MOV	BSMODE,BL		;AND MODE FLAGS
	MOV	DELMODE,BL
	CMP	BL,0			;WORDSTAR 3?
	JZ	WRTCON			;IF SO, WRITE CONFIGURATION NOW
ASKBS:	MOV	DX,OFFSET BSMSG
	MOV	AH,9
	INT	21H			;ASK ABOUT BACK SPACE
	MOV	AH,1
	INT	21H			;GET REPLY
	AND	AL,5FH			;CAPITALIZE
	MOV	BL,1			;ASSUME "Y"
	CMP	AL,'Y'			;IS IT?
	JZ	SETBSM			;YES, SET BACK SPACE MODE
	DEC	BL			;ASSUME "N"
	CMP	AL,'N'			;IS IT?
	JNZ	ASKBS			;BAD REPLY
SETBSM:	MOV	BSMODE,BL		;SET BACK SPACE MODE
ASKDEL:	MOV	DX,OFFSET DELMSG
	MOV	AH,9
	INT	21H			;ASK ABOUT DEL
	MOV	AH,1
	INT	21H			;GET REPLY
	AND	AL,5FH			;CAPITALIZE
	MOV	BL,1			;ASSUME "Y"
	CMP	AL,'Y'			;IS IT?
	JZ	SETDM			;YES, SET DEL MODE
	DEC	BL			;ASSUME "N"
	CMP	AL,'N'			;IS IT?
	JNZ	ASKDEL			;BAD REPLY
SETDM:	MOV	DELMODE,BL		;SET DEL MODE
WRTCON:	MOV	DX,OFFSET WSUDNAM	;POINT TO THIS FILE'S NAME
	MOV	AX,3D01H		;OPEN IT FOR WRITING
	INT	21H
	JC	BADWRT			;COULDN'T DO IT
	MOV	BX,AX			;HANDLE TO BX
	MOV	CX,0
	MOV	DX,OFFSET SCANCD-100H	;MOVE FILE POINTER TO HERE
	MOV	AX,4200H
	INT	21H
	JC	BADWRT
	MOV	DX,OFFSET SCANCD	;DATA TO WRITE IS HERE
	MOV	CX,84			;THIS MUCH TO WRITE
	MOV	AH,40H
	INT	21H			;WRITE DATA
	JC	BADWRT
	MOV	AH,3EH
	INT	21H			;CLOSE FILE
	JNC	WRTOK			;IT WENT OK
BADWRT:	MOV	DX,OFFSET WRTERR
	JMP	SHORT CONX
WRTOK:	MOV	DX,OFFSET WRTDN
CONX:	MOV	AH,9
	INT	21H			;PRINT LAST MSG
	INT	20H
NOTCON:	CLI
	MOV	SP,OFFSET START		;PUT STACK HERE
	STI
	MOV	AH,15
	INT	10H			;GET VIDEO STATE
	CMP	AL,7			;MONOCHROME MODE?
	JNZ	NOTMON
	MOV	VIDRAM,0B000H		;ELSE, FIX VIDEO RAM ADDRESS
NOTMON:	MOV	AX,3516H
	INT	21H			;GET INT 16 ADDRESS
	MOV	INT16V,BX
	MOV	INT16V+2,ES		;SAVE IT
	PUSH	CS
	POP	ES			;PUT ES HERE
	MOV	AX,2516H
	MOV	DX,OFFSET INT16
	INT	21H			;SET NEW INT 16 ADDRESS
	MOV	BX,OFFSET ENDADR	;POINT TO END OF THIS PROGRAM
	MOV	CL,4
	SHR	BX,CL			;MAKE IT A PARAGRAPH
	INC	BX			;ROUND UP
	MOV	AH,4AH
	INT	21H			;FREE UP MEMORY FOR WSCHANGE.EXE
	JC	CNTEX			;SOMETHING'S WRONG
	MOV	AX,ENVSEG
	MOV	PBENV,AX		;SET UP ENV. SEGMENT ADDRESS
	MOV	PBCMD+2,CS		;SET UP SEGMENT FOR CMD LINE
	MOV	PBFCB1+2,CS		;SET UP FCB1 SEGMENT
	MOV	PBFCB2+2,CS		;SET UP FCB2 SEGMENT
	MOV	DX,OFFSET WSNAM		;POINT TO WS NAME
	MOV	BX,OFFSET PBLOCK	;AND TO PARAMETER BLOCK
	MOV	AX,4B00H		;PROGRAM EXEC FUNCTION
	INT	21H			;TRY TO EXECUTE WSCHANGE
	JNC	EXECOK			;IT WAS OK
CNTEX:	MOV	DX,OFFSET NOEXEC
	MOV	AH,9
	INT	21H
EXECOK:	MOV	DX,CS:INT16V		;GET INT 16 VECTOR
	MOV	DS,CS:INT16V+2
	MOV	AX,2516H
	INT	21H			;FIX INT 16 VECTOR
	MOV	AX,CS
	MOV	DS,AX			;PUT DS HERE
	CLD
	INT	20H			;AND EXIT

;	INT 16 PROCESSOR

INT16:	CMP	AH,0			;GET CHARACTER?
	JZ	PRRQ			;YES, PROCESS INTERRUPT REQUEST HERE
	CMP	AH,1			;CHECK STATUS?
	JNZ	INT16X			;NO, EXIT
	CMP	CS:INSFLG,1		;INSERT MODE ON?
	JNZ	INT16X			;NO
RETCS:	MOV	AX,1F13H		;GET CONTROL-S CODE
	OR	AX,AX			;CLEAR Z FLAG
	STI				;RESTORE INTERRUPTS
DUMMY	PROC	FAR
	RET	2			;RETURN INDICATING CHAR READY
DUMMY	ENDP
INT16X:	JMP	CS:DWORD PTR INT16V	;ELSE, LET BIOS DO IT
PRRQ:	CMP	CS:INSFLG,1		;INSERT MODE ON?
	JNZ	PRRQ1			;IF NOT, CONTINUE PROCESS
	MOV	CS:INSFLG,0		;ELSE, CLEAR INSERT FLAG
	JMP	RETCS			;AND RETURN CONTROL-S
PRRQ1:	PUSH	BX			;SAVE SOME REGISTERS
	PUSH	SI
	PUSH	DS
	PUSH	CS
	POP	DS			;PUT DS HERE
	PUSHF				;FAKE INTERRUPT CALL
	CALL	DWORD PTR INT16V	;CALL KEYBOARD PROCESSOR
	CMP	BYTE PTR BSMODE,1	;CHECK BACK SPACE MODE
	JNZ	CHKDEL			;NOT WORDSTAR 4 MODE
	CMP	AX,0E08H		;BACK SPACE?
	JZ	BS			;YES
	CMP	AX,2308H		;CONTROL-H?
	JZ	BS			;TREAT AS BACK SPACE
	MOV	BYTE PTR BSFLG,0	;FLAG NOT A BS
	JMP	SHORT CHKDEL		;CHECK DEL KEY
WS3BS:	CMP	AX,5300H		;DEL KEY?
	JZ	BS			;USED AS BACK SPACE
	CMP	AX,0E7FH		;CONTROL-BACK SPACE (DELETE)?
	JZ	BS			;TREAT AS BACK SPACE
	MOV	BYTE PTR BSFLG,0	;FLAG NOT A BS
	JMP	SHORT CHKCG		;CHECK CONTROL-G
CHKDEL:	CMP	BYTE PTR DELMODE,1	;CHECK DEL MODE
	JNZ	WS3BS			;DEL USED AS BACK SPACE
	CMP	AX,5300H		;DEL KEY?
	JZ	DEL
	CMP	AX,0E7FH		;CONTROL-BACK SPACE (DELETE)?
	JZ	DEL			;TREAT AS DEL
CHKCG:	CMP	AX,2207H		;CONTROL-G?
	JZ	DEL			;THE REAL WORDSTAR DEL
	JMP	MORE			;DECODE MORE KEYS LATER
BS:	PUSH	AX			;SAVE CHARACTER
	MOV	AX,40H
	MOV	DS,AX			;POINT TO BIOS RAM
	MOV	BX,CURPOS		;GET CURSOR POSITION
	PUSH	CS
	POP	DS			;PUT DS HERE
	CMP	BYTE PTR BSFLG,1	;WAS LAST KEY BS?
	JNZ	NLBS			;NO
	CMP	BX,OCPOS		;CURSOR AT SAME LOCATION?
	JZ	BSX			;IF SO, DON'T RE-STORE CHARACTER
NLBS:	MOV	OCPOS,BX		;UPDAT OLD CURSOR POSITION
	MOV	BYTE PTR BSFLG,1	;FLAG BS DONE
	OR	BL,BL			;AT LINE BEGINNING?
	JZ	BSX			;IF SO, CAN'T BACK SPACE
	MOV	AL,BH			;ROW TO AL
	MOV	BH,80
	MUL	BH			;CONVERT ROW TO POSITION
	XOR	BH,BH			;BX = COLUMN
	ADD	AX,BX			;AX = POSITION OF CHARACTER
	SHL	AX,1			;MULTIPLY BY 2 TO GET ADDRESS
	MOV	SI,AX			;SAVE CURSOR ADDRESS
	MOV	AX,CS:VIDRAM
	MOV	DS,AX			;POINT TO VIDEO RAM
	MOV	AL,-2[SI]		;GET CHARACTER TO BE DELETED
	JMP	SHORT SAVCHR		;SAVE IT
DEL:	PUSH	AX			;SAVE CHARACTER
	MOV	AX,40H
	MOV	DS,AX			;POINT TO BIOS RAM
	MOV	BX,CURPOS		;GET CURSOR POSITION
	MOV	AL,BH			;ROW TO AL
	MOV	BH,80
	MUL	BH			;CONVERT ROW TO POSITION
	XOR	BH,BH			;BX = COLUMN
	ADD	AX,BX			;AX = POSITION OF CHARACTER
	SHL	AX,1			;MULTIPLY BY 2 TO GET ADDRESS
	MOV	SI,AX			;SAVE CURSOR ADDRESS
	MOV	AX,CS:VIDRAM
	MOV	DS,AX			;POINT TO VIDEO RAM
	MOV	AL,[SI]			;GET CHARACTER TO BE DELETED
SAVCHR:	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	SI,DELPTR		;GET DELETE POINTER
	CMP	SI,OFFSET DELBUF+256	;AT END?
	JNZ	STCHR			;NO, STORE CHARACTER
	PUSH	ES			;ELSE, SAVE ES
	PUSH	DI			;SAVE DI
	PUSH	CX			;AND CX
	PUSH	CS
	POP	ES			;PUT ES HERE
	MOV	SI,OFFSET DELBUF+1	;SET MOVE POINTERS
	MOV	DI,OFFSET DELBUF
	MOV	CX,255
	CLD
	REP	MOVSB			;MOVE CHARACTERS DOWN
	MOV	SI,OFFSET DELBUF+255	;FIX POINTER
	POP	CX
	POP	DI
	POP	ES
STCHR:	MOV	[SI],AL			;STORE DELETED CHARACTER
	INC	SI			;BUMP POINTER
	MOV	DELPTR,SI		;SAVE IT
BSX:	POP	AX
	JMP	SHORT PRRQX		;RETURN WITH CHARACTER
MORE:	CMP	AX,1600H		;ALT-U?
	JZ	UNDEL			;IF SO, UNDELETE ONE CHARACTER
	CMP	AX,1700H		;ALT-I?
	JZ	INSERT			;IF SO, INSERT UNDELETED CHARACTER
	CMP	AX,2000H		;ALT-D?
	JZ	DUMP			;IF SO, DUMP SAVED CHARACTER
	CMP	AX,1900H		;ALT-P?
	JZ	PURGE			;IF SO, PURGE UNDELETE BUFFER
PRRQX:	POP	DS			;RESTORE REGISTERS
	POP	SI
	POP	BX
	IRET				;NOT A SPECIAL CHARACTER
UNDEL:	MOV	SI,DELPTR		;GET DELETE POINTER
	CMP	SI,OFFSET DELBUF	;DELETE BUFFER EMPTY?
	JZ	NODEL			;IF SO, CAN'T DO THIS FUNCTION
	DEC	SI			;BACK UP POINTER
	MOV	AL,[SI]			;GET CHARACTER
UPPTR:	MOV	DELPTR,SI		;FIX POINTER
NODEL:	MOV	AH,SCANCD		;RETURN PROPER SCAN CODE
	JMP	PRRQX			;RETURN WITH CHARACTER
INSERT:	MOV	SI,DELPTR		;GET DELETE POINTER
	CMP	SI,OFFSET DELBUF	;DELETE BUFFER EMPTY?
	JZ	NODEL			;IF SO, CAN'T DO THIS FUNCTION
	DEC	SI			;BACK UP POINTER
	MOV	AL,[SI]			;GET CHARACTER
	MOV	INSFLG,1		;MARK INSERT MODE
	JMP	UPPTR
DUMP:	MOV	SI,DELPTR		;GET DELETE POINTER
	CMP	SI,OFFSET DELBUF	;DELETE BUFFER EMPTY?
	JZ	NODEL			;IF SO, CAN'T DO THIS FUNCTION
	DEC	SI			;BACK UP POINTER
	JMP	UPPTR			;UPDATE IT AND RETURN
PURGE:	MOV	SI,OFFSET DELBUF	;RESET POINTER
	JMP	UPPTR			;AND UPDATE IT

;	DATA AREA

VIDRAM	DW	0B800H			;VIDEO RAM ADDRESS
BSFLG	DB	0			;BACK SPACE FLAG
OCPOS	DW	0			;OLD CURSOR POSITION
INSFLG	DB	0			;INSERT FLAG

;	STORAGE BUFFER FOR DELETED CHARACTERS

DELPTR	DW	OFFSET DELBUF		;BUFFER POINTER
DELBUF	DB	256 DUP (0)		;BUFFER

;	PARAMETER BLOCK USED TO EXECUTE WS.EXE

PBLOCK	LABEL	NEAR
PBENV	DW	0			;ENVIRONMENT SEGMENT
PBCMD	DW	80H,0			;COMMAND LINE ADDRESS
PBFCB1	DW	5CH,0			;FCB1 ADDRESS
PBFCB2	DW	6CH,0			;FCB2 ADDRESS

INT16V	DW	0,0			;INT 16 VECTOR

CONNAM	DB	'CONFIG     '		;CONFIG SEARCH ARGUMENT
WSUDNAM	DB	'WSUD.COM',0		;THIS FILE'S NAME

;	CONFIGURATION DATA, ALTERED BY CONFIG MODE

SCANCD	DB	0			;SCAN CODE TO RETURN
BSMODE	DB	1			;BACK SPACE MODE (1 = WS4)
DELMODE	DB	1			;DEL MODE (1 = WS4)
WSNAM	DB	'WS.EXE',0		;WORDSTAR PATH NAME
	DB	74 DUP (0)		;ROOM FOR 80 CHARACTER PATH NAME

;	MESSAGES

BADVER	DB	13,10,'DOS version 2 or higher is required.',13,10,'$'
SIGNON	DB	13,10,'WordStar Character Undelete Utility, v 1.0',13,10,'$'
CONMSG	DB	13,10,'Entering configuration mode...',13,10,10
	DB	'Enter WS execution path:',13,10,'$'
WSMSG	DB	13,10,'What is your WordStar version? (3 or 4) $'
BSMSG	DB	13,10,10,'Does BACK SPACE delete characters? (Y/N) $'
DELMSG	DB	13,10,10,'Does DEL work like Control-G? (Y/N) $'
WRTERR	DB	13,10,10,'Unable to write configuration.',13,10,'$'
WRTDN	DB	13,10,10,'New configuration stored.',13,10,'$'
NOEXEC	DB	13,10,"Can't execute your WS file.",13,10,'$'
ENDADR	LABEL	NEAR

CODE	ENDS
	END	START
