	TITLE	SPECIAL WORDSTAR KEYMAP
	PAGE	,132
;	KEYWS -- SPECIAL KEY MAPPER FOR WORDSTAR.
;
;	THIS PROGRAM MAPS THE VARIOUS FUNCTION AND KEYPAD KEYS
;	TO WORDSTAR SPECIFIC CODES.
;
;	Z-150/IBM-PC VERSION
;
;	BY P. SWAYNE, HUG  26-SEP-84  19-OCT-84  27-MAY-87
;	COPYRIGHT (C) 1984 BY HEATH USERS' GROUP

;	DEFINITIONS

M	EQU	Byte Ptr 0[BX]		;MEMORY POINTER
TYPEF	EQU	9			;TYPE STRING FUNCTION

KEY	SEGMENT
	ASSUME	CS:KEY,DS:KEY,SS:KEY,ES:KEY
	ORG	17H
KEYFLG	LABEL	BYTE			;KEYBOARD FLAG
	ORG	1CH
TYHPTR	LABEL	WORD			;TYPE-AHEAD POINTER
	ORG	100H

START:	JMP	SETUP			;SET UP KEYMAP

;	TABLE OF MAPPED SEQUENCES

MAPTBL	DW	Offset F1
	DW	Offset F2
	DW	Offset F3
	DW	Offset F4
	DW	Offset F5
	DW	Offset F6
	DW	Offset F7
	DW	Offset F8
	DW	Offset F9
	DW	Offset F10
	DW	Offset NOTDF1		;E
	DW	Offset NOTDF2		;F
	DW	Offset HOME
	DW	Offset UP
	DW	Offset PGUP
	DW	Offset NOTDF3		;J
	DW	Offset BK
	DW	Offset KEY5		;KEYPAD 5 KEY
	DW	Offset FWD
	DW	Offset NOTDF5		;N
	DW	Offset ENDKEY
	DW	Offset DN
	DW	Offset PGDN
	DW	Offset INS
	DW	Offset DEL
	DW	Offset SF1
	DW	Offset SF2
	DW	Offset SF3
	DW	Offset SF4
	DW	Offset SF5
	DW	Offset SF6
	DW	Offset SF7
	DW	Offset SF8
	DW	Offset SF9
	DW	Offset SF10
	DW	Offset CF1
	DW	Offset CF2
	DW	Offset CF3
	DW	Offset CF4
	DW	Offset CF5
	DW	Offset CF6
	DW	Offset CF7
	DW	Offset CF8
	DW	Offset CF9
	DW	Offset CF10
	DW	Offset AF1
	DW	Offset AF2
	DW	Offset AF3
	DW	Offset AF4
	DW	Offset AF5
	DW	Offset AF6
	DW	Offset AF7
	DW	Offset AF8
	DW	Offset AF9
	DW	Offset AF10
;	DW	Offset CPSC
;	DW	Offset CBK
;	DW	Offset CFWD
;	DW	Offset CEND
;	DW	Offset CPGDN
;	DW	Offset CHOME

;	MAPPED CHARACTER SEQUENCES

;HOME	DB	'TEST',13,255
;	DB	15 DUP (0)
HOME	DB	'R'-'@',255
	DB	19 DUP (0)
UP	DB	'E'-'@',255
	DB	19 DUP (0)
PGUP	DB	'C'-'@',255
	DB	19 DUP (0)
BK	DB	'S'-'@',255
	DB	19 DUP (0)
KEY5	DB	0,'L',255
	DB	18 DUP (0)
FWD	DB	'D'-'@',255
	DB	19 DUP (0)
ENDKEY	DB	'A'-'@',255
	DB	19 DUP (0)
DN	DB	'X'-'@',255
	DB	19 DUP (0)
PGDN	DB	'F'-'@',255
	DB	19 DUP (0)
INS	DB	'V'-'@',255
	DB	19 DUP (0)
DEL	DB	'G'-'@',255
	DB	19 DUP (0)

F1	DB	'K'-'@',255
	DB	19 DUP (0)
F2	DB	'K'-'@','S',255
	DB	18 DUP (0)
F3	DB	'K'-'@','B',255
	DB	18 DUP (0)
F4	DB	'K'-'@','C',255
	DB	18 DUP (0)
F5	DB	'B'-'@',255
	DB	19 DUP (0)
F6	DB	'O'-'@','G',255
	DB	18 DUP (0)
F7	DB	'P'-'@','B',255
	DB	18 DUP (0)
F8	DB	'O'-'@','L',255
	DB	18 DUP (0)
F9	DB	'K'-'@','R',255
	DB	18 DUP (0)
F10	DB	'U'-'@',255
	DB	19 DUP (0)
SF1	DB	'K'-'@','Q',255
	DB	18 DUP (0)
SF2	DB	'Q'-'@','P',255
	DB	18 DUP (0)
SF3	DB	'K'-'@','K',255
	DB	18 DUP (0)
SF4	DB	'K'-'@','V',255
	DB	18 DUP (0)
SF5	DB	'L'-'@',255
	DB	19 DUP (0)
SF6	DB	'O'-'@','C',255
	DB	18 DUP (0)
SF7	DB	'P'-'@','S',255
	DB	18 DUP (0)
SF8	DB	'O'-'@','R',255
	DB	18 DUP (0)
SF9	DB	'K'-'@','W',255
	DB	18 DUP (0)
SF10	DB	'O'-'@','D',255
	DB	18 DUP (0)
CF1	DB	0,'^',255
	DB	18 DUP (0)
CF2	DB	0,'_',255
	DB	18 DUP (0)
CF3	DB	0,'`',255
	DB	18 DUP (0)
CF4	DB	0,'a',255
	DB	18 DUP (0)
CF5	DB	0,'b',255
	DB	18 DUP (0)
CF6	DB	0,'c',255
	DB	18 DUP (0)
CF7	DB	0,'d',255
	DB	18 DUP (0)
CF8	DB	0,'e',255
	DB	18 DUP (0)
CF9	DB	0,'f',255
	DB	18 DUP (0)
CF10	DB	0,'g',255
	DB	18 DUP (0)
AF1	DB	0,'h',255
	DB	18 DUP (0)
AF2	DB	0,'i',255
	DB	18 DUP (0)
AF3	DB	'K'-'@','H',255
	DB	18 DUP (0)
AF4	DB	0,'k',255
	DB	18 DUP (0)
AF5	DB	0,'l',255
	DB	18 DUP (0)
AF6	DB	0,'m',255
	DB	18 DUP (0)
AF7	DB	0DH,0DH,0DH,0DH,0DH,0DH,0DH,0DH,0DH
	DB	9,9,9,9,9,9,9,9,9,9,255,0
AF8	DB	'Sincerely,',0DH,0DH,0DH,0DH,0DH,255
	DB	5 DUP (0)
AF9	DB	'Patrick Swayne, HUG',255,0
AF10	DB	' Software Engineer',0DH,255,0
NOTDF1	DB	0,'E',255
NOTDF2	DB	0,'F',255
NOTDF3	DB	0,'J',255
;NOTDF4	DB	0,'L',255
NOTDF5	DB	0,'N',255

;	ALTERNATE MAPPED CHARACTER SEQUENCES

XHOME	DB	'Q'-'@','R',255
	DB	18 DUP (0)
LTBL	EQU	XHOME-HOME		;TABLE LENGTH
XUP	DB	'Q'-'@','E',255
	DB	18 DUP (0)
XPGUP	DB	'Q'-'@','C',255
	DB	18 DUP (0)
XBK	DB	'Q'-'@','S',255
	DB	18 DUP (0)
XKEY5	DB	'Q'-'@','V',255
	DB	18 DUP (0)
XFWD	DB	'Q'-'@','D',255
	DB	18 DUP (0)
XENDKEY	DB	'Q'-'@','A',255
	DB	18 DUP (0)
XDN	DB	'Q'-'@','X',255
	DB	18 DUP (0)
XPGDN	DB	'Q'-'@','F',255
	DB	18 DUP (0)
XINS	DB	0,'R',255
	DB	18 DUP (0)
XDEL	DB	'T'-'@',255
	DB	19 DUP (0)

XF1	DB	0,';',255
	DB	18 DUP (0)
XF2	DB	0,'<',255
	DB	18 DUP (0)
XF3	DB	0,'=',255
	DB	18 DUP (0)
XF4	DB	0,'>',255
	DB	18 DUP (0)
XF5	DB	0,'?',255
	DB	18 DUP (0)
XF6	DB	0,'@',255
	DB	18 DUP (0)
XF7	DB	0,'A',255
	DB	18 DUP (0)
XF8	DB	0,'B',255
	DB	18 DUP (0)
XF9	DB	0,'C',255
	DB	18 DUP (0)
XF10	DB	0,'D',255
	DB	18 DUP (0)
XSF1	DB	0,'T',255
	DB	18 DUP (0)
XSF2	DB	0,'U',255
	DB	18 DUP (0)
XSF3	DB	0,'V',255
	DB	18 DUP (0)
XSF4	DB	0,'W',255
	DB	18 DUP (0)
XSF5	DB	0,'X',255
	DB	18 DUP (0)
XSF6	DB	0,'Y',255
	DB	18 DUP (0)
XSF7	DB	0,'Z',255
	DB	18 DUP (0)
XSF8	DB	0,'[',255
	DB	18 DUP (0)
XSF9	DB	0,'\',255
	DB	18 DUP (0)
XSF10	DB	0,']',255
	DB	18 DUP (0)
XCF1	DB	0,'^',255
	DB	18 DUP (0)
XCF2	DB	0,'_',255
	DB	18 DUP (0)
XCF3	DB	0,'`',255
	DB	18 DUP (0)
XCF4	DB	0,'a',255
	DB	18 DUP (0)
XCF5	DB	0,'b',255
	DB	18 DUP (0)
XCF6	DB	0,'c',255
	DB	18 DUP (0)
XCF7	DB	0,'d',255
	DB	18 DUP (0)
XCF8	DB	0,'e',255
	DB	18 DUP (0)
XCF9	DB	0,'f',255
	DB	18 DUP (0)
XCF10	DB	0,'g',255
	DB	18 DUP (0)
XAF1	DB	0,'h',255
	DB	18 DUP (0)
XAF2	DB	0,'i',255
	DB	18 DUP (0)
XAF3	DB	0,'j',255
	DB	18 DUP (0)
XAF4	DB	0,'k',255
	DB	18 DUP (0)
XAF5	DB	0,'l',255
	DB	18 DUP (0)
XAF6	DB	0,'m',255
	DB	18 DUP (0)
XAF7	DB	0,'n',255
	DB	18 DUP (0)
XAF8	DB	0,'o',255
	DB	18 DUP (0)
XAF9	DB	0,'p',255
	DB	18 DUP (0)
XAF10	DB	0,'q',255
	DB	18 DUP (0)
XNOTDF1	DB	0,'E',255
XNOTDF2	DB	0,'F',255
XNOTDF3	DB	0,'J',255
;XNOTDF4	DB	0,'L',255
XNOTDF5	DB	0,'N',255

SCANTBL	DB	57,2,40,4,5,6,8,40,10,11,9,13,51,12,52,53
	DB	11,2,3,4,5,6,7,8,9,10,39,39,51,13,52,53
	DB	3,30,48,46,32,18,33,34,35,23,36,37,38,50,49,24
	DB	25,16,19,31,20,22,47,17,45,21,44,26,43,27,7,12
	DB	41,30,48,46,32,18,33,34,35,23,36,37,38,50,49,24
	DB	25,16,19,31,20,22,47,17,45,21,44,26,43,27,7,14

MAPFLG	DB	0			;MAPPING IN PROGRESS FLAG
MAPPTR	DW	0			;MAPPED CHARACTER POINTER
ASFLG	DB	0			;ALTERNATE SELECT FLAG
ASKEY	DB	'L'			;ALTERNATE SELECT KEY
TGLFLG	DB	1			;ON/OFF TOGGLE FLAG
TGLK	DB	'^'-'@'			;TOGGLE KEY
OFFLNK	DB	'\'-'@'			;OFF LINE KEY
INT16V	DD	0			;INT 16H VECTOR
INT10V	DD	0			;INT 10H VECTOR
INT9V	DD	0			;INT 9 VECTOR

BLMSG	DB	'F'+80H,'1'+80H,'Fil/Qt'
	DB	'F'+80H,'2'+80H,'Sv/Rst'
	DB	'F'+80H,'3'+80H,'Mark  '
	DB	'F'+80H,'4'+80H,'Cpy/Mv'
	DB	'F'+80H,'5'+80H,'Ref/Rp'
	DB	'F'+80H,'6'+80H,'Ind/Cn'
	DB	'F'+80H,'7'+80H,'Bld/Un'
	DB	'F'+80H,'8'+80H,'Margin'
	DB	'F'+80H,'9'+80H,'Br/Bw '
	DB	'1'+80H,'0'+80H,'Can/Ds'

;	THIS IS THE MAIN CODE THAT INTERCEPTS BIOS CONSOLE
;	STATUS AND INPUT CALLS (INT 16H) TO DETECT FUNCTION
;	KEYS AND MAP THE USER-DEFINED CHARACTERS TO THEM

	DB	'KM'			;IDENTIFIER
MYINT16:STI				;ENABLE OTHER INTERRUPTS
	CMP	AH,1			;STATUS CHECK?
	JZ	MYSTAT			;YES
	OR	AH,AH			;INPUT?
	JZ	MYINP			;YES
XINT16:	JMP	CS:Dword Ptr INT16V	;ELSE, JUMP TO BIOS

MYSTAT:	CMP	CS:BYTE PTR MAPFLG,0	;ARE WE MAPPING?
	JZ	XINT16			;NO, NORMAL STATUS CHECK
	PUSH	BX			;ELSE, SAVE SOME REGISTERS
	MOV	BX,CS:WORD PTR MAPPTR	;GET MAP CHARACTER POINTER
	MOV	AL,CS:BYTE PTR [BX]	;GET NEXT CHARACTER
	INC	AL			;DONE MAPPING?
	JZ	CKRST			;YES, CHECK REGULAR STATUS
	DEC	AL			;ELSE, FIX CHARACTER
	CALL	GETSCAN			;GET SCAN CODE FOR IT
	CLI				;KILL INTERRUPTS
	PUSH	BP			;SAVE BP
	MOV	BP,SP			;POINT TO STACK
	AND	Word Ptr 8[BP],1111111110111111B	;CLEAR Z FLAG
	POP	BP
	STI
	POP	BX
	IRET				;RETURN FROM INTERRUPT, CHAR READY
CKRST:	MOV	CS:BYTE PTR MAPFLG,AL	;CLEAR MAP FLAG
	POP	BX
	JMP	SHORT XINT16		;CHECK STATUS

;	MY CONSOLE INPUT ROUTINE

MYINP:	PUSH	BX			;SAVE SOME REGISTERS
	PUSH	DX
	CMP	CS:BYTE PTR MAPFLG,0	;ARE WE MAPPING?
	JZ	NMAP			;NO
	JMP	MAP			;YES, RETURN MAPPED CHARACTER
NMAP:	CALL	INCHAR			;INPUT CHARACTER
	CMP	AL,CS:BYTE PTR TGLK	;TOGGLE KEYMAP?
	JNZ	NOTGL
	JMP	TOGGLE			;GO TOGGLE KEYMAP
NOTGL:	CMP	AL,CS:BYTE PTR OFFLNK	;GO OFF LINE?
	JNZ	NOTOFL
	JMP	OFFLIN			;GO OFF LINE
NOTOFL:	CMP	AX,0E08H		;BACK SPACE?
	JNZ	NOTBS			;NO
	CMP	CS:BYTE PTR TGLFLG,0	;KEYMAP ON?
	JNZ	INTRET			;NO
	MOV	AX,0E7FH		;ELSE, REPLACE BS WITH DEL
NOTBS:	OR	AL,AL			;NULL CHARACTER?
	JZ	GOTNULL
INTRET:	POP	DX			;RESTORE REGISTERS
	POP	BX
	IRET				;RETURN FROM BIOS INTERRUPT

;	WE HAVE A NULL CHAR -- SEE IF IT'S A FUNCTION KEY

GOTNULL:CMP	CS:BYTE PTR TGLFLG,0	;TEST FOR ON/OFF TOGGLE
	JZ	KEYON			;KEYMAP IS ON
	JMP	SHORT INTRET		;ELSE, RETURN WITH CHARACTER
KEYON:	MOV	CS:BYTE PTR ASFLG,0	;CLEAR ALTERNATE SEL. FLAG
KEYON1:	MOV	BX,Offset MAPTBL	;POINT TO MAP TABLE
	CMP	AH,';'			;";" OR MORE?
	JB	INTRET			;NO, RETURN WITH CODE
	CMP	AH,'q'+1		;"q" OR LESS?
	JNB	INTRET			;NO, RETURN WITH CODE
	CMP	CS:BYTE PTR ASFLG,0	;WORKING ON ALTERNATE KEY?
	JNZ	NOAS			;IF SO, SKIP SHIFT CHECK
	CMP	AH,CS:BYTE PTR ASKEY	;IS THIS THE ALTERNATE SEL. KEY?
	JNZ	NOAS			;NO
	INC	CS:BYTE PTR ASFLG	;ELSE, SET ALTERNATE SEL. FLAG
	CALL	INCHAR			;GET SECOND KEY
	OR	AL,AL			;NULL?
	JZ	KEYON1			;IT'S NULL, GET NEXT CHARACTER
	DEC	CS:BYTE PTR ASFLG	;ELSE, CLEAR ALTERNATE SEL. FLAG
	JMP	INTRET			;RETURN WITH CHARACTER

;	IT'S A VALID FUNCTION KEY -- TURN MAPPING ON

NOAS:	INC	CS:BYTE PTR MAPFLG	;SET MAP FLAG
	SUB	AH,';'			;REMOVE ASCII FROM CHARACTER
	ADD	AH,AH			;DOUBLE IT
	XCHG	AL,AH			;NOW, AX = INDEX INTO TABLE
	ADD	BX,AX			;BX POINTS TO TABLE ENTRY
	MOV	BX,CS:[BX]		;BX POINTS TO MAP STRING
	CMP	CS:BYTE PTR ASFLG,0	;ALTERNATE FUNCTION?
	JZ	NOAS1			;NO
	ADD	BX,LTBL			;ELSE, USE SECOND TABLE
	MOV	CS:BYTE PTR ASFLG,0	;CLEAR ALTERNATE FLAG
NOAS1:	MOV	CS:WORD PTR MAPPTR,BX	;SET UP MAP POINTER

;	MAPPING ROUTINE -- SENDS A CHARACTER FROM THE USER SUPPLIED
;	STRING AS LONG AS THE SYSTEM REQUESTS KEYBOARD INPUT, UNTIL
;	THE END OF THE STRING IS REACHED.  THEN NORMAL INPUT IS
;	RESUMED

MAP:	MOV	BX,CS:WORD PTR MAPPTR	;GET MAP POINTER
	MOV	AL,CS:BYTE PTR [BX]	;GET MAPPED CHARACTER
	INC	BX			;INCREMENT POINTER
	OR	AL,AL			;NULL CHARACTER?
	JNZ	NOTCODE			;NO, NOT CODE KEY
	MOV	AH,CS:[BX]		;ELSE, GET MAPPED SCAN CODE
	INC	BX			;FIX POINTER
	JMP	SHORT CSEND		;AND EXIT
NOTCODE:CALL	GETSCAN			;GET SCAN CODE FOR CHARACTER
CSEND:	MOV	CS:WORD PTR MAPPTR,BX	;UPDATE MAP POINTER
	CMP	CS:BYTE PTR [BX],255	;END OF STRING?
	JNZ	MAPX			;NO
	MOV	CS:BYTE PTR MAPFLG,0	;ELSE, CLEAR MAP FLAG
MAPX:	JMP	INTRET			;RETURN WITH MAPPED CHARACTER

;	TOGGLE KEYMAP OFF AND ON

TOGGLE:	XOR	CS:BYTE PTR TGLFLG,1	;TOGGLE TOGGLE FLAG
	PUSHF				;SAVE RESULT OF TOGGLE
	CMP	CS:BYTE PTR BLMSG,0	;ANY BOTTOM LINE MESSAGE?
	JNZ	TOGGLE0			;YES
	POPF				;ELSE, REMOVE PUSHED FLAGS
	JMP	NMAP			;GET ANOTHER INPUT
TOGGLE0:POPF				;GET RESULT OF TOGGLE
	JZ	TOGGLE1			;TOGGLED ON, WRITE BOTTOM LINE
	PUSH	CX			;ELSE, PREPARE TO CLEAR BOTTOM LINE
	PUSH	SI
	PUSH	DI
	PUSH	BP
	MOV	AH,15
	INT	10H			;GET ACTIVE PAGE
	MOV	AH,8
	INT	10H			;GET ATTRIBUTE AT CURSOR POS.
	MOV	BH,AH			;PUT IT IN BH
	MOV	AX,600H			;GET BLANK WINDOW FUNCTION
	MOV	CX,24*256		;UPPER CORNER OF WINDOW
	MOV	DX,24*256+79		;LOWER CORNER
	INT	10H			;BLANK 24TH LINE
	POP	BP
	POP	DI
	POP	SI
	POP	CX
	STI
	JMP	NMAP			;GET ANOTHER INPUT
TOGGLE1:PUSH	DI
	PUSH	BP
	PUSH	CX
	CALL	PBMSG			;PRINT BOTTOM MSG
	POP	CX
	POP	BP
	POP	DI
	STI
	JMP	NMAP			;GET ANOTHER CHARACTER

;	PRINT BOTTOM MESSAGE AND FIX INT 10H VECTOR

PBMSG:	PUSH	SI			;SAVE SOME REGISTERS
	PUSH	DS
	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	AH,15
	INT	10H			;GET ACTIVE PAGE
	MOV	AH,3
	INT	10H			;GET CURSOR POSITION
	PUSH	DX			;SAVE IT
	CMP	DH,24			;CURSOR ON BOTTOM?
	JNZ	NOTBOT			;NO
	POP	DX			;ELSE, GET IT AGAIN
	DEC	DH			;MOVE IT UP ONE
	PUSH	DX			;SAVE AGAIN
	MOV	AH,8
	INT	10H			;GET CURRENT ATTRIBUTE
	PUSH	BX			;SAVE ACTIVE PAGE
	MOV	BH,AH			;ATTRIBITE TO BH
	MOV	AX,6*256+1		;FUNC. 6, 1 LINE
	MOV	CX,0			;SCROLL FROM UPPER LEFT
	MOV	DX,24*256+79		;TO LOWER RIGHT
	PUSHF
	CALL	DWORD PTR INT10V	;SCROLL SCREEN UP
;	INT	10H			;SCROLL SCREEN UP
	POP	BX			;RESTORE ACTIVE PAGE
NOTBOT:	MOV	DX,24*256		;SET CURSOR TO BOTTOM LINE
	PUSH	DX			;SAVE IT
	MOV	SI,Offset BLMSG		;POINT TO BOTTOM LINE MSG
	MOV	CX,80			;WRITE 80 CHARACTERS
	CLD				;ENSURE FORWARD STRING DIRECTION
	POP	DX			;GET CURSOR POSITION
PBLP:	LODSB				;GET A CHARACTER
	PUSH	CX			;SAVE COUNTER
	PUSH	SI			;SAVE POINTER
	PUSH	DX			;SAVE CURSOR POSITION
	PUSH	AX			;SAVE CHARACTER
	MOV	AH,2
	INT	10H			;SET CURSOR POSITION
	POP	AX			;GET CHARACTER
	POP	DX
	INC	DL			;UPDATE POSITION
	PUSH	DX
	MOV	BL,7			;ASSUME NORMAL VIDEO
	OR	AL,AL			;TEST CHARACTER
	JNS	NORVID			;IT'S NORMAL
	MOV	BL,0FH			;ELSE, SET INTENSE VIDEO
	AND	AL,7FH			;STRIP MARKER BIT
NORVID:	MOV	CX,1			;WRITE 1 CHARACTER
	MOV	AH,9
	INT	10H			;WRITE CHARACTER
	POP	DX
	POP	SI
	POP	CX
	LOOP	PBLP			;LOOP UNTIL DONE
	POP	DX			;GET OLD CURSOR POSITION
	MOV	AH,2
	INT	10H			;SET IT
	POP	DS			;RESTORE DS
	POP	SI			;AND SI
	RET

;	TAKE "TERMINAL" OFF LINE

OFFLIN:	CALL	INCHAR			;GET A CHARACTER
	CMP	AL,CS:BYTE PTR OFFLNK	;GO BACK ON LINE?
	JZ	ONLIN			;YES
	MOV	AH,14
	MOV	BX,0
	PUSH	SI
	PUSH	DI
	PUSH	BP
	INT	10H			;SEND CHARACTER
	POP	BP
	POP	DI
	POP	SI
	JMP	SHORT OFFLIN		;GO AROUND AGAIN
ONLIN:	JMP	NMAP			;CONTINUE WHERE WE LEFT OFF

;	GET SCAN CODE FOR MAPPED CHARACTER

GETSCAN:CMP	AL,9			;TAB
	MOV	AH,15			;ASSUME IT IS
	JZ	GETSCX			;IT IS
	CMP	AL,0DH			;CR?
	MOV	AH,28			;ASSUME IT IS
	JZ	GETSCX
	CMP	AL,0AH			;LF?
	MOV	AH,28			;USE RET KEY
	JZ	GETSCX
	PUSH	DS			;NOT SPECIAL CASE, SAVE DS
	PUSH	CS
	POP	DS			;PUT DS HERE
	PUSH	BX			;SAVE BX
	PUSH	AX			;AND CHAR
	MOV	BX,Offset SCANTBL	;POINT TO SCAN TABLE
	CMP	AL,' '			;LESS THAN SPACE?
	JNB	GETSC1			;NO
	ADD	AL,'@'			;ELSE, CONTROL CHAR, CONVERT
GETSC1:	XLAT				;GET SCAN CODE FROM TABLE
	MOV	BL,AL			;SAVE CODE IN BL
	POP	AX			;RESTORE CHARACTER
	MOV	AH,BL			;PUT SCAN CODE IN AH
	POP	BX
	POP	DS
GETSCX:	RET

;	INPUT CHARACTERS FROM KEYBOARD, BYPASSING KEYMAP CHECKS

INCHAR:	MOV	AH,1
	PUSHF
	CALL	CS:DWORD PTR INT16V	;CHECK STATUS
	JNZ	GOTCHAR			;GOT A KEY
	INT	28H			;RUN BACKGROUND PROCESSES
	JMP	INCHAR
GOTCHAR:XOR	AH,AH
	PUSHF				;FAKE INT CALL
	CALL	CS:DWORD PTR INT16V	;CALL INT 16 ROUTINE
	RET

;	SCREEN OUTPUT PROCESSOR, THAT PROTECTS 25TH LINE

MYOUT:	CMP	CS:BYTE PTR TGLFLG,1	;KEYMAP ON?
	JZ	MYOUTX			;IF NOT, EXIT
	CMP	CS:BYTE PTR BLMSG,0	;ANY BOTTOM LINE MESSAGE?
	JZ	MYOUTX			;IF NOT, EXIT
	STI				;TURN INTERRUPTS ON
	PUSH	SI			;ELSE, SAVE SOME REGISTERS
	PUSH	DI
	PUSH	BP
	PUSH	BX
	PUSH	CX
	PUSH	DX
	CMP	AH,6			;BLANK?
	JZ	MYBLNK			;YES, CHECK IT
	CMP	AH,7			;OTHER BLANK?
	JZ	MYBLNK
	CMP	AH,0			;CHANGE MODE?
	JZ	MYMODE
	CMP	AX,0E0AH		;TTY FUNC., LF?
	JZ	MYLF			;YES
MYOUT0:	POP	DX
	POP	CX
	POP	BX
	POP	BP
	POP	DI
	POP	SI
MYOUTX:	JMP	CS:DWORD PTR INT10V	;LET BIOS PROCESS CHAR
MYBLNK:	CMP	AL,0			;BLANK ENTIRE WINDOW?
	JZ	FUNCOK			;YES, DO IT HERE
	CMP	AL,25			;BLANK 25 LINES?
	JB	MYOUT0			;NO
	JMP	SHORT FUNCOK		;DO FUNC., RESTORE 25TH LINE
MYMODE:	CMP	AL,7			;MONO CARD?
	JZ	FUNCOK			;OK
	CMP	AL,2			;80 COL BW?
	JZ	FUNCOK
	CMP	AL,3			;80 COL COLOR?
	JNZ	MYOUT0			;ANOTHER MODE
FUNCOK:	PUSHF
	CALL	CS:DWORD PTR INT10V	;MAKE THE CHANGE
	CALL	PBMSG			;FIX BOTTOM MESSAGE
	JMP	SHORT MYX
MYLF:	MOV	AH,15
	INT	10H			;GET ACTIVE PAGE
	MOV	AH,3			;GET CURSOR POSITION
	INT	10H
	MOV	AX,14*256+10		;REPLACE FUNC #, CHAR
	CMP	DH,23			;IF LINE <24 THEN NORMAL LF
	JL	MYOUT0
	JE	SCROL24			;IF LINE = 24 THEN SCROLL 1-24
MYX:	POP	DX			;RESTORE REGISTERS
	POP	CX
	POP	BX
	POP	BP
	POP	DI
	POP	SI
	IRET				;IF LINE = 25 THEN IGNORE LF
SCROL24:MOV	AH,8
	INT	10H			;READ CHAR ATTRIBUTE
	MOV	BH,AH			;ATTRIBUTE TO BH
	MOV	AX,6*256+1		;SCROLL FUNCTION (6), 1 LINE
	MOV	CX,0			;UPPER LEFT SCROLL POSITION
	MOV	DX,23*256+79		;LOWER RIGHT CORNER
	PUSHF
	CALL	CS:DWORD PTR INT10V
	JMP	SHORT MYX		;AND RETURN

;	KEYBOARD INTERRUPT PROCESSOR
;	WE PROCESS THESE INTERRUPTS TO CAUSE THE KEYPAD 5 KEY
;	WITH NUMLOCK OFF, OR SHIFTED KEYPAD 5 WITH NUMLOCK ON
;	TO PRODUCE A CODE.

KEYPROC:CMP	CS:TGLFLG,1		;KEYMAP ON?
	JZ	KEYPRX1			;IF NOT, EXIT
	PUSH	AX
	IN	AL,60H			;READ KEY
	CMP	AL,4CH			;KEYPAD 5 KEY?
	JNZ	KEYPRX			;IF NOT, EXIT
KEYOK:	MOV	AH,AL			;KEY TO AH
	PUSH	BX			;SAVE SOME REGISTERS
	PUSH	SI
	PUSH	DS
	MOV	BX,40H
	MOV	DS,BX			;POINT TO BIOS RAM
	MOV	AL,KEYFLG		;GET KEY FLAG
	AND	AL,23H			;NUMLOCK OR SHIFT ON?
	JZ	MAKS5			;IF NOT, MAKE CODE
	CMP	AL,20H			;NUMLOCK ON, SHIFT OFF?
	JZ	NOCODE			;NO CODE
	CMP	AL,4			;SHIFT KEY(S) ONLY?
	JB	NOCODE			;IF SO, NO CODE
MAKS5:	MOV	AX,4C00H		;GET CODE FOR SHIFT-5
	MOV	BX,TYHPTR		;GET TYPE-AHEAD POINTER
	MOV	SI,BX			;IN SI, TOO
	INC	BX			;POINT TO NEXT POSITION
	INC	BX
	CMP	BX,3EH			;AT END OF BUFFER?
	JNZ	NBEND			;NO
	MOV	BX,1EH			;ELSE, POINT TO BEGINNING
NBEND:	CMP	BX,SI			;BUFFER FULL?
	JZ	NOCODE
	MOV	WORD PTR [SI],AX	;ELSE INSERT KEY CODE
	MOV	TYHPTR,BX		;UPDATE POINTER
NOCODE:	POP	DS
	POP	SI
	POP	BX
KEYPRX:	POP	AX
KEYPRX1:JMP	CS:DWORD PTR INT9V	;LET ROM FINISH PROCESS

LEND:					;END OF RESIDENT CODE

;	SET UP FOR KEY MAPPING BY VECTORING BIOS CONSOLE STATUS
;	AND INPUT ROUTINES TO THIS PROGRAM

SETUP:	MOV	AH,15
	INT	10H			;READ VIDEO STATE
	CMP	AH,15			;AH CHANGED?
	JNZ	GDSYS			;YES, GOOD SYSTEM
	MOV	DX,Offset BSMSG
	MOV	AH,TYPEF
	INT	21H			;ELSE, SAY "BAD SYSTEM"
	INT	20H			;AND EXIT
GDSYS:	XOR	AX,AX
	MOV	DS,AX			;POINT TO BOTTOM SEGMENT
	MOV	SI,16H*4		;POINT TO INPUT VECTOR
	PUSH	SI
	LES	DI,Dword Ptr [SI]	;GET ROUTINE ADDRESS
	CMP	Word Ptr ES:-2[DI],'MK'	;TEST FOR KEYMAP ALREADY IN
	JZ	ITSIN			;IT'S IN, EXIT
	MOV	DI,Offset INT16V	;POINT TO KEYMAP EXIT
	PUSH	CS
	POP	ES			;PUT ES HERE
	CLD				;ENSURE FORWARD DIRECTION
	MOVSW				;MOVE INPUT VECTOR TO KEYMAP
	MOVSW
	POP	SI
	MOV	Word Ptr [SI],Offset MYINT16	;ALTER VECTOR TO HERE
	MOV	2[SI],CS
	MOV	SI,10H*4		;POINT TO INT 10H VECTOR
	MOV	DI,Offset INT10V	;WHERE TO PUT IT
	PUSH	SI
	MOVSW				;PUT IT THERE
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET MYOUT	;ALTER VECTOR TO HERE
	MOV	2[SI],CS
	MOV	SI,9*4			;POINT TO KEYBOARD INT VECTOR
	PUSH	SI
	MOV	DI,OFFSET INT9V		;PUT IT HERE
	MOVSW
	MOVSW				;MOVE VECTOR
	POP	SI
	MOV	WORD PTR [SI],OFFSET KEYPROC	;ALTER VECTOR
	MOV	2[SI],CS
	PUSH	CS
	POP	DS			;RESTORE DS
;	CMP	BYTE PTR BLMSG,0	;ANY BOTTOM LINE MESSAGE?
;	JZ	NMSG			;NO
;	CALL	PBMSG			;PRINT BOTTOM LINE MSG
NMSG:	MOV	DX,Offset SIGNON
	MOV	AH,TYPEF
	INT	21H			;PRINT SIGN ON MESSAGE
	MOV	DX,Offset LEND		;SET DX
	INT	27H			;TERMINATE, BUT STAY RESIDENT
ITSIN:	MOV	AX,CS
	MOV	DS,AX			;RESTORE DX
	MOV	DX,Offset INMSG
	MOV	AH,TYPEF
	INT	21H			;SAY "ALREADY LOADED"
	INT	20H			;AND EXIT

SIGNON	DB	13,10
	DB	'Z-150 KEYMAP Function Key Mapper, Version 1.1'
	DB	' (by PS:) is now installed.$'
INMSG	DB	13,10
	DB	'ERROR -- KEYMAP is already installed.$'
BSMSG	DB	13,10
	DB	'ERROR -- Incompatible computer system.  '
	DB	'Can',27H,'t run Z-150 KEYMAP.$'

KEY	ENDS
	END	START
