; BINHEX
;
; Utility to convert .COM or other binary files
; to Intel HEX format.
;
; by P. Swayne, HUG    24-Jul-81
;	Adapted from IHEX from 885-1089
;	MS-DOS TRANSLATION 01-DEC-87
;	THIS VERSION USES STANDARD I/O

M	EQU	BYTE PTR 0[BX]
CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	5CH
FCB	LABEL	BYTE			;DEFINE FCB
	ORG	80H
DTA	LABEL	BYTE			;DEFINE DTA
	ORG	100H
START:	MOV	DI,OFFSET DTA		;POINT TO DTA ADDRESS
	MOV	AL,[DI]			;GET CHARACTER COUNT
	OR	AL,AL			;ANY ARGUMENT?
	JNZ	GOTARG			;YES
	MOV	DX,OFFSET EXPL
	MOV	AH,9
	INT	21H			;ELSE, EXPLAIN PROGRAM
	INT	20H			;AND EXIT
GOTARG:	INC	DI
	XOR	AH,AH			;AX = COUNT
	MOV	CX,AX			;IN CX
	MOV	AL,'/'			;SEARCH FOR SWITCH CHARACTER
	CLD
	REPNZ	SCASB
	JNZ	TRANST			;NONE FOUND
	MOV	SI,DI
	CALL	HEXIN			;ELSE, GET IT
	MOV	STADR,BX		;SAVE IT
	MOV	OUTADR,BX		;HERE, TOO

; PREPARE FOR TRANSLATION

TRANST:

; Start a hex record.

TRAN:	XOR	AL,AL
	MOV	BYTE PTR CHKSUM,AL
	MOV	AL,':'			;INSERT RECORD START MARK
	CALL	WRTCH

; Calculate and output record length.

CHEOF:	CALL	GET16			;GET 16 BYTES
	OR	CH,CH			;DONE?
	JZ	TRAN04
	MOV	AL,CH			;COUNT TO AL
TRAN01:	CALL	OBYTE			;Output length

; Output address pointer.

	MOV	BX,WORD PTR OUTADR
	MOV	AL,BH
	CALL	OBYTE			;Output msb's
	MOV	AL,BL
	CALL	OBYTE			;and lsb's

; OUTPUT DATA TYPE.

	XOR	AL,AL
	CALL	OBYTE

; Output data bytes.

	MOV	SI,OFFSET (BUFF16)
TRAN02:	LODSB				;GET A BYTE
	CALL	OBYTE			;Output byte
	INC	WORD PTR OUTADR		;Increment file address

; Check byte count.

	DEC	CH			;COUNT BYTE
	JNZ	TRAN02			;NOT DONE

; Finish up the data record with checksum.

TRAN03:	MOV	AL,BYTE PTR CHKSUM
	CALL	OBYTE			;Output the checksum
	MOV	AL,13
	CALL	WRTCH			;WRITE A CR
	MOV	AL,10
	CALL	WRTCH			;WRITE A LF
	JMP	TRAN			;and send another record

; Output the ending record.

TRAN04:	XOR	AL,AL
	CALL	OBYTE			;Show "last record"
	MOV	BX,STADR		;GET START ADDRESS
	MOV	AL,BH
	CALL	OBYTE			;Output start addr msb's
	MOV	AL,BL
	CALL	OBYTE			;and lsb's
	MOV	AL,1
	CALL	OBYTE			;Show end-of-file
	MOV	AL,BYTE PTR CHKSUM
	CALL	OBYTE			;and checksum
	MOV	AL,13
	CALL	WRTCH			;WRITE A CR
	MOV	AL,10
	CALL	WRTCH			;WRITE A LF

; DONE

TRAN05:	MOV	DX,OFFSET CONNAM	;POINT TO "CON" NAME
	MOV	CX,0
	MOV	AX,3D01H		;OPEN FOR WRITING
	INT	21H
	JC	EXIT			;OOPS, CAN'T DISPLAY MSG
	MOV	BX,AX			;HANDLE TO BX
	MOV	DX,OFFSET COMPL		;POINT TO "DONE" MSG
	MOV	CX,COMPLZ
	MOV	AH,40H
	INT	21H			;SAY "DONE"
EXIT:	INT	20H			;RETURN TO DOS

; Subroutine to Output one BYTE. Adds to checksum and
; converts to hex.
;	Input	   (A) = Byte to move
;	Output     to Std Output

OBYTE:	MOV	CL,AL
	SUB	BYTE PTR CHKSUM,AL	;UPDATE CHECKSUM

; Convert msb's to hex.

	MOV	AL,CL
	AND	AL,11110000B
	RCR	AL,1
	RCR	AL,1
	RCR	AL,1
	RCR	AL,1
	CALL	CONHEX
	CALL	WRTCH			;Output a nibble
	MOV	AL,CL
	AND	AL,00001111B
	CALL	CONHEX
	CALL	WRTCH			;Output another nibble
	RET

;	WRITE A CHARACTER TO STD OUTPUT

WRTCH:	PUSH	BX
	PUSH	CX
	MOV	OUTBUF,AL		;PUT CHARACTER IN BUFFER
	MOV	DX,OFFSET OUTBUF	;POINT TO IT
	MOV	BX,1			;USE STD OUTPUT
	MOV	CX,1			;WRITE ONE CHARACTER
	MOV	AH,40H
	INT	21H			;WRITE CHARACTER
	POP	CX
	POP	BX
	RET

; Subroutine to convert a 4-bit nibble to
; ASCII hex

CONHEX:	ADD	AL,90H
	DAA
	ADC	AL,40H
	DAA
	RET

; Get 16 (or all remaining) bytes from input file
; Store them in a special buffer.  CH = bytes input.

GET16:	MOV	DX,OFFSET (BUFF16)	;POINT TO 16-BYTE BUFFER
	MOV	CH,0			;CLEAR A COUNTER
GETLP:	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	BX,0			;USE STD INPUT
	MOV	CX,1			;READ ONE CHARACTER
	MOV	AH,3FH
	INT	21H			;READ FROM STD INPUT
	POP	DX
	POP	CX
	POP	BX
	INC	DX			;MOVE BUFFER POINTER
	OR	AX,AX			;ANYTHING READ?
	JZ	GETEND			;NO
	INC	CH
	CMP	CH,16			;16 BYTES READ?
	JNZ	GETLP
GETEND:	RET

;	INPUT ASCII HEX NUMBERS. SI POINTS TO STRING.
;	RESULT IN BX.

HEXIN:	XOR	BX,BX			;CLEAR ACCUMULATOR
HEXLP:	LODSB				;GET DIGIT
	SUB	AL,'0'			;REMOVE ASCII
	JC	HEXEND			;LESS THAN "0"
	ADD	AL,'0'-'G'
	JC	HEXEND			;MORE THAN "F"
	ADD	AL,6			;TEST FOR A-F
	JNS	HEXOK			;DIGIT IS A-F
	ADD	AL,7			;TEST FOR 0-9
	JC	HEXEND			;DIGIT OUT OF RANGE
HEXOK:	ADD	AL,10			;ELSE, ADJUST
	PUSH	AX			;SAVE DIGIT
	MOV	AX,BX
	MOV	DX,16
	MUL	DX			;MULTIPLY ACCUMULATOR BY 16
	MOV	BX,AX
	POP	AX
	OR	BL,AL			;ADD IN LATEST DIGIT
	JMP	HEXLP			;GET ANOTHER ONE
HEXEND:	RET

; Buffer areas and variables.

EXPL	DB	13,10,'To use this program, enter',13,10,10
	DB	'  BINHEX <BinaryFilePath >HexFilePath[/addr]',13,10,10
	DB	'where addr is the starting address to be',13,10
	DB	'used in the hex file.  If no address is',13,10
	DB	'specified, 100H is used.',13,10,'$'
COMPL 	DB	13,10,'Conversion complete.',13,10
COMPLE	LABEL	NEAR
COMPLZ	EQU	COMPLE-COMPL

CONNAM	DB	'CON',0
CHKSUM 	DB	0			;Checksum accumulator
BUFF16 	DB	16 DUP (?)		;Buffer for 16 bytes
OUTBUF	DB	0			;SINGLE CHARACTER OUTPUT BUFFER
STADR	DW	100H			;STARTING ADDRESS OF FILE
OUTADR 	DW	100H			;OUTPUT ADDRESS POINTER

CODE	ENDS
	END	START
