	PAGE	,132
;	THIS PROGRAM PRINTS THE CODE OF ANY KEY PRESSED
;	Z-100 VERSION
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  26-AUG-88

TRUE	EQU	0FFFFH			;DEFINE TRUE
FALSE	EQU	NOT TRUE		;AND FALSE
BIOSCOD	EQU	TRUE			;SHOW BIOS KEY CODES

BIOS	SEGMENT AT 40H
	ORG	3
CONST	LABEL	FAR			;DEFINE BIOS CONSOLE STATUS
	ORG	6
CONIN	LABEL	FAR			;DEFINE BIOS CONSOLE INPUT
	ORG	9
CONOUT	LABEL	FAR			;DEFINE BIOS CONSOLE OUTPUT
	ORG	24H
GETDATE	LABEL	FAR			;DEFINE BIOS GETDATE
BIOS	ENDS

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;PRINT SIGN-ON
	MOV	AX,3550H
	INT	21H			;GET INT 50 VECTOR
	MOV	INT50V,BX		;SAVE IT
	MOV	INT50V+2,ES
	PUSH	CS
	POP	ES			;FIX ES
	MOV	AX,2550H
	MOV	DX,OFFSET INT50
	INT	21H			;VECTOR KEYBOARD TO HERE
WLOOP:	CMP	BYTE PTR INTFLG,1	;HAS A KEY BEEN HIT
	JNZ	WLOOP			;IF NOT, WAIT FOR KEY
	MOV	BYTE PTR INTFLG,0	;ELSE, CLEAR INT FLAG
	MOV	DX,OFFSET KEYMSG
	CALL	PMSG			;SAY "KEYCODE IS"
	MOV	AL,KEYCODE		;GET THE KEY CODE
	CALL	HEXOUT
	MOV	DX,OFFSET DECMSG	;SAY "IN DECIMAL"
	CALL	PMSG
	MOV	BL,KEYCODE		;GET KEY CODE AGAIN
	XOR	BH,BH			;IN BX
	CALL	DECOUT			;PRINT IT
	CALL	CONST			;ANY BIOS CODE
	JZ	DOCRLF			;NO
	MOV	DX,OFFSET BIOSMSG
	CALL	PMSG			;PRINT BIOS MESSAGE
BIOSLP:	CALL	CONIN			;ELSE, GET A CODE
	PUSH	AX			;SAVE IT
	CALL	HEXOUT			;PRINT IT IN HEX
	MOV	AL,'('
	CALL	CONOUT			;PRINT "("
	POP	AX
	MOV	BL,AL
	XOR	BH,BH			;BX = CODE
	CALL	DECOUT			;PRINT CODE IN DECIMAL
	CALL	CONST			;ANY MORE CODES?
	JZ	BIOSDN			;NO
	MOV	DX,OFFSET PARSP		;ELSE, PRINT PARENTHESIS, SPACE
	CALL	PMSG
	JMP	BIOSLP			;GET OTHER CODES
BIOSDN:	MOV	AL,')'
	CALL	CONOUT			;PRINT LAST PARENTHESIS
DOCRLF:	MOV	DX,OFFSET CRLF
	CALL	PMSG			;PRINT CR, LF
	CMP	BL,1BH			;WAS LAST KEY ESCAPE?
	JZ	QUIT			;IF SO, QUIT
	JMP	WLOOP			;AND WAIT FOR MORE KEYS

QUIT:	MOV	DX,INT50V		;GET OLD KEY VECTOR
	MOV	DS,INT50V+2
	MOV	AX,2550H
	INT	21H			;FIX KEYBOARD VECTOR
	INT	20H

;	KEYBOARD INTERRUPT PROCESSOR

INT50:	MOV	CS:BYTE PTR KEYCODE,AL	;STORE KEY CODE
	MOV	CS:BYTE PTR INTFLG,1	;SIGNAL KEY INTERRUPT RECEIVED
	JMP	CS:DWORD PTR INT50V	;GO TO OTHER PROCESSORS

;	PRINT AL IN HEX

HEXOUT:	PUSH	AX
	AND	AL,0F0H
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1			;MOVE HIGH NIBBLE DOWN
	CALL	CVTNIB			;PRINT IT
	POP	AX
	AND	AL,0FH
CVTNIB:	ADD	AL,90H			;CONVERT TO HEX ASCII
	DAA
	ADC	AL,40H
	DAA
	CALL	CONOUT
	RET

;	DECOUT - PRINT BX IN DECIMAL
;	THIS IS A TRICKY ROUTINE THAT MAKES USE OF THE
;	STACK TO STORE DECODED DIGITS.

DECOUT:	PUSH	CX
	PUSH	DX
	PUSH	BX			;SAVE REGISTERS
	MOV	CX,10			;RADIX FOR CONVERSION
	MOV	DX,0
	MOV	AX,BX
	DIV	CX			;DIVIDE BY 10
	MOV	BX,AX			;ANSWER TO BX (DX [REMAINDER] = DIGIT)
	CMP	BX,0			;DONE?
	JZ	DEC1	
	CALL	DECOUT			;CALL RECURSIVELY UNTIL DONE
DEC1:	ADD	DL,'0'			;ADD ASCII BIAS
	MOV	AL,DL
	CALL	CONOUT			;PRINT DIGIT
	POP	BX			;RESTORE REGISTERS
	POP	DX
	POP	CX
	RET

;	PRINT MESSAGE WITHOUT USING DOS

PMSG:	PUSH	SI
	MOV	SI,DX			;POINT TO STRING
	CLD
PMSGLP:	LODSB				;GET A CHARACTER
	CMP	AL,'$'			;END OF STRING?
	JZ	PMSGX			;YES
	CALL	CONOUT			;ELSE, PRINT CHARACTER
	JMP	PMSGLP
PMSGX:	POP	SI
	RET

KEYCODE	DB	0			;SAVED KEY CODE
INTFLG	DB	0			;KEY INTERRUPT FLAG
INT50V	DW	0,0			;INT 50 VECTOR

SIGNON	DB	13,10,'HUG Z-100 Keyboard Code Reporter, v. 1.0',13,10,10,'$'
KEYMSG	DB	13,10,'Keyboard interrupt code: $'
DECMSG	DB	', in decimal: $'
BIOSMSG	DB	13,10,'BIOS keyboard code(s) returned: $'
PARSP	DB	'), $'
CRLF	DB	13,10,'$'

CODE	ENDS
	END	START
