	PAGE	,132
;	THIS PROGRAM SETS THE SCREEN COLOR
;	TO USER-SUPPLIED VALUES.
;
;	TO USE THIS PROGRAM, ENTER
;
;	  COLOR F,B
;
;	WHERE F IS THE FOREGROUND COLOR, AND
;	B IS THE BACKGROUND COLOR.
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  11-FEB-88

BIOS	SEGMENT AT 40H
	ORG	0
JMPTBL	LABEL	BYTE		;DEFINE Z-100 JUMP TABLE
BIOS	ENDS

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	5DH
ARG1	LABEL	WORD		;DEFINE ARGUMENT 1
	ORG	6DH
ARG2	LABEL	WORD		;DEFINE ARGUMENT 2
	ORG	100H


START:	MOV	AX,40H
	MOV	DS,AX		;POINT TO BIOS RAM
	ASSUME	DS:BIOS
	CMP	JMPTBL,0E9H	;CHECK FOR JUMP TABLE
	PUSH	CS
	POP	DS		;FIX DS
	ASSUME	DS:CODE
	JNZ	NOTZ		;NOT Z-100
	MOV	BYTE PTR ZFLG,1	;ELSE, MARK IT
NOTZ:	MOV	AX,ARG1		;GET ARGUMENT 1
	CMP	AL,' '		;ANYTHING THERE?
	JNZ	GOTARG		;YES
NOARG:	MOV	DX,OFFSET EXPL
	MOV	AH,9
	INT	21H		;SHOW EXPLANATION MSG
	MOV	DX,OFFSET ZCOL	;ASSUME Z-100
	CMP	BYTE PTR ZFLG,1
	JZ	SHOWZ		;SHOW Z-100 COLORS
	MOV	DX,OFFSET PCCOL
SHOWZ:	MOV	AH,9
	INT	21H		;SHOW COLORS
	INT	20H		;AND EXIT
GOTARG:	CALL	CONBIN		;CONVERT TO BINARY
	MOV	BH,AL		;FOREGROUND TO BH
	MOV	AX,ARG2		;GET ARGUMENT 2
	CMP	AL,' '		;ANYTHING THERE
	JZ	NOARG		;IF NOT, EXIT
	CALL	CONBIN		;CONVERT TO BINARY
	MOV	BL,AL		;BACKGROUND TO BL
	CMP	BYTE PTR ZFLG,1	;IS IT A Z-100?
	JZ	GOTZ		;IT'S A Z-100
	MOV	CL,4
	SHL	BL,CL		;SHIFT BACKGROUND UP
	OR	BH,BL		;ADD RESULT TO FOREGROUND
	MOV	CX,0		;UPPER CORNER
	MOV	DX,24*256+79	;LOWER CORNER
	MOV	AX,600H		;CLEAR ENTIRE PAGE
	INT	10H		;CLEAR PAGE WITH NEW COLOR
	MOV	DX,0
	MOV	BH,0
	MOV	AH,2
	INT	10H		;HOME CURSOR
	INT	20H		;AND EXIT
GOTZ:	MOV	AX,BX		;COLORS TO AX
	AND	AX,707H		;ENSURE THEY ARE IN RANGE
	MOV	BX,OFFSET COLMAP
	XLAT			;MAP BACKGROUND COLORS
	XCHG	AL,AH		;SWAP BGND, FGND
	XLAT			;MAP FOREGROUND COLORS
	ADD	AX,'00'		;ADD ASCII OFFSET
	MOV	COLOR,AX	;STORE COLOR IN STRING
	MOV	DX,OFFSET COLSTR ;POINT TO COLOR STRING
	MOV	AH,9
	INT	21H		;SET COLOR
	INT	20H		;AND EXIT

CONBIN:	CMP	AH,' '		;SINGLE DIGIT?
	JNZ	GOT2D		;NO
	SUB	AL,'0'		;ELSE, REMOVE ASCII
	RET			;AND RETURN
GOT2D:	SUB	AH,'0'		;FIX LOW DIGIT
	MOV	AL,10		;ASSUME NOT > 19
	ADD	AL,AH		;ADD LOW DIGIT
	AND	AL,0FH		;ENSURE <= 15
	RET

ZFLG	DB	0

EXPL	DB	13,10,'This program is used to set the screen colors.',13,10
	DB	'To use it, enter',13,10,10
	DB	'  COLOR F,B',13,10,10
	DB	'where F is the foreground color you want, and',13,10
	DB	'B is the background color.  Available colors are:',13,10,10,'$'
PCCOL	DB	'0  black     4  red       8  dk gray   12  br red',13,10
	DB	'1  blue      5  magenta   9  br blue   13  br magenta',13,10
	DB	'2  green     6  brown    10  br green  14  yellow',13,10
	DB	'3  cyan      7  gray     11  br cyan   15  white',13,10,10
	DB	'Use 0-7 only for the background color.',13,10,'$'
ZCOL	DB	'0  black     4  red',13,10
	DB	'1  blue      5  magenta',13,10
	DB	'2  green     6  yellow',13,10
	DB	'3  cyan      7  white',13,10,'$'
COLMAP	DB	0,1,4,5,2,3,6,7 ;Z-100 TO PC COLOR MAP
COLSTR	DB	27,'m'
COLOR	DW	0
	DB	27,'E',13,'$'
CODE	ENDS
	END	START
