	PAGE	,132
;	CAPCON -- A SOFTWARE FIX FOR THE MISPLACED
;	CAPS LOCK AND CONTROL KEYS.  TO USE THIS PROGRAM,
;	ENTER
;
;	CAPCON		TO INSTALL OR ENABLE IT
;	CAPCON D	TO DIS-ABLE IT
;	CAPCON U	TO UN-INSTALL IT (MUST BE LAST TSR)
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  14-SEP-88
;	COPYRIGHT (C) HEATH/ZENITH USERS' GROUP 1988.
;	ALL RIGHTS RESERVED.

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

;	DEFINE SOME MEMORY LOCATIONS

	ORG	1
PSPSEG	LABEL	WORD			;PROGRAM SEGMENT PREFIX SEGMENT ADDR.
	ORG	3
MCBSIZE	LABEL	WORD			;MEMORY CONTROL BLOCK SIZE
	ORG	2CH
ENVSEG	LABEL	WORD			;ENVIRONMENT SEGMENT
	ORG	5DH
FCBARG	LABEL	BYTE			;FCB ARGUMENT
	ORG	100H

START:	JMP	SETUP			;GO SET UP PROGRAM
	EVEN
SIG	DB	'CAPCON 1.1'		;PROGRAM SIGNATURE

ENFLG	DB	1			;ENABLE FLAG
INT15V	DW	0,0			;INT 15H VECTOR
INT28V	DW	0,0			;INT 28H VECTOR
KEYHB	DB	0			;KEY HIGH BIT
E0FLG	DB	0			;KEYCODE E0 FLAG

;	INT 15H PROCESSOR. KEYS ARE SWAPPED HERE

INT15:	CMP	AH,4FH			;IS THIS A KEY PRESS?
	JZ	GOTKEY			;YES
	JMP	CS:DWORD PTR INT15V	;ELSE, GO ON
GOTKEY:	CMP	CS:ENFLG,1		;CAPCON ENABLED?
	JNZ	INT15X			;IF NOT, EXIT
	CMP	AL,0E0H			;WAS CODE E0?
	JNZ	NOTE0			;NO
	MOV	CS:E0FLG,1		;ELSE, MARK IT
	JMP	SHORT INT15X		;AND EXIT
NOTE0:	PUSH	AX			;SAVE KEY CODE
	AND	AL,80H			;ISOLATE HIGH BIT
	MOV	CS:KEYHB,AL		;SAVE IT
	POP	AX			;GET KEY CODE
	AND	AL,7FH			;STRIP HIGH BIT
	CMP	AL,1DH			;CTRL KEY?
	JNZ	NOTCTL			;NO
	CMP	CS:E0FLG,1		;RIGHT CTRL KEY PRESSED?
	JZ	FIXHB			;IF SO, DON'T ALTER IT
	MOV	AL,3AH			;REPLACE WITH CAPS LOCK
	JMP	SHORT FIXHB		;AND FIX HIGH BIT
NOTCTL:	CMP	AL,3AH			;CAPS LOCK KEY?
	JNZ	FIXHB			;NO
	MOV	AL,1DH			;REPLACE WITH CTRL
FIXHB:	OR	AL,CS:KEYHB		;RESTORE HIGH BIT
	MOV	CS:E0FLG,0		;CLEAR E0 FLAG
INT15X:	IRET				;RETURN WITH FIXED KEY

;	INT 28H PROCESSOR.  USED FOR UN-INSTALLING CAPCON.

INT28:	CMP	CS:ENFLG,2		;UN-INSTALL CAPCON?
	JZ	UNINS			;YES
	JMP	CS:DWORD PTR INT28V	;ELSE, EXIT
UNINS:	PUSH	CS
	POP	DS			;POINT TO THIS SEGMENT
	XOR	AX,AX
	MOV	ES,AX			;AND TO INT. SEGMENT
	MOV	SI,OFFSET INT15V	;POINT TO INT 15 VECTOR
	MOV	DI,15H*4		;WHERE IT GOES
	CLD
	MOVSW				;RESTORE VECTOR
	MOVSW
	MOV	SI,OFFSET INT28V	;POINT TO INT 28 VECTOR
	MOV	DI,28H*4		;WHERE IT GOES
	MOVSW				;RESTORE VECTOR
	MOVSW
	PUSH	CS
	POP	ES			;PUT ES HERE
	MOV	AH,49H
	INT	21H			;RELEASE THIS PROGRAM'S MEMORY
	MOV	ES,ENVSEG		;POINT TO ENVIRONMENT SEGMENT
	MOV	AH,49H
	INT	21H			;RELEASE ENVIRONMENT SEGMENT
	STI				;ENABLE INTERRUPTS
	INT	20H			;EXIT
ENDRES:					;END OF RESIDENT CODE

;	INSTALL CAPCON IN MEMORY

SETUP:	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;PRINT SIGN-ON
	MOV	AH,52H
	INT	21H			;GET MEMORY CONTROL BLOCK ADDR.
	MOV	AX,ES:[BX-2]		;GET FIRST MCB SEGMENT
	MOV	DS,AX			;POINT TO IT
FNDLP:	MOV	AX,PSPSEG		;GET PSP SEGMENT
	MOV	DX,CS
	CMP	AX,DX			;IN THIS SEGMENT?
	JAE	CHKFND			;IF SO, CHECK IF CAPCON FOUND
	MOV	ES,AX			;ELSE, PSP SEGMENT TO ES
	MOV	SI,OFFSET SIG
	MOV	DI,SI
	PUSH	DS			;SAVE MCB SEGMENT
	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	CX,5			;5 WORDS IN SIGNATURE
	REPZ	CMPSW			;IS CAPCON HERE?
	JZ	GOTCC			;WE FOUND CAPCON
	MOV	LSTSEG,ES		;SAVE PSP SEGMENT
FNDNXT:	POP	DS			;RESTORE MCB SEGMENT
	MOV	AX,MCBSIZE		;GET MCB SIZE
	INC	AX			;CORRECT IT
	MOV	BX,DS
	ADD	AX,BX			;CALCULATE NEXT MCB SEGMENT
	MOV	DS,AX			;POINT TO IT
	JMP	FNDLP			;TRY AGAIN
GOTCC:	MOV	FNDSEG,ES		;SAVE SEGMENT WHERE FOUND
	MOV	BYTE PTR FNDFLG,1	;MARK PROGRAM FOUND
	JMP	FNDNXT
CHKFND:	PUSH	CS
	POP	DS			;FIX DS
	CMP	BYTE PTR FNDFLG,1	;WAS CAPCON FOUND?
	JNZ	NOTFND			;NO
	MOV	ES,FNDSEG		;GET SEGMENT WHERE FOUND
	XOR	AL,AL			;ASSUME DISABLE WANTED
	MOV	DX,OFFSET DISMSG
	CMP	FCBARG,'D'		;DISABLE CAPCON?
	JZ	SETFLG			;YES
	MOV	AL,2			;ASSUME UNINSTALL
	MOV	DX,OFFSET UNMSG
	CMP	FCBARG,'U'		;UNINSTALL?
	JNZ	ENABLE			;NO, ENABLE CAPCON
	MOV	BX,FNDSEG		;GET SEGMENT WHERE FOUND
	CMP	BX,LSTSEG		;COMPARE WITH LAST PSP FOUND
	JNC	SETFLG			;OK TO UNLOAD
	MOV	DX,OFFSET NOUNMSG
	MOV	AH,9
	INT	21H			;ELSE, SAY "CAN'T UNLOAD"
	INT	20H
ENABLE:	DEC	AL			;ELSE, ENABLE CAPCON
	MOV	DX,OFFSET ENMSG
SETFLG:	PUSH	AX			;SAVE FLAG
	MOV	AH,9
	INT	21H			;PRINT APPROPRIATE MSG
	POP	AX			;GET FLAG
	MOV	ES:ENFLG,AL		;SET CONDITION
	INT	20H			;AND EXIT
NOTFND:	CMP	FCBARG,'U'		;UNINSTALL?
	JZ	CANTUN			;CAN'T, IT'S NOT INSTALLED!
	MOV	AX,3515H
	INT	21H			;GET INT 15H VECTOR
	MOV	INT15V,BX		;SAVE IT
	MOV	INT15V+2,ES
	MOV	AX,3528H
	INT	21H			;GET INT 28H VECTOR
	MOV	INT28V,BX
	MOV	INT28V+2,ES		;SAVE IT
	MOV	AX,2515H
	MOV	DX,OFFSET INT15
	INT	21H			;INSTALL NEW INT 15H VECTOR
	MOV	AX,2528H
	MOV	DX,OFFSET INT28
	INT	21H			;INSTALL NEW INT 28H VECTOR
	MOV	DX,OFFSET INSMSG
	MOV	AH,9
	INT	21H			;PRINT INSTALLATION MSG
	CMP	FCBARG,'D'		;DISABLE?
	JNZ	NOTDIS			;NO
	MOV	BYTE PTR ENFLG,0	;ELSE, KILL ENABLE FLAG
	MOV	DX,OFFSET DISMSG
	MOV	AH,9
	INT	21H			;SAY "CAPCON DISABLED"
NOTDIS:	MOV	DX,OFFSET ENDRES
	INT	27H			;EXIT WITH CAPCON RESIDENT
CANTUN:	MOV	DX,OFFSET NINMSG
	MOV	AH,9
	INT	21H			;SAY "NOT INSTALLED"
	INT	20H

LSTSEG	DW	0			;LAST PSP SEGMENT (SHOULD BE < PSPSEG)
FNDSEG	DW	0			;SEGMENT WHERE FOUND
FNDFLG	DB	0			;PROGRAM FOUND FLAG

SIGNON	DB	13,10,'CAPCON -- Caps Lock and Control key swapper, v. 1.1'
	DB	13,10,10,'$'
INSMSG	DB	'CAPCON is now installed in memory.  You may control it',13,10
	DB	'by entering',13,10,10
	DB	'  CAPCON D		To disable Caps Lock-Ctrl swapping.',13,10
	DB	'  CAPCON		To enable Caps Lock-Ctrl swapping.',13,10
	DB	'  CAPCON U		To un-install CAPCON.  You can only',13,10
	DB	'			un-install if CAPCON is the last',13,10
	DB	'			TSR loaded.',13,10,'$'
DISMSG	DB	'CAPCON is now disabled.',13,10,'$'
ENMSG	DB	'CAPCON is now enabled.',13,10,'$'
UNMSG	DB	'CAPCON is now un-installed.',13,10,'$'
NOUNMSG	DB	"CAPCON is not the last TSR.  Can't un-install.",13,10,'$'
NINMSG	DB	"CAPCON is already not installed.",13,10,'$'

CODE	ENDS
	END	START
