	PAGE	,132
;	BS -- PRINT DOCUMENT ON BOTH SIDES OF THE PAPER
;	TO USE THIS PROGRAM, ENTER
;
;	BS FILENAME[,FILENAME,ETC...]/SWITCHES
;
;	WHERE THE SWITCHES ARE
;
;	/Ln	SET n LINES/PAGE (DEFAULT 66)
;	/On	SET OFFSET TO n CHARACTERS (DEFAULT 8)
;	/2	START PRINTING ON THE SECOND SIDE
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  18-MAR-88

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

;	PRINT SIGN-ON, SIZE MEMORY, CHECK COMMAND LINE

START:	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;PRINT SIGN-ON
	MOV	AH,30H
	INT	21H			;GET DOS VERSION
	CMP	AL,2			;TEST IT
	JNB	VERSOK			;VERSION OK
	MOV	DX,OFFSET BADVER
	MOV	AH,9
	INT	21H			;SAY "BAD VERSION"
	INT	20H
VERSOK:	MOV	BX,1000H
	MOV	AH,4AH
	INT	21H			;FREE THIS ENTIRE SEGMENT
	JNC	MEMOK			;WE GOT ALL OF IT
	CMP	AL,8			;NOT ENOUGH MEMORY?
	JNZ	BADMEM			;SOME OTHER PROBLEM
	CMP	BX,800H			;GIVE ME AT LEAST 32K
	JB	BADMEM			;BUY MORE MEMORY!
	MOV	AH,4AH
	INT	21H			;GET WHAT WE CAN
	JNC	MEMOK
BADMEM:	MOV	DX,OFFSET BMMSG
	MOV	AH,9
	INT	21H			;REPORT BAD MEMORY
	INT	20H
MEMOK:	MOV	CL,4
	SHL	BX,CL			;COMVERT MEMORY TO BYTES
	SUB	BX,OFFSET BA.BUFFER	;CALCULATE BUFFER SIZE
	MOV	MEMSIZ,BX		;SAVE IT
	MOV	SI,OFFSET 80H		;POINT TO COMMAND ARGUMENT
	CLD
	LODSB				;GET COUNT
	OR	AL,AL			;ANY ARGUMENT?
	JNZ	GOTARG			;YES
NOARG:	MOV	DX,OFFSET EXPL
	MOV	AH,9
	INT	21H			;ELSE, EXPLAIN
	INT	20H

;	PROCESS COMMAND LINE

GOTARG:	XOR	AH,AH			;AX = COUNT
	MOV	CX,AX			;COUNT TO CX
SOS:	CMP	BYTE PTR [SI],' '	;LOOK FOR SPACE
	JNZ	NOTSP			;NOT ONE
	INC	SI			;SKIP SPACE
	LOOP	SOS			;LOOK FOR MORE
	JMP	NOARG			;ALL SPACES, NO ARGUMENT
NOTSP:	PUSH	CX			;SAVE COUNT
	MOV	DI,OFFSET ARG		;PUT ARGUMENT HERE
	REP	MOVSB			;MOVE ARGUMENT
	POP	CX			;RESTORE COUNT
	MOV	SP,OFFSET START		;PUT STACK HERE
	MOV	DI,OFFSET ARG		;POINT TO ARGUMENT
	PUSH	CX			;SAVE COUNT AGAIN
FNDSW:	MOV	AL,'/'			;SEARCH FOR THIS
	REPNZ	SCASB			;LOOK FOR SWITCHES
	JNZ	NOSW			;NONE FOUND
	MOV	BYTE PTR -1[DI],0	;ZERO SWITCH CHARACTER
	MOV	AL,[DI]			;GET THE SWITCH
	CMP	AL,'2'			;SECOND PAGE?
	JNZ	NOTS2			;NO
	MOV	BYTE PTR SIDFLG,1	;FLAG TO START WITH SIDE 1
	JMP	FNDSW
NOTS2:	AND	AL,5FH			;CAPITALIZE
	CMP	AL,'L'			;SET LINES?
	JNZ	NOTSL			;NO
	MOV	AX,1[DI]		;ELSE, GET NUMBER
	CALL	CONA2B			;CONVERT
	OR	AL,AL
	JZ	FNDSW
	MOV	LINES,AL		;SAVE LINES
	JMP	FNDSW			;LOOK FOR MORE SWITCHES
NOTSL:	CMP	AL,'O'			;SET OFFSET?
	JNZ	FNDSW
	MOV	AX,1[DI]		;ELSE, GET NUMBER
	CALL	CONA2B			;CONVERT
	MOV	PO,AL			;SAVE OFFSET
	JMP	FNDSW			;LOOK FOR MORE SWITCHES
NOSW:	POP	CX			;GET COUNT
	MOV	ARGCNT,CX		;SAVE IT
	MOV	TACNT,CX		;HERE, TOO
	XOR	BX,BX			;CLEAR HANDLE REGISTER
	MOV	DI,OFFSET ARG		;POINT TO ARGUMENT
	MOV	AL,' '			;LOOK FOR SPACE
	REPNZ	SCASB
	JNZ	NMS			;NO SPACES
	MOV	BYTE PTR -1[DI],0	;ELSE, REPLACE WITH ZERO
NMS:	CMP	BYTE PTR SIDFLG,1	;STARTING ON BACK SIDE?
	JNZ	MAIN			;NO
	MOV	BYTE PTR FTFLG,1	;ELSE, MARK FIRST TIME DONE

;	MAIN PROGRAM LOOP

MAIN:	MOV	BYTE PTR MFFLG,0	;CLEAR MORE FILES FLAG
	MOV	CX,TACNT		;GET ARGUMENT COUNT
	MOV	DI,FNPTR		;GET FILE NAME POINTER
	MOV	AL,','			;LOOK FOR COMMA
	REPNZ	SCASB
	MOV	TACNT,CX		;UPDATE COUNT
	JNZ	NOCMA			;NO COMMA
	MOV	BYTE PTR -1[DI],0	;ELSE, REPLACE WITH ZERO
	MOV	BYTE PTR MFFLG,1	;INDICATE MORE FILES

;	OPEN A FILE

NOCMA:	MOV	AX,3D00H		;OPEN FILE FOR READING
	MOV	DX,FNPTR		;POINT TO NAME
	MOV	CNAME,DX		;SAVE CURRENT NAME
	CMP	DX,OFFSET ARG		;AT BEGINNING OF LIST?
	JZ	NCR			;IF SO, DON'T RESTORE COMMAS
	MOV	SI,DX			;ELSE, POINT WITH SI, TOO
	MOV	BYTE PTR -1[SI],','	;RESTORE COMMA, IF ANY
NCR:	MOV	FNPTR,DI		;UPDATE MORE FILE POINTER
	INT	21H			;OPEN FILE
	JNC	OPENOK			;OK
	MOV	DX,OFFSET NOFILE
	MOV	AH,9
	INT	21H			;SAY "CAN'T OPEN"
	CALL	PRTFIL			;PRINT FILE NAME
	CMP	BYTE PTR MFFLG,1	;MORE FILES?
	JZ	MAIN			;IF SO, TRY THEM
	INT	20H			;ELSE, EXIT
OPENOK:	MOV	BX,AX			;SAVE HANDLE IN BX
	MOV	BYTE PTR FRFLG,0	;CLEAR FIRST READ FLAG
	MOV	DX,OFFSET PRTMSG
	MOV	AH,9
	INT	21H			;SAY "PRINTING SIDE "
	MOV	DL,SIDFLG		;GET THE SIDE
	ADD	DL,'1'			;MAKE IT A NUMBER
	MOV	AH,2
	INT	21H			;SHOW SIDE NUMBER
	MOV	DX,OFFSET PR2MSG
	MOV	AH,9
	INT	21H			;PRINT " OF "
	CALL	PRTFIL			;PRINT FILE NAME
	CMP	BYTE PTR FTFLG,1	;FIRST TIME DONE?
	JZ	READLP			;YES
	MOV	AL,12
	CALL	PRINT			;ELSE, EJECT A PAGE
	MOV	AL,13
	CALL	PRINT			;HOME THE PRINT HEAD
	MOV	BYTE PTR FTFLG,1	;FLAG FIRST TIME DONE

;	READ IN THE FILE

READLP:	MOV	DX,OFFSET BA.BUFFER	;POINT TO BUFFER
	MOV	CX,MEMSIZ		;GET SIZE OF MEMORY
	MOV	AH,3FH
	INT	21H			;READ FROM FILE
	JNC	READOK			;READ OK
BADRD:	MOV	DX,OFFSET NOREAD
	MOV	AH,9
	INT	21H			;SAY "CAN'T READ
	CALL	PRTFIL
	INT	20H
READOK:	OR	AX,AX			;END OF FILE?
	JNZ	NOTEND			;NO
	JMP	RDEND
NOTEND:	MOV	SI,OFFSET BA.BUFFER	;POINT TO BUFFER
	MOV	CX,AX			;GET CHARACTER COUNT
	MOV	FSIZE,AX		;SAVE FILE SIZE
	CMP	BYTE PTR FRFLG,1	;FIRST READ OF THIS FILE?
	JZ	NOTFFF			;IF NOT, DON'T CHECK FOR FORM FEED
	CMP	BYTE PTR [SI],12	;FIRST CHARACTER FORM FEED?
	JNZ	NOTFFF			;NO
	INC	SI			;ELSE, SKIP IT
	DEC	CX
	MOV	BYTE PTR FRFLG,1	;MARK FIRST READ DONE
NOTFFF:	CALL	DOPO1			;DO PAGE OFFSET FIRST

;	ONE SIDE OF THE FILE (ODD OR EVEN PAGES)

PRTLP:	LODSB				;GET A CHARACTER
	CMP	AL,1AH			;END?
	JZ	PRTEND			;YES
	MOV	AH,PGFLG		;GET PAGE FLAG
	CMP	AH,SIDFLG		;COMPARE WITH SIDE FLAG
	JNZ	NOPRT			;NOT THE SAME, DO NOT PRINT
	CALL	PRINT			;ELSE, PRINT CHARACTER
NOPRT:	CMP	AL,10			;LINE FEED?
	JNZ	NOTLF			;NO
	MOV	AH,LINCNT		;GET LINE COUNTER
	INC	AH			;ADD ONE
	MOV	LINCNT,AH		;UPDATE COUNTER
	CMP	AH,LINES		;ONE PAGE USED?
	JZ	SETCNT			;IF SO, SET COUNTS
	AND	BYTE PTR EPFLG,0FFH-1	;CLEAR END OF PAGE FLAG 1
	MOV	AH,PGFLG		;GET PAGE FLAG
	CMP	AH,SIDFLG		;COMPARE WITH SIDE FLAG
	JNZ	PRTNXT			;NOT THE SAME, DO NOT CLEAR FLAG
	AND	BYTE PTR EPFLG,0FFH-2	;CLEAR END OF PAGE FLAG (PRINTED PAGE)
	JMP	SHORT PRTNXT		;PRINT NEXT CHARACTER
NOTLF:	CMP	AL,12			;FORM FEED?
	JNZ	NOTFF			;NO
SETCNT:	XOR	BYTE PTR PGFLG,1	;ELSE, FLIP PAGE FLAG
	MOV	BYTE PTR LINCNT,0	;ZERO LINE COUNT
	INC	BYTE PTR PGCNT		;COUNT THIS PAGE
	OR	BYTE PTR EPFLG,1	;SET END OF PAGE FLAG 1
	MOV	AH,PGFLG
	CMP	AH,SIDFLG		;PRINTING THE LAST PAGE?
	JZ	PRTNXT			;NO
	OR	BYTE PTR EPFLG,2	;ELSE, SET END OF PAGE FLAG
	JMP	SHORT PRTNXT
NOTFF:	CMP	AL,13			;CR?
	JNZ	PRTNXT			;NO
	CALL	DOPO			;ELSE, DO PAGE OFFSET
PRTNXT:	LOOP	PRTLP			;LOOP UNTIL DONE
PRTEND:	MOV	AX,MEMSIZ
	CMP	AX,FSIZE		;DID WE LOAD A BUFFER FULL?
	JNZ	RDEND			;NO
	JMP	READLP			;ELSE, TRY FOR MORE

;	FINISED WITH FILE, EVEN UP PAPER

RDEND:	OR	BX,BX			;WAS A FILE EVER OPENED?
	JNZ	DIDFIL			;YES
	JMP	EXIT			;ELSE, EXIT
DIDFIL:	MOV	AH,3EH
	INT	21H			;CLOSE THE FILE
	MOV	AL,13
	CALL	PRINT			;HOME THE PRINT HEAD
	CMP	BYTE PTR SIDFLG,1	;ON BACK SIDE?
	JNZ	CLPG			;NO, CHECK LAST PAGE
	MOV	AL,BYTE PTR PGCNT	;GET PAGE COUNT
	TEST	BYTE PTR EPFLG,1	;WAS LAST PAGE FULL?
	JNZ	LPF			;YES
	INC	AL			;ELSE, COUNT LAST PAGE
LPF:	SHR	AL,1			;TEST FOR ODD/EVEN
	JNC	CLPG			;EVEN PAGE COUNT
	MOV	AL,12
	CALL	PRINT			;ELSE, EJECT TO EVEN UP
CLPG:	TEST	BYTE PTR EPFLG,2	;WAS LAST PRINTED PAGE FULL?
	JNZ	CNF			;YES, DO NEXT FILE
	MOV	AL,12
	CALL	PRINT			;ELSE, EJECT TO EVEN UP
CNF:	CMP	BYTE PTR MFFLG,1	;MORE FILES TO DO?
	JNZ	NMF			;NO
NXTFIL:	MOV	BYTE PTR PGFLG,0	;ZERO PAGE FLAG
	MOV	BYTE PTR LINCNT,0	;AND LINE COUNT
	MOV	BYTE PTR PGCNT,0	;AND PAGE COUNT
	JMP	MAIN

;	DO OTHER SIDE OF DOCUMENT

NMF:	MOV	AL,BYTE PTR SIDFLG	;GET THE SIDE FLAG
	INC	AL			;MOVE TO NEXT SIDE
	MOV	BYTE PTR SIDFLG,AL	;UPDATE FLAG
	CMP	AL,2			;DONE WITH FILE?
	JZ	DONE			;YES
	MOV	AL,12
	CALL	PRINT			;EJECT A PAGE
	CALL	PRINT			;ONE MORE
	CALL	FLPRN			;FLUSH THE PRINT BUFFER
	MOV	DX,OFFSET REMSG
	MOV	AH,9
	INT	21H			;SAY "RE-LOAD PAPER"
WFCR:	MOV	AH,8
	INT	21H			;WAIT FOR CHARACTER
	CMP	AL,13			;CR?
	JNZ	WFCR			;IF NOT, WAIT
	MOV	DX,OFFSET CRLF
	MOV	AH,9
	INT	21H			;PRINT CRLF
	MOV	BYTE PTR PGFLG,0	;ZERO PAGE FLAG
	MOV	BYTE PTR LINCNT,0	;AND LINE COUNT
	MOV	BYTE PTR PGCNT,0	;AND PAGE COUNT
	MOV	WORD PTR FNPTR,OFFSET ARG ;FIX FILE NAME POINTER
	MOV	AX,ARGCNT
	MOV	TACNT,AX		;UPDATE ARG COUNT
	JMP	MAIN			;AND PROCESS AGAIN
DONE:	MOV	AL,12
	CALL	PRINT			;EJECT A PAGE
	CALL	FLPRN			;FLUSH THE PRINT BUFFER
	MOV	DX,OFFSET DNMSG
	MOV	AH,9
	INT	21H			;SAY "DONE"
EXIT:	INT	20H

;	SUBROUTINES

;	PRINT A CHARACTER ON PRINTER

PRINT:	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	BX,PRNPTR		;GET PRINT BUFFER POINTER
	MOV	[BX],AL			;PUT CHARACTER IN BUFFER
	INC	BX
	MOV	PRNPTR,BX		;UPDATE POINTER
	CMP	BX,OFFSET BA.BUFFER	;AT END OF BUFFER?
	JNZ	PRINTX			;NO
	MOV	WORD PTR PRNPTR,OFFSET PRNBUF ;ELSE, RESET POINTER
	MOV	DX,OFFSET PRNBUF	;POINT TO BUFFER
	MOV	CX,256			;PRINT 256 CHARACTERS
	MOV	BX,4			;TO STD PRN
	MOV	AH,40H
	INT	21H			;PRINT THE CHARACTERS
PRINTX:	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

;	FLUSH THE PRINT BUFFER

FLPRN:	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	CX,PRNPTR		;GET PRINT BUFFER POINTER
	SUB	CX,OFFSET PRNBUF	;IS BUFFER EMPTY?
	JZ	FLPRNX			;YES, EXIT
	MOV	WORD PTR PRNPTR,OFFSET PRNBUF ;ELSE, RESET POINTER
	MOV	DX,OFFSET PRNBUF	;POINT TO BUFFER
	MOV	BX,4			;TO STD PRN
	MOV	AH,40H
	INT	21H			;PRINT THE CHARACTERS
FLPRNX:	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

;	CONVERT ASCII IN AX TO BINARY IN AL

CONA2B:	CMP	AH,'9'			;HIGH BYTE BELOW 9?
	JA	NOTNUM			;NOT A NUMBER
	CMP	AH,'0'			;BELOW 0?
	JNB	CON2			;IT'S A NUMBER
NOTNUM:	MOV	AH,AL			;NUMBER IN AL TO AH
	MOV	AL,0			;THE HIGH DIGIT IS ZERO
CON2:	AND	AX,0F0FH		;REMOVE ASCII
	XCHG	AL,AH			;FIX ORDER
	AAD				;CONVERT TO BINARY
	RET

;	DO PAGE OFFSET

DOPO:	MOV	AH,PGFLG
	CMP	AH,SIDFLG
	JNZ	DOPOX			;NOT PRINTING NOW
DOPO1:	MOV	AL,PO			;GET PAGE OFFSET
	OR	AL,AL			;NONE?
	JZ	DOPOX			;IF SO, SKIP
	PUSH	CX
	MOV	CL,AL			;GET PAGE OFFSET
	XOR	CH,CH			;IN CX
	MOV	AL,' '			;GET A SPACE
DOPOLP:	CALL	PRINT			;PRINT A SPACE
	LOOP	DOPOLP			;UNTIL OFFSET DONE
	POP	CX
DOPOX:	RET

;	PRINT FILE NAME

PRTFIL:	MOV	SI,CNAME		;GET CURRENT FILE NAME
PRTFLP:	LODSB				;GET A CHARACTER
	OR	AL,AL			;END?
	JZ	PRTFX			;YES
	MOV	DL,AL
	MOV	AH,2
	INT	21H			;PRINT IT
	JMP	PRTFLP			;GET ANOTHER
PRTFX:	MOV	DX,OFFSET PCRLF
	MOV	AH,9
	INT	21H			;PRINT PERIOD, CR, LF
	RET

;	DATA AREA

MEMSIZ	DW	0			;MEMORY SIZE
FTFLG	DB	0			;FIRST TIME FLAG
FRFLG	DB	0			;FIRST READ FLAG
LINES	DB	66			;LINES/PAGE
PO	DB	8			;PAGE OFFSET
LINCNT	DB	0			;LINE COUNT
PGFLG	DB	0			;PAGE FLAG
EPFLG	DB	0			;END OF PAGE FLAG
SIDFLG	DB	0			;SIDE FLAG
PGCNT	DB	0			;PAGE COUNT
PRNPTR	DW	OFFSET PRNBUF		;PRINT BUFFER POINTER
MFFLG	DB	0			;MORE FILES FLAG
FSIZE	DW	0			;FILE SIZE
FNPTR	DW	OFFSET ARG		;FILE NAME POINTER
CNAME	DW	OFFSET ARG		;CURRENT NAME
ARGCNT	DW	0			;ARGUMENT CHARACTER COUNT
TACNT	DW	0			;TEMP. ARG. CHAR. COUNT
ARG	DB 	128 DUP (0)		;ARGUMENT SPACE

SIGNON	DB	13,10,'Both Sides printer utility, version 1.0.',13,10
	DB	"Copyright (C) Heath/Zenith Users' Group 1988.  "
	DB	'All Rights Reserved.',13,10,'$'
BADVER	DB	13,10,7,'This program requires MS-DOS version 2 '
	DB	'or above.',13,10,'$'
BMMSG	DB	13,10,7,'Not enough free memory to run this program.'
	DB	13,10,'$'
EXPL	DB	13,10
	DB	'This program allows you to print a paginated',13,10
	DB	'file on both sides of the paper, by printing',13,10
	DB	'all of the odd numbered pages on one side,',13,10
	DB	'and then the even numbered pages on the other.',13,10,10
	DB	'To use this program, enter',13,10,10
	DB	'  BS pathname[,pathname...][/Ln][/On][/2]',13,10,10
	DB	'where pathname is the path description',13,10
	DB	'of each file you want to print, and n',13,10
	DB	'is a number.  /Ln sets the page length to',13,10
	DB	'n lines (default is 66), and /On sets the',13,10
	DB	'offset of each line to n characters (de-',13,10
	DB	'fault is 8).  /2 causes only the second',13,10
	DB	'side to be printed (pages 2, 4, 6, etc.)'
PCRLF	DB	'.'
CRLF	DB	13,10,'$'
PRTMSG	DB	13,10,'Printing side $'
PR2MSG	DB	' of $'
NOFILE	DB	13,10,7,"Can't find $"
NOREAD	DB	13,10,7,'Error reading $'
REMSG	DB	13,10,7
	DB	'Side 1 printing completed.',13,10,10
	DB	'Re-load your paper with the back side facing',13,10
	DB	'the print head, and the top of the first',13,10
	DB	'printed page aligned at the print head, and',13,10
	DB	'press Return...$'
DNMSG	DB	13,10,'Printing completed.',13,10,'$'
PRNBUF	LABEL	NEAR
BA	LABEL	NEAR
BUFF	STRUC
	DB	256 DUP (?)		;PRINT BUFFER SPACE
BUFFER	DB	?
BUFF	ENDS

CODE	ENDS
	END	START
