PAGE ,132

	TITLE SCDMPOKI - Z-100/Z-150 SCREEN DUMP UTILITY
;                   Version 3.52   15-Aug-86

;	for Okidata Microline Series Printers
 
;	Written by Les Bordelon - All Rights Reserved

;	Usage:  SCDMP<cr>

;		 loads screen dump and set defaults to:

;		   bank: All (if only one VRAM bank, green) - Z-100
;		    or
;		   mode: Graphics			    - Z-150

;		   image: Negative
;		   density: Standard
;		   25th line: Dumped, if displayed

;	or	SCDMP wxyz<cr>  for Z-100

;		 loads screen dump and changes defaults to:

;	           w = <B>lue, <R>ed, <G>reen or <T>ext - Z-100
;		    or
;		   w = <T>ext				- Z-150

;		   x = <P>ositive image
;		   y = <S>tandard or <H>igh density
;		   z = <D>o not dump 25th line, unless requested


;	Activation:  <SHIFT-F12>[U][V][W][X][Y][Z]     for Z-100
;		      or
;		     <SHIFT-PrtSc>[U][V][W][X][Y][Z]   for Z-150

;		 initiates screen dump and sets parameters to:

;	           U = <A>ll, <B>lue, <R>ed, <G>reen or <T>ext - Z-100
;		    or
;		   U = <G>raphics or <T>ext mode	       - Z-150

;		   V = <N>egative or <P>ositive image
;		   W = <S>tandard or <H>igh density
;		   X = <D>ump/<D>o not dump 25th line
;		   Y = <C>hange default settings
;		   Z = <Q>uery default settings


;	Credits:  Zenith Data Systems 	      - Interrupt-5 routine (PSC)
;		  Digital Information Systems - Original Graphic Routines

;	Definitions 

FALSE	=	0
TRUE	=	NOT FALSE

;	Set Z100 to TRUE for Z-100 or FALSE for Z-150

Z100	=	TRUE
Z150	=	NOT Z100

;	Set OKI83 to TRUE if printer is Okidata 83A else set to FALSE

OKI83	=	FALSE

;	Set ZPC to TRUE if Z150 version to be used on Z100 under ZPC

ZPC	=	FALSE

;	Set CLOCK_8 to TRUE if higher clock speed

CLOCK_8	=	FALSE

IF Z100
BIOS_SEG SEGMENT AT 40H 			;bios location
	ORG 1*3
  BIOS_STATUS	LABEL FAR			;console status
	ORG 2*3
  BIOS_CONIN	LABEL FAR			;console input
	ORG 3*3
  BIOS_CONOUT	LABEL FAR			;console output
	ORG 4*3
  BIOS_PRINT	LABEL FAR			;printer output 
BIOS_SEG ENDS

;  	If monitor version = 1, then change ORG to 0290H or the 25th
;		line will not be printed.

MTR_D_SEG SEGMENT AT 0				;ROM monitor data
	ORG	007FH
  MTR_RDC	DD ?				;addr of read displayed char
	ORG	0292H
  MTR_VERP	DB ?				;vertical position of cursor
MTR_D_SEG ENDS

IPAGE_SEG SEGMENT AT 0				;the interrupt area page
	ORG	03FEH
  MTR_DS	LABEL WORD			;location of monitor DS value
IPAGE_SEG ENDS

ELSE

DMPSTAT	SEGMENT AT 0				;current dump status
	ORG	500H
  DMP_CHK	LABEL BYTE
DMPSTAT	ENDS
ENDIF

CMDBUF	EQU	80H


CODE	SEGMENT PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	100H

;*****************ENTRY POINT******************

BEGIN:
	JMP	START

CHECK	DB	'SCREEN DUMP version 3.52'
CHECKLN EQU	$-CHECK
DEFCLR	DB	'G'
DEFDEN	DB	'S'
DEFL25	DB	25D
DEFIMG	DB	'N'

IF Z100
BANKS	DB	0
ENDIF

	DB	' Copyright (c) 1985, 1986, Bordelon Software '

;************INTERRUPT_5 HANDLER***************

INT_5:
	PUSH	DS				;save previous data segment
	PUSH	AX

IF Z150
	SUB	AX,AX				;check current dump status
	MOV	DS,AX
	MOV	AL,01
	XCHG	AL,DS:DMP_CHK
	CMP	AL,01
	JZ	IT3				;exit if already in dump mode
ENDIF

	MOV	CS:INT_SP,SP
	MOV	CS:INT_SS,SS			;save previous stack

	MOV	AX,CS
	MOV	SS,AX				;set local stack
	MOV	SP,OFFSET INT_STACK

	STI					;now allow interrupts

	PUSH	ES
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI

	MOV	DS,AX
	MOV	ES,AX				;set up new segments

	MOV	AL,DEFDEN			;set defaults - print density
	MOV	DENFLG,AL
	MOV	BYTE PTR L25FLG,0		; 25th line
	MOV	BYTE PTR CHGFLG,0
	MOV	AL,DEFCLR			; VRAM bank/mode
	MOV	CLRFLG,AL
	MOV	AL,DEFIMG			; image
	MOV	IMGFLG,AL
	MOV	BYTE PTR CNT,00			; and bit shift count

IF Z100
	CALL	INT_SIZE			;size screen
ELSE
	MOV	WORD PTR LINES,25D		;size screen
ENDIF

	CALL	INT_SCRN			;process the screen

	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	ES

	CLI					;INTs off while messing around
	MOV	AX,INT_SP
	MOV	SP,AX
	MOV	AX,INT_SS			;restore original stack
	MOV	SS,AX

IF Z100
	POP	AX
	POP	DS
	IRET					;back to bios
ELSE
	SUB	AX,AX
	MOV	DS,AX
	MOV	BYTE PTR DS:DMP_CHK,00		;reset status bit

	POP	AX
	POP	DS
	CMP	BYTE PTR CS:VRAM_MD,04		;check video status
	JB	IT2				;if text mode, do text dump
	IRET					;else, back to bios

IT2:	JMP	CS:DWORD PTR TXTINT5		;jump to text int 5

IT3:	POP	AX
	POP	DS
	IRET					;back to bios
ENDIF

INT_SS	DW	0				;saved stack values
INT_SP	DW	0
LINES	DW	0				;minimum lines

IF Z100
INT_CX	DW	0				;current X location
INT_CY	DW	0				;current Y location
MYCHR	DW	0				;character at position

ELSE

TXTINT5	DW	00				;text dump interrupt address
	DW	00
ENDIF

	DW	128 DUP (?)

INT_STACK LABEL NEAR				;internal stack

IF Z100
;*****************SIZE SCREEN******************

;	INT_SIZE checks to see if the 25th line is enabled. If
;	it is, LINES is modified to be 25, so all lines are
;	printed


INT_SIZE:
	MOV	WORD PTR LINES,24		;assume not
	MOV	SI,OFFSET INT_SIZA		;print first line
	CLI					;don't interrupt me now
	CALL	INT_PLINE			;output line
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX				;get data segment
	MOV	DS,DS:[MTR_DS]
	MOV	AL,DS:[MTR_VERP]		;AL=vertical position of cursor
	POP	DS
	PUSH	AX
	MOV	SI,OFFSET INT_SIZB		;put cursor back
	CALL	INT_PLINE			;output line
	STI
	POP	AX
	CMP	AL,24
	JNZ	INT_SIZ1			;if not on 24th line

;	Cursor moved to 25th line, must be enabled

	INC	WORD PTR LINES

INT_SIZ1:
	RET

INT_SIZA LABEL	NEAR
	DB	01BH,'j'			;save cursor
	DB	01BH,'Y',25+31,1+31		;go here
	DB	-1				;end of message

INT_SIZB LABEL	NEAR
	DB	01BH,'k'			;restore cursor
	DB	-1

INT_PLINE:
	MOV	AL,BYTE PTR [SI]		;get character
	INC	SI				;bump for next time
	CMP	AL,-1
	JZ	INT_PLIN1			;if end of text
	PUSH	SI
	CALL	FAR PTR BIOS_CONOUT		;output it
	POP	SI
	JMP	SHORT INT_PLINE 		;do next

INT_PLIN1:
	RET

ENDIF

VRAM_MD	DB	0
CLRFLG	DB	0
DENFLG	DB	0
L25FLG	DB	0
IMGFLG	DB	0
CHGFLG	DB	0
SCN_LN	DW	0
CUR_RO	DW	0
COL_INR DW	0

;************VIDEO ADDRESS TABLE***************

IF Z100

ROW_DAT DW	00				;Z-100 address table
L24	DW	50176D
L23	DW	48128D
L22	DW	46080D
L21	DW	44032D
L20	DW	41984D
L19	DW	39936D
L18	DW	37888D
L17	DW	35840D
L16	DW	33792D
L15	DW	31744D
L14	DW	29696D
L13	DW	27648D
L12	DW	25600D
L11	DW	23552D
L10	DW	21504D
L09	DW	19456D
L08	DW	17408D
L07	DW	15360D
L06	DW	13312D
L05	DW	11264D
L04	DW	09216D
L03	DW	07168D
L02	DW	05120D
L01	DW	03072D
L00	DW	01024D
ETAB	DW	0000

ELSE

ROW_DAT DW	00				;Z-150 address table
L24	DW	16112D
L23	DW	15792D
L22	DW	15472D
L21	DW	15152D
L20	DW	14832D
L19	DW	14512D
L18	DW	14192D
L17	DW	13872D
L16	DW	13552D
L15	DW	13232D
L14	DW	12912D
L13	DW	12592D
L12	DW	12272D
L11	DW	11952D
L10	DW	11632D
L09	DW	11312D
L08	DW	10992D
L07	DW	10672D
L06	DW	10352D
L05	DW	10032D
L04	DW	09712D
L03	DW	09392D
L02	DW	09072D
L01	DW	08752D
L00	DW	08432D
ETAB	DW	0000

ENDIF

;***************END TO TABLE*********************

ADDR_1	DW	0000
ADDR_2	DW	0000
G_CHR	DB	00
G_CHR1	DB	00
G_CHR2	DB	00
CNT	DB	00

;***INT_SCRN - INTERRUPT TIME SCREEN PROCESSOR***

INT_SCRN:

IF Z100
	MOV	DX,0D8H				;video port
	IN	AL,DX				;get current status
	MOV	VRAM_MD,AL			;store it
	MOV	AL,78H				;enable video port
	OUT	DX,AL
ELSE
	MOV	AH,0FH				;get current video status
	INT	10H
	MOV	VRAM_MD,AL			;store it
ENDIF

DE_LAY:
	MOV	DX,5D				;set max number of char input

IF Z100 OR ZPC
IF CLOCK_8
	MOV	BX,300D
ELSE
	MOV	BX,200D 
ENDIF
ENDIF

IF Z150 AND NOT ZPC
IF CLOCK_8
	MOV	BX,35D
ELSE
	MOV	BX,20D 
ENDIF
ENDIF

DL1:	DEC	DX
DL2:	MOV	CX,1000D			;initialize delay loop 2
DL3:	DEC	CX				;delay loop 1

IF Z100 OR ZPC
	IN	AL,0F5H				;check for char avail
	TEST	AL,01H
	JZ	DL4				;no, continue
	IN	AL,0F4H				;else get char
ELSE
	MOV	AH,01H				;check for char avail
	INT	16H
	JZ	DL4				;no, continue
	MOV	AH,0	 			;else get char
	INT	16H
ENDIF

	JMP	SHORT GET_ARG

DL4:	CMP	CX,0
	JG	DL3
	DEC	BX				;delay loop 2
	CMP	BX,0
	JG	DL2
	JMP	CHK_CHNG

GET_ARG:
	AND	AL,0DFH				;force to upper case

IF Z100
	CMP	BANKS,33H			;check # VRAM banks
	JNE	GA3				;only one bank, continue
	CMP	AL,'B'				;check for 'B'
	JNE	GA1				;nope
	JMP	SHORT GA5			;set color flag for blue
GA1:	CMP	AL,'R'				;check for 'R'	
	JNE	GA2				;nope
	JMP	SHORT GA5			;set color flag for red
GA2:	CMP	AL,'A'				;check for 'A'
	JNE	GA3				;nope
	JMP	SHORT GA5			;set color flag for all banks
ENDIF

GA3:	CMP	AL,'G'				;check for 'G'
	JNE	GA4				;nope
	JMP	SHORT GA5			;set color/mode flag for green
GA4:	CMP	AL,'T'				;check for 'T'
	JNE	GA6				;nope
GA5:	MOV	CLRFLG,AL			;set color/mode flag for text
	JMP	SHORT GA16
GA6:	CMP	AL,'P'				;check for 'P'
	JNE	GA7				;nope
	JMP	SHORT GA8			;set image flag for positive
GA7:	CMP	AL,'N'				;check for 'N'
	JNE	GA9				;nope
GA8:	MOV	IMGFLG,AL			;set image flag for negative
	JMP	SHORT GA16
GA9:	CMP	AL,'H'				;check for 'H'
	JNE	GA10				;nope
	JMP	SHORT GA11			;set density flag for high
GA10:	CMP	AL,'S'				;check for 'S'
	JNE	GA12				;nope
GA11:	MOV	DENFLG,AL			;set density flag for standard
	JMP	SHORT GA16
GA12:	CMP	AL,'D'				;check for 'D'
	JNE	GA13				;nope
	MOV	L25FLG,AL			;set to 24 line screen
	JMP	SHORT GA16	
GA13:	CMP	AL,'C'				;check for 'C'
	JNE	GA14				;nope
	JMP	SHORT GA15			;set to change flag
GA14:	CMP	AL,'Q'				;check for 'Q'
	JNE	GA16				;nope
GA15:	MOV	CHGFLG,AL			;set to change flag
GA16:	CMP	DX,0				;more characters to get?
	JG	DL1				;yes, go get

CHK_CHNG:
	CMP	CHGFLG,0			;check for change flag
	JNE	CC1				;no, continue
	JMP	GET_SIZE
CC1:	CMP	CHGFLG,'C'			;change defaults?
	JNE	CHK_QURY			;no, then print defaults
	MOV	AL,CLRFLG			;get color/mode flag
	CMP	DEFCLR,AL			;was change made?
	JE	CC2				;no change, continue
	MOV	DEFCLR,AL			;reset color/mode default
CC2:	MOV	AL,IMGFLG			;get image flag
	CMP	DEFIMG,AL			;was change made?
	JE	CC3				;no change, continue
	MOV	DEFIMG,AL			;reset image flag
CC3:	MOV	AL,DENFLG			;get density flag
	CMP	DEFDEN,AL			;was change made?
	JE	CC4				;no change, continue
	MOV	DEFDEN,AL			;reset density default
CC4:	CMP	L25FLG,0			;was change made?
	JE	CC6				;no change, continue
	CMP	DEFL25,25D			;is default 25 lines?
	JE	CC5				;yes, reset to 24 lines
	MOV	DEFL25,25D			;no, reset to 25 lines
	JMP	SHORT CC6
CC5:	MOV	DEFL25,24D
CC6:	MOV	AL,07H				;sound bell to indicate 

IF Z100
	CALL	FAR PTR BIOS_CONOUT		; defaults reset
ELSE
	MOV	BX,0000H			; defaults reset
	MOV	AH,0EH
	INT	10H
ENDIF

	JMP	SHORT CQ3			;exit

CHK_QURY:
	MOV	SI,OFFSET DEFMSG1		;get default message signon
	CALL	PRT_MSG				;print it
	MOV	SI,OFFSET DEFMSG2		;get VRAM default message
	CALL	PRT_MSG				;print it
	MOV	AL,DEFCLR
	CALL	CPRN
	MOV	SI,OFFSET DEFMSG3		;get image default message
	CALL	PRT_MSG				;print it
	MOV	AL,DEFIMG
	CALL	CPRN
	MOV	SI,OFFSET DEFMSG4		;get density default message
	CALL	PRT_MSG				;print it
	MOV	AL,DEFDEN
	CALL	CPRN
	MOV	SI,OFFSET DEFMSG5		;get 25th line default message
	CALL	PRT_MSG				;print it
	CMP	DEFL25,25D
	JE	CQ1
	MOV	AL,'N'
	JMP	SHORT CQ2
CQ1:	MOV	AL,'Y'
CQ2:	CALL	CPRN
	MOV	AL,13D				;terminate with <CR>, <LF>
	CALL	CPRN
	MOV	AL,10D
	CALL	CPRN

IF Z100
CQ3:	RET					;exit to DOS
ELSE
CQ3:	MOV	VRAM_MD,04			;set up to exit
	RET					;exit to DOS
ENDIF

PRT_MSG:
	MOV	AL,BYTE PTR [SI]		;get character
	INC	SI				;bump for next time
	CMP	AL,0
	JZ	PM1				;if end of text
	PUSH	SI
	CALL	CPRN				;output it
	POP	SI
	JMP	SHORT PRT_MSG	 		;do next
PM1:	RET

GET_SIZE:
	CMP	DEFL25,25D			;print 25 lines?
	JNE	GS1				;no, only if directed
	CMP	L25FLG,0			;yes, check 25th line flag
	JE	GET_BANK			;print 25 lines
	JMP	SHORT GS2			;else, print 24 lines
GS1:	CMP	L25FLG,0			;check 25th line flag
	JNE	GET_BANK			;print 25 lines
GS2:	MOV	WORD PTR LINES,24D		;else, set to 24 lines

GET_BANK:

IF Z100
	CMP	CLRFLG,'T'			;check color flag for text
	JNE	GTB1				;no, continue
	JMP	TXT_DMP				;else, dump text only
GTB1:	CMP	CLRFLG,'B'			;if flag -> B, dump blue
	JE	B_BANK
	CMP	CLRFLG,'R'			;if flag -> R, dump red
	JE	R_BANK

G_BANK: 					;green vram bank
	MOV	AX,0E000H			;select location E000H
	JMP	SHORT GO_PSC

R_BANK: 					;red vram bank
	MOV	AX,0D000H			;select location D000H
	JMP	SHORT GO_PSC

B_BANK: 					;blue vram bank
	MOV	AX,0C000H			;select location C000H

ELSE

	CMP	CLRFLG,'T'			;check mode flag for 'T'
	JNE	GTB3				;no, continue
GTB1:	MOV	VRAM_MD,00			;yes, dump text only
GTB2:	RET
GTB3:	CMP	VRAM_MD,04			;check for graphics mode
	JB	GTB2				;no, dump text only
	CMP	VRAM_MD,06			;check if valid CGA mode 4-5-6
	JG	GTB1				;no, dump text only
	MOV	AX,0B800H			;select video segment
ENDIF

GO_PSC: 					;OKIDATA graphics routine
	MOV	ES,AX				;set up seg
	MOV	WORD PTR COL_INR,79D		;init col =79
	MOV	WORD PTR CUR_RO,24D 		;init row =24 -->max lines
	MOV	WORD PTR SCN_LN,0		;init scan line =0
	CMP	DENFLG,'S'			;check density flag for standard	
	JE	GP1

IF OKI83
	MOV	AL,1DH				;set to compressed for high
ELSE
	MOV	AL,03H
	CALL	CPRN
	MOV	AL,1CH				;set to elite for high
	CALL	CPRN
	MOV	AL,0DH
ENDIF

	CALL	CPRN
	MOV	AL,0DH
	CALL	CPRN
GP1:	MOV	BX,03D				;set top page margin
	CALL	PRLF				;print line feeds
	CALL	MODE_G 				;graphics mode
	CALL	PRSPC				;print spaces (to center)
	JMP	ROW2

;*********CHARACTER PRINT - CPRN***************

CPRN:

IF Z100
	CALL	FAR PTR BIOS_PRINT		;character print function
ELSE
	PUSH	AX
	PUSH	DX
	XOR	DX,DX				;character print function
	MOV	AH,0
	INT	17H				; for parallel printer
	POP	DX
	POP	AX
ENDIF

	RET


;*********PRINT SPACES ROUTINE*****************

PRSPC:
	CMP	LINES,25			;if 25 lines
	JB	PRSPC1				;pad with spaces
	CMP	DENFLG,'S'
	JNE	PR1

IF Z100
	MOV	BX,15D				;15 spaces, standard density
ELSE
	MOV	BX,40D				;40 spaces, standard density
ENDIF

	JMP	SHORT PSC1
PR1:

IF Z100
	MOV	BX,58D				;58 spaces, high density
ELSE
	MOV	BX,96D				;96 spaces, high density
ENDIF

PSC1:
	MOV	AL,00H				;print spaces 
	CALL	CPRN				;spaces+graphics
	DEC	BX				
	CMP	BX,0
	JG	PSC1				;continue as needed
	RET

PRSPC1:
	CMP	DENFLG,'S'			;check density flag for standard
	JNE	PS1

IF Z100
	MOV	BX,24D				;if 24 lines, 24 spaces
ELSE
	MOV	BX,48D				;48 spaces, standard density
ENDIF

	JMP	SHORT PSC1
PS1:

IF Z100
	MOV	BX,72D				;72 spaces, high density
ELSE
	MOV	BX,108				;108 spaces, high density
ENDIF

	JMP	SHORT PSC1

;*********PRINT LINE FEED ROUTINE**************

PRLF:
	MOV	AL,0AH				;print <LF>
	CALL	CPRN
	DEC	BX
	CMP	BX,0
	JG	PRLF				;continue as needed
	RET


;******MODE_G - SENDS GRAPHICS TO PRINTER******

MODE_G:
	MOV	AX,0000H			;clear AX reg
	MOV	AL,03H				;graphics mode
	CALL	CPRN
	RET					;back to calling

;****DO_BYTE - READ THE VRAM AND SEND TO PRN***

DO_BYTE:
	CMP	COL_INR,-01H			;check if last column done
	JG	DB1				;no, continue
	MOV	G_CHR1,00			;else, get remaining part of
	JMP	SHORT DB3			; last column byte
DB1:	MOV	BX,WORD PTR ADDR_1		;current address
	MOV	AL,BYTE PTR ES:[BX]		;byte pointed by cur addr

IF Z100
	CMP	BANKS,33H			;check # of VRAM banks
	JNE	DB2				;nope, print green bank
	CMP	CLRFLG,'A'			;check for 'A'
	JNE	DB2				;nope, print green bank
	MOV	G_CHR,AL			;save green bank char
	MOV	AX,0D000H			;get red bank segment
	MOV	ES,AX				;set up segment
	MOV	BX,WORD PTR ADDR_1		;current address
	MOV	AL,BYTE PTR ES:[BX]		;byte pointed by cur addr
	OR	G_CHR,AL			;OR with green bank char
	MOV	AX,0C000H			;get blue bank segment
	MOV	ES,AX				;set up segment
	MOV	BX,WORD PTR ADDR_1		;current address
	MOV	AL,BYTE PTR ES:[BX]		;byte pointed by cur addr
	OR	G_CHR,AL			;OR with other banks
	MOV	AX,0E000H			;get green bank segment
	MOV	ES,AX				;set up segment
	MOV	AL,G_CHR			;set char for print	
ENDIF

DB2:	CMP	COL_INR,79D			;check if first column
	JE	DB5				;yes, skip previous
	MOV	G_CHR1,AL			;else, store it
DB3:	MOV	BX,WORD PTR ADDR_2		;previous column address
	MOV	AL,BYTE PTR ES:[BX]		;byte pointed by prev addr

IF Z100
	CMP	BANKS,33H			;check # of VRAM banks
	JNE	DB4				;nope, print green bank
	CMP	CLRFLG,'A'			;check for 'A'
	JNE	DB4				;nope, print green bank
	MOV	G_CHR,AL			;save green bank char
	MOV	AX,0D000H			;get red bank segment
	MOV	ES,AX				;set up segment
	MOV	BX,WORD PTR ADDR_2		;current address
	MOV	AL,BYTE PTR ES:[BX]		;byte pointed by cur addr
	OR	G_CHR,AL			;OR with green bank char
	MOV	AX,0C000H			;get blue bank segment
	MOV	ES,AX				;set up segment
	MOV	BX,WORD PTR ADDR_2		;current address
	MOV	AL,BYTE PTR ES:[BX]		;byte pointed by cur addr
	OR	G_CHR,AL			;OR with other banks
	MOV	AX,0E000H			;get green bank segment
	MOV	ES,AX				;set up segment
	MOV	AL,G_CHR			;set char for print	
ENDIF

DB4:	MOV	G_CHR2,AL			;store it
	CALL	SHFT_BIT			;re-align bits
DB5:	CMP	IMGFLG,'N'			;check image flag for negative
	JE	DB6				;yes, continue
	NOT	AL				;reverse image to positive
DB6:	CMP	AL,128D				;check if 7-bit char
	JB	DB7				;if so, continue 
	SUB	AL,128D				;else convert to 7-bit
DB7:	CALL	CPRN				;print twice for full-
	CALL	CPRN				;screen effect
	CMP	DENFLG,'S'			;check density flag for standard
	JE	DB8
	CALL	CPRN				;print one more time for high
DB8:	CMP	AL,03H				;check for grap char = 3
	JNE	DB9
	CALL	CPRN				;print two more times
	CALL	CPRN				;so all are printed
	CMP	DENFLG,'S'			;check density flag for standard
	JE	DB9
	CALL	CPRN				;print one more time for high
DB9:	INC	SCN_LN				;count scan line done
	CMP	COL_INR,-01H
	JE	DB10
	MOV	BX,WORD PTR ADDR_1		;current address
	CALL	ADJ_SCN				;adjust for scan line
	MOV	WORD PTR ADDR_1,BX		;and save addr
	CMP	COL_INR,79D			;check if first column
	JE	DB11
DB10:	MOV	BX,WORD PTR ADDR_2		;previous column address
	CALL	ADJ_SCN				;adjust for scan line
	MOV	WORD PTR ADDR_2,BX		;and save addr
DB11:

IF Z100
	CMP	SCN_LN,9			;have we done all 9
ELSE
	CMP	SCN_LN,8			;have we done all 8
ENDIF

	JGE	ROW				;all done
	JMP	DO_BYTE				;less than all done

;**********ADJUST FOR NEXT SCAN LINE***********

ADJ_SCN:

IF Z100
	ADD	BX,128D				;adjust for scan line
ELSE
	CMP	BX,2000H			;adjust for scan line
	JB	AS1
	SUB	BX,1FB0H
	JMP	SHORT AS2
AS1:	ADD	BX,2000H
ENDIF

AS2:	RET

;**********ROW - LOOP FOR EACH ROW*************

ROW:
	MOV	SCN_LN,0			;init scan line again
	DEC	CUR_RO				;count row done
	CMP	LINES,25			;if 25 lines
	JB	ROW24

	CMP	CUR_RO,-1H			;test all lines done
	JE	DO_COL				;do next col 
	JMP	SHORT ROW2

ROW24:
	CMP	CUR_RO,0			;if 24 lines, test all done
	JZ	DO_COL				;do next col

ROW2:	
	MOV	AX,CUR_RO			;else more rows
	MOV	BX,OFFSET ROW_DAT		;table start

LNS:						;return tgt
	CMP	COL_INR,-01H			;check if past last column
	JE	LNS1	
	ADD	BX,AX				;R_ADDR=ROW_DAT+CUR_RO
	ADD	BX,AX				;--times two
	MOV	AX,WORD [BX]			;get actual address
	MOV	BX,AX				;swap it back
	MOV	AX,COL_INR			;get current column
	ADD	BX,AX				;C_ADDR=R_ADDR+COL_INR

IF Z100
	SUB	BX,1024D			;adjust table for reverse
ELSE
	SUB	BX,8432D			;adjust table for reverse
ENDIF

	MOV	WORD PTR ADDR_1,BX		;save it at ADDR_1

	CMP	COL_INR,79D			;check if initial column
	JE	LNS2				;do next row

	MOV	AX,CUR_RO			;else get previous column byte
	MOV	BX,OFFSET ROW_DAT		;table start

LNS1:						;return tgt
	ADD	BX,AX				;R_ADDR=ROW_DAT+CUR_RO
	ADD	BX,AX				;--times two
	MOV	AX,WORD [BX]			;get actual address
	MOV	BX,AX				;swap it back
	MOV	AX,COL_INR			;get current column
	INC	AX				;change to previous column
	ADD	BX,AX				;C_ADDR=R_ADDR+COL_INR+1

IF Z100
	SUB	BX,1024D			;adjust table for reverse
ELSE
	SUB	BX,8432D			;adjust table for reverse
ENDIF

	MOV	WORD PTR ADDR_2,BX		;save it at ADDR_2
LNS2:	JMP	DO_BYTE				;do next row


;*DO_COL - INCREMENT COLUMN AT END OF EACH ROW*

DO_COL:
	MOV	AL,03H
	CALL	CPRN				;terminate line with
	MOV	AL,0EH
	CALL	CPRN				;graphics <CR/LF>

IF Z100 OR ZPC
	IN	AL,0F5H				;check for char avail
	TEST	AL,01H

IF ZPC AND Z150
	JZ	DC2
ELSE
	JZ	DC1				;no, continue
ENDIF

	IN	AL,0F4H 			;poll the keyboard port
	CMP	AL,01BH 			 
	JE	DC6				;if port -><ESC> then quit

IF Z100
DC1:	CALL	FAR PTR BIOS_STATUS		;check console status
	JZ	DC2				;no char, continue
	CALL	FAR PTR BIOS_CONIN		;else, get char
ENDIF

ELSE
	MOV	AH,01H				;check console status
	INT	16H
	JZ	DC2				;no char, continue
	MOV	AH,0				;else, get char
	INT	16H
ENDIF

	CMP	AL,01BH 			;is it an <ESC>
	JE	DC6				;if yes then quit
	AND	AL,0DFH				;force to upper case
	CMP	AL,'Q'				;is it a 'Q'
	JE	DC6				;if yes then quit

DC2:	CMP	CNT,06				;check for 7th pass
	JE	DC3				;if so, don't decrement
	DEC	COL_INR 			;else, decrement column
	CMP	CNT,07				;check for 8th pass
	JE	DC4				;if yes, reset counter
DC3:	INC	CNT				;else, increment counter
	JMP	SHORT DC5
DC4:	MOV	CNT,00				;counter reset to 1
DC5:	CMP	COL_INR,-02H			;are all done?
	JG	CON_CL 				;if no --> continue 
DC6:	JMP	SHORT FINI			;else we are done

CON_CL:
	MOV	CUR_RO,24D			;reset max rows =24
	MOV	AX,0000H        		;do next col
	CALL	PRSPC				
	JMP	ROW2

;************SHFT_BIT - REALIGN BITS***********

SHFT_BIT:
	CMP	CNT,00				;check for first pass
	JNE	SB1				;if not, continue
	MOV	AL,G_CHR1			;else dump current column only
	JMP	SHORT SB5
SB1:	CMP	CNT,07				;check for eighth pass
	JNE	SB2				;if not, continue
	MOV	AL,G_CHR1
	SHR	AL,1				;else, shift current column
	JMP	SHORT SB5			; left 1 bit for dump
SB2:	MOV	AL,G_CHR2			;get previous column byte
	MOV	CL,08				;determine shift
	SUB	CL,CNT
SB3:	SHR	AL,CL				;shift right by 9-CNT bits
	MOV	G_CHR2,AL			;store it
	MOV	AL,G_CHR1			;get current column byte
	MOV	CL,CNT
SB4:	SHL	AL,CL				;shift left by CNT bits
	OR	AL,G_CHR2			;OR re-aligned bytes
SB5:	RET


;*************FINISH - ALL DONE****************

FINI:						;reset printer
	MOV	AL,03H				;turn off graphics
	CALL	CPRN
	MOV	AL,02H				;<3> <2>
	CALL	CPRN
	MOV	AL,1EH				;reset to default
	CALL	CPRN
	MOV	AL,12D				;set to bottom of page
	CALL	CPRN
	MOV	AL,0DH
	CALL	CPRN

IF Z100
FI3:	MOV	AL,VRAM_MD			;restore video mode
	OUT	0D8H,AL
ENDIF

	RET

IF Z100
TXT_DMP:
	MOV	WORD PTR INT_CX,0		;start at line 0
	MOV	WORD PTR INT_CY,0		; and column 0

TD1:	PUSH	DS
	PUSH	DS
	MOV	AX,OFFSET MYCHR
	PUSH	AX				;32 bit address for character

	PUSH	WORD PTR INT_CY			;vertical location
	PUSH	WORD PTR INT_CX			;horizontal location

	XOR	AX,AX
	MOV	DS,AX
	MOV	DS,DS:[MTR_DS]			;pointer to MTR data area

	CALL	DS:DWORD PTR MTR_RDC		;read character at CX, CY

	POP	DS

	MOV	AL,BYTE PTR MYCHR
	ADD	AL,' '				;AL = character

	AND	AL,07FH				;make it printable
	CMP	AL,' '
	JNE	TD2				;if printable, continue
	MOV	AL,' '				;else, make it a space

TD2:	CALL	CPRN				;print it

	INC	WORD PTR INT_CX			;go to next character
	CMP	WORD PTR INT_CX,80D		;check if end of line
	JB	TD1				;no, continue

	MOV	AL,0DH				;else, terminate line with
	CALL	CPRN				; a CR
	MOV	AL,0AH
	CALL	CPRN				; a LF

	MOV	WORD PTR INT_CX,0		;reset to column 0
	INC	WORD PTR INT_CY			;go to next horizontal line

	MOV	AX,WORD PTR INT_CY
	CMP	AX,LINES			;end of screen?
	JB	TD1				;nope, continue
	MOV	AL,0AH
	CALL	CPRN
	JMP	FI3				;exit
ENDIF

DEFMSG1	DB	'SCREEN DUMP defaults:',0

IF Z100
DEFMSG2	DB	13,10,'    VRAM bank = ',0
ELSE
DEFMSG2	DB	13,10,'    mode      = ',0
ENDIF

DEFMSG3 DB	13,10,'    image     = ',0
DEFMSG4 DB	13,10,'    density   = ',0
DEFMSG5 DB	13,10,'    dump 25th = ',0

;*******MARK END OF RESIDENT PORTION***********

INT_END LABEL	NEAR

;*************MAIN ENTRY POINT*****************


START:
	MOV	AX,00H				;check to see if already
	MOV	ES,AX				; installed.
	MOV	SI,5*4				;si points to interrupt
	MOV	ES,ES:WORD PTR [SI+2]
	MOV	SI,OFFSET CHECK 		;get ID message
	MOV	DI,SI
	MOV	CX,CHECKLN			;get length
	REPE	CMPSB				;compare
	JNZ	SETUP				;not installed

	PUSH	DS				;save DS
	MOV	AX,ES
	MOV	DS,AX				;get default settings
	LODSB					
	MOV	CS:DEFCLR,AL			; of currently installed
	LODSB
	MOV	CS:DEFDEN,AL			; version and save for
	LODSB
	MOV	CS:DEFL25,AL			; for print out
	LODSB
	MOV	CS:DEFIMG,AL

IF Z100
	LODSB
	MOV	CS:BANKS,AL
ENDIF
	POP	DS				;restore DS
	MOV	BYTE PTR LDFLG,01H		;set already loaded flag
	JMP	PRTMSG				;print signon message

SETUP:
	MOV	SP,OFFSET INT_STACK		;good place for it
	PUSH	DS

IF Z100
	MOV	AX,0C00H			;flush keyboard buffer
	INT	21H	
	MOV	DX,OFFSET VRAM_CK		;get # banks of VRAM
	CALL	PRTSTR

CHKVRM:	MOV	AH,0BH				;check for char available
	INT	21H
	CMP	AL,0FFH
	JNE	GETCMD				;no, continue
	MOV	AH,08H				;else, get character
	INT	21H
	CMP	AL,33H				;is it a '3'
	JNE	CHKVRM				;no, only green bank
	MOV	BANKS,AL			;else, store (all VRAM)
	MOV	DEFCLR,'A'			;set default to 'All' banks
	JMP	CHKVRM
ENDIF

GETCMD:	MOV	SI,OFFSET CMDBUF		;point to command line
	LODSB					;get count byte
	OR	AL,AL				;any arguments?
	JZ	SETINT				;no, continue

GETCHR:	LODSB					;get next byte
	CMP	AL,' '				;space?
	JZ	GETCHR				;if so, skip it
	CMP	AL,0DH
	JE	SETINT
	AND	AL,0DFH				;force to upper case

IF Z100
	CMP	BANKS,33H			;check # VRAM banks
	JNE	GC3				;only one bank, continue
	CMP	AL,'B'				;check for 'B'
	JNE	GC1				;nope
	MOV	DEFCLR,AL			;set color default for blue
	JMP	GETCHR	
GC1:	CMP	AL,'R'				;check for 'R'	
	JNE	GC2				;nope
	MOV	DEFCLR,AL			;set color default for red
	JMP	GETCHR
GC2:	CMP	AL,'G'				;check for 'G'
	JNE	GC3				;nope
	MOV	DEFCLR,AL			;set color default for green
	JMP	GETCHR
ENDIF

GC3:	CMP	AL,'T'				;check for 'T'
	JNE	GC4				;nope
	MOV	DEFCLR,AL			;set color default for text
	JMP	GETCHR
GC4:	CMP	AL,'P'				;check for 'P'
	JNE	GC5				;nope
	MOV	DEFIMG,AL			;set image default for positive
	JMP	GETCHR
GC5:	CMP	AL,'H'                          ;check for 'H'
	JNE	GC6      			;nope
	MOV	DEFDEN,AL			;set density default for high
	JMP	GETCHR
GC6:	CMP	AL,'D'				;check for 'D'
	JNE	GETCHR      			;nope
	MOV	DEFL25,24D			;set 24 line dump as default
	JMP	GETCHR

SETINT:	XOR	AX,AX
	MOV	DS,AX				;clear DS

	MOV	SI,5*4				;SI points to interrupt

IF Z150
	MOV	AX,[SI]				;save address of text int 5
	MOV	CS:TXTINT5,AX
	MOV	AX,[SI+2]
	MOV	CS:TXTINT5+2,AX
ENDIF

	CLI

	MOV	WORD PTR [SI],OFFSET INT_5
	MOV	WORD PTR [SI+2],CS		;set my interrupt vector

	STI
	POP	DS

PRTMSG:	MOV	DX,OFFSET MESG1 		;get signon message address
     	CALL	PRTSTR				;print signon message
	CMP	LDFLG,0                         ;check loaded flag
	JZ	PRTM1				; and print proper message
	MOV	DX,OFFSET MESG2
	CALL	PRTSTR
	MOV	DX,OFFSET MESG4
	JMP	SHORT PRTM2
PRTM1:	MOV	DX,OFFSET MESG3
PRTM2:	CALL	PRTSTR

IF Z100
	CMP	BANKS,33H
	JNE	PRTM3
	MOV	DX,OFFSET MESG5			; and instruction
	CALL	PRTSTR
	JMP	SHORT PRTM4
PRTM3:	MOV	DX,OFFSET MESG6			; messages
	CALL	PRTSTR
ENDIF

PRTM4:	CMP	DEFL25,25D			;which 25th line message?
	JE	PRTM5				
	MOV	DX,OFFSET MESG8			;print 'dump on switch'
	JMP	SHORT PRTM6
PRTM5:	MOV	DX,OFFSET MESG7			;print 'do not dump' on switch
PRTM6:	CALL	PRTSTR				;print default settings
	MOV	DL,DEFCLR
	CALL	PRTCHR				; bank/mode
	MOV	DX,OFFSET MESG9
	CALL	PRTSTR
	MOV	DL,DEFIMG			; image
	CALL	PRTCHR
	MOV	DX,OFFSET MESG10
	CALL	PRTSTR
	MOV	DL,DEFDEN			; density
	CALL	PRTCHR
	MOV	DX,OFFSET MESG11		; 25th line
	CALL	PRTSTR
	CMP	DEFL25,25D
	JE	PRTM7
	MOV	DL,'N'
	JMP	SHORT PRTM8
PRTM7:	MOV	DL,'Y'
PRTM8:	CALL	PRTCHR
	MOV	DX,OFFSET MESG12		;print abort message
	CALL	PRTSTR
	CMP	LDFLG,01
	JZ	PRTM9

	MOV	DX,OFFSET INT_END		;LWA of resident portion
	INT	27H

PRTM9:	INT	20H

PRTSTR:	MOV	AH,09H				;print string function
	INT	21H
	RET

PRTCHR:	MOV	AH,02H				;print character function
	INT	21H
	RET

IF Z100
VRAM_CK	DB	1BH,'i0$'

MESG1	DB	13,10,'              Z-100 '

ELSE
IF ZPC

MESG1	DB	13,10,'            Z-150/ZPC '

ELSE

MESG1	DB	13,10,'              Z-150 '
ENDIF
ENDIF

	DB	'SCREEN DUMP version 3.52',13,10
	DB	'        Copyright (c) 1985, 1986, Bordelon Software',13,10,10

IF OKI83
	DB	'Printer:  Okidata Microline 83A',13,10,10,'$'
ELSE
	DB	'Printer:  Okidata Microline Series',13,10,10,'$'
ENDIF

MESG2	DB	7,'Already installed...',13,10,10,'$'

MESG3	DB	'Installed and ready...',13,10,10
MESG4	DB	'To dump screen, type:   '

IF Z100
	DB	'<SHIFT-F12>[U][V][W][X][Y][Z]',13,10,10
	DB	'   [U = $'
MESG5	DB	'<A>ll, <B>lue, <R>ed, '
MESG6	DB	'<G>reen or <T>ext]',13,10
ELSE
IF ZPC
	DB	'<SHIFT-F12>[U][V][W][X][Y][Z]',13,10,10
ELSE
	DB	'<SHIFT-PrtSc>[U][V][W][X][Y][Z]',13,10,10
ENDIF

	DB	'   [U = <G>raphics or <T>ext mode]',13,10
ENDIF

	DB	'   [V = <N>egative or <P>ositive image]',13,10
	DB	'   [W = <S>tandard or <H>igh density]',13,10
	DB	'   [X = <D>$'

MESG7	DB	'o not d'
MESG8	DB	'ump 25th line]',13,10
	DB	'   [Y = <C>hange default settings]',13,10
	DB	'   [Z = <Q>uery default settings]',13,10,10
	DB	'   defaults:'

IF Z100
	DB	'  bank=$'
ELSE
	DB	'  mode=$'
ENDIF

MESG9	DB	'  image=$'

MESG10	DB	'  density=$'

MESG11	DB	'  dump 25th=$'

MESG12	DB	13,10,10,'To abort dump during printing, type:   <ESC>'
	DB	13,10,10,'$'

LDFLG	DB	0

CODE	ENDS
	END	BEGIN
