	TITLE	ZPC ANSI DRIVER CONTROL PROGRAM
	PAGE	,132
;	THIS PROGRAM ALLOWS YOU TO ENABLE OR DISABLE
;	THE ANSISYS ANSI DRIVER EMULATOR PROGRAM.  TO
;	USE THIS PROGRAM, ENTER
;
;	A>SETANSI OFF		TO TURN OFF ANSI EMULATION
;
;	A>SETANSI		TO TURN ON ANSI EMULATION
;
;	BY P. SWAYNE, HUG   24-OCT-85
;	COPYRIGHT (C) 1985 BY HEATH/ZENITH USERS' GROUP

;	DEFINITIONS

FCB	EQU	5CH			;COMMAND LINE BUFFER

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	XOR	AX,AX
	MOV	DS,AX			;PUT DS AT INT. SEGMENT
	MOV	SI,10H*4		;INT 10H VECTOR
	LES	DI,DWORD PTR [SI]	;GET INT 10 ADDRESS
	CMP	ES:WORD PTR -4[DI],'NA'	;ANSISYS IN?
	PUSH	CS
	POP	DS			;FIX DS
	JZ	ANSIN			;ANSISYS IN
	MOV	DX,OFFSET NOANSI
	MOV	AH,9
	INT	21H			;SAY "NO ANSISYS"
	INT	20H			;EXIT
ANSIN:	MOV	SI,OFFSET FCB+1		;POINT TO USER ENTRY
	CLD
	LODSB				;GET COUNT BYTE
	CMP	AL,' '			;ANY ARGUMENT?
	JNZ	GOTARG			;YES
EXPL:	MOV	DX,OFFSET EXPMSG
	MOV	AH,9
	INT	21H			;EXPLAIN PROGRAM
	INT	20H			;EXIT
GOTARG:	CMP	AL,'O'			;LETTER O?
	JNZ	EXPL			;IF NOT, EXPLAIN
	LODSB				;GET NEXT LETTER
	CMP	AL,'N'			;ON?
	JZ	ANSION			;YES, TURN ANSI ON
	CMP	AL,'F'			;OFF?
	JNZ	EXPL			;IF NOT, EXPLAIN
	MOV	AX,0F400H		;ANSI FUNC., ANSI OFF
	INT	21H			;KILL ANSI
	MOV	DX,OFFSET ANSOFF	;SAY "ANSI OFF"
EXIT:	MOV	AH,9
	INT	21H
	INT	20H			;AND EXIT
ANSION:	MOV	AX,0F401H		;ANSI FUNC, ENABLE ANSI
	INT	21H			;SET ANSI
	MOV	DX,OFFSET ANSON		;SAY "ANSI ON"
	JMP	EXIT			;AND EXIT

EXPMSG	DB	13,10,'ANSISYS Control Program, V 1.0',13,10,10
	DB	'To use this program, enter',13,10,10
	DB	'  SETANSI ON		to turn ANSI emulation on'
	DB	13,10,10
	DB	'  SETANSI OFF		to turn ANSI emulation off'
	DB	13,10,'$'
NOANSI	DB	13,10,7,'ANSISYS is not installed.$'
ANSOFF	DB	13,10,'ANSI emulation is off.$'
ANSON	DB	13,10,'ANSI emulation is on.$'

CODE	ENDS
	END	START
                                                 