	PAGE	,132
;	ANSI DEVICE DRIVER SIMULATOR FOR ZPC
;	THIS PROGRAM ALLOWS YOU TO RUN PC PROGRAMS UNDER ZPC
;	THAT REQUIRE ANSI.SYS.
;
;	BY P. SWAYNE, HUG  24-OCT-85  14-MAR-86
;
;	DERIVED FROM THE Z-150 ANSI DRIVER
;	Author:	RJM
;	Date: 1/11/84
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
	TITLE	ANSI - ANSI device driver for the Z-150

M	EQU	BYTE PTR 0[BX]

JMPF	MACRO
	DB	0EAH			;DEFINE FAR JUMP
	ENDM
RETF	MACRO
	DB	0CBH			;DEFINE FAR RETURN
	ENDM
RETFD	MACRO
	DB	0CAH			;DEFINE FAR RET W/DISP.
	ENDM

	PAGE

CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	0
ZERO	=	$
	ORG	100H

START:	JMP	SETUP			;GO SET UP "DRIVER"

;	MEMORY CELLS USED IN THIS PROGRAM

STK	DW	0			;SYSTEM STACK
STKS	DW	0			;SYSTEM STACK SEGMENT
TEMP1	DW	0			;TEMP. STORAGE NO. 1
TEMP2	DW	0			;TEMP. STORAGE NO. 2
TEMP3	DW	0			;TEMP. STORAGE NO. 3
ANSIFLG	DB	0			;ANSI ENABLE FLAG
PCFLG	DB	0			;PC MODE FLAG
CCFLG	DB	1			;CONTROL-C ABORT ENABLE FLAG
PRNFLG	DB	0			;PRINTER TOGGLE FLAG
COLUMN	DB	0			;SCREEN COLUMN NO.
STRTCOL	DB	0			;STARTING COLUMN NO.
COMPCOL	DB	0			;COMPUTED COLUMN NO.
TEMCNT	DB	0			;TEMPLATE COUNT
TEMPLT	DB	128 DUP (0)		;TEMPLATE BUFFER
INSFLG	DB	0			;INSERT MODE FLAG

ESC     =	1BH             ;Escape character used in this implementation.

STATE   DW      ST1             ;Current ANSI character state.

TEN		DB	10
QUOTE_CHAR	DB	?	; Match character for quoted string
NXT_CHAR	DB	0	; Next character in the input stream
ATTRIBUTE	DB	7	; Attribute for character output
CURSOR_POS	DW	0	; Last saved cursor position
WRAP_FLAG	DB	0	; Flag for screen wrap around (Init. false)
CRT_ROWS	=	25	; Number of rows on the CRT
CRT_COLS	DB	?	; Number of columns on the CRT
VPAGE		DB	0	; Current video page

;	Variables for key remapping
STRING_PTR	DW	0	; Pointer to next character in string
STRING_COUNT	DB	0	; Number of characters left in string

;	Corsor report string
REPORT	DB	ESC, '[', 0, 0, ';', 0, 0, 'R', 13
LREPORT	=	OFFSET $ - OFFSET REPORT

;	Cursor location of current cursor
CURSOR_LOC	LABEL	WORD
COL		DB	0
ROW		DB	0

PRMSTART	DW	PARAMS+4	; Start of parameter buffer
PRMPNT		DW      PARAMS+4	;Current parameter pointer.

;	Parameter table.  Filled with strings of the following form:
;		count,parm_1,...,parm_n  where count is a count of the
;		number of bytes the string takes. (i.e. n-1 params in a string)
;
PARAMS  DB      4,0,72H,10H, 252 DUP(0)	;Allow for parameters.
LASTPRM =	OFFSET ($-ZERO)

CMDTABL DB      'A'             ;Cursor up.  "esc","[",#,"A"
        DW      CUU
        DB      'B'             ;Cursor down. "esc","[",#,"B"
        DW      CUD
        DB      'C'             ;Cursor forward. "esc","[",#,"C"
        DW      CUF
        DB      'D'             ;Cursor back. "esc","[",#,"D"
        DW      CUB
        DB      'H'             ;Direct cursor posit. "esc","[",x,y,"H"
        DW      CUP
        DB      'J'             ;Erase. "esc","[",code,"J"
        DW      ED
        DB      'K'             ;Erase in line. "esc","[",code,"K"
        DW      EL
	DB	'R'		; Eat the escape seq. for cursor report
	DW	STSKIP
        DB      'f'             ;Direct cursor posit. "esc","[",x,y,"f"
        DW      CUP
        DB      'm'             ;Special video mode. "esc","[",code,"m"
        DW      SGR
        DB      's'             ;Save cursor posit. "esc","[","s"
        DW      PSCP
        DB      'u'             ;Move cursor to saved. "esc","[","u"
        DW      PRCP
	DB	'h'		;Set mode #2
	DW	QMARKH
	DB	'l'		;Reset mode #2
	DW	QMARKL
;	DB	'r'		;Ignore any ending in 'r'
;	DW	STSKIP
;	DB	'q'		;   or ending in 'q'
;	DW	STSKIP
;	DB	'w'		;   or ending in 'w'
;	DW	STSKIP
;	DB	'i'		;   or ending in 'i'
;	DW	STSKIP
;	DB	'g'		;   or ending in 'g'
;	DW	STSKIP
	DB	'n'		;   Report cursor position
	DW	DSR
	DB	'p'		;   Remap key
	DW	MAP_KBD
;	DB	'v'		;   or ending in 'v'
;	DW	STSKIP
;	DB	'x'		;   or ending in 'x'
;	DW	STSKIP
;	DB	'z'		;   or ending in 'z'
;	DW	STSKIP
;	DB	'}'		;   or ending in '}'
;	DW	STSKIP
        DB      00              ;End of table.

;	INT 10H PROCESSOR
;	HERE, WE CHECK FOR CALLS TO ENABLE/DISABLE ZPC

I10ADR1	DW	0,0			;STORE INT 10 ADDRESS HERE FOR ZPC
	DB	'AN'			;ANSI DRIVER IDENTIFIER
	DB	'PC'			;ZPC IDENTIFIER
INT10:	CMP	AH,0			;CHECK FUNCTION
	JNZ	INT10X			;NOT SET
	CMP	AL,100			;ZPC CONTROL?
	JC	INT10X			;NO
	PUSH	AX
	AND	AL,1			;ISOLATE FLAG
	MOV	CS:PCFLG,AL		;SAVE IT
	POP	AX
INT10X:	JMPF				;PASS TO ZPC
I10ADR	DW	0,0

;	DOS I/O PROCESSOR
;	HERE, WE INTERCEPT SYSTEM CALLS, AND FILTER OUT
;	I/O CALLS THAT WE WANT TO DO VIA THE ANSI DRIVER.

MYSYS:	CMP	AH,0F4H			;ANSI CONTROL CODE?
	JNZ	NOTCON			;NO
	MOV	CS:ANSIFLG,AL		;ELSE, SET CONDITION
	JMP	SHORT MYEXIT		;AND EXIT
NOTCON:	CMP	CS:PCFLG,0		;ZPC ON?
	JZ	MYEXIT			;IF NOT, EXIT
	CMP	CS:ANSIFLG,0		;ANSI MODE ON?
	JZ	MYEXIT			;IF NOT, EXIT
	OR	AH,AH			;FUNCTION ZERO?
	JZ	MYEXIT			;YES, GO TO DOS
	CMP	AH,13			;SUPPORTED FUNCTION?
	JC	FUNCOK			;YES
	CMP	AH,63			;XENIX READ?
	JZ	READOK
	CMP	AH,64			;XENIX WRITE?
	JNZ	MYEXIT			;UNSUPPORTED FUNCTION
	CMP	BX,1			;STD OUT?
	JNZ	MYEXIT
	JMP	SHORT FUNCOK
READOK:	CMP	BX,0			;STD IN?
	JNZ	MYEXIT
FUNCOK:	PUSH	BX			;SAVE BX
	MOV	CS:STK,SP		;SAVE STACK
	MOV	CS:STKS,SS		;AND STACK SEGMENT
	PUSH	CS
	POP	SS			;PUT STACK SEGMENT HERE
	MOV	SP,OFFSET START		;SET LOCAL STACK
	STI
	CMP	AH,63			;XENIX READ?
	JNZ	NOTXR
	JMP	XREAD
NOTXR:	CMP	AH,64			;XENIX WRITE?
	JNZ	NOTXW
	JMP	XWRITE
NOTXW:	DEC	AH			;ELSE, START AT ZERO
	MOV	BL,AH			;GET FUNCTION IN BL
	XOR	BH,BH
	SHL	BX,1			;MPY BY 2
	MOV	BX,CS:FUNCTBL[BX]	;GET ADDRESS OF FUNCTION
	INC	AH			;FIX AH
	JMP	BX			;EXECUTE FUNCTION
MYEXIT:	JMPF				;JUMP TO SYSTEM
SYSADR	DW	0,0			;SYSTEM ADDRESS
MYRET:	CLI
	MOV	SS,CS:STKS		;RESTORE SYSTEM STACK
	MOV	SP,CS:STK
	POP	BX
	IRET				;RETURN, FUNCTION COMPLETED
MYEXIT1:CLI
	MOV	SS,CS:STKS
	MOV	SP,CS:STK
	POP	BX
	JMP	MYEXIT
	
;	TABLE OF I/O ROUTINES 1-12

FUNCTBL	DW	CONIN			;CONSOLE INPUT
	DW	CONOUT			;CONSOLE OUTPUT
	DW	MYEXIT1			;AUXILIARY INPUT
	DW	MYEXIT1			;AUXILIARY OUTPUT
	DW	MYEXIT1			;LIST OUTPUT
	DW	DCIO			;DIRECT CONSOLE I/O
	DW	DCIN			;DIRECT CONSOLE INPUT
	DW	CONINNE			;CONSOLE INPUT, NO ECHO
	DW	PSTRING			;PRINT STRING
	DW	READCON			;READ CONSOLE BUFFER
	DW	CONST			;CHECK CONSOLE STATUS
	DW	FLUSH			;FLUSH CONSOLE BUFFER

;	CONSOLE INPUT

CONIN:	CALL	LCONST			;CHECK CONSOLE STATUS
	JZ	CONIN			;WAIT FOR CHARACTER
	CALL	MYCONIN			;GET CHARACTER
	PUSH	CX
	PUSH	AX
	MOV	CL,AL
	CALL	CTLOUT			;OUTPUT CHARACTER
	POP	AX
	POP	CX
	JMP	MYRET

;	CONSOLE OUTPUT

CONOUT:	CALL	MYCNOUT			;OUTPUT THE CHARACTER
	JMP	MYRET

;	DIRECT CONSOLE I/O

DCIO:	CMP	DL,0FFH			;INPUT?
	JZ	DCINN			;YES
	PUSH	AX
	MOV	AL,DL
	CALL	LOUT			;ELSE, OUTPUT CHARACTER
	POP	AX
	JMP	MYRET
DCINN:	CALL	LCONST			;GET STATUS
	JNZ	GOTCHR			;WE HAVE A CHARACTER
	XOR	AL,AL			;SET Z FLAG
	JMP	XRET			;RETURN
GOTCHR:	CALL	LCONIN			;GET CHARACTER
	PUSH	AX
	XOR	AL,AL
	INC	AL			;CLEAR Z FLAG
	POP	AX
	JMP	XRET			;RETURN

;	DIRECT CONSOLE INPUT

DCIN:	CALL	LCONST
	JZ	DCIN			;WAIT FOR CHARACTER
	CALL	LCONIN			;GET IT
	JMP	MYRET

;	FLUSH CONSOLE BUFFER, THEN EXECUTE FUNCTION IN AL

FLUSH:	PUSH	AX			;SAVE FUNCTION
FLUSH1:	CALL	LCONST			;CHECK STATUS
	JZ	FLUSH2			;INPUT BUFFER EMPTY
	CALL	LCONIN			;DUMP CHARACTER
	JMP	FLUSH1
FLUSH2:	POP	AX			;GET FUNCTION
	CMP	AL,1
	JZ	CONIN			;EXECUTE SELECTED FUNCTION
	CMP	AL,6
	JZ	DCIO
	CMP	AL,7
	JZ	DCIN
	CMP	AL,8
	JZ	CONINNE
	CMP	AL,10
	JZ	READCON
	JMP	MYRET			;NON-LEGAL, EXIT

;	CONSOLE INPUT, NO ECHO

CONINNE:CALL	MYCONIN			;GET CHARACTER
	JMP	MYRET

;	PRINT STRING

PSTRING:MOV	BX,DX			;POINT BX TO STRING
	PUSH	AX
	PUSH	CX
PSTRLP:	MOV	CL,[BX]			;GET CHARACTER
	INC	BX
	CMP	CL,'$'			;END OF STRING?
	JZ	PSTRX			;IF SO, EXIT
	CALL	TABOUT			;ELSE, OUTPUT CHARACTER
	JMP	PSTRLP			;DO MORE
PSTRX:	POP	CX
	POP	AX
	JMP	MYRET

;	READ CONSOLE INTO BUFFER

READCON:CALL	READLN			;READ A LINE FROM CONSOLE
	JMP	MYRET			;AND RETURN

;	GET CONSOLE STATUS

CONST:	CALL	MYCONST			;GET CONSOLE STATUS
	JMP	MYRET

;	XENIX READ

XREAD:	PUSH	CX
	PUSH	SI			;SAVE REGISTERS
	MOV	SI,DX			;GET POINTER TO BUFFER
	MOV	BYTE PTR [SI],80	;INSERT MAX COUNT
	CALL	READLN			;READ LINE FROM CONSOLE
	MOV	AL,1[SI]		;GET COUNT OF CHARACTERS
	INC	AL			;INCLUDE CR
	XOR	AH,AH			;AX = COUNT
	PUSH	ES			;SAVE ES
	PUSH	DS
	POP	ES			;ES = DS
	PUSH	DI
	MOV	DI,SI			;POINT DI TO BUFFER
	INC	SI
	INC	SI			;MOVE TO TEXT
	MOV	CX,AX			;GET COUNT
	CLD
	REP	MOVSB			;MOVE TEXT DOWN
	MOV	BYTE PTR [DI],0AH	;ADD LF
	INC	AX			;COUNT IT
	PUSH	AX
	MOV	CL,0AH
	CALL	COUT			;PRINT LF
	POP	AX
	POP	DI			;RESTORE REGISTERS
	POP	ES
	POP	SI
	POP	CX
	CLC
XRET:	CLI
	MOV	SS,CS:STKS		;RESTORE SYSTEM STACK
	MOV	SP,CS:STK
	POP	BX
	STI
	RETFD
	DW	2			;RETURN, OLD FLAGS DUMPED

;	XENIX WRITE

XWRITE:	PUSH	DI
	PUSH	BX
	MOV	DI,OFFSET MYCNOUT	;STD OUTPUT
XWRIT1:	PUSH	SI
	PUSH	CX			;SAVE COUNT
	PUSH	DX
	MOV	SI,DX			;POINT TO BUFFER
	XOR	AX,AX			;SET A COUNTER
	OR	CX,CX			;NULL COUNT?
	JZ	XWRIT2
XWRITLP:MOV	DL,[SI]			;GET CHARACTER
	CMP	DL,'Z'-'@'		;CONTROL-Z?
	JZ	XWRIT2			;YES
	INC	AX			;ELSE, COUNT CHARACTER
	CALL	DI			;WRITE TO DEVICE
	INC	SI
	LOOP	XWRITLP			;UNTIL DONE
XWRIT2:	POP	DX
	POP	CX
	POP	SI
	POP	BX
	POP	DI
	CLC
	JMP	XRET

;	SUBROUTINES
;	READ A LINE FROM THE CONSOLE

READLN:	PUSH	SI
	PUSH	DI
	PUSH	ES
	PUSH	CS
	POP	ES			;PUT ES HERE
	MOV	DI,OFFSET TEMPLT	;POINT TO TEMPLATE
	MOV	SI,DI			;SI TOO
	PUSH	CX
	PUSH	AX
	MOV	AL,CS:TEMCNT		;GET TEMPLATE COUNT
	XOR	AH,AH			;IN AX
	ADD	SI,AX			;SI POINTS TO END OF TEMPLATE CHARS
	MOV	CS:INSFLG,0		;CLEAR INSERT FLAG
READ1:	MOV	AL,CS:COLUMN		;GET COLUMN NO.
	MOV	CS:STRTCOL,AL		;SET STARTING COLUMN NO.
	MOV	BX,DX
	MOV	CL,M			;CL = MAX LENGTH
	INC	BX			;SKIP TO USER'S COUNT
	PUSH	BX
	MOV	CH,0			;CH = CURRENT LENGTH
READNX:	PUSH	CX
	PUSH	BX			;SAVE BUFFER, COUNTERS
READN0:	CALL	MYCONIN			;GET A CHARACTER
	POP	BX
	POP	CX			;GET BUFFER, COUNTERS
	CMP	AL,0DH			;CR?
	JZ	GOTEND			;YES, END OF INPUT
	CMP	AL,0AH			;LINE FEED?
	JNZ	NOTEND
GOTEND:	INC	BX
	MOV	M,0DH			;END STRING WITH CR
	POP	BX
	MOV	M,CH			;PUT IN COUNT
	MOV	CS:TEMCNT,CH		;PUT IT HERE, TOO
	XCHG	CL,CH
	XOR	CH,CH			;CX = COUNT
	MOV	SI,BX
	INC	SI			;POINT TO CHARACTERS
	MOV	DI,OFFSET TEMPLT	;POINT TO TEMPLATE
	PUSHF
	CLD
	REP	MOVSB			;COPY INPUT TO TEMPLATE
	POPF
	MOV	CL,0DH
	CALL	COUT			;PRINT CR
READX:	POP	AX
	POP	CX
	POP	ES
	POP	DI
	POP	SI
	RET				;AND EXIT
NOTEND:	CMP	AL,0			;FUNCTION KEY?
	JNZ	NOTFUNJ			;NO
	CALL	LCONIN			;ELSE, GET KEY CODE
	CMP	AL,3BH			;F1 KEY?
	JNZ	NOTF1			;NO
	CMP	DI,SI			;AT END OF TEMPLATE?
	JZ	READNJ			;IF SO, NO CHARS
	MOV	AL,ES:[DI]		;ELSE, GET CHARACTER
	MOV	CS:INSFLG,0		;KILL INSERT FLAG
NOTFUNJ:JMP	NOTFUN			;PROCESS CHARACTER
NOTF1:	CMP	AL,3CH			;F2 KEY?
	JNZ	NOTF2
	CALL	LCONIN			;GET CHARACTER TO SEARCH FOR
	CALL	SCHTEM			;SEARCH TEMPLATE
	JNZ	READNJ1			;NOT FOUND
	SUB	AX,DI			;GET COPY COUNT
	CALL	COPYFT			;COPY TO THERE
READNJ:	MOV	CS:INSFLG,0		;CLEAR INSERT FLAG
READNJ1:JMP	READNX			;ILLEGAL FUNCTION KEY EXIT
NOTF2:	CMP	AL,3DH			;F3 KEY?
	JNZ	NOTF3
	MOV	AX,SI			;AX = END OF TEMPLATE
	SUB	AX,DI			;GET COUNT OF CHARS IN TEMPLATE
	JZ	READNJ			;NO CHARACTERS
	CALL	COPYFT			;COPY FROM TEMPLATE
	JMP	READNJ
NOTF3:	CMP	AL,53H			;DEL KEY?
	JNZ	NOTDEL
	CMP	DI,SI			;TOO MUCH?
	JZ	READNJ1			;YES
	INC	DI			;ELSE, INCREMENT TEMPLATE POINTER
	JMP	READNJ1
NOTDEL:	CMP	AL,3EH			;F4 KEY?
	JNZ	NOTF4
	CALL	LCONIN			;GET CHAR TO SEARCH FOR
	CALL	SCHTEM			;SEARCH TEMPLATE
	JNZ	READNJ1			;NOT FOUND
	MOV	DI,AX			;ELSE, PUT POINTER THERE
	JMP	READNJ1
NOTF4:	CMP	AL,3FH			;F5 KEY?
	JNZ	NOTF5
	CALL	NEWTMP			;MAKE NEW TEMPLATE
	MOV	AL,'X'-40H		;PROCESS AS CONTROL-X
	MOV	CS:INSFLG,0		;CLEAR INSERT FLAG
	JMP	SHORT NOTFUN
NOTF5:	CMP	AL,40H			;F6 KEY?
	JNZ	NOTF6
	MOV	AL,'Z'-40H
	JMP	SHORT NOTFUN		;F6 = CONTROL-Z
NOTF6:	CMP	AL,52H			;INS KEY?
	JNZ	NOTINS
	XOR	CS:INSFLG,1		;TOGGLE INSERT FLAG
	JMP	READNJ1
NOTINS:	CMP	AL,4BH			;LEFT ARROW?
	JZ	BKSP			;YES, USE AS BACKSPACE
	JMP	READNJ1
NOTFUN:	CMP	AL,8			;BACK SPACE?
	JZ	BKSP			;YES
	CMP	AL,7FH			;RUBOUT?
	JNZ	NOTRUB			;NO
BKSP:	CMP	CS:INSFLG,0		;INSERT ON?
	JNZ	TEMNBK			;IF SO, DON'T BACK UP
	CMP	DI,OFFSET TEMPLT	;AT START?
	JZ	TEMNBK			;IF SO, DON'T BACK UP
	DEC	DI			;BACK UP
TEMNBK:	CMP	CH,0			;ANY CHARACTERS?
	JNZ	DOBKS			;YES, BACK UP
	JMP	READNX
DOBKS:	DEC	CH			;ELSE, REMOVE ONE CHAR
	MOV	AL,CS:COLUMN
	MOV	CS:COMPCOL,AL		;MARK LENGTH TO COMPARE
	JMP	SHORT LINELEN		;BACK UP
NOTRUB:	CMP	AL,'X'-40H		;CONTROL-X?
	JNZ	NOTX			;NO
GOTX:	MOV	DI,OFFSET TEMPLT	;RESET TEMPLATE POINTER
BACKX:	MOV	AL,CS:STRTCOL
	CMP	AL,CS:COLUMN
	JC	BACKX1			;COL > STARTCOL
	POP	DX			;GET ORIGINAL START POSITION
	DEC	DX			;BACK UP TO START
	JMP	READ1			;START OVER
BACKX1:	DEC	CS:COLUMN		;DECREMENT COLUMN NO.
	CALL	BACKUP
	JMP	BACKX
NOTX:	CMP	AL,'U'-40H		;CONTROL-U?
	JZ	GOTX			;PROCESS AS CONTROL-X
	CMP	AL,'R'-40H		;CONTROL-R?
	JNZ	NOTR
LINELEN:PUSH	CX
	CALL	CRLFP
	POP	CX
	POP	BX			;RESTORE VALUE
	PUSH	BX
	PUSH	CX
REP0:	CMP	CH,0
	JZ	REP1			;COUNT IS ZERO
	INC	BX
	MOV	CL,M			;GET NEXT CHAR
	DEC	CH			;DECREMENT COUNT
	PUSH	CX
	PUSH	BX
	CALL	CTLOUT			;ECHO CHARACTER
	POP	BX
	POP	CX
	JMP	SHORT REP0
REP1:	PUSH	BX			;SAVE POINTER
	MOV	AL,CS:COMPCOL
	CMP	AL,0
	JNZ	REP2			;NOT AT BEGINNING
	JMP	READN0
REP2:	SUB	AL,CS:COLUMN
	MOV	CS:COMPCOL,AL		;RESET COMPARED COLUMN
BACKSP:	CALL	BACKUP			;BACK UP ONE
	DEC	CS:COMPCOL
	JNZ	BACKSP			;UNTIL DONE
	JMP	READN0			;GET NEXT CHAR
NOTR:	CMP	CS:INSFLG,0		;INSERT ON?
	JNZ	INSON			;YES
	CMP	DI,SI			;TOO MUCH?
	JZ	INSON			;YES
	INC	DI			;ELSE, INCREMENT TEMPLATE POINTER
INSON:	INC	BX
	MOV	M,AL			;PUT IN CHARACTER
	INC	CH			;COUNT IT
	CMP	CH,CL			;END OF BUFFER?
	JC	NOTLST			;NOT LAST CHARACTER
	MOV	AL,7
	CALL	LOUT			;ELSE, RING BELL
	DEC	BX			;BACK UP POINTER
	DEC	CH			;BACK UP COUNTER
	JMP	READNX			;TRY AGAIN
NOTLST:	PUSH	CX			;SAVE COUNTERS
	MOV	CL,AL
	CALL	CTLOUT			;PRINT CHAR
	POP	CX
	JMP	READNX			;READ NEXT CHAR

;	COPY CHARACTERS FROM TEMPLATE TO BUFFER
;	AX = COUNT TO COPY

COPYFT:	PUSH	SI
	MOV	SI,AX			;COUNT TO SI
COPYFTL:MOV	AL,ES:[DI]		;ELSE, GET CHARACTER
	INC	DI
	INC	BX
	MOV	M,AL			;PUT IN CHARACTER
	INC	CH			;COUNT IT
	PUSH	CX			;SAVE COUNTERS
	MOV	CL,AL
	CALL	CTLOUT			;PRINT CHAR
	POP	CX
	DEC	SI			;DONE?
	JNZ	COPYFTL
	POP	SI
	RET

;	SEARCH TEMPLATE FOR CHARACTER IN AL
;	EXIT WITH AX POINTING TO CHARACTER

SCHTEM:	PUSH	DI			;SAVE POINTER
	PUSH	CX			;SAVE CX
	MOV	CX,SI			;GET END OF TEMPLATE
	SUB	CX,DI			;GET COUNT FOR SEARCH
	CLD
	REPNZ	SCASB			;SEARCH FOR CHARACTER
	MOV	AX,DI
	PUSHF
	DEC	AX			;BACK UP TO IT
	POPF				;FLAGS TELL ALL
	POP	CX
	POP	DI
	RET

;	MAKE NEW TEMPLATE BY PUTTING CHARACTERS TO CURSOR IN IT

NEWTMP:	POP	AX			;SAVE IP
	POP	SI			;GET BUFFER START
	PUSH	SI
	PUSH	AX
	INC	SI			;POINT TO CHARACTERS
	PUSH	CX			;SAVE COUNTERS
	XCHG	CL,CH
	XOR	CH,CH			;CX = COUNT
	MOV	CS:TEMCNT,CL		;SAVE COUNT
	MOV	AX,CX			;IN AX, TOO
	MOV	DI,OFFSET TEMPLT	;POINT TO TEMPLATE
	PUSHF
	CLD
	REP	MOVSB			;MOVE IN CHARACTERS
	POPF
	POP	CX
	MOV	SI,OFFSET TEMPLT
	ADD	SI,AX			;POINT TO END OF NEW TEMPLATE
	RET

;	OUTPUT CHARACTER, WITH SPECIAL HANDLING FOR
;	CONTROL CHARACTERS

CTLOUT:	MOV	AL,CL
	CALL	ECHOC			;CHECK FOR ECHO
	JNC	TABOUT			;SKIP IF TAB, CR, LF, CTL-H
	PUSH	AX
	MOV	CL,'^'
	CALL	COUT			;PRINT "^"
	POP	AX
	OR	AL,40H			;MAKE CHARACTER PRINTABLE
	MOV	CL,AL
TABOUT:	CMP	CL,9			;TAB?
	JNZ	TAB1			;NO, USE CONOUT
TAB0:	MOV	CL,' '
	CALL	COUT			;ELSE, PRINT SPACES
	MOV	AL,CS:COLUMN
	AND	AL,111B
	JNZ	TAB0			;UNTIL TAB STOP
	RET
TAB1:	JMP	COUT

;	BACK UP CURSOR

BACKUP:	MOV	CL,8
	CALL	COUTF			;BACK UP
	MOV	CL,' '
	CALL	COUTF			;SPACE
	MOV	CL,8
	CALL	COUTF			;BACK UP AGAIN
	RET

;	PRINT CRLF, AND SPACE TO INPUT POSITION

CRLFP:	MOV	CL,'#'
	CALL	COUT			;PRINT "#"
	CALL	CRLF
CRLFP0:	MOV	AL,CS:COLUMN
	CMP	AL,CS:STRTCOL		;AT START?
	JNC	CRLFPX			;IF SO, EXIT
	MOV	CL,' '
	CALL	COUT			;ELSE, PRINT SPACES
	JMP	CRLFP0
CRLFPX:	RET

;	PRINT CRLF

CRLF:	MOV	CL,0DH
	CALL	COUT
	MOV	CL,0AH
	CALL	COUT
	RET

;	OUTPUT CHARACTER, AND MAINTAIN COLUMN NO.

COUT:	CMP	CS:COMPCOL,0		;COMPARING COLUMN NO.?
	JNZ	COMPOUT			;YES
	CALL	COUTF			;OUTPUT THE CHARACTER
	CMP	CS:PRNFLG,0		;PRINTER ON?
	JZ	COMPOUT			;NO
	MOV	AL,CL
PRTCH:	MOV	AL,CL
	MOV	AH,0
	INT	17H			;ELSE, PRINT CHARACTER
	TEST	AH,29H
	JNZ	PRTCH
COMPOUT:MOV	AL,CS:COLUMN		;GET COLUMN NUMBER
	CMP	CL,7FH			;RUBOUT?
	JZ	COUTX			;IF SO, EXIT
	CMP	CL,9			;TAB?
	JNZ	NOTTAB			;NO
	ADD	AL,8
	AND	AL,0F8H			;MOVE POINTER TO NEXT STOP
	JMP	SHORT COUTX
NOTTAB:	INC	AL			;INCREMENT COLUMN
	CMP	CL,' '			;LESS THAN SPACE?
	JNC	COUTX			;IF NOT, EXIT
	DEC	AL			;ELSE, DECREMENT COLUMN
	CMP	AL,0			;AT COLUMN ZERO?
	JZ	COUTX			;IF SO, EXIT
	CMP	CL,'H'-40H		;BACK SPACE?
	JNZ	NOTBKSP			;NO
	DEC	AL			;ELSE, DECR. COLUMN NUMBER
COUTX:	MOV	CS:COLUMN,AL		;REPLACE COLUMN NO.
	RET
NOTBKSP:CMP	CL,0DH			;CR?
	JNZ	COUTX			;NO
	MOV	AL,0			;ELSE, RESET COLUMN
	JMP	SHORT COUTX

;	OUTPUT CHARACTER, WITH CHECK FOR CONTROL-C

COUTF:	PUSH	AX
	MOV	AL,CL
	CALL	LOUT			;OUTPUT CHARACTER
	CALL	MYCONST			;CHECK FOR CONTROL-C
	POP	AX
	RET

;	CHECK FOR ECHO-ABLE CHARACTER

ECHOC:	CMP	AL,1BH			;ESC?
	JZ	ECHOX
	CMP	AL,0DH			;CR?
	JZ	ECHOX
	CMP	AL,0AH
	JZ	ECHOX
	CMP	AL,9			;TAB?
	JZ	ECHOX
	CMP	AL,8			;BACK SPACE?
	JZ	ECHOX
	CMP	AL,' '			;LESS THAN SPACE?
ECHOX:	RET

;	LOCAL CONSOLE STATUS ROUTINE

MYCONST:CALL	LCONST			;CHECK STATUS VIA BIOS
	JNZ	HAVCHR			;WE HAVE A CHARACTER
	XOR	AL,AL			;ELSE, CLEAR AL
	RET
HAVCHR:	CMP	AL,'C'-'@'		;CONTROL-C?
	JNZ	NOTC			;NO
	CALL	LCONIN			;ELSE, ABSORB CONTROL-C
	CALL	CTLC			;AND PROCESS IT
	JMP	MYCONST			;GET ANOTHER CHARACTER
NOTC:	CMP	AL,'S'-'@'		;CONTROL-S?
	JNZ	NOTS
	CALL	LCONIN			;ABSORB CONTROL-S
WFCHR:	CALL	LCONST			;CHECK KEYBOARD
	JZ	WFCHR			;UNTIL CHARACTER TYPED
	CALL	LCONIN			;ABSORB CHARACTER
	CMP	AL,'C'-'@'		;CONTROL-C?
	JNZ	NOTC0			;NO
	CALL	CTLC			;ELSE, PROCESS IT
NOTC0:	JMP	MYCONST			;AND GET ANOTHER CHAR
NOTS:	MOV	AL,0FFH			;SAY CHAR IS READY
MYCNX:	RET

;	LOCAL CONSOLE INPUT ROUTINE

MYCONIN:CALL	LCONIN			;GET CHARACTER
	CMP	AL,3			;CONTROL-C?
	JNZ	NOTC1			;NO
	CALL	CTLC			;ELSE, PROCESS IT
	JMP	MYCONIN			;GET ANOTHER CHARACTER
NOTC1:	CMP	AL,'P'-'@'		;CONTROL-P?
	JNZ	NOTP
	XOR	CS:PRNFLG,1		;TOGGLE PRINT CONTROL FLAG
	JMP	MYCONIN			;GET ANOTHER CHARACTER
NOTP:	CMP	AL,'N'-'@'		;CONTROL-N?
	JNZ	MYCNX			;NO
	MOV	CS:PRNFLG,0		;ELSE, KILL PRINTER
	JMP	MYCONIN			;GET ANOTHER CHARACTER

;	CONTROL-C PROCESSOR

CTLC:	PUSH	AX			;SAVE A BUNCH OF REGISTERS
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	DS
	PUSH	ES
	MOV	CL,AL
	CALL	CTLOUT			;OUTPUT "^C"
	CALL	CRLF
	MOV	CS:TEMP1,SS		;SAVE STACK
	MOV	CS:TEMP2,SP
	CLI
	MOV	SS,CS:STKS		;RESTORE ORIGINAL SEGMENT
	MOV	SP,CS:STK		;AND ORIGINAL STACK
	STI
	INT	23H			;EXECUTE CONTROL-C INTERRUPT
	CLI				;KILL INTERRUPS
	MOV	SS,CS:TEMP1		;RESTORE STACK
	MOV	SP,CS:TEMP2
	CMP	CS:CCFLG,0		;CONTROL-C ABORT ENABLED?
	JZ	CTLCX			;IF NOT, EXIT
	MOV	AX,4C01H		;TERMINATE, CONTROL-C EXIT
	PUSHF
	PUSH	CS
	MOV	BX,OFFSET CTLCX
	PUSH	BX
	JMP	MYEXIT			;FAKE INTERRUPT 21H
CTLCX:	STI				;IN DOS 1, NO FUNC. 4CH
	POP	ES
	POP	DS
	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

;	LOCAL CONSOLE OUTPUT

MYCNOUT:PUSH	CX
	PUSH	AX
	MOV	CL,DL
	CALL	TABOUT			;OUTPUT THE CHARACTER
	POP	AX
	POP	CX
	RET

;	LOCAL INPUT ROUTINES

LCONIN:	PUSH	DS
	PUSH	CS
	POP	DS
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	CALL	ANSI_IN			;READ CHARACTER
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	DS
	RET
LCONST:	PUSH	DS
	PUSH	CS
	POP	DS
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	CALL	ANSI_ICHK		;CHECK KEYBOARD STATUS
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	DS
	RET

;	LOCAL OUTPUT ROUTINE

LOUT:	PUSH	AX			;SAVE REGISTERS
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	CALL	ANSI_OUT		;OUTPUT CHARACTER
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

;	"CALL 5" PROCESSOR

CALL5:	POP	AX			;REMOVE IP
	POP	CS:TEMP3		;REMOVE USER CS
	POP	AX			;REMOVE PROGRAM IP
	PUSH	CS:TEMP3		;RESTORE USER CS
	PUSH	AX			;AND PROGRAM IP
	MOV	AH,CL			;GET CALL
	INT	21H			;EXECUTE IT
	RETF

;**	SPECIAL - This routine is the special console output routine.
;		It is accessed by INT 29H

;SPECIAL	PROC	FAR
;	STI
;	PUSH	DS
;	PUSH	AX
;	PUSH	BX
;	PUSH	CX
;	PUSH	DX
	
;	PUSH	CS
;	POP	DS
;	CALL	ANSI_CONFUNC

;	POP	DX
;	POP	CX
;	POP	BX
;	POP	AX
;	POP	DS
;	IRET
;SPECIAL ENDP

;
; Read from console
;

ANSI_IN:
	CLD
CI1:
	MOV	AL,0			; Clear out next character
	XCHG	NXT_CHAR,AL
	OR	AL,AL			; Was there a char in look-ahead
	JNZ	CI4			; Yes, return it.

;	Check if a string is being sent

	CMP	STRING_COUNT,0		; Any string left?
	JZ	CI2			; No, read a char.
CI1A:
	MOV	SI,STRING_PTR		; Yes, get next char in string
	MOV	AL,[SI]
	INC	STRING_PTR		; Prepare for next one
	DEC	STRING_COUNT
	JMP	SHORT CI4		; Got a good char

;	Read a character from the keyboard
	
CI2:
	MOV	AH,0			; Code for input character
	INT	16H

;	Re-map the input key

	CALL	MATCH_KEY		; Try to match the key
	CMP	STRING_COUNT,0		; String now available?
	JNZ	CI1A			; Yes, get first char
CI3:
	CMP	AL,0			; If special key then
	JNZ	CI4
	MOV	NXT_CHAR,AH		; Save scan code
CI4:
	RET

;
; Non-destructive read
;

ANSI_ICHK:
	MOV	AL,NXT_CHAR		; See if look ahead has a character
	OR	AL,AL
	JNZ	CL1

;	Check if a string is active

	CMP	STRING_COUNT,0
	JZ	CL2			; No, continue
	MOV	SI,STRING_PTR		; Yes, get char.
	MOV	AL,[SI]
	JMP	SHORT CL1		; Got lookahead char.

;	See if ROM has a character

CL2:
	MOV	AH,1			; Get ROM keyboard status
	INT	16H
	JZ	CL1			; No char., skip
	OR	AX,AX			; Check for remnants of Ctrl-break
	JNZ	CL0			; Nope, valid character
	MOV	AH,0			; Yep, eat this character
	INT	16H
	JMP	ANSI_ICHK		; Check for another
CL0:
	CALL	MATCH_KEY		; Try to match the key
	CMP	STRING_COUNT,0		; Did it match
	JZ	CL3			; No, return this char.
	MOV	AH,0			; Yes, eat this char and
	INT	16H
	MOV	SI,STRING_PTR		;  pass back string char.
	MOV	AL,[SI]
CL1:
	RET
CL3:	PUSH	AX
	XOR	AL,AL
	INC	AL
	POP	AX
	RET

;
; Write to console
;

ANSI_OUT:
	PUSH	DS
	PUSH	CS
	POP	DS

	CALL	ANSI_CONFUNC

	POP	DS
	RET

;
;ANSI Info and routines. ANSI driver implemented as a finite state automata
;This ANSI driver translates the ANSI standard escape sequences into the
; Z-150 functions. This driver is not a full implementation of ANSI, but 
; rather a minimal implementation which implements all of the necessary
; ANSI functions.
;

;
; ANSI console output driver.
;

ANSI_CONFUNC:
        JMP     STATE           ;Jump to current state

;
; State one (1).
;   Looks for an Escape character.
;

ST1:    CMP     AL,ESC          ;See if this the first character is ESC.
        JNZ     ST1A	        ;No, treat as regular character output.
        MOV     WORD PTR STATE,OFFSET ST2        ;Yes, setup state two.
        RET
ST1A:
	MOV	STATE,OFFSET ST1
	JMP	OUTCHAR

;
; State two (2).
;   Looks for the "[" character.
;

ST2:
        CMP     AL,'['          ;See if a valid state two.
        JNZ     ST1		; If an extra big one
	
        MOV     BX,PRMSTART	;Yes, get parameter pointer(flush previous).
	INC	BX		; Save spot for count of parms
        MOV     WORD PTR [PRMPNT],BX    ;Setup in pointer index.
        MOV     WORD PTR [BX],0 ;Clear first entry.
        MOV     STATE,OFFSET ST3;Setup for state three.
        RET

STSKIP:
	MOV	WORD PTR STATE,OFFSET ST1
	RET

;
; State three (3).
;   Entered one or more times for parameter passing.
;

ST3:    CMP     AL,';'          ;Look for decimal # seperator.
        JNZ     ST3A            ;No check phase A.
        INC     PRMPNT		;Yes, incr. pointer to next param.
        CMP     PRMPNT,LASTPRM	; At the end?
        JB	RETST3		;No, proceed with next parameter.
        DEC     PRMPNT		;Yes, treat as extentsion to old.
RETST3: MOV     DI,PRMPNT	;Setup for next parameter.
        MOV     BYTE PTR [DI],0 ;Pre-Initialize it to zero.
        RET

;
; State three A (3A).
;   Check for a ascii digit.
;

ST3A:   CMP     AL,'0'          ;Check for ASCII digit.
        JB      ST3A1           ;No, check for seconday command character.
        CMP     AL,'9'          ;Still checking for ASCII digit.
        JA      ST3A1           ;No, it must be a secondary.
        SUB     AL,'0'          ;Convert to binary.
        MOV     DI,PRMPNT	;Get the current parameter pointer.
        XCHG    [DI],AL         ;Get existing #.
        MOV     AH,10           ;Scale by 10.
        MUL     AH
        ADD     [DI],AL         ;Add to new digit.
        RET

;	Check for ?, =, ', and " characters
ST3A1:
	CMP	AL,'?'		; Nothing to do here
	JZ	ST3A3
	CMP	AL,'='		; Nothing to do here
	JZ	ST3A3
	CMP	AL,'"'		; Prepare for string processing
	JZ	ST3A2
	CMP	AL,"'"		; Prepare for string processing
	JNZ	ST3B
ST3A2:
	MOV	QUOTE_CHAR,AL	; Save qoute character for later match
	MOV	STATE,OFFSET ST4	; State for processing strings
ST3A3:
	RET

;	State 4 Process a string in an escape seq.
ST4:
	CMP	AL,QUOTE_CHAR		; End of string?
	JNZ	ST4A			; No, process character
	DEC	PRMPNT			; Back up pointer to correct pos.
	MOV	STATE,OFFSET ST3	; Yes, back to state 3 for more parameters
	RET
ST4A:
	MOV	DI,PRMPNT		; Get pointer
	MOV	[DI],AL			; Save character
	INC	DI
	CMP	DI,OFFSET LASTPRM
	JAE	ST4B
	MOV	BYTE PTR [DI],0
	INC	PRMPNT			; Prepare for next parm.
ST4B:
	RET


;
; State three B (3B).
;   Wasn't a ascii digit, so check for secondary command.
;

ST3B:   MOV	STATE,OFFSET ST1	;Preset STATE to state 1 just in case.
	MOV	BX,PRMPNT		;Get current pointer
	MOV	DI,PRMSTART		; Get start of parameter pointer
	SUB	BX,DI			; Get count of bytes in this string
	INC	BL
	MOV	[DI],BL			; Save as first thing at PRMSTART
	MOV	PRMPNT,DI		; Reset pointer to access parameters
        MOV     DI,OFFSET CMDTABL-3     ;Get start of Secondary command table.

ST3B1:  ADD     DI,3		;Update Command table pointer.
        CMP     BYTE PTR [DI],0	;Check for end of table.
        JNZ     ST3B2		;No, continue processing.
        JMP     OUTCHAR		;Yes, treat as regular character.
ST3B2:  CMP     AL,[DI]		;Check for valid. command.
        JNZ     ST3B1		;No, keep checking.
        JMP     [DI+1]		;Yes, transfer to that secondary command.

;
; Get binary parameter from storage and return a one if = 0
;

GETONE: CALL    GETPARM         ;Get parameter form list.
        OR      AL,AL           ;Verify for non-zero.
        JNZ     GETRET          ;Good, then return to caller.
        INC     AL              ;Bad, make it at least a one.
GETRET: CBW                     ;Sign extend AL.
        MOV     CX,AX           ;Copy of it to CX.
        RET

GETPARM:INC     WORD PTR [PRMPNT]       ;Increment parameter pointer.
GOTPARM:MOV     DI,[PRMPNT]     ;Get parameter pointer.
        MOV     AL,[DI]         ;Get parameter value.
        RET


;	NOP - Do nothing

NOP:
	RET

;	Set and Reset modes
QMARKH:
	CALL	GETPARM
	CMP	AL,7		; Check for wrap request
	JNZ	QM1
	MOV	WRAP_FLAG,1	; Make wrap active
	RET
QMARKL:
	CALL	GETPARM
	CMP	AL,7		; Check for wrap request
	JNZ	QM1
	MOV	WRAP_FLAG,0	; Make wrap inactive
	RET
QM1:
	CMP	AL,6		; Make sure parameter valid
	JBE	QM2
	RET
QM2:
	MOV	AH,0		; Set video mode
	INT	10H
	RET

;
; Enter/exit reverse video
;

ERV:
	MOV	ATTRIBUTE,07H
	RET
XRV:
	MOV	ATTRIBUTE,70H
	RET

;
; Direct cursor positioning routine.
;

CUP:
	CALL	GETONE
	MOV	DH,AL
	DEC	DH
	CALL	GETONE
	MOV	DL,AL
	DEC	DL
	JMP	SHORT MOVE_CURSOR

;	Move cursor up
CUU:
	CALL	CURRENT_CURSOR		; Get current cursor position
	CALL	GETONE
	SUB	DH,AL
	JNS	MOVE_CURSOR
	SUB	DH,DH
	JMP	SHORT MOVE_CURSOR

;	Move cursor down
CUD:
	CALL	CURRENT_CURSOR
	CALL	GETONE
	ADD	DH,AL
	CMP	DH,CRT_ROWS
	JB	MOVE_CURSOR
	MOV	DH,CRT_ROWS-1
	JMP	SHORT MOVE_CURSOR

;	Move cursor right
CUF:
	CALL	CURRENT_CURSOR
	CALL	GETONE
	ADD	DL,AL
	CMP	DL,CRT_COLS
	JB	MOVE_CURSOR
	MOV	DL,CRT_COLS
	DEC	DL
	JMP	SHORT MOVE_CURSOR

;	Move cursor left
CUB:
	CALL	CURRENT_CURSOR
	CALL	GETONE
	SUB	DL,AL
	JNS	MOVE_CURSOR
	SUB	DL,DL
	JMP	SHORT MOVE_CURSOR

;	Move the cursor to the values specified in DX
MOVE_CURSOR:
	MOV	AH,2
	INT	10H
	RET

;
; Erase all/part of screen.
;

ED:
	CALL	GETPARM
	MOV	AH,15			; Get current state
	INT	10H
	PUSH	BX			; Save page
	DEC	AH			; Set column
	MOV	DL,AH
	MOV	DH,CRT_ROWS-1		; Bottom right corner
	SUB	CX,CX			; Top left corner
	MOV	BH,ATTRIBUTE
	SUB	AL,AL			; Scroll entire window
	MOV	AH,6			; Erase screen
	INT	10H
	SUB	DX,DX			; Home the cursor
	POP	BX
	JMP	MOVE_CURSOR

;
; Erase all/part of a line.
;

EL:
	MOV	AH,15			;GET VIDEO STATE
	INT	10H
	PUSH	AX
	MOV	AH,3
	INT	10H
	POP	AX
	PUSH	DX
	SUB	AH,DL
	MOV	CL,AH
	SUB	CH,CH
	MOV	AL,' '
	MOV	BL,ATTRIBUTE
	MOV	AH,9
	INT	10H
	POP	DX
	JMP	MOVE_CURSOR

;
; Special video modes.
;

SGR:
	MOV	DI,PRMSTART	; Get the number of parameters
	MOV	CL,[DI]
	DEC	CL		; Number of parms is one less
	SUB	CH,CH
SGR1:
	PUSH	CX
	CALL	GETPARM		; Process all parameters
	CALL	SET_ATTR
	POP	CX
	LOOP	SGR1
	RET

;	Set the attribute byte according to given parameters
SET_ATTR	PROC	NEAR
;	Check for normal video
	CMP	AL,0
	JNZ	SA1
	MOV	ATTRIBUTE,7
	RET

;	Check for high intensity
SA1:
	CMP	AL,1
	JNZ	SA2
	OR	ATTRIBUTE,1 SHL 3
	RET

;	Check for blink
SA2:
	CMP	AL,5
	JNZ	SA3
	OR	ATTRIBUTE,1 SHL 7
	RET

;	Check for reverse video
SA3:
	CMP	AL,7
	JNZ	SA4
	AND	ATTRIBUTE,88H
	OR	ATTRIBUTE,70H
	RET

;	Check for invisible
SA4:
	CMP	AL,8
	JNZ	SA5
	MOV	ATTRIBUTE,0
	RET

;	Check foreground color
SA5:
	CMP	AL,30
	JB	SA6
	CMP	AL,37
	JA	SA6
	SUB	AL,30
	CALL	SWAP			; Swap bits around to get correct color map
	AND	ATTRIBUTE,NOT 7		; Get rid of old info.
	OR	ATTRIBUTE,AL		; Put in new info.
	RET

;	Check background color
SA6:
	CMP	AL,40
	JB	SA7
	CMP	AL,47
	JA	SA7
	SUB	AL,40
	CALL	SWAP
	AND	ATTRIBUTE,NOT 70H
	SHL	AL,1
	SHL	AL,1
	SHL	AL,1
	SHL	AL,1
	OR	ATTRIBUTE,AL
	RET
SA7:
	RET
SET_ATTR	ENDP

;	Reverse the order of the low three bits in AL
SWAP	PROC	NEAR
	SUB	AH,AH
	SHR	AL,1
	RCL	AH,1
	SHR	AL,1
	RCL	AH,1
	SHR	AL,1
	RCL	AH,1
	MOV	AL,AH
	RET
SWAP	ENDP

;
; Save / restore cursor position.
;

PSCP:
	MOV	AH,15			;GET VIDEO STATE
	INT	10H
	MOV	AH,3			;GET CURSOR POS.
	INT	10H
	MOV	CURSOR_POS,DX
	RET

PRCP:
	MOV	AH,15
	INT	10H
	MOV	DX,CURSOR_POS
	JMP	MOVE_CURSOR

;	Report cursor position
DSR:
	CALL	GETPARM
	CMP	AL,6
	JNZ	DSR_EXIT
	CALL	CURRENT_CURSOR		; Get the current cursor
	INC	DL
	INC	DH
	MOV	AL,DH			; Translate it into ASCII
	CBW
	DIV	TEN
	ADD	AX,'0' SHL 8 + '0'
	MOV	WORD PTR REPORT+1,AX	; Save row

	MOV	AL,DL			; Translate col into ASCII
	CBW
	DIV	TEN
	ADD	AX,'0' SHL 8 + '0'
	MOV	WORD PTR REPORT+4,AX	; Save it

	MOV	STRING_PTR,OFFSET REPORT	; Set up string output
	MOV	STRING_COUNT,LREPORT
DSR_EXIT:
	RET


;
;	Map the keyboard
;

MAP_KBD:
	MOV	DI,PRMSTART		; Get count of chars.
	MOV	AL,[DI]
	CMP	AL,2			; Two byte or less string is not valid
	JBE	MK_EXIT
	CMP	AL,3			; Check for 3 byte string
	JNZ	MK1			; Longer must be valid
	CMP	BYTE PTR [DI+1],0	; Key must not be special key
	JZ	MK_EXIT			; String invalid

;	Valid string found, enter it

MK1:
	SUB	AH,AH
	ADD	AX,PRMSTART		; Find new pointer
	CMP	AX,LASTPRM-8		; Check if less than eight spaces are left
	JAE	MK_EXIT			; If so then do not allow mapping
	MOV	PRMSTART,AX		; else map key

MK_EXIT:
	RET

;	Attempt to match a key, set STRING_COUNT to a count if match made
MATCH_KEY PROC	NEAR

	PUSH	DI			; Save regs.
	PUSH	CX
	PUSH	AX
	
	MOV	DI,OFFSET PARAMS	; Get params
CK1:
	CMP	DI,PRMSTART		; At end of buffer
	JAE	CK_EXIT			; Yes exit
	MOV	CL,[DI]			; No, get the length of the string
	SUB	CH,CH
	INC	DI			; Skip past count
	DEC	CX

;	Check if a special key to match

	CMP	AL,0
	JNZ	CK2
	CMP	AX,[DI]			; Check special key
	JNZ	CK3			; No match try next entry
	INC	DI			; Match, do partial updating of pointers
	DEC	CX
	JMP	SHORT CK4
CK2:
	CMP	AL,[DI]			; Check normal key
	JZ	CK4
CK3:
	ADD	DI,CX			; Check next key
	JMP	CK1

;	Key matched, set up string remapping
CK4:
	INC	DI			; Update pointers
	DEC	CX
	MOV	STRING_PTR,DI		; Set up pointer to string
	MOV	STRING_COUNT,CL		; Count of chars. in string
CK_EXIT:
	POP	AX
	POP	CX
	POP	DI
	RET

MATCH_KEY	ENDP


;	Return the current cursor in DX the video_page in BH
;	Also save these in memory
CURRENT_CURSOR	PROC	NEAR

	PUSH	AX
	PUSH	BX
	CALL	SET_PARMS
	MOV	AH,3			;GET CURSOR POS.
	INT	10H
	MOV	CURSOR_LOC,DX
	POP	BX
	POP	AX
	RET

CURRENT_CURSOR	ENDP

;	Set the video page and the number of columns
SET_PARMS	PROC	NEAR

	MOV	AH,15			;GET VIDEO STATE
	INT	10H
	MOV	VPAGE,BH
	MOV	CRT_COLS,AH
	RET

SET_PARMS	ENDP

;	Stuff a CTRL-C in the look-ahead
KB_BREAK PROC	NEAR
	MOV	CS:NXT_CHAR,3
	IRET
KB_BREAK ENDP

;	Output a character
;
OUTCHAR	PROC	NEAR

	CALL	CURRENT_CURSOR

	CMP	AL,7
	JNZ	OC0
	MOV	AH,14			;TTY OUTPUT
	INT	10H
	RET

;	If a carraige return then reset column to 0 and position the cursor

OC0:
	CMP	AL,13
	JNZ	OC1
	MOV	COL,0
	JMP	MOVE_CSR

;	If a line feed, handle below
OC1:
	CMP	AL,10
	JZ	OC5

;	If a backspace then see if at beginning of line

OC2:
	CMP	AL,8
	JNZ	OC3
	CMP	COL,0			; At befinning of line?
	JNZ	OC2A
	RET				; Yes, nothing to do
OC2A:
	DEC	COL			; No, back up a column
	JMP	MOVE_CSR

;	Print the character
OC3:
	CMP	AL,7
	JNZ	OC3A
	MOV	AH,14			;TTY OUTPUT
	MOV	BL,3
	JMP	SHORT OC3B
OC3A:
	MOV	BH,VPAGE
	MOV	BL,ATTRIBUTE
	MOV	CX,1
	MOV	AH,9			;WRITE ATTRIBUTE/CHAR
OC3B:
	INT	10H

;	Character printed move to next column

	INC	COL
	MOV	AL,COL
	CMP	AL,CRT_COLS		; Past end of screen?
	JB	MOVE_CSR		; No, position cursor
	CMP	WRAP_FLAG,1		; Yes, Check for wrap around active
	JZ	OC4			; Wrap around active
	DEC	COL			; No wrap, back up a column
	JMP	MOVE_CSR
OC4:
	MOV	COL,0			; Back to column 0
OC5:
	INC	ROW			; Next row
	CMP	ROW,CRT_ROWS		; Past last row?
	JB	MOVE_CSR		; No, position cursor
	DEC	ROW			; Back to last row
	CALL	SCROLL_ONE
	JMP	MOVE_CSR
OUTCHAR	ENDP

;	Move the cursor to the updated cursor location
MOVE_CSR	PROC	NEAR

	MOV	DX,CURSOR_LOC
	MOV	BH,VPAGE
	JMP	MOVE_CURSOR

MOVE_CSR	ENDP

;	Scroll the screen one line up
SCROLL_ONE	PROC	NEAR

	MOV	AL,1
	SUB	CX,CX
	MOV	DH,CRT_ROWS-1
	MOV	DL,CRT_COLS
	DEC	DL
	MOV	BH,ATTRIBUTE
	MOV	AH,6			;SCROLL UP
	INT	10H
	RET

SCROLL_ONE	ENDP
	DB	0
END_DRIVER	LABEL	NEAR

;	SET UP "DRIVER" TO INTERCEPT DOS I/O

SETUP:	MOV	AX,0C00H
	INT	21H			;CLEAR CONSOLE
	MOV	DX,OFFSET TSTMSG
	MOV	AH,9
	INT	21H			;TEST FOR Z-100 MODE
	MOV	AH,6
	MOV	DL,0FFH
	INT	21H			;LOOK FOR INPUT
	JNZ	Z100			;Z-100 MODE
	MOV	PCFLG,1			;ELSE, ENABLE PC MODE
Z100:	MOV 	AX,0C00H
	INT	21H			;CLEAR CONSOLE
	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT 	21H			;PRINT SIGN ON MESSAGE
	XOR	AX,AX
	MOV	DS,AX			;PUT DS AT INT. SEGMENT
	MOV	SI,10H*4		;INT 10H VECTOR
	LES	DI,DWORD PTR [SI]	;GET INT 10 ADDRESS
	CMP	ES:WORD PTR -2[DI],'CP'	;ZPC IN?
	JZ	ZPCIN			;IT'S IN
	PUSH	CS
	POP	DS			;ELSE, FIX DS
	MOV	DX,OFFSET NOZPC
	MOV	AH,9
	INT	21H			;SAY "NO ZPC"
	INT	20H			;EXIT
ZPCIN:	CMP	ES:WORD PTR -4[DI],'NA'	;ANSISYS IN?
	JNZ	NOANSI			;NOT IN
	PUSH	CS
	POP	DS			;ELSE, FIX DS
	MOV	DX,OFFSET ANSIN
	MOV	AH,9
	INT	21H			;SAY "ANSISYS IS IN"
	INT	20H			;EXIT
NOANSI:	MOV	[SI],OFFSET INT10	;REPLACE INT 10 VECTOR
	MOV	2[SI],CS
	PUSH	CS
	POP	DS			;RESTORE DS
	MOV	I10ADR,DI		;PUT IN JUMP TO INT 10
	MOV	I10ADR+2,ES
	MOV	I10ADR1,DI		;PUT IT HERE, TOO
	MOV	I10ADR1+2,ES
	XOR	AX,AX
	MOV	DS,AX
	MOV	SI,21H*4		;SYSTEM INT. VECTOR
	LES	DI,DWORD PTR [SI]	;GET SYS INT. ADDRESS
	MOV	[SI],OFFSET MYSYS	;REPLACE IT WITH MY ADDR
	MOV	2[SI],CS		;AND THIS SEGMENT
	PUSH	CS
	POP	DS			;RESTORE DS
	MOV	SYSADR,DI		;PUT IN JUMP TO SYSTEM
	MOV	SYSADR+2,ES
	MOV	SI,6
	LES	DI,DWORD PTR [SI]	;GET "CALL 5" ADDRESS
	INC	DI			;POINT TO ADDRESS
	MOV	AX,OFFSET CALL5
	CLD
	STOSW				;MOVE IN NEW ONE
	MOV	AX,CS
	STOSW

;	SUB	AX,AX
;	MOV	ES,AX
;	MOV	DI,29H SHL 2
;	MOV	AX,OFFSET SPECIAL
;	STOSW
;	MOV	AX,CS
;	STOSW

;	Take keyboard break address

;	MOV	DI,BREAK_INTR SHL 2
;	MOV	AX,OFFSET KB_BREAK
;	STOSW
;	MOV	AX,CS
;	STOSW

	MOV	DX,OFFSET INSMSG
	MOV	AH,9
	INT	21H			;SAY "ANSISYS INSTALLED"
	MOV	AH,3			;GET CURSOR POS.
	INT	10H
	MOV	CURSOR_LOC,DX
	MOV	DX,OFFSET END_DRIVER	;POINT TO END OF RES. CODE
	INT	27H			;EXIT WITH CODE RESIDENT

TSTMSG	DB	13,27,'Z',13,'  $'	;Z-100 TEST MSG
SIGNON	DB	13,10,'ANSI.SYS Emulator for ZPC, V. 1.0',13,10,10
	DB	'By Patrick Swayne, HUG Software Engineer',13,10,10
	DB	"Copyright (C) 1985 by Heath/Zenith Users' Group"
	DB	13,10,10,'$'
NOZPC	DB	7,'You must install ZPC before installing ANSISYS.$'
ANSIN	DB	7,'ANSISYS is already installed.$'
INSMSG	DB	'ANSISYS is now installed.$'

CODE	ENDS
	END	START
          