M	EQU	BYTE PTR 0[BX]
;	TYPER -- PRINT TEXT TYPED AT KEYBOARD
;
;	THIS PROGRAM ALLOWS THE USER TO ENTER
;	LINES OF TEXT AT THE KEYBOARD AND HAVE
;	THEM SENT TO THE PRINTER.  IT ALLOWS
;	ESCAPE SEQUENCES TO BE TYPED WITHOUT
;	ANY EFFECT ON THE TERMINAL.


;	CP/M ROUTINES, ETC.

CONIN	EQU	8			;READ CONSOLE
CONOUT	EQU	2			;OUTPUT TO CONSOLE
LIST 	EQU	5			;SEND CHARACTER TO LST DEVICE
PRINT 	EQU	9			;PRINT STRING ON CONSOLE
	
CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	MOV	DX,OFFSET (SIGNON)	;GET SIGN ON MESSAGE
	MOV	AH,PRINT
	INT	21H			;PRINT IT
PROMPT:	MOV	DX,OFFSET (PRMMSG)	;GET PROMPT MESSAGE
	MOV	AH,PRINT
	INT	21H			;PRINT IT
	MOV	BX,OFFSET (BUFFER)
	MOV	WORD PTR BUFPTR,BX	;SET UP BUFFER POINTER
INLOOP:	XOR	AL,AL
	MOV	BYTE PTR INBUFF+2,AL	;CLEAR FIRST CHARACTER
	MOV	DX,OFFSET (INBUFF)	;POINT TO INPUT BUFFER
	CALL	READ			;READ LINE FROM CONSOLE
	MOV	DX,OFFSET (CRLFMSG)
	MOV	AH,PRINT
	INT	21H			;PRINT CR LF AFTER LINE
	MOV	AL,BYTE PTR INBUFF+2	;GET FIRST CHARACTER
	CMP	AL,'.'			;IS HE DONE?
	JZ	FINISH			;IF SO, LEAVE
	MOV	AL,BYTE PTR INBUFF+1	;GET COUNT
	MOV	CH,AL			;B = COUNT
	INC	CH			;PRE-INCREMENT IT
	MOV	DX,OFFSET (INBUFF+2)	;POINT TO TEXT
	MOV	BX,WORD PTR BUFPTR	;GET BUFFER POINTER
MOVTXT:	DEC	CH			;DONE MOVING TEXT?
	JZ	MOVDONE			;YES
	MOV	SI,DX			;GET A CHARACTER
	MOV	AL,[SI]
	CMP	AL,'^'			;CONTROL CHAR COMING?
	JNZ	NOCON			;NO
	INC	DX			;MOVE TO NEXT CHARACTER
	MOV	SI,DX			;GET IT
	MOV	AL,[SI]
	CMP	AL,'^'			;LITTERAL "^"?
	JZ	NOCON			;YES
	AND	AL,5FH			;ELSE, CAPITALIZE
	SUB	AL,40H			;AND MAKE IT A CONTROL CHARACTER
NOCON:	MOV	M,AL			;PUT IT IN BUFFER
	INC	DX
	INC	BX			;INCREMENT POINTERS
	JMP	MOVTXT			;LOOP UNTIL FINISHED
MOVDONE:DEC	BX			;BACK UP TO LAST CHARACTER
	MOV	AL,M			;GET IT
	CMP	AL,'~'			;SUPPRESS CRLF?
	JZ	NOCRLF			;IF SO, JUMP
	CMP	AL,'`'			;CR ONLY?
	JZ	SUPLF			;IF SO, JUMP
	INC	BX			;ELSE FIX POINTER
SUPLF:	MOV	M,0DH			;TERMINATE LINE
	INC	BX			;WITH CR
	CMP	AL,'`'			;SUPPRESS LF?
	JZ	NOCRLF			;IF SO, JUMP
	MOV	M,0AH			;ADD LF
	INC	BX			;GET NEXT UNUSED LOCATION
NOCRLF:	MOV	WORD PTR BUFPTR,BX	;UPDATE BUFFER POINTER
	JMP	INLOOP			;GET ANOTHER LINE
FINISH:	MOV	BX,WORD PTR BUFPTR	;GET BUFFER POINTER
	MOV	M,0FFH			;TERMINATE TEXT
	MOV	BX,OFFSET (BUFFER)	;POINT TO TEXT START
PLOOP:	MOV	AL,M			;GET CHARCTER
	CMP	AL,0FFH			;END OF TEXT?
	JNZ	L_1			;IF SO, START OVER
	JMP	PROMPT
L_1:
	PUSH	BX			;SAVE POINTER
	MOV	DL,M			;GET CHARACTER TO PRINT
	MOV	AH,LIST
	INT	21H			;PRINT CHARACTER
	POP	BX			;RESTORE POINTER
	INC	BX			;INCREMENT IT
	JMP	PLOOP			;LOOP UNTIL FINISHED

READ:	MOV	Byte Ptr STRTCOL,0	;SET STARTING COLUMN NO.
	MOV	Byte Ptr COLUMN,0	;AND COLUMN NO.
	MOV	BX,DX
	MOV	CL,M			;CL = MAX LENGTH
	INC	BX			;SKIP TO USER'S COUNT
	PUSH	BX
	MOV	CH,0			;CH = CURRENT LENGTH
READNX:	PUSH	CX
	PUSH	BX			;SAVE BUFFER, COUNTERS
READN0:	MOV	AH,CONIN
	INT	21H			;GET A CHARACTER
	POP	BX
	POP	CX			;GET BUFFER, COUNTERS
	CMP	AL,0DH			;CR?
	JZ	GOTEND			;YES, END OF INPUT
	CMP	AL,0AH			;LINE FEED?
	JNZ	NOTEND
GOTEND:	JMP	READEN			;ELSE, END
NOTEND:	CMP	AL,8			;BACK SPACE?
	JZ	BKSP			;YES
	CMP	AL,7FH			;RUBOUT?
	JNZ	NOTRUB			;NO
BKSP:	CMP	CH,0			;NO CHARACTERS?
	JZ	READNX			;NO, JUST READ
	DEC	CH			;ELSE, REMOVE ONE CHAR
	MOV	AL,Byte Ptr COLUMN
	MOV	Byte Ptr COMPCOL,AL	;MARK LENGTH COMPUTING
	JMP	LINELEN			;BACK UP
NOTRUB:	CMP	AL,'X'-40H		;CONTROL-X?
	JNZ	NOTX			;NO
BACKX:	MOV	AL,Byte Ptr STRTCOL
	CMP	AL,Byte Ptr COLUMN
	JC	BACKX1			;COL > STARTCOL
	POP	DX			;GET ORIGINAL START POSITION
	DEC	DX			;BACK UP TO START
	JMP	READ			;ELSE, START OVER
BACKX1:	DEC	Byte Ptr COLUMN		;DECREMENT COLUMN NO.
	CALL	BACKUP
	JMP	SHORT BACKX
NOTX:	CMP	AL,'U'-40H		;CONTROL-U?
	JNZ	NOTU			;NOPE
	CALL	CRLFP			;ELSE, CRLF
	POP	DX			;GET START POS.
	DEC	DX
	JMP	READ			;START OVER
NOTU:	CMP	AL,'R'-40H		;CONTROL-R?
	JNZ	NOTR
LINELEN:PUSH	CX
	CALL	CRLFP
	POP	CX
	POP	BX			;RESTORE VALUE
	PUSH	BX
	PUSH	CX
REP0:	CMP	CH,0
	JZ	REP1			;COUNT IS ZERO
	INC	BX
	MOV	CL,M			;GET NEXT CHAR
	DEC	CH			;DECREMENT COUNT
	PUSH	CX
	PUSH	BX
	CALL	CTLOUT			;ECHO CHARACTER
	POP	BX
	POP	CX
	JMP	SHORT REP0
REP1:	PUSH	BX			;SAVE POINTER
	MOV	AL,Byte Ptr COMPCOL
	CMP	AL,0
	JNZ	REP2			;NOT AT BEGINNING
	JMP	READN0
REP2:	SUB	AL,Byte Ptr COLUMN
	MOV	Byte Ptr COMPCOL,AL	;RESET COMPUTED COLUMN
BACKSP:	CALL	BACKUP			;BACK UP ONE
	DEC	Byte Ptr COMPCOL
	JNZ	BACKSP			;UNTIL DONE
	JMP	READN0			;GET NEXT CHAR
NOTR:
RDECHO:	INC	BX
	MOV	M,AL			;PUT IN CHARACTER
	INC	CH			;COUNT IT
RDECH1:	PUSH	CX
	PUSH	BX			;SAVE POINTERS, COUNTERS
	MOV	CL,AL
	CALL	CTLOUT			;PRINT CHAR
	POP	BX
	POP	CX
	CMP	CH,CL			;END OF BUFFER?
	JNC	READEN			;IF SO, END
	JMP	READNX			;ELSE, READ NEXT CHAR
READEN:	POP	BX
	MOV	M,CH			;PUT IN COUNT
	MOV	CL,0DH
	CALL	COUT			;PRINT CR
READX:	RET				;AND EXIT

CTLOUT:	MOV	AL,CL
	CALL	ECHOC			;CHECK FOR ECHO
	JNC	TABOUT			;SKIP IF GRAPHIC, TAB, CR, LF, CTLH
	PUSH	AX
	MOV	CL,'^'
	CALL	COUT			;PRINT "^"
	POP	AX
	OR	AL,40H			;MAKE CHARACTER PRINTABLE
	MOV	CL,AL
TABOUT:	CMP	CL,9			;TAB?
	JNZ	TAB1			;NO, USE COUT
TAB0:	MOV	CL,' '
	CALL	COUT			;ELSE, PRINT SPACES
	MOV	AL,BYTE PTR COLUMN
	AND	AL,111B
	JNZ	TAB0			;UNTIL TAB STOP
	RET
TAB1:	CALL	COUT
	RET

BACKUP:	MOV	CL,8
	CALL	COUTF			;BACK UP
	MOV	CL,' '
	CALL	COUTF			;SPACE
	MOV	CL,8
	CALL	COUTF			;BACK UP AGAIN
	RET

CRLFP:	MOV	CL,'#'
	CALL	COUT			;PRINT "#"
	CALL	CRLF
CRLFP0:	MOV	AL,BYTE PTR COLUMN
	CMP	AL,BYTE PTR STRTCOL	;AT START?
	JNC	CRLFPX			;IF SO, EXIT
	MOV	CL,' '
	CALL	COUT			;ELSE, PRINT SPACES
	JMP	CRLFP0
CRLFPX:	RET

CRLF:	MOV	CL,0DH
	CALL	COUT
	MOV	CL,0AH
	CALL	COUT
	RET

COUT:	CMP	BYTE PTR COMPCOL,0	;COMPUTING COLUMN?
	JNZ	COMPOUT			;YES
	CALL	COUTF			;PRINT THE CHARACTER
COMPOUT:MOV	AL,BYTE PTR COLUMN	;GET COLUMN NUMBER
	CMP	CL,7FH			;RUBOUT?
	JZ	COUTX			;IF SO, EXIT
	INC	AL			;ELSE, INCREMENT COLUMN
	CMP	CL,' '			;LESS THAN SPACE?
	JNC	COUTX			;IF NOT, EXIT
	DEC	AL			;ELSE, DECREMENT COLUMN
	CMP	AL,0			;AT COLUMN ZERO?
	JZ	COUTX			;IF SO, EXIT
	CMP	CL,'H'-40H		;BACK SPACE?
	JNZ	NOTBKSP			;NO
	DEC	AL			;ELSE, DECREMENT COLUMN NUMBER
COUTX:	MOV	BYTE PTR COLUMN,AL	;REPLACE COLUMN NO.
	RET
NOTBKSP:CMP	CL,0AH			;LF?
	JNZ	COUTX			;NO
	MOV	AL,0			;ELSE, RESET COLUMN
	JMP	SHORT COUTX

COUTF:	MOV	DL,CL
	MOV	AH,CONOUT
	INT	21H
	RET

ECHOC:	CMP	AL,0DH			; CR?
	JZ	ECHOX
	CMP	AL,0AH
	JZ	ECHOX
	CMP	AL,9			; TAB?
	JZ	ECHOX
	CMP	AL,8			; BACK SPACE?
	JZ	ECHOX
	CMP	AL,' '			; LESS THAN SPACE?
ECHOX:	RET

SIGNON 	DB	'TYPEWRITER EMULATOR  by PS:',0DH,0AH,0DH,0AH
	DB	'Enter lines to be printed when prompted.  Enter',0DH,0AH
	DB	'~ at the end of the line to suppress CRLF, and',0DH,0AH
	DB	'` at the end to suppress LF only.  Enter',0DH,0AH
	DB	'. in the first column when done.',0DH,0AH,'$'
PRMMSG 	DB	0DH,0AH,'Enter lines (or Control-C to exit):'
	DB	0DH,0AH
CRLFMSG	DB	0DH,0AH,'$'

COLUMN	DB	0			;COLUMN NO.
STRTCOL	DB	0			;STARTING COLUMN
COMPCOL	DB	0			;COMPUTED COLUMN
BUFPTR 	DW	OFFSET (0)		;BUFFER POINTER
INBUFF 	DB	80,0			;MAX CHARACTERS, COUNT
BUFFER 	EQU	$+80			;BUFFER STARTS HERE

	
CODE	ENDS
	END	START
                                                   