	PAGE	,132
	TITLE	'FAST INPUT/OUTPUT FOR Z-100 MS-DOS'
;	FASTIO - FAST INPUT/OUTPUT
;
;	THIS PROGRAM PROVIDES FAST INPUT/OUTPUT FOR Z-DOS/
;	MS-DOS ON A Z-100 SERIES COMPUTER BY BYPASSING THE
;	SYSTEM FOR CERTAIN I/O CALLS.  AFFECTED ARE CONSOLE
;	I/O, AUXILIARY I/O, AND LIST (PRINTER) OUTPUT.
;
;	I/O RE-DIRECTION WILL NOT WORK WHILE THIS PROGRAM IS
;	ACTIVE.
;
;	BY P. SWAYNE, HUG  18-MAR-85  25-JUN-85
;
;	COPYRIGHT (C) 1985 BY HEATH USERS' GROUP

;	DEFINITIONS

M	EQU	BYTE PTR 0[BX]		;MEMORY POINTER

SYS	SEGMENT AT 0
	ORG	21H*4
SYSINT	LABEL	FAR			;SYSTEM INTERRUPT
SYS	ENDS
BIOS	SEGMENT AT 40H
	ORG	3
BCONST	LABEL	FAR			;BIOS CONSOLE STATUS
	ORG	6
BCONIN	LABEL	FAR			;BIOS CONSOLE INPUT
	ORG	0CH
BLSTOUT	LABEL	FAR			;BIOS LIST OUTPUT
	ORG	0FH
BAUXIN	LABEL	FAR			;BIOS AUX INPUT
	ORG	12H
BAUXOUT	LABEL	FAR			;BIOS AUX OUTPUT
BIOS	ENDS
ROM	SEGMENT AT 0FE01H
	ORG	19H
ROMOUT	LABEL	FAR			;ROM CONSOLE OUTPUT
ROM	ENDS

JMPF	MACRO
	DB	0EAH			;FAR JUMP INSTRUCTION
	ENDM
RETF	MACRO
	DB	0CBH			;FAR RETURN INSTRUCTION
	ENDM
RETFD	MACRO
	DB	0CAH			;FAR RETURN WITH DISPLACEMENT
	ENDM

FASTIO	SEGMENT
	ASSUME	CS:FASTIO,DS:FASTIO,ES:FASTIO,SS:FASTIO
	ORG	100H

START:	JMP	SETUP			;SET UP PROGRAM

;	MEMORY CELLS USED IN THIS PROGRAM

LSTAK	LABEL	NEAR			;PUT STACK HERE (USE HEADER)
SYSSTK	DW	0			;SYSTEM STACK
SYSSTKS	DW	0			;SYSTEM STACK SEGMENT
TEMP1	DW	0			;TEMP. STORAGE NO. 1
TEMP2	DW	0			;TEMP. STORAGE NO. 2
TEMP3	DW	0			;TEMP. STORAGE NO. 3
FASTFLG	DB	1			;FASTIO ENABLE FLAG
CCFLG	DB	1			;CONTROL-C ABORT ENABLE FLAG
PRNFLG	DB	0			;PRINTER TOGGLE FLAG
COLUMN	DB	0			;SCREEN COLUMN NO.
STRTCOL	DB	0			;LINE INPUT STARTING COLUMN
COMPCOL	DB	0			;COMPARED COLUMN NO

;	TABLE OF I/O ROUTINES 1-12

FUNCTBL	DW	CONIN			;CONSOLE INPUT
	DW	CONOUT			;CONSOLE OUTPUT
	DW	AUXIN			;AUXILIARY INPUT
	DW	AUXOUT			;AUXILIARY OUTPUT
	DW	LSTOUT			;LIST OUTPUT
	DW	DCIO			;DIRECT CONSOLE I/O
	DW	DCIN			;DIRECT CONSOLE INPUT
	DW	CONINNE			;CONSOLE INPUT, NO ECHO
	DW	PSTRING			;PRINT STRING
	DW	READCON			;READ CONSOLE BUFFER
	DW	CONST			;CHECK CONSOLE STATUS
	DW	FLUSH			;FLUSH CONSOLE BUFFER

;	MAIN PROGRAM
;	HERE, WE INTERCEPT SYSTEM CALLS, AND FILTER OUT
;	I/O CALLS THAT WE WANT TO DO FASTER.

	DB	'FS'			;IDENTIFIER
MYSYS:	OR	AH,AH			;FUNCTION ZERO?
	JZ	MYEXIT			;YES, GO TO DOS
	CMP	AH,13			;SUPPORTED FUNCTION?
	JC	FUNCOK			;YES
	CMP	AH,63			;XENIX READ?
	JZ	FUNCOK
	CMP	AH,64			;XENIX WRITE?
	JZ	FUNCOK
	CMP	AH,0F0H			;SET FASTIO FUNCTION?
	JZ	SETFAST			;YES
	JMP	SHORT MYEXIT		;UNSUPPORTED FUNCTION
FUNCOK:	CMP	CS:FASTFLG,0		;FASTIO ON?
	JZ	MYEXIT			;NO
	PUSH	BX			;ELSE, SAVE BX
	MOV	CS:SYSSTK,SP		;SAVE STACK
	MOV	CS:SYSSTKS,SS		;AND STACK SEGMENT
	PUSH	CS
	POP	SS			;PUT STACK SEGMENT HERE
	MOV	SP,OFFSET LSTAK		;SET LOCAL STACK
	STI
	CMP	AH,63			;XENIX READ?
	JNZ	NOTXR
	JMP	XREAD
NOTXR:	CMP	AH,64			;XENIX WRITE?
	JNZ	NOTXW
	JMP	XWRITE
NOTXW:	DEC	AH			;ELSE, START AT ZERO
	MOV	BL,AH			;GET FUNCTION IN BL
	XOR	BH,BH
	SHL	BX,1			;MPY BY 2
	MOV	BX,CS:FUNCTBL[BX]	;GET ADDRESS OF FUNCTION
	INC	AH			;FIX AH
	JMP	BX			;EXECUTE FUNCTION
MYEXIT:	JMPF				;JUMP TO SYSTEM
SYSADR	DD	0			;SYSTEM ADDRESS
MYRET:	CLI
	MOV	SS,CS:SYSSTKS		;RESTORE SYSTEM STACK
	MOV	SP,CS:SYSSTK
	POP	BX
	IRET				;RETURN, FUNCTION COMPLETED

;	LOCAL FUNCTIONS START HERE
;	SET FASTIO PARAMETERS

SETFAST:OR	AL,AL			;DECODE SUB-FUNCTION
	JZ	FASTOFF			;TURN FASTIO OFF
	DEC	AL
	JZ	FASTON			;TURN FASTIO ON
	DEC	AL
	JZ	CCABT			;SET CONTROL-C ABORT
	DEC	AL
	JZ	CCNABT			;SET CONTROL-C NO ABORT
	IRET				;ELSE, ILLEGAL FUNCTION
FASTOFF:MOV	CS:FASTFLG,0		;KILL FASTIO
	IRET	
FASTON:	MOV	CS:FASTFLG,1		;ENABLE FASTIO
	IRET	
CCABT:	MOV	CS:CCFLG,1		;ENABLE CONTROL-C ABORT
	IRET	
CCNABT:	MOV	CS:CCFLG,0		;DISABLE CONTROL-C ABORT
	IRET	
	
;	CONSOLE INPUT

CONIN:	CALL	BCONST			;CHECK CONSOLE STATUS
	JZ	CONIN			;WAIT FOR CHARACTER
	CALL	MYCONIN			;GET CHARACTER
	PUSH	CX
	PUSH	AX
	MOV	CL,AL
	CALL	CTLOUT			;OUTPUT CHARACTER
	POP	AX
	POP	CX
	JMP	MYRET

;	CONSOLE OUTPUT

CONOUT:	CALL	MYCNOUT			;OUTPUT THE CHARACTER
	JMP	MYRET

;	LIST OUTPUT

LSTOUT:	CALL	MYLSOUT			;PRINT THE CHARACTER
	JMP	MYRET

;	DIRECT CONSOLE I/O

DCIO:	CMP	DL,0FFH			;INPUT?
	JZ	DCINN			;YES
	PUSH	AX
	MOV	AL,DL
	CALL	ROUT			;ELSE, OUTPUT CHARACTER
	POP	AX
	JMP	MYRET
DCINN:	CALL	BCONST			;GET STATUS
	JNZ	GOTCHR			;WE HAVE A CHARACTER
	XOR	AL,AL			;SET Z FLAG
	JMP	XRET			;RETURN
GOTCHR:	CALL	BCONIN			;GET CHARACTER
	OR	AL,AL			;CLEAR Z FLAG
	JMP	XRET			;RETURN

;	DIRECT CONSOLE INPUT

DCIN:	CALL	BCONST
	JZ	DCIN			;WAIT FOR CHARACTER
	CALL	BCONIN			;GET IT
	JMP	MYRET

;	FLUSH CONSOLE BUFFER, THEN EXECUTE FUNCTION IN AL

FLUSH:	PUSH	AX			;SAVE FUNCTION
FLUSH1:	CALL	BCONST			;CHECK STATUS
	JZ	FLUSH2			;INPUT BUFFER EMPTY
	CALL	BCONIN			;DUMP CHARACTER
	JMP	FLUSH1
FLUSH2:	POP	AX			;GET FUNCTION
	CMP	AL,1
	JZ	CONIN			;EXECUTE SELECTED FUNCTION
	CMP	AL,6
	JZ	DCIO
	CMP	AL,7
	JZ	DCIN
	CMP	AL,8
	JZ	CONINNE
	CMP	AL,10
	JZ	READCON
	JMP	MYRET			;NON-LEGAL, EXIT

;	CONSOLE INPUT, NO ECHO

CONINNE:CALL	MYCONIN			;GET CHARACTER
	JMP	MYRET

;	PRINT STRING

PSTRING:MOV	BX,DX			;POINT BX TO STRING
	PUSH	AX
	PUSH	CX
PSTRLP:	MOV	CL,[BX]			;GET CHARACTER
	INC	BX
	CMP	CL,'$'			;END OF STRING?
	JZ	PSTRX			;IF SO, EXIT
	CALL	COUT			;ELSE, OUTPUT CHARACTER
	JMP	PSTRLP			;DO MORE
PSTRX:	POP	CX
	POP	AX
	JMP	MYRET

;	READ CONSOLE INTO BUFFER

READCON:CALL	READLN			;READ A LINE FROM CONSOLE
	JMP	MYRET			;AND RETURN

;	READ AUXILIARY DEVICE

AUXIN:	CALL	MYAUXIN			;READ AUX DEVICE
	JMP	MYRET

;	OUTPUT TO AUXILIARY DEVICE

AUXOUT:	CALL	MYAXOUT			;OUTPUT TO AUX
	JMP	MYRET

;	GET CONSOLE STATUS

CONST:	CALL	MYCONST			;GET CONSOLE STATUS
	JMP	MYRET

;	XENIX READ

XREAD:	CMP	BX,4			;ILLEGAL CALL?
	JNC	JMPSYS			;IF SO, LET SYSTEM DO IT
	PUSH	DI
	OR	BX,BX
	JNZ	XREAD0			;NOT STD INPUT
	JMP	XREADSI			;ELSE, SPECIAL CASE
XREAD0:	MOV	DI,OFFSET MYAUXIN	;ASSUME AUX INPUT
	CMP	BX,3
	JZ	XREAD1			;IT IS
	POP	DI			;ELSE, ILLEGAL CALL
JMPSYS:	CLI
	MOV	SS,CS:SYSSTKS		;RESTORE SYSTEM STACK
	MOV	SP,CS:SYSSTK
	POP	BX
	JMP	MYEXIT			;EXIT TO SYSTEM
XREAD1:	PUSH	SI			;SAVE SI
	PUSH	CX			;SAVE COUNT
	XOR	BX,BX			;CLEAR A COUNTER
	MOV	SI,DX
XREADLP:CALL	DI			;READ FROM DEVICE
	MOV	[SI],AL			;STORE CHARACTER
	CMP	AL,'Z'-'@'		;CONTROL-Z?
	JZ	XREAD2			;YES
	INC	BX			;ELSE, COUNT CHARACTER
	INC	SI
	LOOP	XREADLP			;LOOP UNTIL DONE
XREAD2:	MOV	AX,BX			;PUT COUNT IN AX
	POP	CX
	POP	SI
	CLC				;CLEAR CARRY
XRET:	CLI
	MOV	SS,CS:SYSSTKS		;RESTORE SYSTEM STACK
	MOV	SP,CS:SYSSTK
	POP	BX
	STI
	RETFD
	DW	2			;RETURN, FLAGS SKIPPED
XREADSI:PUSH	CX
	PUSH	SI			;SAVE REGISTERS
	MOV	SI,DX			;GET POINTER TO BUFFER
	MOV	BYTE PTR [SI],80	;INSERT MAX COUNT
	CALL	READLN			;READ LINE FROM CONSOLE
	MOV	AL,1[SI]		;GET COUNT OF CHARACTERS
	INC	AL			;INCLUDE CR
	XOR	AH,AH			;AX = COUNT
	PUSH	ES			;SAVE ES
	PUSH	DS
	POP	ES			;ES = DS
	PUSH	DI
	MOV	DI,SI			;POINT DI TO BUFFER
	INC	SI
	INC	SI			;MOVE TO TEXT
	MOV	CX,AX			;GET COUNT
	CLD
	REP	MOVSB			;MOVE TEXT DOWN
	MOV	BYTE PTR [DI],0AH	;ADD LF
	INC	AX			;COUNT IT
	PUSH	AX
	MOV	CL,0AH
	CALL	COUT			;PRINT LF
	POP	AX
	POP	DI			;RESTORE REGISTERS
	POP	ES
	POP	SI
	POP	CX
	CLC
	JMP	XRET			;RETURN TO CALLER

;	XENIX WRITE

XWRITE:	CMP	BX,5
	JNC	JMPSYS			;ILLEGAL CALL
	PUSH	DI
	PUSH	BX
	MOV	DI,OFFSET MYCNOUT	;ASSUME STD OUTPUT
	DEC	BX
	JZ	XWRIT1			;IT IS
	MOV	DI,OFFSET MYAXOUT	;ASSUME AUX OUTPUT
	DEC	BX
	DEC	BX
	JZ	XWRIT1			;IT IS
	MOV	DI,OFFSET MYLSOUT	;ASSUME LST OUTPUT
	DEC	BX
	JZ	XWRIT1			;IT IS
	POP	BX
	POP	DI
	JMP	JMPSYS			;ELSE, LET SYSTEM DO IT
XWRIT1:	PUSH	SI
	PUSH	CX			;SAVE COUNT
	PUSH	DX
	MOV	SI,DX			;POINT TO BUFFER
	XOR	AX,AX			;SET A COUNTER
	OR	CX,CX			;NULL COUNT?
	JZ	XWRIT2
XWRITLP:MOV	DL,[SI]			;GET CHARACTER
	CMP	DL,'Z'-'@'		;CONTROL-Z?
	JZ	XWRIT2			;YES
	INC	AX			;ELSE, COUNT CHARACTER
	CALL	DI			;WRITE TO DEVICE
	INC	SI
	LOOP	XWRITLP			;UNTIL DONE
XWRIT2:	POP	DX
	POP	CX
	POP	SI
	POP	BX
	POP	DI
	CLC
	JMP	XRET

;	SUBROUTINES
;	READ A LINE FROM THE CONSOLE

READLN:	PUSH	CX			;SAVE CX
	PUSH	AX
READ1:	MOV	AL,CS:COLUMN		;GET COLUMN NO.
	MOV	CS:STRTCOL,AL		;SET STARTING COLUMN NO.
	MOV	BX,DX
	MOV	CL,M			;CL = MAX LENGTH
	INC	BX			;SKIP TO USER'S COUNT
	PUSH	BX
	MOV	CH,0			;CH = CURRENT LENGTH
READNX:	PUSH	CX
	PUSH	BX			;SAVE BUFFER, COUNTERS
READN0:	CALL	MYCONIN			;GET A CHARACTER
	POP	BX
	POP	CX			;GET BUFFER, COUNTERS
	CMP	AL,0DH			;CR?
	JZ	GOTEND			;YES, END OF INPUT
	CMP	AL,0AH			;LINE FEED?
	JNZ	NOTEND
GOTEND:	INC	BX
	MOV	M,0DH			;END STRING WITH CR
	POP	BX
	MOV	M,CH			;PUT IN COUNT
	MOV	CL,0DH
	CALL	COUT			;PRINT CR
READX:	POP	AX
	POP	CX
	RET				;AND EXIT
NOTEND:	CMP	AL,8			;BACK SPACE?
	JZ	BKSP			;YES
	CMP	AL,7FH			;RUBOUT?
	JNZ	NOTRUB			;NO
BKSP:	CMP	CH,0			;NO CHARACTERS?
	JZ	READNX			;NO, JUST READ
	DEC	CH			;ELSE, REMOVE ONE CHAR
	MOV	AL,CS:COLUMN
	MOV	CS:COMPCOL,AL		;MARK LENGTH TO COMPARE
	JMP	SHORT LINELEN		;BACK UP
NOTRUB:	CMP	AL,'X'-40H		;CONTROL-X?
	JNZ	NOTX			;NO
BACKX:	MOV	AL,CS:STRTCOL
	CMP	AL,CS:COLUMN
	JC	BACKX1			;COL > STARTCOL
	POP	DX			;GET ORIGINAL START POSITION
	DEC	DX			;BACK UP TO START
	JMP	READ1			;START OVER
BACKX1:	DEC	CS:COLUMN		;DECREMENT COLUMN NO.
	CALL	BACKUP
	JMP	SHORT BACKX
NOTX:	CMP	AL,'U'-40H		;CONTROL-U?
	JNZ	NOTU			;NOPE
	CALL	CRLFP			;ELSE, CRLF
	POP	DX			;GET START POS.
	DEC	DX
	JMP	READ1			;START OVER
NOTU:	CMP	AL,'R'-40H		;CONTROL-R?
	JNZ	NOTR
LINELEN:PUSH	CX
	CALL	CRLFP
	POP	CX
	POP	BX			;RESTORE VALUE
	PUSH	BX
	PUSH	CX
REP0:	CMP	CH,0
	JZ	REP1			;COUNT IS ZERO
	INC	BX
	MOV	CL,M			;GET NEXT CHAR
	DEC	CH			;DECREMENT COUNT
	PUSH	CX
	PUSH	BX
	CALL	CTLOUT			;ECHO CHARACTER
	POP	BX
	POP	CX
	JMP	SHORT REP0
REP1:	PUSH	BX			;SAVE POINTER
	MOV	AL,CS:COMPCOL
	CMP	AL,0
	JNZ	REP2			;NOT AT BEGINNING
	JMP	READN0
REP2:	SUB	AL,CS:COLUMN
	MOV	CS:COMPCOL,AL		;RESET COMPARED COLUMN
BACKSP:	CALL	BACKUP			;BACK UP ONE
	DEC	CS:COMPCOL
	JNZ	BACKSP			;UNTIL DONE
	JMP	READN0			;GET NEXT CHAR
NOTR:	INC	BX
	MOV	M,AL			;PUT IN CHARACTER
	INC	CH			;COUNT IT
	CMP	CH,CL			;END OF BUFFER?
	JC	NOTLST			;NOT LAST CHARACTER
	MOV	AL,7
	CALL	ROUT			;ELSE, RING BELL
	DEC	BX			;BACK UP POINTER
	DEC	CH			;BACK UP COUNTER
	JMP	READNX			;TRY AGAIN
NOTLST:	PUSH	CX			;SAVE COUNTERS
	MOV	CL,AL
	CALL	CTLOUT			;PRINT CHAR
	POP	CX
	JMP	READNX			;READ NEXT CHAR
;	OUTPUT CHARACTER, WITH SPECIAL HANDLING FOR
;	CONTROL CHARACTERS

CTLOUT:	MOV	AL,CL
	CALL	ECHOC			;CHECK FOR ECHO
	JNC	CTLOUT1			;SKIP IF TAB, CR, LF, CTL-H
	PUSH	AX
	MOV	CL,'^'
	CALL	COUT			;PRINT "^"
	POP	AX
	OR	AL,40H			;MAKE CHARACTER PRINTABLE
	MOV	CL,AL
CTLOUT1:CALL	COUT
	RET

;	BACK UP CURSOR

BACKUP:	MOV	CL,8
	CALL	COUTF			;BACK UP
	MOV	CL,' '
	CALL	COUTF			;SPACE
	MOV	CL,8
	CALL	COUTF			;BACK UP AGAIN
	RET

;	PRINT CRLF, AND SPACE TO INPUT POSITION

CRLFP:	MOV	CL,'#'
	CALL	COUT			;PRINT "#"
	CALL	CRLF
CRLFP0:	MOV	AL,CS:COLUMN
	CMP	AL,CS:STRTCOL		;AT START?
	JNC	CRLFPX			;IF SO, EXIT
	MOV	CL,' '
	CALL	COUT			;ELSE, PRINT SPACES
	JMP	CRLFP0
CRLFPX:	RET

;	PRINT CRLF

CRLF:	MOV	CL,0DH
	CALL	COUT
	MOV	CL,0AH
	CALL	COUT
	RET

;	OUTPUT CHARACTER, AND MAINTAIN COLUMN NO.

COUT:	CMP	CS:COMPCOL,0		;COMPARING COLUMN NO.?
	JNZ	COMPOUT			;YES
	CALL	COUTF			;OUTPUT THE CHARACTER
	CMP	CS:PRNFLG,0		;PRINTER ON?
	JZ	COMPOUT			;NO
	MOV	AL,CL
	CALL	BLSTOUT			;ELSE, PRINT CHARACTER
COMPOUT:MOV	AL,CS:COLUMN		;GET COLUMN NUMBER
	CMP	CL,7FH			;RUBOUT?
	JZ	COUTX			;IF SO, EXIT
	CMP	CL,9			;TAB?
	JNZ	NOTTAB			;NO
	ADD	AL,8
	AND	AL,0F8H			;ELSE, MOVE TO NEXT TAB STOP
	JMP	SHORT COUTX
NOTTAB:	INC	AL			;INCREMENT COLUMN
	CMP	CL,' '			;LESS THAN SPACE?
	JNC	COUTX			;IF NOT, EXIT
	DEC	AL			;ELSE, DECREMENT COLUMN
	CMP	AL,0			;AT COLUMN ZERO?
	JZ	COUTX			;IF SO, EXIT
	CMP	CL,'H'-40H		;BACK SPACE?
	JNZ	NOTBKSP			;NO
	DEC	AL			;ELSE, DECR. COLUMN NUMBER
COUTX:	MOV	CS:COLUMN,AL		;REPLACE COLUMN NO.
	RET
NOTBKSP:CMP	CL,0DH			;CR?
	JNZ	COUTX			;NO
	MOV	AL,0			;ELSE, RESET COLUMN
	JMP	SHORT COUTX

;	OUTPUT CHARACTER, WITH CHECK FOR CONTROL-C

COUTF:	PUSH	AX
	MOV	AL,CL
	CALL	ROUT			;OUTPUT CHARACTER
	CALL	MYCONST			;CHECK FOR CONTROL-C
	POP	AX
	RET

;	CHECK FOR ECHO-ABLE CHARACTER

ECHOC:	CMP	AL,0DH			;CR?
	JZ	ECHOX
	CMP	AL,0AH
	JZ	ECHOX
	CMP	AL,9			;TAB?
	JZ	ECHOX
	CMP	AL,8			;BACK SPACE?
	JZ	ECHOX
	CMP	AL,' '			;LESS THAN SPACE?
ECHOX:	RET

;	LOCAL CONSOLE STATUS ROUTINE

MYCONST:CALL	BCONST			;CHECK STATUS VIA BIOS
	JNZ	HAVCHR			;WE HAVE A CHARACTER
	XOR	AL,AL			;ELSE, CLEAR AL
	RET
HAVCHR:	CMP	AL,'C'-'@'		;CONTROL-C?
	JNZ	NOTC			;NO
	CALL	BCONIN			;ELSE, ABSORB CONTROL-C
	CALL	CTLC			;AND PROCESS IT
	JMP	MYCONST			;GET ANOTHER CHARACTER
NOTC:	CMP	AL,'S'-'@'		;CONTROL-S?
	JNZ	NOTS
	CALL	BCONIN			;ABSORB CONTROL-S
WFCHR:	CALL	BCONST			;CHECK KEYBOARD
	JZ	WFCHR			;UNTIL CHARACTER TYPED
	CALL	BCONIN			;ABSORB CHARACTER
	CMP	AL,'C'-'@'		;CONTROL-C?
	JNZ	NOTC0			;NO
	CALL	CTLC			;ELSE, PROCESS IT
NOTC0:	JMP	MYCONST			;AND GET ANOTHER CHAR
NOTS:	MOV	AL,0FFH			;SAY CHAR IS READY
MYCNX:	RET

;	LOCAL CONSOLE INPUT ROUTINE

MYCONIN:CALL	BCONIN			;GET CHARACTER
	CMP	AL,3			;CONTROL-C?
	JNZ	NOTC1			;NO
	CALL	CTLC			;ELSE, PROCESS IT
	JMP	MYCONIN			;GET ANOTHER CHARACTER
NOTC1:	CMP	AL,'P'-'@'		;CONTROL-P?
	JNZ	NOTP
	XOR	CS:PRNFLG,1		;TOGGLE PRINT CONTROL FLAG
	JMP	MYCONIN			;GET ANOTHER CHARACTER
NOTP:	CMP	AL,'N'-'@'		;CONTROL-N?
	JNZ	MYCNX			;NO
	MOV	CS:PRNFLG,0		;ELSE, KILL PRINTER
	JMP	MYCONIN			;GET ANOTHER CHARACTER

;	CONTROL-C PROCESSOR

CTLC:	PUSH	AX			;SAVE A BUNCH OF REGISTERS
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	DS
	PUSH	ES
	MOV	CL,AL
	CALL	CTLOUT			;OUTPUT "^C"
	CALL	CRLF
	MOV	CS:TEMP1,SS		;SAVE STACK
	MOV	CS:TEMP2,SP
	CLI
	MOV	SS,CS:SYSSTKS		;RESTORE ORIGINAL SEGMENT
	MOV	SP,CS:SYSSTK		;AND ORIGINAL STACK
	STI
	INT	23H			;EXECUTE CONTROL-C INTERRUPT
	CLI				;KILL INTERRUPS
	MOV	SS,CS:TEMP1		;RESTORE STACK
	MOV	SP,CS:TEMP2
	CMP	CS:CCFLG,0		;CONTROL-C ABORT ENABLED?
	JZ	CTLCX			;IF NOT, EXIT
	MOV	AX,4C01H		;TERMINATE, CONTROL-C EXIT
	PUSHF
	PUSH	CS
	MOV	BX,OFFSET CTLCX
	PUSH	BX
	JMP	MYEXIT			;FAKE INTERRUPT 21H
CTLCX:	STI				;IN DOS 1, NO FUNC. 4CH
	POP	ES
	POP	DS
	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

;	LOCAL CONSOLE OUTPUT

MYCNOUT:PUSH	CX
	PUSH	AX
	MOV	CL,DL
	CALL	COUT			;OUTPUT THE CHARACTER
	POP	AX
	POP	CX
	RET

MYLSOUT:PUSH	AX
	MOV	AL,DL
	CALL	BLSTOUT			;OUTPUT TO LIST
	CALL	MYCONST			;ALLOW CONTROL-C
	POP	AX
	RET

;	LOCAL AUX INPUT

MYAUXIN:CALL	MYCONST			;CHECK FOR CONTROL-C
	CALL	BAUXIN			;READ AUX DEVICE
	RET

;	LOCAL AUX OUTPUT

MYAXOUT:PUSH	AX
	MOV	AL,DL
	CALL	BAUXOUT			;OUTPUT CHARACTER
	CALL	MYCONST			;CHECK FOR CONTROL-C
	POP	AX
	RET

;	OUTPUT ROUTINE, VIA ROM

ROUT:	PUSH	AX			;SAVE REGISTERS ROM USES
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	ES
	CLD				;CLEAR DIRECTION FLAG
	CALL	ROMOUT			;OUTPUT CHARACTER
	POP	ES
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

;	"CALL 5" PROCESSOR

CALL5:	POP	AX			;REMOVE IP
	POP	CS:TEMP3		;REMOVE USER CS
	POP	AX			;REMOVE PROGRAM IP
	PUSH	CS:TEMP3		;RESTORE USER CS
	PUSH	AX			;AND PROGRAM IP
	MOV	AH,CL			;GET CALL
	INT	21H			;EXECUTE IT
	RETF
	DB	0
RESEND:					;END OF RESIDENT CODE

;	SET UP SYSTEM SO THAT SYSTEM INTERRUPTS PASS THROUGH
;	THIS PROGRAM

SETUP:	XOR	AX,AX
	MOV	DS,AX			;PUT DS AT INT. SEGMENT
	MOV	SI,OFFSET SYSINT
	LES	DI,DWORD PTR [SI]	;GET SYS INT. ADDRESS
	CMP	ES:WORD PTR -2[DI],'SF'	;FASTIO ALREADY IN?
	JNZ	NOTIN			;NO
	INT	20H			;ELSE, EXIT
NOTIN:	MOV	[SI],OFFSET MYSYS	;REPLACE IT WITH MY ADDR
	MOV	2[SI],CS		;AND THIS SEGMENT
	PUSH	CS
	POP	DS			;RESTORE DS
	MOV	WORD PTR SYSADR,DI	;PUT IN JUMP TO SYSTEM
	MOV	WORD PTR SYSADR+2,ES
	MOV	SI,6
	LES	DI,DWORD PTR [SI]	;GET "CALL 5" ADDRESS
	INC	DI			;POINT TO ADDRESS
	MOV	AX,OFFSET CALL5
	CLD
	STOSW				;MOVE IN NEW ONE
	MOV	AX,CS
	STOSW
	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT 	21H			;PRINT SIGN ON MESSAGE
	MOV	DX,OFFSET RESEND	;POINT TO END OF RES. CODE
	INT	27H			;EXIT WITH CODE RESIDENT

SIGNON	DB	13,10,"FASTIO Fast Input/Output Processor, "
	DB	"V 1.0 (by PS:)",13,10
	DB	"Copyright (C) 1985 by Heath Users' Group"
	DB	13,10,10
	DB	"FASTIO routines are now installed."
	DB	13,10,"$"
FASTIO	ENDS
	END	START
                                   