PAGE ,132

	TITLE SCDMPOK1 - SCREEN DUMP UTILITY
;              Version 3.0   30-Dec-84

;	for Okidata 82/83/84 (Step 1) Printer (pre MICROLINE series)
 
;	Written by Les Bordelon - All Rights Reserved

;	SCDMP reproduces Graphics and Text data from the screen of
;	the Zenith Z-100 series system for print out using a Okidata
;	82/83/84 Step 1 printer in bit- image mode.  On receipt of
;	an interrupt-5 (generated by entering <SHFT-F12>) VRAM is
;	enabled and the screen printing is performed.  If COLOR is
;	set to true, then entering a <B> for blue, <R> for red, or
;	<G> for green immediately after the <SHFT-F12> will select
;	the VRAM bank to be printed.  If no character is entered
;	within two seconds, the green bank is default.  If COLOR is
;	set to false, only the green bank can be dumped.  Press
;	<ESC> during printing of the screen to abort the dump.

;	Credits:  Zenith Data Systems 	      - Interrupt-5 routine (PSC)
;		  Digital Information Systems - Original Graphic Routines

;	Definitions 

BIOS_SEG SEGMENT AT 40H 			;bios location
	ORG 3*3
  BIOS_CONOUT	LABEL FAR			;console output
	ORG 4*3
  BIOS_PRINT	LABEL FAR			;printer output 
BIOS_SEG ENDS

;  	If monitor version = 1, then change ORG to 0290H or the 25th
;		line will not be printed.

MTR_D_SEG SEGMENT AT 0				;ROM monitor data
	ORG	0292H
  MTR_VERP	DB ?				;vertical position of cursor
MTR_D_SEG ENDS

IPAGE_SEG SEGMENT AT 0				;the interrupt area page
	ORG	03FEH
  MTR_DS	LABEL WORD			;location of monitor DS value
IPAGE_SEG ENDS


FALSE	=	0
TRUE	=	NOT FALSE

;	Set COLOR to TRUE if all three banks of VRAM are installed

COLOR	=	TRUE
MONOCHR =	NOT COLOR


CODE	SEGMENT BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	100H

;*****************ENTRY POINT******************

BEGIN:
	JMP	NEAR PTR START

CHECK	DB	'SCREEN DUMP  VERSION 3.0'	;identification message
CHECKLN EQU	24				;message length

;************INTERRUPT_5 HANDLER***************

INT_5:
	PUSH	DS				;save previous data segment
	PUSH	AX

	MOV	CS:INT_SP,SP
	MOV	CS:INT_SS,SS			;save previous stack

	MOV	AX,CS
	MOV	SS,AX				;set local stack
	MOV	SP,OFFSET INT_STACK

	STI					;now allow interrupts

	PUSH	ES
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI

	MOV	DS,AX
	MOV	ES,AX				;set up new segments

	CALL	INT_SIZE			;size screen
	CALL	INT_SCRN			;process the screen

	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	ES

	CLI					;INTs off while messing around
	MOV	AX,INT_SP
	MOV	SP,AX
	MOV	AX,INT_SS			;restore original stack
	MOV	SS,AX

	POP	AX
	POP	DS
	IRET					;back to bios

INT_SS	DW	0				;saved stack values
INT_SP	DW	0

INT_CX	DW	0				;current X location
INT_CY	DW	0				;current Y location
MYCHR	DW	0				;character at position
MYLINE	DB	82 DUP (?)			;line buffer
LINES	DW	24D				;min lines

	DW	128 DUP (?)

INT_STACK LABEL NEAR				;internal stack

;*****************SIZE SCREEN******************

;	INT_SIZE checks to see if the 25th line is enabled. If
;	it is, LINES is modified to be 25, so all lines are
;	printed


INT_SIZE:
	MOV	WORD PTR LINES,24		;assume not
	MOV	SI,OFFSET INT_SIZA		;print first line
	CLI					;don't interrupt me now
	CALL	INT_PLINE			;output line
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX				;get data segment
	MOV	DS,DS:[MTR_DS]
	MOV	AL,DS:[MTR_VERP]		;AL = horiz. position of cursor
	POP	DS
	PUSH	AX
	MOV	SI,OFFSET INT_SIZB		;put cursor back
	CALL	INT_PLINE			;output line
	STI
	POP	AX
	CMP	AL,24
	JNZ	INT_SIZ1			;if not on 24th line

;	Cursor moved to 25th line, must be enabled

	INC	WORD PTR LINES

INT_SIZ1:
	RET

INT_SIZA LABEL	NEAR
	DB	01BH,'j'			;save cursor
	DB	01BH,'Y',25+31,1+31		;go here
	DB	-1				;end of message

INT_SIZB LABEL	NEAR
	DB	01BH,'k'			;restore cursor
	DB	-1

INT_PLINE:
	MOV	AL,BYTE PTR [SI]		;get character
	INC	SI				;bump for next time
	CMP	AL,-1
	JZ	INT_PLIN1			;if end of text
	PUSH	SI
	CALL	FAR PTR BIOS_CONOUT		;output it
	POP	SI
	JMP	SHORT INT_PLINE 		;do next

INT_PLIN1:
	RET


SCN_LN	DW	0
CUR_RO	DW	0
COL_INR DW	0

;************VIDEO ADDRESS TABLE***************

ROW_DAT DW	00				;base of table
L24	DW	50176D
L23	DW	48128D
L22	DW	46080D
L21	DW	44032D
L20	DW	41984D
L19	DW	39936D
L18	DW	37888D
L17	DW	35840D
L16	DW	33792D
L15	DW	31744D
L14	DW	29696D
L13	DW	27648D
L12	DW	25600D
L11	DW	23552D
L10	DW	21504D
L09	DW	19456D
L08	DW	17408D
L07	DW	15360D
L06	DW	13312D
L05	DW	11264D
L04	DW	09216D
L03	DW	07168D
L02	DW	05120D
L01	DW	03072D
L00	DW	01024D

;*****************END TO TABLE******************
					      
ADDR	DW	0000

;***INT_SCRN - INTERRUPT TIME SCREEN PROCESSOR**

INT_SCRN:
	MOV	AX,0A78H			;video port =11110000 enabled
	OUT	0D8H,AL

IF MONOCHR					;if monochrome video
	JMP	G_BANK				;dump green bank only
ENDIF

	MOV	BX,200D 			;initialize delay loop 1

DE_LAY:
	MOV	CX,1000D			;initialize delay loop 2

DE_LAY1:
	DEC	CX				;delay loop 1
	IN	AL,0F5H				;check for char avail
	TEST	AL,01H
	JZ	DL2				;no, continue
	IN	AL,0F4H 			;poll the keyboard port
	JMP	GET_BANK
DL2:	CMP	CX,0
	JG	DE_LAY1

	DEC	BX				;delay loop 2
	CMP	BX,0
	JG	DE_LAY				;wait for bank selection
	JMP	G_BANK

GET_BANK:					;determine which VRAM bank
	AND	AL,0DFH				;force to upper case
	CMP	AL,42H				;if port -> B, dump blue
	JE	B_BANK
	CMP	AL,52H				;if port -> R, dump red
	JE	R_BANK

G_BANK: 					;green VRAM bank
	MOV	AX,0E000H			;select location E000H
	JMP	GO_PSC

R_BANK: 					;red VRAM bank
	MOV	AX,0D000H			;select location D000H
	JMP	GO_PSC

B_BANK: 					;blue VRAM bank
	MOV	AX,0C000H			;select location C000H

GO_PSC: 					;OKIDATA graphics routine
	DEC	LINES				;adjust lines value
	MOV	ES,AX				;set up seg
	MOV WORD PTR COL_INR,0			;init col =0
	MOV WORD PTR CUR_RO,0			;init row =0
	MOV WORD PTR SCN_LN,0			;init scan line =0
	MOV	BX,8D				;set top page margin
	CALL	PRLF				;print line feeds
	MOV	AL,13D				;print <CR>
	CALL	NEAR PTR CPRN
	MOV	AL,1DH
	CALL	NEAR PTR CPRN
	MOV	AL,1BH				;ESC
	CALL	NEAR PTR CPRN
	MOV	AL,25H				
	CALL	NEAR PTR CPRN
	MOV	AL,39H				;set up 15/144 line feed
	CALL	NEAR PTR CPRN
	MOV	AL,15D				
	CALL	NEAR PTR CPRN
	CALL	NEAR PTR MODE_G 		;graphics mode
	CALL	NEAR PTR PRSPC			;print spaces
	JMP	ROW2

;*********CHARACTER PRINT - CPRN***************

CPRN:
	CALL	FAR PTR BIOS_PRINT		;character print function
	RET


;***********PRINT SPACES ROUTINE***************

PRSPC:
	CMP	LINES,24
	JB	PRSPC1				
	MOV	BX,20D				;pad 20 spaces for 25 lines
	JMP	PSC1				

PRSPC1:
	MOV	BX,29D				;pad 29 spaces for 24 lines

PSC1:	MOV	AL,00H				;make it blank
	CALL	CPRN
	DEC	BX
	CMP	BX,0
	JG	PSC1
	RET

;*********PRINT LINE FEED ROUTINE*************

PRLF:
	MOV	AL,0AH				;print <LF>
	CALL	NEAR PTR CPRN
	DEC	BX
	CMP	BX,0
	JG	PRLF				;continue as needed
	RET


;****MODE G - SET TO ALL POINT ADDRESS MODE****

MODE_G:
	MOV	AX,0000H			;clear AX reg
	MOV	AL,01BH 			;ESC character
	CALL	NEAR PTR CPRN
	MOV	AL,25H				
	CALL	NEAR PTR CPRN
	MOV	AL,32H				;set at full dot mode
	CALL	NEAR PTR CPRN
	MOV	AL,03H				
	CALL	NEAR PTR CPRN
	CMP	LINES,24
	JB	COLMS_24
	MOV	AL,56H				;470 for 25 lines
	JMP	COLMS_25

COLMS_24:
	MOV	AL,4DH				;461 for 24 lines

COLMS_25:
	CALL	NEAR PTR CPRN
	RET					;back to calling

;****DO_BYTE - READ THE VRAM AND SEND TO PRN***

DO_BYTE:

	MOV	BX,WORD PTR ADDR		;current address
	MOV	AL,BYTE PTR ES:[BX]		;byte pointed by cur addr
	CALL	NEAR PTR CPRN			;print twice
	CALL	NEAR PTR CPRN			; for full screen effect
	INC	SCN_LN				;count scan line done
	SUB	BX,128D 			;adjust for scan line
	MOV	WORD PTR ADDR,BX		; and save addr
	CMP	SCN_LN,9			;have we done all 9
	JB	NEAR PTR DO_BYTE		;less than 8 done

;***********ROW - LOOP FOR EACH ROW************

ROW:
	MOV	SCN_LN,0			;init scan line again
	INC	CUR_RO				;count row done

	MOV	BX,LINES			;test # of lines
	CMP	CUR_RO,BX			;test against lines

	JG	DO_COL				;do next col 

ROW2:	
	MOV	AX,CUR_RO			;else more rows
	CMP	LINES,24			;if 25 lines
	JB	LNS24				;--not 25
	MOV	BX,OFFSET ROW_DAT		;begin first table entry

LNS:						;return tgt
	ADD	BX,AX				;R_ADDR=ROW_DAT+CUR_RO
	ADD	BX,AX				;--times two
	MOV	AX,WORD [BX]			;get actual address
	MOV	BX,AX				;swap it back
	MOV	AX,COL_INR			;get current column
	ADD	BX,AX				;C_ADDR=R_ADDR+COL_INR
	MOV	WORD PTR ADDR,BX		;save it at ADDR
	JMP	NEAR PTR DO_BYTE		;do next row

;************24 LINES ROUTINE******************

LNS24:
	MOV	BX,OFFSET ROW_DAT+2		;skip first table entry
	JMP	LNS				;resume at target


;*DO_COL - INCREMENT COLUMN AT END OF EACH ROW*

DO_COL:
	MOV	AL,0DH				;terminate line with
	CALL	NEAR PTR CPRN
	MOV	AL,0AH				;<CR/LF>
	CALL	NEAR PTR CPRN

	IN	AL,0F5H				;check for char avail
	TEST	AL,01H
	JZ	DC1				;no, continue
	IN	AL,0F4H 			;poll the keyboard port
	CMP	AL,01BH 
	JE	NEAR PTR FINI1			;if port -><ESC> then quit

DC1:	INC	COL_INR 			;increment column
	CMP	COL_INR,79D
	JG	NEAR PTR FINI			;screen processed

	MOV	CUR_RO,0			;else re-init row
	CALL	NEAR PTR MODE_G
	CALL	PRSPC
	JMP	NEAR PTR ROW2

;**************FINISH - ALL DONE**************

FINI1:
	MOV	BX,79D				;adjust lines of quit early
	SUB	BX,COL_INR
	CALL	PRLF

FINI:
	MOV	AL,1BH				;ready to reset printer
	CALL	NEAR PTR CPRN
	MOV	AL,25H
	CALL	NEAR PTR CPRN
	MOV	AL,39H				;reset line spacing
	CALL	NEAR PTR CPRN
	MOV	AL,24D				;return to 1/6 line spacing
	CALL	NEAR PTR CPRN
	MOV	AL,30D				;return to 10 cpi
	CALL	NEAR PTR CPRN
	MOV	BX,9D				;reset to new page
	CALL	PRLF
	RET

;*******MARK END OF RESIDENT PORTION**********

INT_END LABEL	NEAR

;**************MAIN ENTRY POINT***************


START:
	MOV	AX,00H				;check to see if already
	MOV	ES,AX				; installed.
	MOV	SI,5*4				;SI points to interrupt
	MOV	ES,ES:WORD PTR [SI+2]
	MOV	SI,OFFSET CHECK 		;get ID message
	MOV	DI,SI
	MOV	CX,CHECKLN			;get length
	REPE	CMPSB				;compare
	JNZ	SETUP				;not installed

	MOV	DX,OFFSET MESG2 		;already installed
	MOV	AH,09H				;get message and function
	INT	21H				;print message
	INT	20H				;exit

SETUP:
	MOV	SP,OFFSET INT_STACK		;good place for it
	PUSH	DS

	XOR	AX,AX
	MOV	DS,AX				;clear DS

	MOV	SI,5*4				;SI points to interrupt
	CLI

	MOV	WORD PTR [SI],OFFSET INT_5
	MOV	WORD PTR [SI+2],CS		;set my interrupt vector

	STI
	POP	DS

	MOV	DX,OFFSET MESG1 		;get signon message address
	MOV	AH,09H				;get function code
	INT	21H				;print message

	MOV	DX,OFFSET INT_END		;LWA of resident portion
	INT	27H

MESG1	DB	13,10,'SCREEN DUMP  Version 3.0  30-Dec-84',13,10,
	DB	'Printer:  Okidata 82/83/84 Step 1',13,10,10,
	DB	'Installed and ready...',13,10,10,
	DB	'To dump screen, type: <SHIFT-F12>',

IF COLOR
	DB	'[X]   [X = <G>reen or <B>lue or <R>ed bank]',
ENDIF

	DB	13,10,10,'To abort dump during printing, type:   <ESC>',
	DB	13,10,10,'$'

MESG2	DB	13,10,7,'SCREEN DUMP already installed!',
	DB	13,10,10,'$'

CODE	ENDS
	END	BEGIN
