	title   PRINTL - Print with Line Numbers and Page Headings
		page    ,96
		subttl  Program Documentation
;
;       PRINTL Version 4 revision 7 of 1/1/85
;
;       Product Code Z05.04.07
;
;       Copyright (c) 1984, 1985 by	David A. Wallace
;                               	146 Westford St.
;                               	Chelmsford,  Ma.
;                                       	01824
;
;                              Program Description
;
;       This program prints an ASCII file with page headings and (optionally)
;       line numbers.  The program is based on a program of the same name
;       developed by the author for the Heathkit H-8 computer.  Unlike that
;       earlier program,  this one supports printing of multiple files, since
;       it is able to expand starnames.  PRINTL understands a plethora of
;       optional control arguments, including:
;
;               -nln    (or /nln)               suppress line numbering
;               -nf     (/nf)                   suppress formfeed at end of list
;               -pf[<length>][:<width>] (/pf)   page format
;               -rl[<from>][:<to>]      (/rl)   range of lines
;               -rp[<from>][:<to>]      (/rp)   range of pages
;
;       The program is invoked with options and a single filename (or starname)
;       argument in any order.  Note that -rp and -rl are conflicting options.
;       There must be exactly one name argument, but it may be a starname which
;       expands to match all files on the specified disk.  Either "-" or "/" can
;       be used to signify an option.
;
;       The page heading consists of three parts:
;               left:   The filename
;               center: The date and time of the file
;               right:  The word "Page" and the page number
;
;       Lines of the file are printed either with line numbers (the default) or
;       without.  The format of the printed line is slightly different if no
;       line numebrs are given, so I will first describe the format with line
;       numbering:  The text from the file is printed, starting in print
;       position nine.  The first five print positions are reserved for a line
;       number which may be 1 to 65535 (with leading zeros replaced by spaces).
;       Print positions 6 through 8 are always blank.  PRINTL expands horizontal
;       tab characters to the appropriate number of spaces when printing the
;       text.  If the line expands to run beyond the right margin (96 characters
;       by default, bu settable using the -pf option), PRINTL will send a
;       carriage return (CR) and line feed (LF) to the printer and then eight
;       spaces, so the continuation of the line will resume at print position
;       nine, leaving a blank line number field to demark the continued line).
;
;       For text without line numbering, the text begins in print position one,
;       tabs are expanded to spaces and lines are continued if they overrun the
;       right margin.  The difference is that continuation is "flagged" by
;       sending CR, LF and then the characters "\c".  This continuation flag is
;       a convention borrowed from the Multics operating system.  The earlier
;       versions of PRINTL used the same convention as well.
;
;       If a line needs to be continued (irrespective of the line numbering
;       option),  the program first checks the page position to make sure that
;       at least two lines of text can be printed on the current page.  It will
;       recognise that the line has been continued and keep track of the page
;       position accordingly.  However, if the continuation should also exceed
;       the right margin, PRINTL will be unable to compensate for the subsequent
;       continuations (although it will still insert the CR LF and spaces).
;
		subttl  Definitions
		page
		.xlist
		include defascii.asm
		include defms.asm
		if1
		include bsharp.asm
typestr         MACRO   strnam
		MOV     AH,DOSF_OUTSTR
		MOV     DX,OFFSET strnam
		INT     DOSI_FUNC
		ENDM
mpydxby10       MACRO
		PUSH    AX
		ADD     DX,DX                   ; dx = dx * 2
		MOV     AX,DX
		ADD     DX,DX                   ; dx = dx * 4
		ADD     DX,DX                   ; dx = dx * 8
		ADD     DX,AX                   ; dx = dx * 8 + dx * 2 = dx * 10
		POP     AX
		ENDM
		endif
		.list
		subttl  Entry Point
		page
prog            segment byte public 'PROG'
		assume  cs:prog,ds:prog,ss:prog,es:prog
		extrn   _getargs:near           ; capture command line arguments
		extrn   cvt_datetime:near       ; convert bin date/time to ascii
		extrn   bindec8:near            ; cvt 8-bit bin to 3 ascii bytes
		extrn   cvt_num:near            ; cvt 16-bit unsigned int (lzs)
		extrn   expand_tab_x:near       ; cvt HT to blank (never number)
		extrn   expand_tab:near         ; cvt HT to blank (optional num)
		org     100h
start:
		call    _getargs
		callfnc _main,CX,BX
		exit
		subttl  Main function
		page
_main           proc    near
		fnc     _main,40
		declare page_no                 ; Page number
		declare line_no                 ; Line number
		declare buf_pos                 ; byte offset in disk buffer
		declare prt_pos                 ; print position
		declare page_len                ; number of lines per page
		declare page_width              ; number of print pos per line
		declare from_page               ; first page to print
		declare from_line               ; first line to print
		declare to_page                 ; last page to print
		declare to_line                 ; last line to print
		declare ff_after                ; issue FF when printing is done
		declare with_linenums           ; print with line-number at left
		declare i                       ; working variable
		declare arg_count               ; number of args
		declare arg_ptr               ; pointer to array of arg pointers
		declare printing                ; now printing file
		declare page_pos                ; number of lines down page
		declare first_heading           ; flags first page printed
;
;       Initialization
;
		MOV     page_len,60          ; (default lines of print per page)
;                                               this allows 58 lines of text.
		MOV     page_width,96  ; (default for number of print positions)
		MOV     from_page,0
		MOV     from_line,0
		MOV     to_page,0ffffh
		MOV     to_line,0ffffh
		MOV     ff_after,1
		MOV     with_linenums,1
		MOV     printing,0
		MOV     first_heading,1
		MOV     FILE_OPENED,0
		MOV     DATA_COUNT,0
		MOV     UNGET_FLAG,0
;
;       Print version and copyright notice.
;
		typestr ID
;
;       Check for args.
;
		arg     0                       ; argc
		CMP     DX,0                    ; see if args given.
		JNE     _L1
;
;       No args -- print usage and exit.
;
badcall:
		typestr USAGE
		return  _main


_L1:
;
;       Had args
;
		arg     0
		MOV     arg_count,DX
		arg     1
		MOV     arg_ptr,DX
		for     f1,i,0,NE,arg_count,1
		MOV     BX,arg_ptr
		PUSH    BX
		ADD     BX,2
		MOV     arg_ptr,BX
		POP     BX
		MOV     SI,[BX]                ; si now has address of i-th arg.
		LODSB
;
;       Either hyphen or slash can indicate an option.  Check the first byte.
;
		CMP     AL,'-'
		JE      _CA0
		CMP     AL,'/'
		JE      _CA0
		JMP     _L2


_CA0:
		LODSB
		AND     AL,01011111B
		CMP     AL,'N'
		JE      _CA1
		CMP     AL,'P'
		JE      _CA2A
		CMP     AL,'R'
		JE      _CA3A
		JMP     BADCALL


_CA2A:          JMP     _CA2
_CA3A:          JMP     _CA3


;
;       -nf or -nln
;
_CA1:
		LODSB
		AND     AL,01011111B
		CMP     AL,'L'
		JE      _CA11
		CMP     AL,'F'
		JE      _CA12
		JMP     BADCALL


;
;       -nln
;
_CA11:
		LODSB
		AND     AL,01011111B
		CMP     AL,'N'
		JE      _CA111
		JMP     BADCALL


;
;       -nf
;
_CA12:
		MOV     ff_after,0
		JMP     _CAMBZ

;
;       -nln
;
_CA111:
		MOV     with_linenums,0
_CAMBZ:
		LODSB
		CMP     AL,0
		JE      _L4A
;
;       Extra characters after the argument flag
;
		JMP     BADCALL


_L4A:
		continue        f1


;
;       -pfLLL:WWW?
;
_CA2:
		LODSB
		AND     AL,01011111B
		CMP     AL,'F'
		JE      _CA21
		JMP     BADCALL


;
;       Was -pf.   Get the page format spec.
;
_CA21:
		MOV     DX,page_len
		LODSB
		CMP     AL,':'
		JE      _CA22                   ; There was no page length spec
		MOV     DX,0
_CA23:
		CMP     AL,'0'
		JL      _CA2_ERR
		CMP     AL,'9'
		JG      _CA2_ERR
		AND     AL,00001111B
		mpydxby10
		MOV     AH,0
		ADD     DX,AX                   ; DX = DX * 10 + AX
		LODSB
		CMP     AL,':'
		JE      _CA22
		CMP     AL,0
		JNE     _CA23
_CA22:
		MOV     page_len,DX
		CMP     AL,0
		JNE     _CA24
		continue        f1


_CA2_ERR:
		JMP     _CA_ERR


_CA24:
		MOV     DX,page_width
		LODSB
		CMP     AL,0
		JE      _CA26                   ; There was no page length spec
		MOV     DX,0
_CA25:
		CMP     AL,'0'
		JL      _CA2_ERR
		CMP     AL,'9'
		JG      _CA2_ERR
		AND     AL,00001111B
		mpydxby10
		MOV     AH,0
		ADD     DX,AX                   ; DX = DX * 10 + AX
		LODSB
		CMP     AL,0
		JNE     _CA25
_CA26:
		MOV     page_width,DX
		continue        f1


;
;       -rl or -rp
;
_CA3:
		LODSB
		AND     AL,01011111B
		CMP     AL,'L'
		JE      _CA31A
		CMP     AL,'P'
		JE      _CA32A
		JMP     BADCALL


_CA31A:         JMP     _CA31
_CA32A:         JMP     _CA32


;
;       Was -rl.  Get the range of lines to be printed.
;
_CA31:
		MOV     DX,to_page
		CMP     DX,0FFFFh
		JE      _CA310
		JMP     _CA_CONFLICT
_CA310:
		MOV     DX,from_line
		LODSB
		CMP     AL,':'
		JE      _CA312                  ; There was no page length spec
		MOV     DX,0
_CA313:
		CMP     AL,'0'
		JL      _CA31_ERR
		CMP     AL,'9'
		JG      _CA31_ERR
		AND     AL,00001111B
		mpydxby10
		MOV     AH,0
		ADD     DX,AX                   ; DX = DX * 10 + AX
		LODSB
		CMP     AL,':'
		JE      _CA312
		CMP     AL,0
		JNE     _CA313
_CA312:
		MOV     from_line,DX
		CMP     AL,0
		JNE     _CA314
		continue        f1


_CA31_ERR:
		JMP     _CA_ERR


_CA314:
		MOV     DX,to_line
		LODSB
		CMP     AL,0
		JE      _CA316                  ; There was no page length spec
		MOV     DX,0
_CA315:
		CMP     AL,'0'
		JL      _CA31_ERR
		CMP     AL,'9'
		JG      _CA31_ERR
		AND     AL,00001111B
		mpydxby10
		MOV     AH,0
		ADD     DX,AX                   ; DX = DX * 10 + AX
		LODSB
		CMP     AL,0
		JNE     _CA315
_CA316:
		MOV     to_line,DX
		continue        f1


;
;       Was -rp.  Get the range of pages to be printed.
;
_CA32:
		MOV     DX,to_line
		CMP     DX,0FFFFh
		JE      _CA320
		JMP     _CA_CONFLICT


_CA320:
		MOV     DX,from_page
		LODSB
		CMP     AL,':'
		JE      _CA322                  ; There was no page length spec
		MOV     DX,0
_CA323:
		CMP     AL,'0'
		JL      _CA32_ERR
		CMP     AL,'9'
		JG      _CA32_ERR
		AND     AL,00001111B
		mpydxby10
		MOV     AH,0
		ADD     DX,AX                   ; DX = DX * 10 + AX
		LODSB
		CMP     AL,':'
		JE      _CA322
		CMP     AL,0
		JNE     _CA323
_CA322:
		MOV     from_page,DX
		CMP     AL,0
		JNE     _CA324
		continue        f1


_CA32_ERR:
		JMP     _CA_ERR


_CA324:
		MOV     DX,to_page
		LODSB
		CMP     AL,0
		JE      _CA326                  ; There was no page length spec
		MOV     DX,0
_CA325:
		CMP     AL,'0'
		JL      _CA32_ERR
		CMP     AL,'9'
		JG      _CA32_ERR
		AND     AL,00001111B
		mpydxby10
		MOV     AH,0
		ADD     DX,AX                   ; DX = DX * 10 + AX
		LODSB
		CMP     AL,0
		JNE     _CA325
_CA326:
		MOV     to_page,DX
		continue        f1


_CA_ERR:
		typestr NNARG
		return  _main


_CA_CONFLICT:
		typestr CCARGS
		return  _main

;
;       This argument was not a control arg.
;
_L2:
		MOV     AH,file_spec
		CMP     AH,0
		JNE     _L2_MF                  ; multiple files specified
		MOV     DI,OFFSET file_spec
		MOV     CX,15
_L31:
		STOSB
		CMP     AL,0
		JE      _L3
		LODSB
		LOOP    _L31
_FN_ERR:
		typestr FERR
		return  _main


_L3:
		DEC     DI                      ; for the purposes of the ZDOS
		MOV     AL,' '                  ; parse_file call, we can't use
		STOSB                           ; zero to terminate this string.
		continue        f1


_L2_MF:         typestr TWOFILE
		return  _main


		endfor  f1
;
;       See if he forgot to specify a filename.
;
		MOV     AL,byte ptr file_spec
		CMP     AL,0
		JNE     _L4
		typestr nofile
		return  _main


;
;       Done parsing arguments.  Construct FCB.
;
_L4:
		MOV     SI,offset file_spec
		MOV     DI,offset file_fcb
		MOV     AH,DOSF_PARSE
		MOV     AL,00000000B
		INT     DOSI_FUNC
		MOV     byte ptr had_starname,AL
		MOV     AL,FILE_FCB
_L7:
;
;       Set disk transfer address to searched_fcb.
;
		MOV     DX,OFFSET SEARCHED_FCB
		MOV     AH,DOSF_SDIOA
		INT     DOSI_FUNC
;
;       Do a search for first entry request.
;
		MOV     DX,OFFSET FILE_FCB
		MOV     AH,DOSF_SRHFI
		INT     DOSI_FUNC
		CMP     AL,0FFH
		JE      NOFIND
		JMP     _L8


NOFIND:
;
;       If search fails, issue error message and exit.
;
		typestr NOTFOUND
		return  _main


_L8:
;
;       If had a starname, print out the file name we just found.
;
		MOV     AL,HAD_STARNAME
		CMP     AL,0
		JE      _L9
		CALL    FORMAT_FILENAME
		MOV     CX,12
		MOV     SI,OFFSET HNAME
		MOV     DI,OFFSET FILE_NAME
		REP MOVSB
		MOV     AL,CC_CR
		STOSB
		MOV     AL,CC_LF
		STOSB
		MOV     AL,'$'
		STOSB
		typestr FILE_NAME
		JMP     _L9_ELSE


_L9:
;
;       Otherwise, just put the filename into the header.
;
		CALL    FORMAT_FILENAME
_L9_ELSE:
;
;       While search succeeds
;
		while   wh2,1
		MOV     page_no,0
		MOV     line_no,0
		MOV     buf_pos,0
		MOV     prt_pos,0
;
;               Copy file's date and time to header
;
		MOV     AX,WORD PTR [SEARCHED_FCB+25]
		MOV     DATE_WORK,AX
		MOV     AX,WORD PTR [SEARCHED_FCB+23]
		MOV     TIME_WORK,AX
		MOV     SI,OFFSET DATE_WORK
		MOV     DI,OFFSET HDATE
		CALL    CVT_DATETIME
;
;               Zero out FCB record and size info
;
		MOV     CX,21
		MOV     AL,0
		MOV     DI,OFFSET SEARCHED_FCB+12
		REP STOSB
;
;               Open file
;
		MOV     DX,OFFSET SEARCHED_FCB
		MOV     AH,000H
		CALL    DISK_FUNC
;
;               Set the line data pointer to the start of the line buffer.
;
		MOV     DX,OFFSET LINEBUF
		MOV     line_ptr,DX
;
;               Set page number to 0
;
		MOV     page_no,0
;
;               Set line number to 0
;
		MOV     line_no,0
;
;               Reset "printing" flag.
;
		MOV     printing,0
;
;               Set page position (number of lines down page) to zero
;
		MOV     page_pos,0
		SUBTTL  Printing Loop
		PAGE
PAGE_LOOP:
;
;       Increment page number.
;
		INC     page_no
;
;               Convert page number to ASCII
;
		MOV     DX,page_no
		MOV     DI,OFFSET HPAGE
		CALL    CVT_NUM
;
;       If starting page number and starting line number are both 0
;               then printing = TRUE
;
		MOV     DX,from_page
		CMP     DX,0
		JNE     PTST
		CMP     DX,from_line
		JNE     PTST
		MOV     printing,1
		JMP     EPTST


PTST:
;
;       if starting page number is above than 0 then do
;
		bsif    if1,from_page,A,0
;
;               If page number >= starting page number then printing = TRUE
;
		bsif    if2,page_no,AE,from_page
		MOV     printing,1
		bsendif if2
		bsendif if1
;
;       if starting line number is above than 0 then do
;
		bsif    if3,from_line,A,0
;
;               If line number >= starting line number then printing = TRUE
;
		bsif    if4,line_no,AE,from_line
		MOV     printing,1
		bsendif if4
		bsendif if3
;
;       if starting page number is above 0 then do
;
		bsif    if5,from_page,A,0
;
;               If page number > ending page number then goto CLOSE
;
		bsif    if6,page_no,A,to_page
		JMP     CLOSE
		bsendif if6
		bsendif if5
;
;       if starting line number is above 0 then do
;
		bsif    if7,from_line,A,0
;
;               If line number > ending line number then printing = FALSE
;
		bsif    if8,line_no,A,to_line
		MOV     printing,0
		bsendif if8
		bsendif if7
EPTST:
;
;               If PRINTING then do
;                       print heading line
;                       set page position to 2
;               end
;
		bsif    if9,printing,E,0
		bsif    if9a,from_page,E,0
		JMP     LINE_LOOP
		bsendif if9a
		bsendif if9
		MOV     PRINTBUF,CC_FF
		MOV     SI,OFFSET HEADER
		bsif    if9ab,first_heading
		MOV     DI,OFFSET PRINTBUF      ; on first heading line for file
		MOV     first_heading,0         ;  we overwrite the formfeed in
		bselse  if9ab                   ;  the first byte of the print
		MOV     DI,OFFSET PRINTBUF+1    ;  buffer.  Subsequent headings
		bsendelse if9ab                 ;  do not overwrite it.
		MOV     CX,page_width
		CALL    EXPAND_TAB_X
		MOV     DX,2
		JNC     NF_HDR                  ; HEADER NOT FOLDED
		INC     DX
NF_HDR:
		MOV     page_pos,DX
		bsif    if9b,printing
		CALL    PRINT_BUFFER
		bselse  if9b
		MOV     first_heading,1
		bsendelse if9b
LINE_LOOP:
;
;               Increment Line number
;
		INC     line_no
;
;               If from_line > 0 then do
;
		bsif    if20,from_line,A,0
;
;               if current line number is greater than to_line then goto CLOSE
;
		bsif    if21,line_no,A,to_line
		JMP     CLOSE
		bsendif if21
;
;       If line_no >= from_line and line_no <= to_line then PRINTING = TRUE
;
		MOV     PRINTING,0
		bsif    if23,line_no,AE,from_line
		MOV     PRINTING,1
		bsif    if24,line_no,E,from_line
		MOV     PRINTBUF,CC_FF
		MOV     SI,OFFSET HEADER
		bsif    if25,first_heading
		MOV     DI,OFFSET PRINTBUF      ; on first heading line for file
		MOV     first_heading,0         ;  we overwrite the formfeed in
		bselse  if25                    ;  the first byte of the print
		MOV     DI,OFFSET PRINTBUF+1    ;  buffer.  Subsequent headings
		bsendelse if25                  ; do not overwrite it.
		MOV     CX,page_width
		CALL    EXPAND_TAB_X
		MOV     DX,2
		JNC     NF_HDR1                 ; HEADER NOT FOLDED
		INC     DX
NF_HDR1:
		MOV     page_pos,DX
		CALL    PRINT_BUFFER
		bsendif if24
		bsendif if23
		bsendif if20
;
;               Get a line from file
;
		MOV     AH,1
		MOV     DX,OFFSET LINEBUF+6
		CALL    DISK_FUNC
		JNC     _LL1
;
;               If at end of file then goto CLOSE
;
		CMP     AL,010H
		JE      READ_ERROR
		CMP     AL,040H
		JNE     _LL1
		JMP     CLOSE                   ;       END OF FILE
_LL1:
		MOV     SI,OFFSET LINEBUF+6
;
;               If numbering lines then do
;
		bsif    if30,with_linenums
;
;                       Convert line number to ASCII
;
		MOV     DX,line_no
		MOV     DI,OFFSET LINEBUF
		CALL    CVT_NUM
;
;                       Append TAB
;
		MOV     AL,cc_ht
		MOV     LINEBUF+5,AL
		MOV     SI,OFFSET LINEBUF
;
;               end
;
		bsendif if30
;
;               If PRINTING then do
;
		bsif    if31a,printing,E,0
		bsif    if31b,from_page,E,0
		JMP     _LL_NPXX
		bsendif if31b
		bsendif if31a
;
;
;                       Copy string to print buffer and expand tabs.
;
		MOV     DI,OFFSET PRINTBUF
		MOV     BX,with_linenums
		MOV     CX,page_width
		CALL    EXPAND_TAB
;
;                       If line is folded when tabs are expanded then do
;
		JNC     _LL_NF
;
;                               If page position is pagelength-1 then do
;
		MOV     DX,page_pos
		MOV     CX,page_len
		DEC     CX
		CMP     DX,CX
		JNE     _LL_NX
;
;                                       unget line from file
;
		DEC     line_no
		MOV     AH,2
		MOV     DX,OFFSET LINEBUF+6
		CALL    DISK_FUNC
;
;                                       goto PAGE_LOOP
;
		JMP     PAGE_LOOP


READ_ERROR:
		typestr rderrmsg
		JMP     CLOSE


;
;                               end
;
_LL_NX:
;
;                                       increment page_pos
;
		INC     page_pos
;
;
;                       end
;
_LL_NF:
;
;                       print line
;
		bsif    if31,printing
		CALL    PRINT_BUFFER
		bsendif if31
;
;                       increment page_pos
;
		INC     page_pos
;
;               end
;
_LL_NPXX:
;
;               if page_pos >= page_len then goto PAGE_LOOP
;
		bsif    if33,page_pos,GE,page_len
		JMP     PAGE_LOOP
		bsendif if33
;
;               goto LINE_LOOP
;
		JMP     LINE_LOOP
		subttl  End of file / Next File processing
		page
CLOSE:
;
;               Close file
;
		MOV     DX,OFFSET SEARCHED_FCB
		MOV     AH,0FFH
		CALL    DISK_FUNC
;
;       If we are supposed to put out a formfeed at end of print-out, now is
;               the time to do so.
;
		bsif    ifcls1,ff_after
		MOV     AL,CC_FF
		MOV     DI,OFFSET PRINTBUF
		STOSB
		MOV     AL,0
		STOSB
		CALL    PRINT_BUFFER
		bsendif ifcls1
;
;               If we are scanning a starname then do
;                       Set disk transfer address to searched_fcb.
;
		MOV     AL,HAD_STARNAME
		CMP     AL,0
		JNE     _L11
		break   wh2
_L11:
		MOV     DX,OFFSET SEARCHED_FCB
		MOV     AH,DOSF_SDIOA
		INT     DOSI_FUNC
;
;                       search for next entry
;
		MOV     DX,OFFSET FILE_FCB
		MOV     AH,DOSF_SRHNX
		INT     DOSI_FUNC
		CMP     AL,0FFH
		JE      NOFIND1
		JMP     _L10


NOFIND1:
;
;                       if no match, break
;
		break   wh2

_L10:
;
;                       else type the filename.
;
		CALL    FORMAT_FILENAME
		MOV     CX,12
		MOV     SI,OFFSET HNAME
		MOV     DI,OFFSET FILE_NAME
		REP MOVSB
		MOV     AL,CC_CR
		STOSB
		MOV     AL,CC_LF
		STOSB
		MOV     AL,'$'
		STOSB
		typestr FILE_NAME
;
;               end
;               else break
;
		endwh   wh2
		return  _main


		endfnc  _main
_main           ENDP
		subttl  Subroutines
		PAGE
;       DISK_FUNC - All of the disk functions for PRINTL go through this
;                   subroutine package
;
;       Entry:  AH = function code
;
;                       000     Open disk file for read
;                       001     Get a line
;                       002     Unget a line
;                       0FF     Close file
;               DX - purpose varies, depending on function; usually the offset
;                    of the line buffer into which to read, but can also be
;                    the offset of the FCB for the disk file or not used.
;       Exit:   AL = status code
;       Uses:   AX, BX, CX, DX
;
DISK_FUNC:
		CMP     AH,0
		JE      DISK_OPEN
		CMP     AH,1
		JE      DISK_GET
		CMP     AH,2
		JE      DISK_UNGET_J
		CMP     AH,0FFH
		JE      DISK_CLOSE
;
;       Invaild Function code
;
		MOV     AL,080H
		STC
		RET


DISK_UNGET_J:
		JMP     DISK_UNGET


DISK_OPEN:
;
;       DX -> UNOPENED FCB.
;
		CMP     BYTE PTR FILE_OPENED,0
		JNE     BAD_OPEN
		PUSH    AX
		PUSH    DX
;
;               Set disk transfer address to disk buffer (We use the ID and
;               usage messages -- which are no longer needed -- as the disk
;               buffer).
;
		MOV     DX,OFFSET ID
		MOV     AH,DOSF_SDIOA
		INT     DOSI_FUNC
;
;               Set the disk data pointer to the buffer address.
;
		MOV     DX,OFFSET ID
		MOV     disk_ptr,DX
		POP     DX
		POP     AX
		MOV     DATA_COUNT,0
		MOV     BYTE PTR UNGET_FLAG,0
		MOV     FCB_PTR,DX
;
;               Open the file.
;
		MOV     AH,DOSF_OPFILE
		INT     DOSI_FUNC
		MOV     BYTE PTR FILE_OPENED,1
		MOV     AL,0
		CLC
		MOV     BYTE PTR NO_MORE,0
		RET


BAD_OPEN:
		MOV     AL,040H
		STC
		RET


DISK_CLOSE:
;
;       DX -> OPENED FCB.
;
		CMP     BYTE PTR FILE_OPENED,0
		JE      BAD_OPEN              ; MUST BE OPENED FOR CLOSE TO WORK
		MOV     AH,DOSF_CLFILE
		INT     DOSI_FUNC
		MOV     BYTE PTR FILE_OPENED,0
		MOV     AL,0
		CLC
		RET


DISK_GET:
;
;       DX -> Line Buffer
;
;       If file_opened != 1 then return EOF status.
;
		PUSH    SI
		PUSH    DI
		CMP     BYTE PTR FILE_OPENED,1
		JNE     READ_EOF
;
;       If unget_flag is set then do
;               copy unget_buf into [DX]
;               clear unget_flag
;       end
;
		CMP     BYTE PTR UNGET_FLAG,0
		JZ      NOT_REREAD
		MOV     DI,DX
		MOV     SI,OFFSET UNGET_BUF
		MOV     CX,UNGET_COUNT
		REP MOVSB
		MOV     BYTE PTR UNGET_FLAG,0
		MOV     AL,0
		CLC
		POP     DI
		POP     SI
		RET


READ_EOF:
		MOV     AL,040H
		MOV     BYTE PTR FILE_OPENED,3
		MOV     BYTE PTR DATA_COUNT,0
		MOV     BYTE PTR NO_MORE,1
		STC
		POP     DI
		POP     SI
		RET


NOT_REREAD:
;
;       If data_count = 0 then do
;               read a record from the disk file
;               if end_of_file status on file then do
;                       return EOF status
;               end
;               set disk_ptr to ID
;               set data_count to 128
;       end
;
		CMP     DATA_COUNT,0
		JG      HAVE_DATA
		CMP     BYTE PTR NO_MORE,0
		JNE     READ_EOF
		PUSH    DX
		MOV     AH,DOSF_SEQREAD
		MOV     DX,FCB_PTR
		INT     DOSI_FUNC
		POP     DX
		OR      AL,AL		;	end of file or partial record
		JZ	HAVE_FULL_RECORD
		CMP	AL,1
		JE	READ_EOF	;	no data read.

;	Have read a partial record.  Scan backwards from end of disk buffer
;	until a non-zero value is hit.

		MOV	CX,128
		MOV	SI,OFFSET [ID + 127]
SCANBUF_1:
		MOV	AL,[SI]
		AND	AL,AL
		JNZ	SCANBUF_1X
		DEC	CX
		DEC	SI
		JMP	SCANBUF_1
SCANBUF_1X:
		MOV	DATA_COUNT,CX
		MOV     disk_ptr,OFFSET ID
		JMP	HAVE_DATA
HAVE_FULL_RECORD:
		MOV     DATA_COUNT,128
		MOV     disk_ptr,OFFSET ID
HAVE_DATA:
		MOV     DI,DX
		MOV     SI,disk_ptr
;
;       while *disk_ptr != cc_lf do
;               if *disk_ptr = cc_cr then continue
;               if data_count = 0 then do
;                       read a record
;                       if end_of_file then do
;                               return with EOF status
;                       end
;                       set disk_ptr to ID
;                       set data_count to 128
;                       if *disk_ptr = cc_lf then break
;               end
;
DSK_DATA_LOOP:
		LODSB
		MOV     disk_ptr,SI
		DEC     data_count
		CMP     AL,CC_LF
		JE      HD1
		CMP     AL,CC_CR
		JE      DSK_DATA_LOOP
		OR      AL,AL
		JE      DSK_DATA_LOOP
		CMP     AL,01AH
		JE      HD2
		bsif    dskif1,data_count,LE,0
		bsif    dskif2,data_count,E,0
		STOSB
		bsendif dskif2
		CMP     BYTE PTR NO_MORE,0
		JNE     NO_DATA_1
		PUSH    DX
		MOV     AH,DOSF_SEQREAD
		MOV     DX,FCB_PTR
		INT     DOSI_FUNC
		POP     DX
		OR      AL,AL                           ; READ OK?
		JZ      HAVE_DATA_2A
		CMP	AL,1
		JE	NO_DATA_1	;	read eof

;	We have read a partial record.  Scan backwards from end of buffer.
;	Look for a non-zero value.  Calculate quantity of data remaining.

		MOV	CX,128
		MOV	SI,OFFSET [ID + 127]
SCANBUF_2:
		MOV	AL,[SI]
		AND	AL,AL
		JNZ	SCANBUF_2X
		DEC	CX
		DEC	SI
		JMP	SCANBUF_2
SCANBUF_2X:
		MOV	DATA_COUNT,CX
		MOV	DISK_PTR,OFFSET ID
		MOV	SI,DISK_PTR
		JMP	DSK_DATA_LOOP

NO_DATA_1:
		JMP     READ_EOF

HD1:            JMP     HAVE_DATA_1

HD2:            JMP     HAVE_DATA_2

HAVE_DATA_2A:
		MOV     disk_ptr,OFFSET ID
		MOV     data_count,128
		MOV     SI,disk_ptr
		JMP     DSK_DATA_LOOP
		bsendif dskif1
;
;               copy *disk_ptr to [DX]
;               increment DX
;               increment disk_ptr
;
		STOSB
;
;       end
;
		JMP     DSK_DATA_LOOP


HAVE_DATA_1:
;
;       copy cc_cr to [DX]
;
		MOV     AL,CC_CR
		STOSB
;
;       copy cc_lf to [DX]
;
		MOV     AL,CC_LF
		STOSB
;
;       copy 0 to [DX]
;
		MOV     AL,0
		STOSB
;
;       return with 0 status
;
		MOV     disk_ptr,SI
		MOV     AL,0
		POP     DI
		POP     SI
		CLC
		RET


HAVE_DATA_2:
;
;       return with EOF status and set FILE_OPENED to 3
;
		MOV     BYTE PTR FILE_OPENED,3
		MOV     disk_ptr,SI
		MOV     AL,040H
		POP     DI
		POP     SI
		STC
		RET


DISK_UNGET:
;
;       COPY THAT WHICH IS POINTED TO BY DX INTO UNGET_BUF UNTIL A NULL IS
;       COPIED.  SET UNGET_COUNT TO THE NUMBER OF BYTES (INCLUDING THE NULL)
;       WHICH HAVE BEEN COPIED.
;
		PUSH    SI
		PUSH    DI
		MOV     SI,DX
		MOV     DI,OFFSET UNGET_BUF
		MOV     CX,0
DISK_UNGET_LOOP:
		LODSB
		STOSB
		INC     CX
		CMP     AL,0
		JNE     DISK_UNGET_LOOP
		MOV     UNGET_COUNT,CX
;
;       SET THE UNGET FLAG
;
		MOV     BYTE PTR UNGET_FLAG,1
		POP     DI
		POP     SI
		MOV     AL,0
		CLC
		RET


;       Data area for above subroutine:

FILE_OPENED             DB      0
NO_MORE                 DB      0
FCB_PTR                 DW      0
DATA_COUNT              DW      0
UNGET_FLAG              DB      0
UNGET_COUNT             DW      0
UNGET_BUF               DB      256 DUP (?)


		PAGE
;       FORMAT_FILENAME -- Convert XXXXXXXXYYY (with possible blanks) to
;                          XXXXXXXX.YYY (with blanks removed).
;       ENTRY:  none
;       Exit:   none
;       Uses:   none
;
FORMAT_FILENAME:
		PUSH    AX
		PUSH    CX
		PUSH    DX
		PUSH    SI
		PUSH    DI
		MOV     SI,OFFSET SEARCHED_FCB+1
		MOV     DI,OFFSET HNAME
		MOV     CX,8
		MOV     DX,12
FL8A:
		LODSB
		CMP     AL,' '
		JE      FL8BB
		STOSB
		DEC     DX
		LOOP    FL8A
		JMP     FL8C
FL8BB:
		DEC     CX
FL8B:
		LODSB
		LOOP    FL8B
FL8C:
		MOV     AL,'.'
		STOSB
		DEC     DX
		MOV     CX,3
FL8D:
		LODSB
		CMP     AL,' '
		JE      FL8E
		STOSB
		DEC     DX
		LOOP    FL8D
FL8E:
		CMP     DX,0
		JLE     FL8G
FL8F:
		MOV     CX,DX
FL8FF:
		MOV     AL,' '
		STOSB
		LOOP    FL8FF
FL8G:
		POP     DI
		POP     SI
		POP     DX
		POP     CX
		POP     AX
		RET
		page
;       print_buffer:   output the print buffer to the line printer
;
;       Entry:  none
;       Exit:   none
;       Uses:   none
;
print_buffer:
		PUSHF
		PUSH    AX
		PUSH    BX
		PUSH    CX
		PUSH    DX
		PUSH    SI
		MOV     SI,OFFSET PRINTBUF
PBL:
		LODSB
		CMP     AL,0
		JE      PBX                     ; FOUND STOPPER
		MOV     DL,AL
		MOV     AH,DOSF_PRINTOUT        ; SEND BYTE TO LST
		INT     DOSI_FUNC
		JMP     PBL


PBX:
		POP     SI
		POP     DX
		POP     CX
		POP     BX
		POP     AX
		POPF
		RET
		subttl  Data Area
		page
ID              db      'PRINTL Version 4.07',cc_cr,cc_lf
		db      'Copyright (c) 1984, 1985 by',cc_ht,'David A. Wallace',cc_cr
		db      cc_lf,cc_ht,cc_ht,cc_ht,cc_ht,'146 Westford St.',cc_cr,cc_lf
		db      cc_ht,cc_ht,cc_ht,cc_ht,'Chelmsford,  Ma.',cc_cr,cc_lf
		db      cc_ht,cc_ht,cc_ht,cc_ht,cc_ht,'01824',cc_cr,cc_lf,cc_lf
		db      '$'

USAGE           db      'Incorrect invocation.  Usage is:',cc_cr,cc_lf
		db      cc_ht,'PRINTL [/args] <filename>',cc_cr,cc_lf
		db      'where <filename> is the name (starnames are okay)'
		db      ' of the file to be printed and',cc_cr,cc_lf
		db      '      [/args] is the optional list of'
		db      ' the control arguments:',cc_cr,cc_lf,cc_lf
		db      '/nf',cc_ht,cc_ht,cc_ht,'no formfeed after printout'
		db      cc_cr,cc_lf
		db      '/nln',cc_ht,cc_ht,cc_ht,'no line numbers',cc_cr,cc_lf
		db      '/pf[<lines>][:width]',cc_ht,'page format spec:'
		db      cc_cr,cc_lf
		db      cc_ht,'<lines>',cc_ht,cc_ht,'lines per page',cc_cr,cc_lf
		db      cc_ht,'<width>',cc_ht,cc_ht,'print positions per line'
		db      cc_cr,cc_lf
		db      '/rl[<from>][:<to>]',cc_ht,'range of lines to print'
		db      cc_cr,cc_lf
		db      cc_ht,'<from>',cc_ht,cc_ht,'first line to print',cc_cr
		db      cc_lf,cc_ht
		db      '<to>',cc_ht,cc_ht,'last line to print',cc_cr,cc_lf
		db      '/rp[<from>][:<to>]',cc_ht,'range of pages to print'
		db      cc_cr,cc_lf,cc_ht
		db      '<from>',cc_ht,cc_ht,'first page to print',cc_cr,cc_lf
		db      cc_ht,'<to>',cc_ht,cc_ht,'last page to print',cc_cr
		db      cc_lf,'(Hyphen may be used in place of slash, on '
		db      'the options arguments, if desired.)',cc_cr,cc_lf
		db      '$'

NNARG           db      'Error - The arguments of the /pf, /rl and /rp cont'
		db      'rols must be numbers.',cc_cr,cc_lf,cc_bel,'$'

CCARGS          db      'Error - you cannot specify both a /rl and a /rp '
		db      'control.',cc_cr,cc_lf,cc_bel,'$'

NOFILE          db      'Error - No filename was given.',cc_cr,cc_lf,cc_bel,'$'

TWOFILE         db      'Error - You may only specify a single filename (use a '
		db      'starname to do multiple ',cc_cr,cc_lf,cc_bel
		db      'files).',cc_cr,cc_lf,'$'

NOTFOUND        db      'Error - No such file.',cc_cr,cc_lf,cc_bel,'$'

FERR            db      'Error - improperly formed filename.',cc_cr,cc_lf
		db      cc_bel,'$'

RDERRMSG        db     'Read error on data -- file closed.',cc_cr,cc_lf,cc_bel
		db     '$'

DATE_WORK       dw      0
TIME_WORK       dw      0

FILE_SPEC       db      15 dup(0)               ; file specification

HEADER:
HNAME           db      'filename.xyz'
		db      cc_ht
		db      cc_ht
HDATE           db      'mm-dd-yy'
		db      ' '
		db      'hh:mm:ss'
		db      cc_ht,cc_ht
		db      'Page '
HPAGE           db      '00000'
		db      cc_cr,cc_lf,cc_cr,cc_lf
		db      0

FILE_NAME       db      11 dup (?)
		db      5 dup (' ')
		db      cc_cr,cc_lf,'$'


FILE_FCB        db      0                       ; drive
SEARCHNAME      db      11 dup(?)               ; name
		dw      0                       ; current block
		dw      0                       ; record size
		db      0,0,0,0                 ; file size
		dw      0                       ; date
		dw      0                       ; time
		db      0,0,0,0,0,0,0,0         ; RFU
		db      0                       ; current record
		db      0,0,0,0                 ; random record

SEARCHED_FCB    db      0                       ; drive
		db      32 dup(?)               ; directory entry
		db      [128-32-1] dup (0)      ; filler

HAD_STARNAME    db      0

disk_ptr        dw      0
line_ptr        dw      0

LINEBUF         db      256 dup (?)
		db      cc_cr,cc_lf,'$'


PRINTBUF        db      256 dup(?)



PROG            ENDS
		END     START
