		title   exptab - expand tab characters to blanks and fold line
		page    ,96
		subttl  Program Documentation
;
;       exptab  - expand horizontal tab and fold line.
;
;       exptab  version 1 revision 1 of 5/20/84
;
;       Copyright (c) 1984 by   David A. Wallace
;                               146 Westford St.
;                               Chelmsford,  Ma.
;                                       01824
;
;       Released with PRINTL Version 4.04
;
;       This function copies a string which may contain horizontal tabs from
;       one area to another, expanding the tabs to spaces and "folding" the line
;       when it threatens to overflow the page width specification.
;
		subttl  Definitions
		.xlist
		include b:defascii.asm
		include b:defms.asm
		.list
		subttl  Code
		page
prog            segment byte public 'PROG'
		assume  cs:prog,ds:prog,es:prog,ss:prog
		public  expand_tab_x
		public  expand_tab
;       expand_tab_x:   Line expand_tab (below), except no test is made for
;                       inserting a line number in the line.  Used primarilly
;                       for outputting the page heading line.
;
;       Entry:  SI -> tabulated string (source)
;               DI -> expnaded string buffer (destination)
;               CX = line width
;       Exit:   'C' flag set it line was folded; else 'C' clear.
;       Uses:   None
;
expand_tab_x:
		PUSH    AX
		PUSH    BX
		PUSH    CX
		PUSH    DX
		PUSH    SI
		PUSH    DI
		CLC
		PUSHF
		MOV     BX,0                    ; clear the line numbering flag
		MOV     page_width,CX
		MOV     CX,0
		JMP     EXTL


;       expand_tab:     Convert cc_ht to proper number of spaces while copying a
;                       character string between two buffers.
;
;       Entry:  SI -> tabulated string (source)
;               DI -> expanded string buffer (destination)
;               BX = Line numbering flag (1 if numbering; else 0)
;               CX = Line width
;       Exit:   'C' flag set if line was folded; else 'C' clear.
;       Uses:   None
;
expand_tab:
		PUSH    AX
		PUSH    BX
		PUSH    CX
		PUSH    DX
		PUSH    SI
		PUSH    DI
		CLC
		PUSHF
		MOV     page_width,CX
		MOV     CX,0
EXTL:
		LODSB
		CMP     AL,CC_HT
		JNE     EXTN
		CALL    ETAB
		JC      TAB_FOLDED
		JMP     EXTL


TAB_FOLDED:
		POPF
		STC
		PUSHF
		JMP     EXTL


EXTN:
		CMP     AL,CC_CR
		JE      EXTCR
		CMP     AL,0
		JE      EXTNUL
EXTST:
		STOSB
		CMP     AL,' '
		JL      EXTL
		INC     CX
		CMP     CX,page_width
		JGE     DO_FOLD
		JMP     EXTL


DO_FOLD:
		POPF
		STC
		PUSHF
		MOV     AL,CC_CR
		STOSB
		MOV     AL,CC_LF
		STOSB
		CMP     BX,0
		JE      NO_LN_FOLD
		MOV     CX,0
		MOV     AL,CC_HT
		CALL    ETAB
		JMP     EXTL


NO_LN_FOLD:
		MOV     AL,'\'
		STOSB
		MOV     AL,'c'
		STOSB
		MOV     CX,2
		JMP     EXTL


EXTCR:
		STOSB
		MOV     CX,0
		JMP     EXTL


EXTNUL:
		STOSB
		POPF
		POP     DI
		POP     SI
		POP     DX
		POP     CX
		POP     BX
		POP     AX
		RET


ETAB:
		MOV     AL,CL
		OR      CL,00000111B
		INC     CX              ; cx = char position of next tabstop
		AND     AL,00000111B
		CMP     CX,page_width
		JGE     ETABF
;
;       (al) = [(cx)+1] modulo 8
;
EXPT:
		CMP     AL,8
		JE      EXPTX
		PUSH    AX
		MOV     AL,' '
		STOSB
		POP     AX
		INC     AL
		JMP     EXPT


EXPTX:
		CLC
		RET


ETABF:
		MOV     AL,CC_CR
		STOSB
		MOV     AL,CC_LF
		STOSB
		CMP     BX,0
		JE      NO_LN_FOLD1
		MOV     CX,0
		MOV     AL,CC_HT
		CALL    ETAB            ; (I hope the recursion works!)
		STC
		RET


NO_LN_FOLD1:
		MOV     AL,'\'
		STOSB
		MOV     AL,'c'
		STOSB
		MOV     CX,2
		STC
		RET

page_width      dw      0

prog            ends
		end     expand_tab_x





















t	9 Rac2R R RsDU3R>u